SET NOCOUNT ON
GO
BEGIN TRANSACTION

DECLARE @fk NVARCHAR(255)
DECLARE @tablename NVARCHAR(255)
declare @execString nvarchar (255)
declare @errCode    int
DECLARE @parentID INT

set @errCode = 0

DECLARE tblCursor CURSOR FOR
    SELECT TABLE_NAME
    FROM INFORMATION_SCHEMA.TABLES 
    WHERE TABLE_TYPE='BASE TABLE' 
    AND TABLE_NAME like '%cf_MetricsQuery%'

OPEN tblCursor
FETCH   NEXT FROM tblCursor INTO @tablename

WHILE   @@FETCH_STATUS = 0
BEGIN
        --print 'Dropping constraint [' + @fkName + '] from table [' + @fromTable + '] to table [' + @ToTable + '].'
		IF COL_LENGTH(@tablename, 'SurveyResultId ') = 4
		BEGIN
		set @fk = (select CONSTRAINT_NAME from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where TABLE_NAME = @tablename)
        set @execString = 'alter table ' + @tablename +' DROP CONSTRAINT ' + @fk
        exec sp_executesql @execString

		set @errCode = @@error
        IF @errCode <> 0
            break;
		
		SELECT @parentID = (SELECT id FROM sysobjects WHERE name = @tablename AND xType = 'U')
		IF EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = @tablename + '_SurveyResultId_idx')
		BEGIN
			set @execString = 'DROP INDEX ' + @tablename + '_SurveyResultId_idx ON ' + @tablename
			exec sp_executesql @execString
		END 

		set @errCode = @@error
        IF @errCode <> 0
            break;

		set @execString = 'alter table ' + @tablename +' ALTER COLUMN SurveyResultId BIGINT'
        exec sp_executesql @execString

		set @errCode = @@error
        IF @errCode <> 0
            break;

		set @execString = 'alter table ' + @tablename +' ADD CONSTRAINT ' + @fk + ' FOREIGN KEY (SurveyResultId) REFERENCES cf_CommservSurveyResults (CommservSurveyResults_ID) ON DELETE CASCADE;'
        exec sp_executesql @execString

		set @errCode = @@error
        IF @errCode <> 0
            break;
	
		set @execString = 'CREATE CLUSTERED INDEX ' + @tablename + '_SurveyResultId_idx ON ' + @tablename + ' (SurveyResultId);'
        exec sp_executesql @execString

		set @errCode = @@error
        IF @errCode <> 0
            break;
		END
        FETCH   NEXT FROM tblCursor INTO @tablename
END

CLOSE tblCursor
DEALLOCATE tblCursor

IF @errCode <> 0
    ROLLBACK TRANSACTION
ELSE
    COMMIT TRANSACTION
    
GO
