

--  ------------  Generated from [../../../Source/CommServer/CloudDB/TblScript/cf_WebConsoleReports.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2007  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/TblScript/cf_WebConsoleReports.script,v $ $Id: cf_WebConsoleReports.script,v 1.1.2.47.4.1 2021/01/15 21:37:05 nbirru Exp $";
-- TABLENAME cf_WebConsoleReports

print '... inserting Table: cf_WebConsoleReports'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME cf_WebConsoleReports

SET NOCOUNT ON;

DECLARE @ReportId		int,

		@Name			nvarchar(200),

		@Description	nvarchar(1024),

		@Status			int,

		@OpFlags		int,

		@DispFlag		int,

		@AltNamesXml	xml,

		@Hyperlink		nvarchar(200),

@RetentionText	nvarchar(MAX) = 'Retention cannot be changed for this report',

@NoDisableText	nvarchar(MAX) = 'This report cannot be disabled'

DECLARE @param_isPrivate INT = 0

SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'

BEGIN TRY

	--Clean up cf_WebConsoleReports (SP6 only)

	IF NOT EXISTS (SELECT * FROM cf_SurveyConfig WITH(NOLOCK) WHERE Name = 'RetentionSettingsPageCleanUp' AND Value = '2')

	BEGIN

		--Default retentions for queries

		DECLARE @DefaultRetention TABLE (QueryId int, Retention int)
		INSERT INTO @DefaultRetention VALUES (7, 1)

		INSERT INTO @DefaultRetention VALUES (8, 365)

		INSERT INTO @DefaultRetention VALUES (23, 365)

		INSERT INTO @DefaultRetention VALUES (39, 365)

		INSERT INTO @DefaultRetention VALUES (44, 1)

		INSERT INTO @DefaultRetention VALUES (55, 1)

		INSERT INTO @DefaultRetention VALUES (77, 1)

		INSERT INTO @DefaultRetention VALUES (72, 365)

		INSERT INTO @DefaultRetention VALUES (117, 1)

		INSERT INTO @DefaultRetention VALUES (136, 400)

		INSERT INTO @DefaultRetention VALUES (162, 100)


		--checking if default retentions have been changed and updating userModifiedProps accordingly

		UPDATE R

		SET userModifiedProps = (SELECT Q.DataRetentionDays AS '@retention' FOR XML PATH ('userModifiedProps'))

		FROM cf_WebConsoleReports R INNER JOIN cf_WebConsoleReportQueryMap M ON R.ReportId = M.ReportId

			INNER JOIN cf_CommservSurveyQueries Q ON M.QueryId = Q.QueryId

			INNER JOIN @DefaultRetention D ON Q.QueryId = D.QueryId

		WHERE Q.DataRetentionDays <> D.Retention

		--checking if 137 has been disabled and updating userModifiedProps accordingly

		UPDATE cf_WebConsoleReports

		SET userModifiedProps = (SELECT 0 AS '@status' FOR XML PATH ('userModifiedProps'))

		WHERE ReportId = 137

		AND (SELECT Flags FROM cf_CommservSurveyQueries WITH (NOLOCK) WHERE QueryId = 137) = 0

		--Deleting dummy reports

		DELETE FROM cf_WebConsoleReports WHERE ReportId IN (35, 73, 104, 119, 160)
		INSERT INTO cf_SurveyConfig VALUES ('RetentionSettingsPageCleanUp', '2', GETUTCDATE())


	END

	SELECT @ReportId = 1,

		@Name = 'License Usage',

		@Description = 'Information about Total and Used Capacity Licence',

@Status = 1,

@OpFlags = 0,

@DispFlag = 1 | 2 | 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 4,

		@Name = 'Snap Engine Usage',

		@Description = 'Snap Usage Information',

@Status = 1,

@OpFlags = 0,

@DispFlag = 1 | 2 | 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 5,

		@Name = 'GUI Login Languages',

		@Description = 'Information about logged in Languages',

@Status = CASE WHEN @param_isPrivate = 1 THEN 0 ELSE 1 END,

@OpFlags = 0,

@DispFlag = CASE WHEN @param_isPrivate = 1 THEN 0 ELSE 1 | 2 END,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 7,

		@Name = 'Scale Statistics',

		@Description = 'Provides information about job, media, and database performance in all CommCells.',

@Status = 1,

@OpFlags = 1,

@DispFlag = 4 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/indcommcellsurvey.jsp?commUniId=<commUniId>&surveyId=' + CAST(@ReportId AS nvarchar(20)),

		@RetentionText = 'The default retention for this report is 1 day'

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 8,

		@Name = 'Client Statistics',

		@Description = 'Includes a count of all clients and laptops.',

@Status = 1,

@OpFlags = 1,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20)),

		@RetentionText = 'The default retention for this report is 365 days'

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 12,

		@Name = 'Software Version',

		@Description = 'CommServe installed updates and update cache information',

@Status = 1,

@OpFlags = 0,

@DispFlag = 1 | 2 | 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 16,

		@Name = 'Backup Job Statistics for last 60 days',

		@Description = 'Backup Success and failure statistics',

@Status = 1,

@OpFlags = 0,

@DispFlag = 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 17,

		@Name = 'Restore Statistics for last 90 days',

		@Description = 'Provides the success and failure job in the CS',

@Status = 1,

@OpFlags = 0,

@DispFlag = 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 18,

		@Name = 'Clients at 2 versions behind CommServe',

		@Description = 'Clients in unsupported version',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 20,

		@Name = 'Subclients without Storage Policy Association',

		@Description = 'Total Number Of clients, Number of Clients without Storage Policy configured, List of clients without Storage Policy configured, % of Client Without Storage Policy Configured',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 22,

		@Name = 'Unused Schedule Policies',

		@Description = 'Is Shedule Policy being used?',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 23,

		@Name = 'Largest 25 Clients',

		@Description = '25 largest clients by application size',

@Status = 1,

@OpFlags = 1,

@DispFlag = 4 | 8 | 64 | 128,

		@AltNamesXML = '',

		@Hyperlink = '/survey/reports/operations.jsp?surveyId=23',

		@RetentionText = 'The default retention for this report is 365 days'

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 24,

		@Name = 'Top 25 Long Running Backup Jobs',

		@Description = 'Get 25 jobs that are taking more than 12 hours',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 25,

		@Name = 'Strike Count',

		@Description = 'All clients that are continuously failing.',

@Status = 1,

@OpFlags = 0,

@DispFlag = 1 | 2 | 4 | 8 | 64 | 128,

		@AltNamesXML = '',

		@Hyperlink = '/survey/reports/operations.jsp?surveyId=25'

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 26,

		@Name = 'Deduplication Ratio For The Last 30 Days',

		@Description = 'Total Deduplication Savings',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 27,

		@Name = 'SLA',

		@Description = 'Clients that are not protected in SLA period',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 28,

		@Name = 'Incremental backup change rate for Last 7 days',

		@Description = 'List out data change rates per day (GB and percentage)',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 30,

		@Name = 'Top 10 Errors in last 24 hours',

		@Description = 'Top 25 Clients most frequent errors',

@Status = 1,

@OpFlags = 0,

@DispFlag = 1 | 2 | 8 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 31,

		@Name = 'Disaster Recovery Backup',

		@Description = '',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 37,

		@Name = 'Clients completing with errors in last 30 days',

		@Description = 'Clients with jobs completing with errors',

@Status = 1,

@OpFlags = 0,

@DispFlag = 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 38,

		@Name = 'Release Adoption Rate',

		@Description = 'CommServe upgrade history',

@Status = 1,

@OpFlags = 0,

@DispFlag = CASE WHEN @param_isPrivate = 1 THEN 0 ELSE 1 | 2 | 64 | 128 END,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 39,

		@Name = 'Index Cache Location',

		@Description = 'Includes status information about each index cache in CommCell.',

@Status = 1,

@OpFlags = 1,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 44,

		@Name = 'Slowest Clients by Throughput in Last 24 Hours',

		@Description = 'Lists the number of slowest clients in the last 24 hours based on throughput ratio.',

@Status = 1,

@OpFlags = 1,

@DispFlag = 8 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20)),

		@RetentionText = 'The default retention for this report is 1 day'

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 51,

		@Name = 'Activity - Daily Job Statistics',

		@Description = 'Daily Success and failure statistics for backup jobs that appear in the Activity Report.',

@Status = 1,

@OpFlags = 1 | 4,

@DispFlag = 8 | 64 | 128,

		@AltNamesXML = '<AlternateReportNames><report reporttype="hourly" name="Hourly Backup Jobs"/><report reporttype="worldwide" name="Worldwide Backup Statistics"/><report reporttype="commcell" name="Backup Statistics"/></AlternateReportNames>',

@Hyperlink = '/survey/reports/operations.jsp',

		@RetentionText = 'The default retention for this report is 400 days'

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 54,

		@Name = 'Protected data per agent for last 7 days',

		@Description = 'How much data was protected by ida per week/month',

@Status = 1,

@OpFlags = 0,

@DispFlag = 2 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 55,

		@Name = 'Average Throughput of Jobs in the Last Week',

		@Description = 'Display average throughput of backup and restore jobs in the last week by media types and agent types.',

@Status = 1,

@OpFlags = 1,

@DispFlag = 1 | 2 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20)),

		@RetentionText = 'The default retention for this report is 10 days'

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 61,

		@Name = 'DDB Partition counts per MediaAgent',

		@Description = 'Provide Media Agent Dedup Partition Configuration',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20)),

		@RetentionText = 'The default retention for this report is 365 days'

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 63,

		@Name = 'Storage Policy Audit',

		@Description = 'Display differences from a user selected storage policy',

@Status = 1,

@OpFlags = 0,

@DispFlag = 1 | 2 | 32 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/audit.do?type=audit&entityTypeId=' + '0'

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 64,

		@Name = 'Fallen Behind Secondary Copies',

		@Description = 'Fallen Behind Secondary Copies',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 65,

		@Name = 'DDB Performance and Status',

		@Description = 'DDB Performance by Average Q&I Time in last 3 days',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 66,

		@Name = 'DDB backups',

		@Description = 'DDB Partitions protected via subclient',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 67,

		@Name = 'Client Details',

		@Description = 'Includes information about each client computer in each CommCell.',

@Status = 1,

@OpFlags = 1,

@DispFlag = CASE WHEN @param_isPrivate = 1 THEN 1 | 2 | 64 | 128 ELSE 2 | 128 END,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20)),

		@RetentionText = 'The default retention for this report is 1 day'

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 70,

		@Name = 'Storage Policy Disk Usage',

		@Description = 'Storage Policy Disk Usage',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 72,

		@Name = 'Daily Storage Usage and Chargeback',

		@Description = 'Daily chargeback information, including the size and cost of stored data.',

@Status = 1,

@OpFlags = 1,

@DispFlag = 1 | 2 | 16 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/chargebackmonthly.jsp?'+ 'repType=4&startDate=1&sizeUnit=TB&groupBy=ClientGroup&excludeDeSCs=0',

		@RetentionText = 'The default retention for this report is 365 days'

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 88,

		@Name = 'MediaAgent Audit',

		@Description = 'Display differences from a user selected MediaAgent',

@Status = 1,

@OpFlags = 0,

@DispFlag = 1 | 2 | 32,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/audit.do?type=audit&entityTypeId=' + '1'

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 92,

		@Name = 'Royalty Report',

		@Description = 'Royalty Report',

@Status = 0,

@OpFlags = 0,

@DispFlag = 0,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 93,

		@Name = 'Library Audit',

		@Description = 'Display differences from a user selected library',

@Status = 1,

@OpFlags = 0,

@DispFlag = 1 | 2 | 32,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/audit.do?type=audit&entityTypeId=' + '2'

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

		DELETE FROM cf_WebConsoleReports WHERE ReportId = 95

	SELECT @ReportId = 96,

		@Name = 'Disk Library Growth',

		@Description = 'Includes information about the libraries associated with each CommCell.',

@Status = 1,

@OpFlags = 0,

@DispFlag = 1 | 2 | 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20)),

		@RetentionText = 'The default retention for this report is 365 days'

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 97,

		@Name = 'Network Efficiency',

		@Description = 'Value Assessment - Infrastructure Savings - Network Efficiency',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 98,

		@Name = 'File System Backup Efficiency',

		@Description = 'Value Assessment - Infrastructure Savings - File system Backup Efficiency',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 99,

		@Name = 'File Data Placement',

		@Description = 'Value Assessment - Infrastructure Savings - File Data Placement',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/indcommcellsurvey.jsp?commUniId=<commUniId>&surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 100,

		@Name = 'Rapid Recovery Capability',

		@Description = 'Value Assessment - Risk and SLAs - Rapid Recovery Capability',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/indcommcellsurvey.jsp?commUniId=<commUniId>&surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 101,

		@Name = 'VM Backup Efficiency',

		@Description = 'Value Assessment - Risk and SLAs - VM Backup Efficiency',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/indcommcellsurvey.jsp?commUniId=<commUniId>&surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 102,

		@Name = 'Application Backup Efficiency',

		@Description = 'Value Assessment - Risk and SLAs - Application Backup Efficiency',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 103,

		@Name = 'Failed Jobs in last 24 hours',

		@Description = 'Collect Failed Jobs in last 24 hours. Reasons for a job not finishing -> failed, failed to start and killed',

@Status = 1,

@OpFlags = 0,

@DispFlag = CASE WHEN @param_isPrivate = 1 THEN 1 | 2 | 64 | 128 ELSE 2 | 128 END,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 105,

		@Name = 'Index Cache Space Utilization',

		@Description = 'Includes information about  the status of each index cache based on the amount of free space.',

@Status = 1,

@OpFlags = 1,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 106,

		@Name = 'Client Version History',

		@Description = 'Gives count of clients running simpana version 10,9 and 8',

@Status = 1,

@OpFlags = 0,

@DispFlag = 2 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/indcommcellsurvey.jsp?commUniId=<commUniId>&surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 111,

		@Name = 'Disk Protection Tier Savings',

		@Description = 'Value Assessment - Infrastructure Savings - Disk Protection Tier Savings',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 112,

		@Name = 'Email Data Placement',

		@Description = 'Value Assessment - Infrastructure Savings - Email Data Placement',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 113,

		@Name = 'Tape Media Management',

		@Description = 'Value Assessment - Operational Efficiency - Tape Media Management',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 114,

		@Name = 'Self-Service',

		@Description = 'Value Assessment - Operational Efficiency - Self-Service',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 117,

		@Name = 'Storage Resources Summary',

		@Description = 'Displays information about all storage-related entities, such as MediaAgents and libraries.',

@Status = 1,

@OpFlags = 1,

@DispFlag = CASE WHEN @param_isPrivate = 1 THEN 1 | 2 | 64 | 128 ELSE 2 | 128 END,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20)),

		@RetentionText = 'The default retention for this report is 1 day'

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 124,

		@Name = 'High-risk Settings',

		@Description = 'High-risk Settings used in Commserver',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 134,

		@Name = 'Mailbox Quota Usage',

		@Description = 'Mailbox Quota Usage Summary',

@Status = CASE WHEN @param_isPrivate = 1 THEN 1 ELSE 0 END,

@OpFlags = 0,

@DispFlag = CASE WHEN @param_isPrivate = 1 THEN 1 | 64 ELSE 0 END,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 136,

		@Name = 'Monthly Storage Usage and Chargeback',

		@Description = 'Monthly chargeback information, including the size and cost of stored data.',

@Status = 1,

@OpFlags = 1,

@DispFlag = 1 | 2 | 16 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/chargebackmonthly.jsp?'+ 'repType=1&startDate=1&sizeUnit=TB&groupBy=ClientGroup&excludeDeSCs=0',

		@RetentionText = 'The default retention for this report is 400 days'

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 137,

		@Name = 'Activity - Job Details',

		@Description = 'Displays the number and status of jobs in all CommCells for each day in the Activity Report.',

@Status = CASE WHEN @param_isPrivate = 1 THEN 1 ELSE 0 END,

@OpFlags = 1 | 2 | 4,

@DispFlag = CASE WHEN @param_isPrivate = 1 THEN 8 | 64 | 128 ELSE 0 END,

		@AltNamesXML = '<AlternateReportNames><report reporttype="monthly" name="Daily Backup Jobs"/></AlternateReportNames>',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20)) + '&startDate=<startDate>&endDate=<endDate>&repType=monthly&jobStatus=0',

		@RetentionText = 'The default retention for this report is 26 months',

		@NoDisableText = ''

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 141,

		@Name = 'Data Retention',

		@Description = 'Backup data retention',

@Status = 1,

@OpFlags = 0,

@DispFlag = 0,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 144,

		@Name = 'Database Index Fragmentation',

		@Description = 'Database Index Fragmentation Percentage',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 156,

		@Name = 'Disk Pruning',

		@Description = 'Number of Pending Deletes',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 159,

		@Name = 'CommCell Parameters Audit',

		@Description = 'Display differences of CommCell parameters from a user selected CommCell',

@Status = 1,

@OpFlags = 0,

@DispFlag = 1 | 2 | 32 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/audit.do?type=audit&entityTypeId=' + '3'

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 161,

		@Name = 'Search Engines',

		@Description = 'Display Search Engine information for CommCell',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/indcommcellsurvey.jsp?commUniId=<commUniId>&surveyId=' + CAST(@ReportId AS nvarchar(20)),

		@RetentionText = 'The default retention for this report is 1 day'

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 162,

		@Name = 'Weekly Storage Usage and Chargeback',

		@Description = 'Weekly chargeback information, include the size and cost of stored data.',

@Status = 1,

@OpFlags = 1,

@DispFlag = 1 | 2 | 16 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/chargebackmonthly.jsp?'+ 'repType=2&startDate=1&sizeUnit=TB&groupBy=ClientGroup&excludeDeSCs=0',

		@RetentionText = 'The default retention for this report is 100 days'

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 171,

		@Name = 'Value Assessment',

		@Description = 'Value Assessment',

@Status = 1,

@OpFlags = 0,

@DispFlag = 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/indcommcellsurvey.jsp?commUniId=<commUniId>&surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 173,

		@Name = 'Activity - Monthly Job Statistics',

		@Description = 'Monthly success and failure statistics for backup jobs that appear in the Activity Report.',

@Status = 1,

@OpFlags = 1 | 4,

@DispFlag = 8 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/operations.jsp',

		@RetentionText = 'The default retention for this report is 60 Months'

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 181,

		@Name = 'Replication',

		@Description = 'Replicated VM Information',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 186,

		@Name = 'Tape Library Growth',

		@Description = 'Tape Media Usage',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 196,

		@Name = 'Cloud Library Growth',

		@Description = 'Cloud Library Information',

@Status = 0,

@OpFlags = 0,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 200,

		@Name = 'Index Backup',

		@Description = 'Display information about Index Backup Status ',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 201,

		@Name = 'Index State',

		@Description = 'Display information about individual Indices Status ',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 204,

		@Name = 'Top 25 Growing Clients',

		@Description = 'Top 25 clients for growing application size',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 207,

		@Name = 'Subclients not having full backup in 60 days',

		@Description = 'Subclients not having full backup in 60 days',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 208,

		@Name = 'Admin Job Details',

		@Description = 'Admin Job Details',

@Status = CASE WHEN @param_isPrivate = 1 THEN 1 ELSE 0 END,

@OpFlags = 0,

@DispFlag = 0,

		@AltNamesXML = '',

		@Hyperlink = ''

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 209,

		@Name = 'Fallen Behind Backup Copy Jobs',

		@Description = 'Fallen Behind Backup Copy Jobs',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 213,

		@Name = 'Subclients without full backup in active DDB',

		@Description = 'Subclients without full backup in active DDB',

@Status = 0,

@OpFlags = 0,

@DispFlag = 0,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 1000,

		@Name = 'Activity Report',

		@Description = '',

@Status = 1,

@OpFlags = 0,

@DispFlag = 1 | 2 | 8 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/operations.jsp',

		@RetentionText = 'Changing the retention for this report will also affect the health reports "Largest 25 Clients", "Strike Count" and "Top 10 Errors in last 24 hours"'

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 1001,

		@Name = 'Growth and Trends',

		@Description = 'Displays information about the media size, application size, and number of clients for entities such as CommCells, agents, and client groups.',

@Status = 1,

@OpFlags = 1 | 4,

@DispFlag = 1 | 2 | 64 | 128,

		@AltNamesXML = '',

		@Hyperlink = '/survey/reports/growthDashboard.jsp',

		@RetentionText = 'The default retention for this report is 365 days'

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 146,

		@Name = 'SLA Trend',

		@Description = 'Displays last 12 months commcells SLA trend.',

@Status = 1,

@OpFlags = 0,

@DispFlag = 64 | 128,

		@AltNamesXML = '<AlternateReportNames><report reporttype="slatrend" name="SLA Trend"/></AlternateReportNames>',

		@Hyperlink = '/survey/reports/CommCellSurvey.jsp?showSLATrend=true&repType=SLATrend&surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

	SELECT @ReportId = 260,

		@Name = 'Data Aging Troubleshooting',

		@Description = 'Collect Data Aging Troubleshooting Information',

@Status = 1,

@OpFlags = 0,

@DispFlag = 4 | 64 | 128,

		@AltNamesXML = '',

@Hyperlink = '/survey/reports/CommCellSurvey.jsp?surveyId=' + CAST(@ReportId AS nvarchar(20))

IF NOT EXISTS (SELECT * FROM cf_WebConsoleReports WHERE ReportId = @ReportId)	
		INSERT INTO cf_WebConsoleReports (ReportId, Name, Description, Status, OpFlags, DispFlag, AltNamesXML, Hyperlink, RetentionText, NoDisableText)	
		VALUES(@ReportId, @Name, @Description, @Status, @OpFlags, @DispFlag, @AltNamesXML, @Hyperlink, @RetentionText, @NoDisableText)	
	ELSE	
		UPDATE cf_WebConsoleReports	
		SET Name = @Name,	
			Description = @Description,	
			Status = @Status,	
			OpFlags = @OpFlags,	
			DispFlag = @DispFlag,	
			AltNamesXML = @AltNamesXML,	
			Hyperlink = @Hyperlink,	
			RetentionText = @RetentionText,	
			NoDisableText = @NoDisableText	
		WHERE ReportId = @ReportId	
	SELECT @ReportId = NULL, @Name = NULL, @Description = NULL, @Status = NULL, @OpFlags = NULL, @DispFlag = NULL, @AltNamesXML = NULL, @Hyperlink = NULL, @RetentionText = 'Retention cannot be changed for this report', @NoDisableText = 'This report cannot be disabled'

END TRY

BEGIN CATCH

	DECLARE @ErrorMessage nvarchar(max) = ISNULL(ERROR_MESSAGE(), '')

	RAISERROR('Error while inserting/updating report [%d]

	Error Message: [%s]', 16, 1, @ReportId, @ErrorMessage)

END CATCH

SET NOCOUNT OFF;

