

--  ------------  Generated from [../../../Source/CommServer/CloudDB/TblScript/cf_SurveyIDAMonthlyRSTJobStats.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2007  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/TblScript/cf_SurveyIDAMonthlyRSTJobStats.script,v $ $Id: cf_SurveyIDAMonthlyRSTJobStats.script,v 1.1.2.2 2019/11/06 22:02:30 nbirru Exp $";
-- TABLENAME cf_SurveyIDAMonthlyRSTJobStats

print '... inserting Table: cf_SurveyIDAMonthlyRSTJobStats'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME cf_SurveyIDAMonthlyRSTJobStats
INSERT INTO cf_SurveyIDAMonthlyRSTJobStats(CommServUniqueId, MonthStart, AppTypeId, TotalJobs, CompletedJobs, CWEJobs, CWWJobs, FailedJobs, KilledJobs, SkippedJobs, TotUnCompMB, TotCompMB, CommittedJobs,TotFiles2xfer,TotSuccess,SkippedObjects,FailedObjects)


SELECT  B.CommservUniqueId ,

				CAST (DATEADD(MONTH, DATEDIFF(MONTH, 0, DBO.GETDATETIME(B.EndTime)), 0) AS DATE),

				B.AppTypeId as AppTypeId,

				SUM(CASE WHEN (B.jobstatus) IN (1,2,3,4,9,14,16) THEN 1 ELSE 0 END) as TotalJobs,

				SUM(CASE WHEN B.jobstatus = 1  THEN 1 ELSE 0 END) AS CompletedJobs,

				SUM(CASE WHEN B.jobstatus = 3  THEN 1 ELSE 0 END) as CWEJobs,

				SUM(CASE WHEN B.jobstatus = 14 THEN 1 ELSE 0 END) as CWWJobs,

				SUM(CASE WHEN B.jobstatus = 2  OR (B.jobstatus = 9 AND B.errorcode = '8') THEN 1 ELSE 0 END) as FailedJobs,

				SUM(CASE WHEN B.jobstatus = 4 THEN 1 ELSE 0 END) as KilledJobs,

				SUM(CASE WHEN (B.jobstatus = 9 AND B.errorcode <> '8') THEN 1 ELSE 0 END) as SkippedJobs,

				SUM(CASE WHEN B.jobstatus IN (1,3,14) THEN TotUnCompMB ELSE 0 END) AS TotUnCompMB,

				SUM(TotCompMB) AS TotCompMB,

				SUM(CASE WHEN B.jobstatus = 16 THEN 1 ELSE 0 END) as CommittedJobs,

				SUM(TotFiles2xfer) AS TotFiles2xfer,

				SUM(TotSuccess) AS TotSuccess,

				SUM(SkippedObjects) AS SkippedObjects,

				SUM(FailedObjects) AS FailedObjects

			FROM	 	

				 cf_SurveyRestoreJobStats B WITH (NOLOCK) 

				LEFT OUTER JOIN (SELECT CommServUniqueId,AppTypeId, cast (MAX(MonthStart) as date) as MonthStart FROM  cf_SurveyIDAMonthlyRSTJobStats (NOLOCK) GROUP BY CommservUniqueId,AppTypeId ) AS ExData

				ON ExData.CommServUniqueId = B.CommServUniqueId

				AND B.AppTypeID = ExData.AppTypeID

				WHERE ExData.CommServUniqueId IS NULL

				 or ExData.MonthStart <CAST (DATEADD(MONTH, DATEDIFF(MONTH, 0, DBO.GETDATETIME(B.EndTime)), 0) AS DATE)				

				GROUP BY CAST (DATEADD(MONTH, DATEDIFF(MONTH, 0, DBO.GETDATETIME(B.EndTime)), 0) AS DATE),B.CommservUniqueId,B.AppTypeId

