

--  ------------  Generated from [../../../Source/CommServer/CloudDB/TblScript/cf_SurveyIDAMonthlyRSTJobFailurePerClient.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2007  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/TblScript/cf_SurveyIDAMonthlyRSTJobFailurePerClient.script,v $ $Id: cf_SurveyIDAMonthlyRSTJobFailurePerClient.script,v 1.1.2.1 2019/03/18 18:17:25 nbirru Exp $";
-- TABLENAME cf_SurveyIDAMonthlyRSTJobFailurePerClient

print '... inserting Table: cf_SurveyIDAMonthlyRSTJobFailurePerClient'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME cf_SurveyIDAMonthlyRSTJobFailurePerClient

IF object_id('tempdb.dbo.#FailureClientTemp') is not null DROP TABLE #FailureClientTemp 

CREATE TABLE #FailureClientTemp (

	CommservUniqueId INT, 

	MonthStart DATETIME, 

	SrcClientId INT, 

	AppTypeId INT,

	JobStatus INT, 

	ErrorCode NVARCHAR(32), 

	FailureReason NVARCHAR(512)

)

IF object_id('tempdb.dbo.#FailureClientJobsTemp') is not null DROP TABLE #FailureClientJobsTemp 

CREATE TABLE #FailureClientJobsTemp (

	CommservUniqueId INT, 

	MonthStart DATETIME, 

	SrcClientId INT, 

	AppTypeId INT,

	JobStatus INT, 

	JobCount INT

)
INSERT INTO #FailureClientJobsTemp


SELECT T.CommservUniqueId, T.MonthStart, T.SrcClientId, T.AppTypeId, T.JobStatus, T.JobCount

FROM (

	SELECT T.CommservUniqueId, CAST (DATEADD(MONTH, DATEDIFF(MONTH, 0, DBO.GETDATETIME(T.EndTime)), 0) AS DATE) AS MonthStart, T.SrcClientId, T.AppTypeId, T.JobStatus, COUNT(T.jobid) AS JobCount, 

		ROW_NUMBER() OVER (PARTITION BY T.CommservUniqueId, CAST (DATEADD(MONTH, DATEDIFF(MONTH, 0, DBO.GETDATETIME(T.EndTime)), 0) AS DATE), T.JobStatus ORDER BY COUNT(T.jobid) DESC) as rn

	FROM cf_SurveyRestoreJobStats as T WITH (NOLOCK)	

	WHERE T.JobStatus in (2,4)

	GROUP BY T.CommservUniqueId, CAST (DATEADD(MONTH, DATEDIFF(MONTH, 0, DBO.GETDATETIME(T.EndTime)), 0) AS DATE), T.SrcClientId, T.AppTypeId, T.JobStatus

) as T

WHERE T.rn <= 5
INSERT INTO cf_SurveyIDAMonthlyRSTJobFailurePerClient


SELECT T.CommservUniqueId,T.MonthStart, T.SrcClientId, T.AppTypeId, T.JobStatus, T.JobCount, '', ''

FROM #FailureClientJobsTemp T

LEFT OUTER JOIN (SELECT CommServUniqueId,SrcClientId,AppTypeId, Status, cast (MAX(MonthStart) as date) as MonthStart FROM  cf_SurveyIDAMonthlyRSTJobFailurePerClient (NOLOCK) GROUP BY CommservUniqueId,SrcClientId,AppTypeId, Status ) AS ExData

	ON ExData.CommServUniqueId = T.CommServUniqueId

				AND T.SrcClientId = ExData.SrcClientId

				AND T.AppTypeID = ExData.AppTypeID

				AND T.JobStatus = ExData.Status

	WHERE ExData.CommServUniqueId IS NULL

				 or ExData.MonthStart < T.MonthStart				

				GROUP BY T.MonthStart,T.CommservUniqueId,T.SrcClientId, T.AppTypeId, T.JobStatus, T.JobCount
INSERT INTO #FailureClientTemp


SELECT T.CommservUniqueId, T.MonthStart, T.SrcClientId, T.AppTypeId, T.JobStatus, T.ErrorCode, T.FailureReason

FROM (

SELECT R.CommservUniqueId, DATEADD(MONTH, DATEDIFF(MONTH, 0, dbo.GETDATETIME(R.EndTime)), 0) AS MonthStart,

		   COUNT(jobid) AS JobCount,

           jobstatus,

           SrcClientId,

		   AppTypeId,

           errorcode,

		   MAX(FailedReason) AS FailureReason,

		   ROW_NUMBER() OVER (PARTITION BY R.CommservUniqueId, CAST (DATEADD(MONTH, DATEDIFF(MONTH, 0, DBO.GETDATETIME(R.EndTime)), 0) AS DATE), R.SrcClientId, R.errorcode, R.JobStatus ORDER BY COUNT(R.jobid) DESC) as rn

    FROM cf_SurveyRestoreJobStats R WITH (NOLOCK)

        INNER JOIN cf_CommcellIdNameMap CC WITH (NOLOCK) ON R.CommServUniqueId = CC.id AND R.JobStatus IN (2,4)

    GROUP BY R.CommservUniqueId, DATEADD(MONTH, DATEDIFF(MONTH, 0, dbo.GETDATETIME(R.EndTime)), 0) ,SrcClientId , AppTypeId    ,jobstatus    ,errorcode 

    having len(errorcode)>0 ) as T

	WHERE T.rn <= 1

UPDATE cf_SurveyIDAMonthlyRSTJobFailurePerClient

SET cf_SurveyIDAMonthlyRSTJobFailurePerClient.ErrorCode = T.ErrorCode, cf_SurveyIDAMonthlyRSTJobFailurePerClient.FailureReason = T.FailureReason

FROM #FailureClientTemp T

WHERE T.CommservUniqueId = cf_SurveyIDAMonthlyRSTJobFailurePerClient.CommservUniqueId AND T.MonthStart = cf_SurveyIDAMonthlyRSTJobFailurePerClient.MonthStart AND T.SrcClientId = cf_SurveyIDAMonthlyRSTJobFailurePerClient.SrcClientId AND T.AppTypeId = cf_SurveyIDAMonthlyRSTJobFailurePerClient.AppTypeId AND T.JobStatus = cf_SurveyIDAMonthlyRSTJobFailurePerClient.Status

DROP TABLE #FailureClientTemp 

DROP TABLE #FailureClientJobsTemp
