

--  ------------  Generated from [../../../Source/CommServer/CloudDB/TblScript/cf_SurveyIDADailyRSTJobStats.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2007  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/TblScript/cf_SurveyIDADailyRSTJobStats.script,v $ $Id: cf_SurveyIDADailyRSTJobStats.script,v 1.1.2.2 2019/11/06 22:02:39 nbirru Exp $";
-- TABLENAME cf_SurveyIDADailyRSTJobStats

print '... inserting Table: cf_SurveyIDADailyRSTJobStats'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME cf_SurveyIDADailyRSTJobStats
INSERT INTO cf_SurveyIDADailyRSTJobStats(CommServUniqueId, JobEndDate, AppTypeId, TotalJobs, CompletedJobs, CWEJobs, CWWJobs, FailedJobs, KilledJobs, SkippedJobs, TotUnCompMB, TotCompMB, CommittedJobs,TotFiles2xfer,TotSuccess,SkippedObjects,FailedObjects)


SELECT  B.CommservUniqueId ,

				CAST(DBO.GETDATETIME(B.EndTime) AS DATE),

				B.AppTypeId as AppTypeId,

				SUM(CASE WHEN (B.jobstatus) IN (1,2,3,4,9,14,16) THEN 1 ELSE 0 END) as TotalJobs,

				SUM(CASE WHEN B.jobstatus = 1  THEN 1 ELSE 0 END) AS CompletedJobs,

				SUM(CASE WHEN B.jobstatus = 3  THEN 1 ELSE 0 END) as CWEJobs,

				SUM(CASE WHEN B.jobstatus = 14 THEN 1 ELSE 0 END) as CWWJobs,

				SUM(CASE WHEN B.jobstatus = 2  OR (B.jobstatus = 9 AND B.errorcode = '8') THEN 1 ELSE 0 END) as FailedJobs,

				SUM(CASE WHEN B.jobstatus = 4 THEN 1 ELSE 0 END) as KilledJobs,

				SUM(CASE WHEN (B.jobstatus = 9 AND B.errorcode <> '8') THEN 1 ELSE 0 END) as SkippedJobs,

				SUM(CASE WHEN B.jobstatus IN (1,3,14) THEN TotUnCompMB ELSE 0 END) AS TotUnCompMB,

				SUM(TotCompMB) AS TotCompMB,

				SUM(CASE WHEN B.jobstatus = 16 THEN 1 ELSE 0 END) as CommittedJobs,

				SUM(TotFiles2xfer) AS TotFiles2xfer,

				SUM(TotSuccess) AS TotSuccess,

				SUM(SkippedObjects) AS SkippedObjects,

				SUM(FailedObjects) AS FailedObjects

			FROM	 	

				 cf_SurveyRestoreJobStats B WITH (NOLOCK) 

				LEFT OUTER JOIN (SELECT CommServUniqueId,AppTypeId, MAX(JobEndDate) as JobEndDate FROM  cf_SurveyIDADailyRSTJobStats (NOLOCK) GROUP BY CommservUniqueId,AppTypeId ) AS ExData

				ON ExData.CommServUniqueId = B.CommServUniqueId

				AND B.AppTypeID = ExData.AppTypeID

				WHERE ExData.CommServUniqueId IS NULL

				 or ExData.JobEndDate <CAST(DBO.GETDATETIME(B.EndTime) AS DATE) 

				GROUP BY CAST(DBO.GETDATETIME(B.EndTime) AS DATE),B.CommservUniqueId,B.AppTypeId

