

--  ------------  Generated from [../../../Source/CommServer/CloudDB/TblScript/CreateCLRFunctionsDuringUpgrade.script] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON

DECLARE @dbDataPathUnix NVARCHAR(MAX) = ''

DECLARE @baseFolderPath NVARCHAR(MAX) = ''

DECLARE @dllPath NVARCHAR(MAX) = ''

DECLARE @retVal INTEGER = 0

DECLARE @windows TINYINT = 1

DECLARE @linux TINYINT = 2

DECLARE @osType TINYINT = 0

DECLARE @nl VARCHAR(4) = ''

DECLARE @versionSQL NVARCHAR(MAX)

SET @versionSQL = @@VERSION

SET @osType = IIF((@versionSQL LIKE '%Linux%'), @linux, @windows)

SET @nl = IIF((@osType = @windows), (CHAR(13) + CHAR(10)), CHAR(10))	-- CRLF(Windows), LF(Linux newline)

IF EXISTS (SELECT 1 FROM sysobjects WHERE id = OBJECT_ID(N'[dbo].[DBUpgradeSteps]') and OBJECTPROPERTY(id, N'IsTable') = 1)

BEGIN

	IF (@osType = @windows)

	BEGIN

		IF EXISTS(SELECT 1 FROM DBUpgradeSteps WHERE Step = 'BaseFolderPath')

		BEGIN

			SELECT @baseFolderPath = Status FROM DBUpgradeSteps WHERE Step = 'BaseFolderPath'

			IF LEN(@baseFolderPath) <= 0

			BEGIN

				RAISERROR('BaseFolderPath is not set in DBUpgradeSteps', 16, -1)

			END

			ELSE

			BEGIN

				SELECT @dllPath = CASE WHEN RIGHT(@baseFolderPath, 1) = '\' THEN SUBSTRING( @baseFolderPath, 1, LEN(@baseFolderPath) - 1 ) ELSE @baseFolderPath END

				SET @dllPath = @dllPath + '\DBCLR.dll'

				EXEC @retVal = AppCreateCLRFunctions @dllPath

			END

		END

	END

    ELSE

    BEGIN

		IF EXISTS(SELECT 1 FROM DBUpgradeSteps WHERE Step = 'DBDataPathUnix')

		BEGIN

			SELECT @dbDataPathUnix = Status FROM DBUpgradeSteps WHERE Step = 'DBDataPathUnix'

			IF LEN(@dbDataPathUnix) <= 0

			BEGIN

				RAISERROR('DBDataPathUnix is not set in DBUpgradeSteps', 16, -1)

			END

			ELSE

			BEGIN

				SELECT @dllPath = CASE WHEN RIGHT(@dbDataPathUnix, 1) = '/' THEN SUBSTRING( @dbDataPathUnix, 1, LEN(@dbDataPathUnix) - 1 ) ELSE @dbDataPathUnix END

				EXEC @retVal = AppCreateCLRFunctions @dllPath

			END

		END

	END

END

IF @retVal <> 0 OR @@ERROR <> 0

    SELECT 1

ELSE

	SELECT 0

GO

