

--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/UpgradedCommCells.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: UpgradedCommCells"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[UpgradedCommCells]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[UpgradedCommCells]
GO

delete from GXDBVersions where name = 'UpgradedCommCells' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'UpgradedCommCells', '1.2', 'UpgradedCommCells', '')
GO
CREATE VIEW [dbo].[UpgradedCommCells]
AS
SELECT
	result1.CommServUniqueId,
	result1.CommCellID,
	result1.UpgradedDate,
	result1.Version AS 'CurrentVersion',
	result2.Version AS 'PreviousVersion',
	result1.LogDate AS 'AsOf'
FROM
	(SELECT
		resultView.CommcellIdNameMap_ID AS CommServUniqueId,
		CAST(ccMap.CommCellID AS INT) AS CommCellID,
		CAST(FLOOR(csInfo.Version) AS INT) AS Version,
		CAST(csInfo.InstallTime AS DATE) AS UpgradedDate,
		csInfo.LogDate,
		ROW_NUMBER() OVER (PARTITION BY resultView.CommcellIdNameMap_ID ORDER BY csInfo.ReleaseId ) AS RowId
	 FROM cf_SurveyUpgradeHistory AS csInfo WITH (NOLOCK)
		INNER JOIN cf_CommservSurveyResults AS resultView  WITH (NOLOCK)
			ON resultView.CommservSurveyResults_ID = csInfo.SurveyResultId
			AND resultView.QueryId = 38
			AND resultView.Flags = 1
			AND csInfo.ReleaseId > 0
		INNER JOIN cf_CommcellIdNameMap AS ccMap  WITH (NOLOCK)
			ON ccMap.ID = resultView.CommcellIdNameMap_ID
			AND ccMap.ID = csInfo.CommServUniqueId
			AND ccMap.Flags = 0
			AND ccMap.CommCellID <> -1
	 ) AS result1
	INNER JOIN
	(SELECT
		resultView.CommcellIdNameMap_ID AS CommServUniqueId,
		CAST(FLOOR(csInfo.Version) AS INT) AS Version,
		ROW_NUMBER() OVER (PARTITION BY resultView.CommcellIdNameMap_ID ORDER BY csInfo.ReleaseId ) AS RowId
	FROM cf_SurveyUpgradeHistory AS csInfo WITH (NOLOCK)
		INNER JOIN cf_CommservSurveyResults AS resultView  WITH (NOLOCK)
			ON resultView.CommservSurveyResults_ID = csInfo.SurveyResultId
			AND resultView.QueryId = 38
			AND resultView.Flags = 1
			AND csInfo.ReleaseId > 0
		INNER JOIN cf_CommcellIdNameMap AS ccMap  WITH (NOLOCK)
			ON ccMap.ID = resultView.CommcellIdNameMap_ID
			AND ccMap.ID = csInfo.CommServUniqueId
			AND ccMap.Flags = 0
			AND ccMap.CommCellID <> -1
	) AS result2
	ON result1.RowId > 1
		AND result1.CommServUniqueId = result2.CommServUniqueId
		AND (result1.RowId - 1) = result2.RowId
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [UpgradedCommCells]'
END
GO

