

--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/Last7DayVMBackupDetails.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: Last7DayVMBackupDetails"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[Last7DayVMBackupDetails]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[Last7DayVMBackupDetails]
GO

delete from GXDBVersions where name = 'Last7DayVMBackupDetails' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'Last7DayVMBackupDetails', '1.1.2.2', 'Last7DayVMBackupDetails', '')
GO
CREATE VIEW Last7DayVMBackupDetails
AS
SELECT
	CAST(CC.CommCellID AS INT) AS CommCellID,
	CC.CommServName AS CommServName,
	CL.ClientId AS 'VMClientID',
	CL.ClientDisplayName AS VMClientName,
	ISNULL(CL.PhysicalClientName, CL.clientName) AS VMPhysicalClientName,
	CL.ClientHostName AS VMHostName,
	SA.ClientId AS 'Virtual Server ClientID',
	SA.ClientName AS 'Virtual Server',
	SA.AppTypeId AS 'AgentID',
	SA.AgentName AS 'Agent',
	SA.InstanceId AS 'InstanceID',
	SA.InstanceName AS 'Instance',
	SA.BackupsetId AS 'BackupSetID',
	SA.BackupsetName AS 'Backupset',
	SA.AppId AS 'SubclientID',
	SA.SubclientName AS 'Subclient',
	VM.JobId AS 'JobID',
	VM.ParentJobId AS 'Parent JobID',
	VM.vmBackupStart AS 'StartTime',
	DATEADD(SS, VM.vmBackupStart, CAST('1970-01-01 00:00:00' AS datetime)) AS 'StartDate',
	VM.vmBackupEnd AS 'EndTime',
	DATEADD(SS, VM.vmBackupEnd, CAST('1970-01-01 00:00:00' AS datetime)) AS 'EndDate',
	CASE J.OpType
		  WHEN 4 THEN (CASE WHEN SA.AppTypeId = 67 THEN N'Compliance Archive' ELSE N'Backup' END)
		  WHEN 14 THEN N'Synthetic Full'
		  WHEN 18 THEN N'Backup 3RD'
		  WHEN 59 THEN N'Snap Backup'
		  WHEN 60 THEN N'Backup Copy'
		  WHEN 65 THEN N'Snap Backup3RD'
		  ELSE N'Unknown'
	END AS 'Operation',
	CASE J.BkpLevel
		  WHEN 1 THEN (CASE WHEN SA.AppTypeId IN (45,56,57,58,67,73) THEN N'New Index' ELSE N'Full' END)
		  WHEN 2 THEN (CASE WHEN SA.AppTypeId IN (4,5,16,70,81) THEN N'Transaction Log' WHEN SA.AppTypeId = 125 THEN N'Log Only' ELSE N'Incremental' END)
		  WHEN 4 THEN (CASE WHEN SA.AppTypeId IN (37,62) THEN N'Delta' ELSE N'Differential' END)
		  WHEN 0x40    THEN N'Synthetic Full' WHEN 0x80 THEN N'Synthetic Full' WHEN 0x4000 THEN N'Synthetic Full'
		  WHEN 0x100   THEN (CASE WHEN SA.AppTypeId = 104 THEN N'Incremental' ELSE N'Transaction Log' END)
		  WHEN 0x200   THEN N'ASR'
		  WHEN 0x800   THEN N'Snapshot'
		  WHEN 0x1000  THEN N'New Volume Creation'
		  WHEN 0x2000  THEN N'Incremental Volume Update'
		  WHEN 0x400   THEN N'Offline Full'
		  WHEN 0x8000  THEN N'Online Full'
		  WHEN 0x20000 THEN N'Analysis'
		  WHEN 0x40000 THEN N'Discovery'
		  ELSE N'Unknown'
	END AS 'Job Type',
	CASE J.Status
		  WHEN 0 THEN 'Running'
		  WHEN 1 THEN 'Completed'
		  WHEN 2 THEN 'Failed'
		  WHEN 3 THEN 'Completed with errors'
		  WHEN 4 THEN 'Killed'
		  WHEN 5 THEN 'Suspended'
		  WHEN 6 THEN 'Interrupted'
		  WHEN 7 THEN 'Any Status'
		  WHEN 8 THEN 'Skipped'
		  WHEN 9 THEN   CASE WHEN J.failureErrorCode NOT IN (8)  THEN 'Skipped' ELSE 'Failed To Start' END
		  WHEN 10 THEN 'Synchronized'
		  WHEN 11 THEN 'Not Synchronized'
		  WHEN 12 THEN 'Not Attempted'
		  WHEN 13 THEN 'Started'
		  WHEN 14 THEN 'Completed with warnings'
		  WHEN 15 THEN 'System Failed'
		  WHEN 16 THEN 'Committed'
		  ELSE 'Unknown'
	END AS 'Job Status',
	CASE VM.vmStatus
		  WHEN 0 THEN 'Success'
		  WHEN 1 THEN 'Failed'
		  WHEN 3 THEN 'PartialSuccess'
		  WHEN 2 THEN 'In Progress'
	  	  WHEN 4 THEN 'Waiting'
		  WHEN 5 THEN 'Kill Pending'
		  WHEN 6 THEN 'Killed'
		  WHEN 7 THEN 'Pending'
		  WHEN 8 THEN 'Suspended'
	END AS 'VM Status',
	VM.vmFailureReason AS 'VM Failure Reason',
	CAST(VM.vmUsedSpace/1024.0/1024.0 AS DECIMAL(30,3)) AS 'VM Used Space (MB)',
	CAST(VM.vmGuestSize/1024.0/1024.0 AS DECIMAL(30,3)) AS 'VM Guest Size (MB)',
	CAST(VM.vmSize/1024.0/1024.0 AS DECIMAL(30,3)) AS 'VM Size (MB)',
	J.SchedulePolicy AS 'Schedule Policy',
	J.ScheduleName AS 'Schedule Name'
FROM
	cf_SurveyJobStats J WITH (NOLOCK)
	INNER JOIN cf_SurveyJobVMStats VM WITH (NOLOCK) ON J.CommservUniqueId = VM.CommservUniqueId AND J.JobId = VM.JobId
	INNER JOIN cf_SurveyClient CL WITH (NOLOCK) ON VM.CommservUniqueId = CL.CommservUniqueId AND VM.vmClientId = CL.ClientId
	INNER JOIN cf_CommcellIdNameMap as CC WITH (NOLOCK)
            ON CC.ID = J.CommservUniqueId
    INNER JOIN cf_SurveySubclientAssociation SA WITH (NOLOCK)
		ON J.CommservUniqueId = SA.CommservUniqueId AND J.AppId = SA.AppId
WHERE
	J.EndDate > DATEDIFF(s, '1970-01-01 00:00:00', DATEADD(d, -7, GETUTCDATE()))
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [Last7DayVMBackupDetails]'
END
GO

