

--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/InstalledCommCells.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: InstalledCommCells"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[InstalledCommCells]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[InstalledCommCells]
GO

delete from GXDBVersions where name = 'InstalledCommCells' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'InstalledCommCells', '1.2', 'InstalledCommCells', '')
GO
CREATE VIEW [dbo].[InstalledCommCells]
AS
SELECT CommServUniqueId, CommCellID, InstallDate, Version, LogDate AS 'AsOf' FROM
		(SELECT
			resultView.CommcellIdNameMap_ID AS CommServUniqueId,
			CAST(ccMap.CommCellID AS INT) AS CommCellID,
			CAST(FLOOR(csInfo.Version) AS INT) AS Version,
			CAST(csInfo.InstallTime AS DATE) AS InstallDate,
			csInfo.LogDate,
			ROW_NUMBER() OVER (PARTITION BY resultView.CommcellIdNameMap_ID ORDER BY csInfo.ReleaseId ) AS RowId
		 FROM cf_SurveyUpgradeHistory AS csInfo WITH (NOLOCK)
			INNER JOIN cf_CommservSurveyResults AS resultView  WITH (NOLOCK)
				ON resultView.CommservSurveyResults_ID = csInfo.SurveyResultId
				AND resultView.QueryId = 38
				AND resultView.Flags = 1
				AND csInfo.ReleaseId > 0
			INNER JOIN cf_CommcellIdNameMap AS ccMap  WITH (NOLOCK)
				ON ccMap.ID = resultView.CommcellIdNameMap_ID
				AND ccMap.ID = csInfo.CommServUniqueId
				AND ccMap.Flags = 0
				AND ccMap.CommCellID <> -1
		 )sub
	WHERE sub.RowId = 1
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [InstalledCommCells]'
END
GO

