

--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/DiskLibrarySummary.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: DiskLibrarySummary"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DiskLibrarySummary]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[DiskLibrarySummary]
GO

delete from GXDBVersions where name = 'DiskLibrarySummary' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'DiskLibrarySummary', '1.3.12.3', 'DiskLibrarySummary', '')
GO
CREATE VIEW [dbo].[DiskLibrarySummary]
AS
	SELECT 	R.LogDate,
			R.CommCellID AS 'CommCell ID',
			ISNULL(R.CommServName, '') AS 'CommCell Name',
			L.LibraryName AS 'Library',
			CAST(ISNULL(S.totalFreeSpaceGB, L.FreeSpaceMB/1024.0) AS DECIMAL(32,2)) AS 'Free Space (GB)',
			CAST((S.totalSpaceGB - S.totalFreeSpaceGB) AS DECIMAL(32,2)) AS 'Used Space (GB)',
			CAST(S.totalSpaceGB AS DECIMAL(32,2))	AS 'Capacity (GB)',
			CASE WHEN L.Offline = 1 THEN 'Yes' ELSE 'No' END AS 'Offline',
			CASE WHEN S.totalSpaceGB IS NULL THEN 'N/A'
			     WHEN ISNULL(S.RunoutDays, -1) = -1 THEN 'Never'
			     ELSE CONVERT(VARCHAR(15), DATEADD(DAY, S.RunoutDays, S.LogDate), 107)
			END AS 'Date to be Full'
	FROM	cf_SurveyLibrarySummary AS L WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(117, 0, 1, NULL, NULL, -1, -1) R ON L.SurveyResultId = R.SurverResultId
			LEFT OUTER JOIN
			(
				SELECT	D.CommServUniqueId, D.LibraryId, D.totalSpaceGB, D.totalFreeSpaceGB, R.LogDate, R.LogDateUTC,
						CASE WHEN ISNULL(G.GrowthInMB, -1) <= 0.001 THEN -1
							 WHEN 30.0*(1024.0*D.totalFreeSpaceGB - D.TotalReserveSpaceMB) > G.GrowthInMB*(DATEDIFF(DAY, R.LogDateUTC, GETUTCDATE()) + 9999) THEN -1
							 ELSE 30.0*(1024.0*D.totalFreeSpaceGB - D.TotalReserveSpaceMB) / G.GrowthInMB END AS RunoutDays
				FROM	cf_Survey96DiskLibDetails AS D WITH (NOLOCK)
						INNER JOIN dbo.cf_SurveyResultFuncV1(96, 0, 1, NULL, NULL, -1, -1) R
							ON D.SurveyResultId = R.SurverResultId
						LEFT OUTER JOIN dbo.DiskLibraryGrowth(0, 'M') G
							ON D.CommServUniqueId = G.CommServUniqueId AND D.LibraryId = G.LibraryId
			) S ON S.CommServUniqueId= R.CommServUniqueId AND S.LibraryId= L.LibraryId
	WHERE	L.LibraryTypeId = 3
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [DiskLibrarySummary]'
END
GO

