

--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/ClientStoragePolicyAssociation.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: ClientStoragePolicyAssociation"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ClientStoragePolicyAssociation]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[ClientStoragePolicyAssociation]
GO

delete from GXDBVersions where name = 'ClientStoragePolicyAssociation' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'ClientStoragePolicyAssociation', '1.8', 'ClientStoragePolicyAssociation', '')
GO
CREATE VIEW [dbo].[ClientStoragePolicyAssociation]
AS
SELECT      CAST(CC.CommCellID AS INT) AS CommCellID,
            CC.CommServName,
            SC.ClientId,
            SA.clientName AS ClientName,
			ISNULL(SA.PhysicalClientName,SA.clientName) AS PhysicalClientName,
            SC.AgentId,
            SC.AgentName,
            SC.InstanceId,
            SC.InstanceName,
            SC.BackupSetId,
            SC.BackupsetName,
            SC.SubclientId,
            SC.subclientName,
            SC.Content,
            SchedulePolicy,
            ScheduleName,
            SchedBackupType,
            SchedPattern,
            SchedBackupDay,
            SchedBackupTime,
            SchedNextBackupTime,
            Copy.PolicyName,
            Copy.CopyName,
            CASE Copy.IsDefaultCopy
                  WHEN 1 THEN (CASE Copy.IsSnapCopy WHEN 1 THEN 'Primary Snap' ELSE 'Primary' END)
                  ELSE (CASE Copy.CopyType
                              WHEN 1 THEN (CASE Copy.IsSnapCopy WHEN 1 THEN 'Synchronous Snap' ELSE 'Synchronous' END)
                              ELSE (CASE Copy.IsSnapCopy WHEN 1 THEN 'Selective Snap' ELSE 'Selective' END)
                          END)
            END AS CopyType,
            Copy.RetentionDays,
            Copy.RetentionCycles,
            CASE AC.type WHEN 0 THEN 'All full'
						 WHEN 1 THEN 'Cycle'
						 WHEN 2 THEN 'Weekly Fulls'
						 WHEN 3 THEN 'Daily Fulls'
						 WHEN 4 THEN (CASE AC.NumPeriod
											WHEN 3 THEN 'Quarterly Fulls'
											WHEN 6 THEN 'Half Yearly Fulls'
											WHEN 12 THEN 'Yearly Fulls'
											ELSE 'Monthly' END)
						 WHEN 6 THEN 'Monthy On weekday'
						 WHEN 8 THEN 'Copy last full when auxillary copy starts'
						 WHEN 9 THEN 'Manual'
						 WHEN 10 THEN 'Hourly'
						 ELSE ''
			END AS 'Job Selection',
            CASE WHEN AC.type = 4 AND AC.NumPeriod IN (3,6,12) THEN '1'
											ELSE ISNULL(CAST(AC.NumPeriod AS varchar(5)),'') END AS 'Frequency',
            CASE AC.type WHEN 2 THEN (CASE AC.dayNumber
											WHEN 0 THEN 'Sunday'
											WHEN 1 THEN 'Monday'
											WHEN 2 THEN 'Tuesday'
											WHEN 3 THEN 'Wednesday'
											WHEN 4 THEN 'Thursday'
											WHEN 5 THEN 'Friday'
											WHEN 6 THEN 'Saturday' END)
						WHEN 4 THEN CAST(AC.dayNumber AS varchar(5))
						ELSE '' END AS 'Week/Month Start Day'
FROM  cf_SurveySubclientAssociation AS SA
      INNER JOIN cf_SurveyCopyBasicRetention AS Copy
            ON SA.DataPolicyId = Copy.PolicyId
            AND SA.CommservUniqueId = Copy.CommservUniqueId
      INNER JOIN cf_CommcellIdNameMap as CC
            ON CC.ID = SA.CommservUniqueId
            AND Copy.CommservUniqueId = CC.ID
			AND SA.CommservUniqueId = CC.ID
      INNER JOIN SubclientContent SC
            ON SC.SubclientID = SA.AppId AND SA.Deleted = 0
            AND SC.CommCellID = CC.CommCellID
      LEFT OUTER JOIN BackupSchedules BS
            ON BS.SubclientID = SA.AppId
            AND BS.CommCellID = CC.CommCellID
      LEFT OUTER JOIN cf_SurveyArchSelectiveCopy AS AC
			ON Copy.CopyId = AC.CopyId
			AND Copy.CommservUniqueId = AC.CommServUniqueId
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [ClientStoragePolicyAssociation]'
END
GO

