

--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/ClientDetailsView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: ClientDetailsView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ClientDetailsView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[ClientDetailsView]
GO

delete from GXDBVersions where name = 'ClientDetailsView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'ClientDetailsView', '1.7.42.1', 'ClientDetailsView', '')
GO
CREATE VIEW [dbo].[ClientDetailsView]
AS
SELECT      CAST(resultView.CommCellID AS INT) AS CommCellID,
			ISNULL(resultView.CommServName,'') AS CommServName,
			CAST(clientId AS INT) AS ClientID,
			clientName AS ClientName,
			ISNULL(PhysicalClientName,clientName) AS PhysicalClientName,
			operatingSystem AS OperatingSystem ,
			servicePack AS ServicePack,
			installdate AS InstallDate,
			reverse(substring(reverse(ISNULL(timezone,'')),0,charindex(':',reverse(ISNULL(timezone,'')))))  AS 'Timezone',
			CASE WHEN InstallStatus = 1 THEN 'Deconfigured'
				 WHEN InstallStatus = 2 THEN 'Uninstalled'
				 ELSE 'Installed' END 'Status'
	FROM 	cf_SurveyClient csInfo
			INNER JOIN dbo.cf_SurveyResultFuncV1(77,0,1,null,null,-1,-1) resultView
			ON resultView.CommServUniqueId = csInfo.CommServUniqueId AND csInfo.Deleted = 0
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [ClientDetailsView]'
END
GO

