SET QUOTED_IDENTIFIER OFF


--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/cf_GlobalCostParamView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: cf_GlobalCostParamView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[cf_GlobalCostParamView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[cf_GlobalCostParamView]
GO

delete from GXDBVersions where name = 'cf_GlobalCostParamView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'cf_GlobalCostParamView', '1.7', 'cf_GlobalCostParamView', '')
GO
CREATE VIEW cf_GlobalCostParamView
AS
SELECT
	ISNULL((SELECT CAST(Value AS FLOAT) FROM cf_SurveyConfig WHERE Name = 'FrontEndTBCost'), 1)        AS FrontEndTBCost,
	ISNULL((SELECT CAST(Value AS FLOAT) FROM cf_SurveyConfig WHERE Name = 'DataWrittenCostPerTB'),0)   AS DataWrittenCostPerTB,
	ISNULL((SELECT CAST(Value AS FLOAT) FROM cf_SurveyConfig WHERE Name = 'AdminCostPerClient'), 0)    AS AdminCostPerClient,
	ISNULL((SELECT CAST(Value AS FLOAT) FROM cf_SurveyConfig WHERE Name = 'AdminCostPerSubclient'), 0) AS AdminCostPerSubclient,
	ISNULL((SELECT CAST(Value AS FLOAT) FROM cf_SurveyConfig WHERE Name = 'DataProtectedTBCost'), 0)   AS DataProtectedTBCost,
	ISNULL((SELECT CAST(Value AS FLOAT) FROM cf_SurveyConfig WHERE Name = 'TotalProtectedAppTBCost'), 0) AS TotalProtectedAppTBCost,
	ISNULL((SELECT CAST(Value AS FLOAT) FROM cf_SurveyConfig WHERE Name = 'TotalDataOnMediaTBCost'),0) AS TotalDataOnMediaTBCost,
	ISNULL((SELECT CAST(Value AS FLOAT) FROM cf_SurveyConfig WHERE Name = 'FrontEndArchiveTBCost'),1)  AS FrontEndArchiveTBCost,
	ISNULL((SELECT CAST(Value AS FLOAT) FROM cf_SurveyConfig WHERE Name = 'PrimaryAppTBCost'),1)       AS PrimaryAppTBCost,
	ISNULL((SELECT CAST(Value AS FLOAT) FROM cf_SurveyConfig WHERE Name = 'DiscountLevel'),-1)         AS DiscountLevel,
	ISNULL((SELECT CAST(Value AS FLOAT) FROM cf_SurveyConfig WHERE Name = 'DiscountSizeTB'),0)         AS DiscountSizeTB,
	ISNULL((SELECT CAST(Value AS FLOAT) FROM cf_SurveyConfig WHERE Name = 'DiscountPercentage'),0)     AS DiscountPercentage
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [cf_GlobalCostParamView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/cf_SurveyResultView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: cf_SurveyResultView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[cf_SurveyResultView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[cf_SurveyResultView]
GO

delete from GXDBVersions where name = 'cf_SurveyResultView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'cf_SurveyResultView', '1.5', 'cf_SurveyResultView', '')
GO
CREATE VIEW [dbo].[cf_SurveyResultView]
AS
	SELECT
		ccNameMap.ID AS 'CommServUniqueId',
		ccNameMap.CommCellID AS 'CommCellID',
		ccNameMap.CommServIP AS 'CommServIP',
		ccNameMap.CommServGUID AS 'CommServGUID',
		ccNameMap.CustomerName AS 'CustomerName',
		ccNameMap.CommServName AS 'CommServName',
		xmlFile.ID AS 'CustomerFeedbackXMLFileId',
		xmlFile.CommServTZ AS 'CommServTimeZone',
		xmlFile.CommServVersion AS 'CommServVersion',
		result.CommservSurveyResults_ID AS 'SurverResultId',
		result.QueryId AS 'SurveyID',
		result.LogDate AS 'LogDate',
		result.LogDateUTC AS 'LogDateUTC',
		result.RunningTime AS 'RunningTime',
		result.Flags AS 'SureyResultFlags',
		result.collectedResults AS 'CollectedResults'
	FROM dbo.cf_CommservSurveyResults AS result
		INNER JOIN dbo.cf_CustomerFeedbackXmlFile AS xmlFile
			ON xmlFile.ID = result.CustomerFeedbackXmlFile_id
		INNER JOIN dbo.cf_CommcellIdNameMap AS ccNameMap
			ON xmlFile.CommcellIdNameMap_ID = ccNameMap.ID
			AND (ccNameMap.Flags & 1) <> 1 --Remove Blocked CommCells
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [cf_SurveyResultView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/MetricsCollectedResultsView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: MetricsCollectedResultsView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MetricsCollectedResultsView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[MetricsCollectedResultsView]
GO

delete from GXDBVersions where name = 'MetricsCollectedResultsView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'MetricsCollectedResultsView', '1.3', 'MetricsCollectedResultsView', '')
GO
CREATE VIEW [dbo].[MetricsCollectedResultsView]
AS
	SELECT
		ccNameMap.ID AS 'CommServUniqueID',
		ccNameMap.CommCellID AS 'CommCellID',
		ccNameMap.CommServGUID AS 'CommServGUID',
		ccNameMap.CustomerName AS 'CustomerName',
		ccNameMap.CommServName AS 'CommServName',
		ccNameMap.CommServTZ AS 'CommServTimeZone',
		ccNameMap.CommServVersion AS 'CommServVersion',
		xmlFile.ID AS 'XMLFileID',
		result.QueryId AS 'QueryId',
		result.CommservSurveyResults_ID AS 'ResultID',
		result.LogDate AS 'LogDate',
		result.LogDateUTC AS 'LogDateUTC',
		result.Flags AS 'SurveyResultFlags'
	FROM dbo.cf_CommservSurveyResults AS result WITH (NOLOCK)
		INNER JOIN dbo.cf_CustomerFeedbackXmlFile AS xmlFile WITH (NOLOCK)
			ON xmlFile.ID = result.CustomerFeedbackXmlFile_id
		INNER JOIN dbo.cf_CommcellIdNameMap AS ccNameMap WITH (NOLOCK)
			ON xmlFile.CommcellIdNameMap_ID = ccNameMap.ID
			AND (ccNameMap.Flags & 1) <> 1 --Remove Blocked CommCells
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [MetricsCollectedResultsView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/cf_ReportParameterView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: cf_ReportParameterView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[cf_ReportParameterView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[cf_ReportParameterView]
GO

delete from GXDBVersions where name = 'cf_ReportParameterView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'cf_ReportParameterView', '1.9', 'cf_ReportParameterView', '')
GO
CREATE VIEW cf_ReportParameterView
AS
SELECT	'Health Report' AS ReportName,
		HP.QueryId,
		CASE WHEN LEN(GM.ParameterName) > 0 THEN GM.ParameterName ELSE Q.Name END AS QueryName,
		GM.GroupId AS QueryGroupId,
		G.Name AS QueryGroupName,
		HP.ParameterName,
		HP.ThresholdName, HP.ThresholdMin, HP.ThresholdMax, HP.WarningThreshold, HP.CriticalThreshold,
		HP.GoodThresholdText, HP.WarningThresholdText, HP.CriticalThresholdText,
		HP.InfoMessage,
		REPLACE(HP.GoodMessage, '#1', HP.WarningThreshold) AS GoodMessage,
		REPLACE(REPLACE(HP.WarningMessage, '#1', HP.WarningThreshold), '#2', HP.CriticalThreshold) AS WarningMessage,
		REPLACE(HP.CriticalMessage, '#2', HP.CriticalThreshold) AS CriticalMessage,
		CASE WHEN GM.GroupId = 18 THEN HP.ParamId ELSE GM.SurveySortOrder END AS 'ParamSortOrder',
		ISNULL(HP.DescriptionText, '') AS DescriptionText,
		HP.ParamId
FROM	cf_SurveyHealthParam HP
		INNER JOIN cf_CommservSurveyQueries Q ON HP.QueryId = Q.QueryId
		INNER JOIN cf_CommservSurveyGroupMap GM ON HP.QueryId = GM.SurveyId AND (LEN(GM.ParameterName) = 0 OR GM.ParameterName = HP.ParameterName)
		INNER JOIN cf_CommservSurveyGroups G ON GM.GroupId = G.SurveyGroupId
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [cf_ReportParameterView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/UpgradedCommCells.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: UpgradedCommCells"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[UpgradedCommCells]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[UpgradedCommCells]
GO

delete from GXDBVersions where name = 'UpgradedCommCells' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'UpgradedCommCells', '1.2', 'UpgradedCommCells', '')
GO
CREATE VIEW [dbo].[UpgradedCommCells]
AS
SELECT
	result1.CommServUniqueId,
	result1.CommCellID,
	result1.UpgradedDate,
	result1.Version AS 'CurrentVersion',
	result2.Version AS 'PreviousVersion',
	result1.LogDate AS 'AsOf'
FROM
	(SELECT
		resultView.CommcellIdNameMap_ID AS CommServUniqueId,
		CAST(ccMap.CommCellID AS INT) AS CommCellID,
		CAST(FLOOR(csInfo.Version) AS INT) AS Version,
		CAST(csInfo.InstallTime AS DATE) AS UpgradedDate,
		csInfo.LogDate,
		ROW_NUMBER() OVER (PARTITION BY resultView.CommcellIdNameMap_ID ORDER BY csInfo.ReleaseId ) AS RowId
	 FROM cf_SurveyUpgradeHistory AS csInfo WITH (NOLOCK)
		INNER JOIN cf_CommservSurveyResults AS resultView  WITH (NOLOCK)
			ON resultView.CommservSurveyResults_ID = csInfo.SurveyResultId
			AND resultView.QueryId = 38
			AND resultView.Flags = 1
			AND csInfo.ReleaseId > 0
		INNER JOIN cf_CommcellIdNameMap AS ccMap  WITH (NOLOCK)
			ON ccMap.ID = resultView.CommcellIdNameMap_ID
			AND ccMap.ID = csInfo.CommServUniqueId
			AND ccMap.Flags = 0
			AND ccMap.CommCellID <> -1
	 ) AS result1
	INNER JOIN
	(SELECT
		resultView.CommcellIdNameMap_ID AS CommServUniqueId,
		CAST(FLOOR(csInfo.Version) AS INT) AS Version,
		ROW_NUMBER() OVER (PARTITION BY resultView.CommcellIdNameMap_ID ORDER BY csInfo.ReleaseId ) AS RowId
	FROM cf_SurveyUpgradeHistory AS csInfo WITH (NOLOCK)
		INNER JOIN cf_CommservSurveyResults AS resultView  WITH (NOLOCK)
			ON resultView.CommservSurveyResults_ID = csInfo.SurveyResultId
			AND resultView.QueryId = 38
			AND resultView.Flags = 1
			AND csInfo.ReleaseId > 0
		INNER JOIN cf_CommcellIdNameMap AS ccMap  WITH (NOLOCK)
			ON ccMap.ID = resultView.CommcellIdNameMap_ID
			AND ccMap.ID = csInfo.CommServUniqueId
			AND ccMap.Flags = 0
			AND ccMap.CommCellID <> -1
	) AS result2
	ON result1.RowId > 1
		AND result1.CommServUniqueId = result2.CommServUniqueId
		AND (result1.RowId - 1) = result2.RowId
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [UpgradedCommCells]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/InstalledCommCells.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: InstalledCommCells"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[InstalledCommCells]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[InstalledCommCells]
GO

delete from GXDBVersions where name = 'InstalledCommCells' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'InstalledCommCells', '1.2', 'InstalledCommCells', '')
GO
CREATE VIEW [dbo].[InstalledCommCells]
AS
SELECT CommServUniqueId, CommCellID, InstallDate, Version, LogDate AS 'AsOf' FROM
		(SELECT
			resultView.CommcellIdNameMap_ID AS CommServUniqueId,
			CAST(ccMap.CommCellID AS INT) AS CommCellID,
			CAST(FLOOR(csInfo.Version) AS INT) AS Version,
			CAST(csInfo.InstallTime AS DATE) AS InstallDate,
			csInfo.LogDate,
			ROW_NUMBER() OVER (PARTITION BY resultView.CommcellIdNameMap_ID ORDER BY csInfo.ReleaseId ) AS RowId
		 FROM cf_SurveyUpgradeHistory AS csInfo WITH (NOLOCK)
			INNER JOIN cf_CommservSurveyResults AS resultView  WITH (NOLOCK)
				ON resultView.CommservSurveyResults_ID = csInfo.SurveyResultId
				AND resultView.QueryId = 38
				AND resultView.Flags = 1
				AND csInfo.ReleaseId > 0
			INNER JOIN cf_CommcellIdNameMap AS ccMap  WITH (NOLOCK)
				ON ccMap.ID = resultView.CommcellIdNameMap_ID
				AND ccMap.ID = csInfo.CommServUniqueId
				AND ccMap.Flags = 0
				AND ccMap.CommCellID <> -1
		 )sub
	WHERE sub.RowId = 1
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [InstalledCommCells]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/BackupSchedules.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: BackupSchedules"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BackupSchedules]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[BackupSchedules]
GO

delete from GXDBVersions where name = 'BackupSchedules' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'BackupSchedules', '1.13', 'BackupSchedules', '')
GO
CREATE VIEW [dbo].[BackupSchedules]
AS
SELECT * FROM
(
SELECT distinct
    CAST(cc.CommCellID AS INT) AS CommCellID,
    cc.CommServName AS CommServName,
    sc.ClientId AS ClientID,
    sc.ClientName AS ClientName,
	ISNULL(SC.PhysicalClientName,SC.clientName) AS PhysicalClientName,
    sc.AppTypeId AS AgentID,
    sc.AgentName AS AgentName,
    sc.InstanceId AS InstanceID,
    sc.InstanceName AS InstanceName,
    sc.BackupsetId AS BackupsetID,
    sc.BackupsetName AS BackupsetName,
    sc.AppId AS SubclientID,
    sc.SubclientName AS SubclientName,
    case when sc.DataPolicyId > 1 or sc.LogPolicyId > 1 then 1 else 0 end as IsStoragePolicyAssociated,
    bs.SchedulePolicy AS SchedulePolicy,
    bs.ScheduleName AS ScheduleName,
    bs.Disabled AS IsScheduleDisabled,
    bs.SchedBackupType AS SchedBackupType,
    bs.SchedPattern AS SchedPattern,
    bs.SchedInterval AS SchedInterval,
    CAST(bs.SchedBackupDay AS varchar(512)) AS SchedBackupDay,
    bs.SchedBackupTime AS SchedBackupTime,
    bs.SchedNextBackupTime AS SchedNextBackupTime,
    CASE WHEN bs.MaxRunningSec > 0 THEN DATEADD(SECOND, bs.MaxRunningSec, bs.SchedNextBackupTime)
		 WHEN ISNULL(rt.MaxRunningSec, -1) > 0 THEN DATEADD(SECOND, rt.MaxRunningSec, bs.SchedNextBackupTime)
		 ELSE NULL
	END AS MaxNextBackupEndTime
FROM
    cf_CommcellIdNameMap AS cc WITH (NOLOCK)
    INNER JOIN cf_SurveySubclientAssociation as sc WITH (NOLOCK)
        ON cc.ID = sc.CommservUniqueId
        AND (sc.SubclientStatus & (2|4|8|64|128|4096)) IN (0, 8, 64, 128, 4096)
        AND sc.AppId > 0 AND sc.Deleted = 0
    INNER JOIN cf_SurveyBackupSchedule AS bs WITH (NOLOCK)
        ON bs.CommservUniqueId = sc.CommservUniqueId
        AND bs.ClientGroupId = 0
        AND (bs.ClientId > 0 OR bs.AssocType = 2)
        AND bs.ClientId IN (sc.ClientId, 0)
        AND bs.AppTypeId IN (sc.AppTypeId, 0)
        AND bs.InstanceId IN (sc.InstanceId, 0)
        AND bs.BackupsetId IN (sc.BackupsetId, 0)
        AND bs.AppId IN (sc.AppId, sc.SubclientPolicyAppId, 0)
        AND ISNULL(Exclude,0) = 0
	LEFT OUTER JOIN cf_SurveyBackupMaxRunningTime AS rt WITH (NOLOCK)
		ON sc.AppTypeId = rt.AppTypeId
UNION
SELECT distinct
    CAST(cc.CommCellID AS INT) AS CommCellID,
    cc.CommServName AS CommServName,
    sc.ClientId AS ClientID,
    SC.clientName AS ClientName,
	ISNULL(SC.PhysicalClientName,SC.clientName) AS PhysicalClientName,
    sc.AppTypeId AS AgentID,
    sc.AgentName AS AgentName,
    sc.InstanceId AS InstanceID,
    sc.InstanceName AS InstanceName,
    sc.BackupsetId AS BackupsetID,
    sc.BackupsetName AS BackupsetName,
    sc.AppId AS SubclientID,
    sc.SubclientName AS SubclientName,
    case when sc.DataPolicyId > 1 or sc.LogPolicyId > 1 then 1 else 0 end as IsStoragePolicyAssociated,
    bs.SchedulePolicy AS SchedulePolicy,
    bs.ScheduleName AS ScheduleName,
    bs.Disabled AS IsScheduleDisabled,
    bs.SchedBackupType AS SchedBackupType,
    bs.SchedPattern AS SchedPattern,
    bs.SchedInterval AS SchedInterval,
    CAST(bs.SchedBackupDay AS varchar(512)) AS SchedBackupDay,
    bs.SchedBackupTime AS SchedBackupTime,
    bs.SchedNextBackupTime AS SchedNextBackupTime,
    CASE WHEN bs.MaxRunningSec > 0 THEN DATEADD(SECOND, bs.MaxRunningSec, bs.SchedNextBackupTime)
		 WHEN ISNULL(rt.MaxRunningSec, -1) > 0 THEN DATEADD(SECOND, rt.MaxRunningSec, bs.SchedNextBackupTime)
		 ELSE NULL
	END AS MaxNextBackupEndTime
FROM
    cf_CommcellIdNameMap AS cc WITH (NOLOCK)
    INNER JOIN cf_SurveySubclientAssociation as sc WITH (NOLOCK)
        ON cc.ID = sc.CommservUniqueId
        AND (sc.SubclientStatus & (2|4|8|64|128|4096)) IN (0, 8, 64, 128, 4096)
        AND sc.AppId > 0 AND sc.Deleted = 0
    INNER JOIN cf_SurveyClientGroupAssociation AS cga WITH (NOLOCK)
        ON sc.CommservUniqueId = cga.CommservUniqueId
        AND sc.ClientId = cga.ClientId
    INNER JOIN cf_SurveyBackupSchedule AS bs WITH (NOLOCK)
        ON bs.CommservUniqueId = sc.CommservUniqueId
        AND bs.ClientGroupId = cga.ClientGroupId
        AND bs.ClientGroupId > 0
        AND bs.ClientId IN (sc.ClientId, 0)
        AND bs.AppTypeId IN (sc.AppTypeId, 0)
        AND bs.InstanceId IN (sc.InstanceId, 0)
        AND bs.BackupsetId IN (sc.BackupsetId, 0)
        AND bs.AppId IN (sc.AppId, sc.SubclientPolicyAppId, 0)
        AND ISNULL(Exclude,0) = 0
	LEFT OUTER JOIN cf_SurveyBackupMaxRunningTime AS rt WITH (NOLOCK)
		ON sc.AppTypeId = rt.AppTypeId
) A
EXCEPT
SELECT * FROM
(SELECT
    CAST(cc.CommCellID AS INT) AS CommCellID,
    cc.CommServName AS CommServName,
    sc.ClientId AS ClientID,
    sc.ClientName AS ClientName,
	ISNULL(SC.PhysicalClientName,SC.clientName) AS PhysicalClientName,
    sc.AppTypeId AS AgentID,
    sc.AgentName AS AgentName,
    sc.InstanceId AS InstanceID,
    sc.InstanceName AS InstanceName,
    sc.BackupsetId AS BackupsetID,
    sc.BackupsetName AS BackupsetName,
    sc.AppId AS SubclientID,
    sc.SubclientName AS SubclientName,
    case when sc.DataPolicyId > 1 or sc.LogPolicyId > 1 then 1 else 0 end as IsStoragePolicyAssociated,
    bs.SchedulePolicy AS SchedulePolicy,
    bs.ScheduleName AS ScheduleName,
    bs.Disabled AS IsScheduleDisabled,
    bs.SchedBackupType AS SchedBackupType,
    bs.SchedPattern AS SchedPattern,
    bs.SchedInterval AS SchedInterval,
    CAST(bs.SchedBackupDay AS varchar(512)) AS SchedBackupDay,
    bs.SchedBackupTime AS SchedBackupTime,
    bs.SchedNextBackupTime AS SchedNextBackupTime,
    CASE WHEN bs.MaxRunningSec > 0 THEN DATEADD(SECOND, bs.MaxRunningSec, bs.SchedNextBackupTime)
		 WHEN ISNULL(rt.MaxRunningSec, -1) > 0 THEN DATEADD(SECOND, rt.MaxRunningSec, bs.SchedNextBackupTime)
		 ELSE NULL
	END AS MaxNextBackupEndTime
FROM
    cf_CommcellIdNameMap AS cc WITH (NOLOCK)
    INNER JOIN cf_SurveySubclientAssociation as sc WITH (NOLOCK)
        ON cc.ID = sc.CommservUniqueId
        AND (sc.SubclientStatus & (2|4|8|64|128|4096)) IN (0, 8, 64, 128, 4096)
        AND sc.AppId > 0 AND sc.Deleted = 0
    INNER JOIN cf_SurveyBackupSchedule AS bs WITH (NOLOCK)
        ON bs.CommservUniqueId = sc.CommservUniqueId
        AND bs.ClientGroupId = 0
        AND (bs.ClientId > 0 OR bs.AssocType = 2)
        AND bs.ClientId IN (sc.ClientId, 0)
        AND bs.AppTypeId IN (sc.AppTypeId, 0)
        AND bs.InstanceId IN (sc.InstanceId, 0)
        AND bs.BackupsetId IN (sc.BackupsetId, 0)
        AND bs.AppId IN (sc.AppId, sc.SubclientPolicyAppId, 0)
        AND ISNULL(Exclude,0) = 1
	LEFT OUTER JOIN cf_SurveyBackupMaxRunningTime AS rt WITH (NOLOCK)
		ON sc.AppTypeId = rt.AppTypeId
UNION
SELECT
    CAST(cc.CommCellID AS INT) AS CommCellID,
    cc.CommServName AS CommServName,
    sc.ClientId AS ClientID,
	SC.clientName AS ClientName,
	ISNULL(SC.PhysicalClientName,SC.clientName) AS PhysicalClientName,
    sc.AppTypeId AS AgentID,
    sc.AgentName AS AgentName,
    sc.InstanceId AS InstanceID,
    sc.InstanceName AS InstanceName,
    sc.BackupsetId AS BackupsetID,
    sc.BackupsetName AS BackupsetName,
    sc.AppId AS SubclientID,
    sc.SubclientName AS SubclientName,
    case when sc.DataPolicyId > 1 or sc.LogPolicyId > 1 then 1 else 0 end as IsStoragePolicyAssociated,
    bs.SchedulePolicy AS SchedulePolicy,
    bs.ScheduleName AS ScheduleName,
    bs.Disabled AS IsScheduleDisabled,
    bs.SchedBackupType AS SchedBackupType,
    bs.SchedPattern AS SchedPattern,
    bs.SchedInterval AS SchedInterval,
    CAST(bs.SchedBackupDay AS varchar(512)) AS SchedBackupDay,
    bs.SchedBackupTime AS SchedBackupTime,
    bs.SchedNextBackupTime AS SchedNextBackupTime,
    CASE WHEN bs.MaxRunningSec > 0 THEN DATEADD(SECOND, bs.MaxRunningSec, bs.SchedNextBackupTime)
		 WHEN ISNULL(rt.MaxRunningSec, -1) > 0 THEN DATEADD(SECOND, rt.MaxRunningSec, bs.SchedNextBackupTime)
		 ELSE NULL
	END AS MaxNextBackupEndTime
FROM
    cf_CommcellIdNameMap AS cc WITH (NOLOCK)
    INNER JOIN cf_SurveySubclientAssociation as sc WITH (NOLOCK)
        ON cc.ID = sc.CommservUniqueId
        AND (sc.SubclientStatus & (2|4|8|64|128|4096)) IN (0, 8, 64, 128, 4096)
        AND sc.AppId > 0 AND sc.Deleted = 0
    INNER JOIN cf_SurveyClientGroupAssociation AS cga WITH (NOLOCK)
        ON sc.CommservUniqueId = cga.CommservUniqueId
        AND sc.ClientId = cga.ClientId
    INNER JOIN cf_SurveyBackupSchedule AS bs WITH (NOLOCK)
        ON bs.CommservUniqueId = sc.CommservUniqueId
        AND bs.ClientGroupId = cga.ClientGroupId
        AND bs.ClientGroupId > 0
        AND bs.ClientId IN (sc.ClientId, 0)
        AND bs.AppTypeId IN (sc.AppTypeId, 0)
        AND bs.InstanceId IN (sc.InstanceId, 0)
        AND bs.BackupsetId IN (sc.BackupsetId, 0)
        AND bs.AppId IN (sc.AppId, sc.SubclientPolicyAppId, 0)
        AND ISNULL(Exclude,0) = 1
	LEFT OUTER JOIN cf_SurveyBackupMaxRunningTime AS rt WITH (NOLOCK)
		ON sc.AppTypeId = rt.AppTypeId
) B
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [BackupSchedules]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/SubclientContent.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: SubclientContent"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SubclientContent]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[SubclientContent]
GO

delete from GXDBVersions where name = 'SubclientContent' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'SubclientContent', '1.9', 'SubclientContent', '')
GO
CREATE VIEW [dbo].[SubclientContent]
AS
SELECT
	CAST(C.CommCellID AS INT) AS CommCellID,
	C.CommServName AS CommServName,
	S.ClientId AS ClientID,
	S.clientName AS ClientName,
	ISNULL(S.PhysicalClientName,S.clientName) AS PhysicalClientName,
	S.AppTypeId AS AgentID,
	S.AgentName AS AgentName,
	S.InstanceId AS InstanceID,
	S.InstanceName AS InstanceName,
	S.BackupsetId AS BackupsetID,
	S.BackupsetName AS BackupsetName,
	S.AppId AS SubclientID,
	S.SubclientName AS SubclientName,
	CASE WHEN S.BackupDisabled = 0 THEN 'Yes' ELSE 'No' END AS IsBackupEnabled,
	ISNULL(CAST(SC.Content AS nvarchar(1024)), '') AS Content
FROM
	cf_SurveySubclientAssociation AS S WITH (NOLOCK)
	INNER JOIN cf_CommcellIdNameMap AS C WITH (NOLOCK)
		ON C.ID = S.CommservUniqueId AND (S.SubclientStatus & (2|4|8|64|128|4096)) IN (0,8,64,128,4096)
		AND S.AppId > 0 AND S.Deleted = 0
	LEFT OUTER JOIN cf_SurveySubclientContent AS SC  WITH (NOLOCK)
		ON SC.AppId IN (S.AppId, S.SubclientPolicyAppId)
		AND SC.CommservUniqueId = S.CommservUniqueId AND SC.Type = 1
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [SubclientContent]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/SubclientCopyRetention.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: SubclientCopyRetention"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SubclientCopyRetention]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[SubclientCopyRetention]
GO

delete from GXDBVersions where name = 'SubclientCopyRetention' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'SubclientCopyRetention', '1.4', 'SubclientCopyRetention', '')
GO
CREATE VIEW [dbo].[SubclientCopyRetention]
AS
SELECT
    CC.CommCellID,
    CC.CommServName,
    SC.ClientId,
    SC.clientName AS ClientName,
	ISNULL(SC.PhysicalClientName,SC.clientName) AS PhysicalClientName,
    SC.AppTypeId,
    SC.AgentName,
    SC.InstanceName,
    SC.BackupsetName,
    SC.AppId,
    SC.SubclientName,
    Copy.PolicyId,
    Copy.PolicyName,
    Copy.CopyId,
    Copy.CopyName,
    Copy.IsDefaultCopy,
    Copy.IsSnapCopy,
    CASE WHEN (Copy.AgingFlags & 4) = 4 THEN -1
	     WHEN SC.AppTypeId IN (45,56,57,58,66,67,68,73,82,83,89,90) THEN Copy.ArchiverRetDays
	     ELSE Copy.RetentionDays
    END AS RetentionDays,
    Copy.RetentionCycles
FROM cf_SurveySubclientAssociation AS SC
    INNER JOIN cf_SurveyCopyBasicRetention AS Copy
       ON SC.CommservUniqueId = Copy.CommservUniqueId AND SC.DataPolicyId = Copy.PolicyId AND SC.AppId > 0 AND SC.Deleted = 0
    INNER JOIN cf_CommcellIdNameMap AS CC
       ON Copy.CommservUniqueId = CC.ID
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [SubclientCopyRetention]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/Last7DayBackupDetails.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: Last7DayBackupDetails"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[Last7DayBackupDetails]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[Last7DayBackupDetails]
GO

delete from GXDBVersions where name = 'Last7DayBackupDetails' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'Last7DayBackupDetails', '1.9', 'Last7DayBackupDetails', '')
GO
CREATE VIEW Last7DayBackupDetails
AS
SELECT
	CAST(CC.CommCellID AS INT) AS CommCellID,
	CC.CommServName AS CommServName,
	SA.ClientId AS 'ClientID',
	SA.clientName AS Client,
	ISNULL(SA.PhysicalClientName,SA.clientName) AS PhysicalClientName,
	SA.AppTypeId AS 'AgentID',
	S.AgentName AS 'Agent',
	SA.InstanceId AS 'InstanceID',
	S.InstanceName AS 'Instance',
	SA.BackupsetId AS 'BackupSetID',
	S.BackupsetName AS 'Backupset',
	SA.AppId AS 'SubclientID',
	S.SubclientName AS 'Subclient',
	JobId AS 'Job ID',
	StartDate AS 'Start Time',
	DATEADD(second, StartDate, CAST('1970-01-01 00:00:00' AS datetime)) AS 'StartDate',
	EndDate AS 'End Time',
	DATEADD(second, EndDate, CAST('1970-01-01 00:00:00' AS datetime)) AS 'EndDate',
	CASE Status
		  WHEN 0 THEN 'Running'
		  WHEN 1 THEN 'Completed'
		  WHEN 2 THEN 'Failed'
		  WHEN 3 THEN 'Completed with errors'
		  WHEN 4 THEN 'Killed'
		  WHEN 5 THEN 'Suspended'
		  WHEN 6 THEN 'Interrupted'
		  WHEN 7 THEN 'Any Status'
		  WHEN 8 THEN 'Skipped'
		  WHEN 9 THEN 'Failed To Start'
		  WHEN 10 THEN 'Synchronized'
		  WHEN 11 THEN 'Not Synchronized'
		  WHEN 12 THEN 'Not Attempted'
		  WHEN 13 THEN 'Started'
		  WHEN 14 THEN 'Completed with warnings'
		  WHEN 15 THEN 'System Failed'
		  WHEN 16 THEN 'Committed'
		  ELSE 'Unknown'
	END AS 'Job Status',
	CASE OpType
		  WHEN 4 THEN (CASE WHEN S.AppTypeId = 67 THEN N'Compliance Archive' ELSE N'Backup' END)
		  WHEN 14 THEN N'Synthetic Full'
		  WHEN 18 THEN N'Backup 3RD'
		  WHEN 59 THEN N'Snap Backup'
		  WHEN 60 THEN N'Backup Copy'
		  WHEN 65 THEN N'Snap Backup3RD'
		  ELSE N'Unknown'
	END AS 'Operation',
	CASE BkpLevel
		  WHEN 1 THEN (CASE WHEN S.AppTypeId IN (45,56,57,58,67,73) THEN N'New Index' ELSE N'Full' END)
		  WHEN 2 THEN (CASE WHEN S.AppTypeId IN (4,5,16,70,81) THEN N'Transaction Log' WHEN S.AppTypeId = 125 THEN N'Log Only' ELSE N'Incremental' END)
		  WHEN 4 THEN (CASE WHEN S.AppTypeId IN (37,62) THEN N'Delta' ELSE N'Differential' END)
		  WHEN 0x40    THEN N'Synthetic Full' WHEN 0x80 THEN N'Synthetic Full' WHEN 0x4000 THEN N'Synthetic Full'
		  WHEN 0x100   THEN (CASE WHEN S.AppTypeId = 104 THEN N'Incremental' ELSE N'Transaction Log' END)
		  WHEN 0x200   THEN N'ASR'
		  WHEN 0x800   THEN N'Snapshot'
		  WHEN 0x1000  THEN N'New Volume Creation'
		  WHEN 0x2000  THEN N'Incremental Volume Update'
		  WHEN 0x400   THEN N'Offline Full'
		  WHEN 0x20000 THEN N'Analysis'
		  WHEN 0x40000 THEN N'Discovery'
		  ELSE N'Unknown'
	END AS 'Job Type',
	CASE ScanType
		  WHEN 1 THEN 'Change Journal'
		  WHEN 2 THEN 'Classic'
		  WHEN 3 THEN 'Mixed'
		  WHEN 4 THEN 'Optimized Scan'
		  ELSE ''
	END AS 'Scan Type',
	CAST(DataProtected/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Application Size (MB)',
	CAST((CASE WHEN DataProtected > 0 AND DataProtected > DataCompressed THEN 100.0*(DataProtected - DataCompressed)/DataProtected ELSE 0 END)
		  AS DECIMAL(20,2)) AS 'Compression Rate (%)',
	CAST(DataTransferred/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Data Transferred (MB)',
	CAST(DataWritten/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Data Written (MB)',
	CAST((CASE WHEN DataProtected > 0 AND DataProtected > DataWritten THEN 100.0*(DataProtected - DataWritten)/DataProtected ELSE 0 END)
		  AS DECIMAL(10,2)) AS 'Space Saving (%)',
	SizeChangePct AS 'Data Size Change (%)',
	CONVERT(VARCHAR(20), DATEADD(SECOND, TransferTime, 0), 108) AS 'Transfer Time',
	CAST((CASE WHEN TransferTime > 0 THEN 3600.0*DataProtected/1024.0/1024.0/1024.0/TransferTime ELSE 0.0 END)
		  AS DECIMAL(10,3)) AS 'Throughput (GB/Hour)',
	StoragePolicy AS 'Storage Policy',
	CAST(ClientGroups AS nvarchar(1024)) AS 'Client Groups',
	ErrorCode AS 'Error Code',
	FailureReason AS 'Failure Reason',
	CASE WHEN S.AppTypeId IN (45,56,57,58,66,67,68,73,82,83,89,90) THEN P.MaxArchiverRetDays
		 ELSE P.MaxRetentionDays
	END AS 'Max Retention Days',
	SchedulePolicy AS 'Schedule Policy',
	ScheduleName AS 'Schedule Name',
	Attempts AS 'Job Attempts'
FROM
	cf_SurveyJobStats J WITH (NOLOCK)
	INNER JOIN cf_SurveySubclients S WITH (NOLOCK) ON J.CommservUniqueId = S.CommservUniqueId AND J.AppId = S.AppId
	INNER JOIN (
		SELECT CommservUniqueId, PolicyId, MAX(RetentionDays) AS MaxRetentionDays, MAX(ArchiverRetDays) AS MaxArchiverRetDays
		FROM cf_SurveyCopyBasicRetention WITH (NOLOCK)
		GROUP BY CommservUniqueId, PolicyId
	) AS P ON P.CommservUniqueId = J.CommservUniqueId AND P.PolicyId = J.StoragePolicyID
	INNER JOIN cf_CommcellIdNameMap as CC WITH (NOLOCK)
            ON CC.ID = J.CommservUniqueId
    INNER JOIN cf_SurveySubclientAssociation SA WITH (NOLOCK)
		ON J.CommservUniqueId = SA.CommservUniqueId AND J.AppId = SA.AppId
WHERE
	J.EndDate > DATEDIFF(s, '1970-01-01 00:00:00', DATEADD(d, -7, GETUTCDATE()))
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [Last7DayBackupDetails]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/Last7DayBackupDbSize.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: Last7DayBackupDbSize"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[Last7DayBackupDbSize]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[Last7DayBackupDbSize]
GO

delete from GXDBVersions where name = 'Last7DayBackupDbSize' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'Last7DayBackupDbSize', '1.6', 'Last7DayBackupDbSize', '')
GO
CREATE VIEW Last7DayBackupDbSize
AS
SELECT
	CAST(CC.CommCellID AS INT) AS CommCellID,
	CC.CommServName AS CommServName,
	SA.ClientId AS 'ClientID',
	SA.clientName AS Client,
	ISNULL(SA.PhysicalClientName,SA.clientName) AS PhysicalClientName,
	SA.AppTypeId AS 'AgentID',
	S.AgentName AS 'Agent',
	SA.InstanceId AS 'InstanceID',
	S.InstanceName AS 'Instance',
	SA.BackupsetId AS 'BackupSetID',
	S.BackupsetName AS 'Backupset',
	SA.AppId AS 'SubclientID',
	S.SubclientName AS 'Subclient',
	J.JobId AS 'Job ID',
	StartDate AS 'Start Time',
	DATEADD(second, StartDate, CAST('1970-01-01 00:00:00' AS datetime)) AS 'StartDate',
	EndDate AS 'End Time',
	DATEADD(second, EndDate, CAST('1970-01-01 00:00:00' AS datetime)) AS 'EndDate',
	CASE Status
		  WHEN 0 THEN 'Running'
		  WHEN 1 THEN 'Completed'
		  WHEN 2 THEN 'Failed'
		  WHEN 3 THEN 'Completed with errors'
		  WHEN 4 THEN 'Killed'
		  WHEN 5 THEN 'Suspended'
		  WHEN 6 THEN 'Interrupted'
		  WHEN 7 THEN 'Any Status'
		  WHEN 8 THEN 'Skipped'
		  WHEN 9 THEN 'Failed To Start'
		  WHEN 10 THEN 'Synchronized'
		  WHEN 11 THEN 'Not Synchronized'
		  WHEN 12 THEN 'Not Attempted'
		  WHEN 13 THEN 'Started'
		  WHEN 14 THEN 'Completed with warnings'
		  WHEN 15 THEN 'System Failed'
		  WHEN 16 THEN 'Committed'
		  ELSE 'Unknown'
	END AS 'Job Status',
	CASE OpType
		  WHEN 4 THEN (CASE WHEN S.AppTypeId = 67 THEN N'Compliance Archive' ELSE N'Backup' END)
		  WHEN 14 THEN N'Synthetic Full'
		  WHEN 18 THEN N'Backup 3RD'
		  WHEN 59 THEN N'Snap Backup'
		  WHEN 60 THEN N'Backup Copy'
		  WHEN 65 THEN N'Snap Backup3RD'
		  ELSE N'Unknown'
	END AS 'Operation',
	CASE BkpLevel
		  WHEN 1 THEN (CASE WHEN S.AppTypeId IN (45,56,57,58,67,73) THEN N'New Index' ELSE N'Full' END)
		  WHEN 2 THEN (CASE WHEN S.AppTypeId IN (4,5,16,70,81) THEN N'Transaction Log' WHEN S.AppTypeId = 125 THEN N'Log Only' ELSE N'Incremental' END)
		  WHEN 4 THEN (CASE WHEN S.AppTypeId IN (37,62) THEN N'Delta' ELSE N'Differential' END)
		  WHEN 0x40    THEN N'Synthetic Full' WHEN 0x80 THEN N'Synthetic Full' WHEN 0x4000 THEN N'Synthetic Full'
		  WHEN 0x100   THEN (CASE WHEN S.AppTypeId = 104 THEN N'Incremental' ELSE N'Transaction Log' END)
		  WHEN 0x200   THEN N'ASR'
		  WHEN 0x800   THEN N'Snapshot'
		  WHEN 0x1000  THEN N'New Volume Creation'
		  WHEN 0x2000  THEN N'Incremental Volume Update'
		  WHEN 0x400   THEN N'Offline Full'
		  WHEN 0x20000 THEN N'Analysis'
		  WHEN 0x40000 THEN N'Discovery'
		  ELSE N'Unknown'
	END AS 'Job Type',
	CASE ScanType
		  WHEN 1 THEN 'Change Journal'
		  WHEN 2 THEN 'Classic'
		  WHEN 3 THEN 'Mixed'
		  WHEN 4 THEN 'Optimized Scan'
		  ELSE ''
	END AS 'Scan Type',
	CAST(DataProtected/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Application Size (MB)',
	CAST((CASE WHEN DataProtected > 0 AND DataProtected > DataCompressed THEN 100.0*(DataProtected - DataCompressed)/DataProtected ELSE 0 END)
		  AS DECIMAL(20,2)) AS 'Compression Rate (%)',
	CAST(DataTransferred/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Data Transferred (MB)',
	CAST(DataWritten/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Data Written (MB)',
	CAST((CASE WHEN DataProtected > 0 AND DataProtected > DataWritten THEN 100.0*(DataProtected - DataWritten)/DataProtected ELSE 0 END)
		  AS DECIMAL(10,2)) AS 'Space Saving (%)',
	SizeChangePct AS 'Data Size Change (%)',
	CONVERT(VARCHAR(20), DATEADD(SECOND, TransferTime, 0), 108) AS 'Transfer Time',
	CAST((CASE WHEN TransferTime > 0 THEN 3600.0*DataProtected/1024.0/1024.0/1024.0/TransferTime ELSE 0.0 END)
		  AS DECIMAL(10,3)) AS 'Throughput (GB/Hour)',
	StoragePolicy AS 'Storage Policy',
	CAST(ClientGroups AS nvarchar(1024)) AS 'Client Groups',
	ErrorCode AS 'Error Code',
	FailureReason AS 'Failure Reason',
	CASE WHEN S.AppTypeId IN (45,56,57,58,66,67,68,73,82,83,89,90) THEN P.MaxArchiverRetDays
		 ELSE P.MaxRetentionDays
	END AS 'Max Retention Days',
	SchedulePolicy AS 'Schedule Policy',
	ScheduleName AS 'Schedule Name',
	Attempts AS 'Job Attempts',
	DbName AS 'DB Name',
	CAST(DbSize/1024.0/1024.0 AS DECIMAL(30,3)) AS 'DB Size (MB)'
FROM
	cf_SurveyJobStats J WITH (NOLOCK)
	INNER JOIN cf_SurveySubclients S WITH (NOLOCK) ON J.CommservUniqueId = S.CommservUniqueId AND J.AppId = S.AppId
	INNER JOIN (
		SELECT CommservUniqueId, PolicyId, MAX(RetentionDays) AS MaxRetentionDays, MAX(ArchiverRetDays) AS MaxArchiverRetDays
		FROM cf_SurveyCopyBasicRetention WITH (NOLOCK)
		GROUP BY CommservUniqueId, PolicyId
	) AS P ON P.CommservUniqueId = J.CommservUniqueId AND P.PolicyId = J.StoragePolicyID
	INNER JOIN cf_CommcellIdNameMap as CC WITH (NOLOCK)
            ON CC.ID = J.CommservUniqueId
    INNER JOIN cf_SurveySubclientAssociation SA WITH (NOLOCK)
		ON J.CommservUniqueId = SA.CommservUniqueId AND J.AppId = SA.AppId
	INNER JOIN cf_SurveyJobDbSize DS WITH (NOLOCK) ON J.CommservUniqueId = DS.CommservUniqueId AND J.jobId = DS.jobId
WHERE
	J.EndDate > DATEDIFF(s, '1970-01-01 00:00:00', DATEADD(d, -7, GETUTCDATE()))
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [Last7DayBackupDbSize]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/Last7DayRestoreDetails.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: Last7DayRestoreDetails"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[Last7DayRestoreDetails]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[Last7DayRestoreDetails]
GO

delete from GXDBVersions where name = 'Last7DayRestoreDetails' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'Last7DayRestoreDetails', '1.9', 'Last7DayRestoreDetails', '')
GO
CREATE VIEW [dbo].[Last7DayRestoreDetails]
AS
SELECT
	CAST(cc.CommCellID AS INT) AS CommCellID,
	cc.CommServName AS CommServName,
	Jobid AS JobID,
    CASE JobStatus
		WHEN 1 THEN 'Success'
		WHEN 2 THEN 'Failed'
		WHEN 3 THEN 'PartialSuccess'
		WHEN 4 THEN 'Killed'
		WHEN 5 THEN 'Stopped'
		WHEN 6 THEN 'Interrupted'
		WHEN 9 THEN 'Failed to Start'
		ELSE 'Unknown'
    END AS JobStatus,
	SrcClientId AS SrcClientID,
	SrcClientName AS SrcClientName,
	ISNULL(SrcPhysicalClientName,SrcClientName) AS SrcPhysicalClientName,
	DestClientId AS DestClientID,
	DestClientName AS DestClientName,
	ISNULL(DestPhysicalClientName,DestClientName) AS DestPhysicalClientName,
	AppTypeId AS AgentID,
	AppType AS AgentName,
	InstanceId AS InstanceID,
	case Instance
		when 'DefaultInstanceName' then ''
		when 'defaultDummyInstanceForOracle' then ''
		else Instance
	end AS InstanceName,
	BkpsetId AS BackupsetID,
	case AppTypeId
		when 6 then 'NULL'
		when 9 then 'NULL'
		when 15 then 'NULL'
		when 27 then 'NULL'
		when 31 then 'NULL'
		else Bkpset
	end AS BackupsetName,
	StartTime,
	DATEADD(second, StartTime, CAST('1970-01-01 00:00:00' AS datetime)) AS 'StartDate',
	EndTime,
	DATEADD(second, EndTime, CAST('1970-01-01 00:00:00' AS datetime)) AS 'EndDate',
	Duration,
	TotFiles2xfer AS TotalObjects,
	TotSuccess AS SuccessfulObjects,
	SkippedObjects,
	FailedObjects,
	TotUnCompMB AS 'ApplicationSizeInMB',
	ErrorCode,
	FailedReason,
	UserName,
	CAST(JobDescription AS nvarchar(1024)) AS 'JobDescription'
FROM cf_SurveyRestoreJobStats AS J WITH (NOLOCK)
	INNER JOIN cf_CommcellIdNameMap as cc WITH (NOLOCK)
		ON J.CommservUniqueId = cc.ID
WHERE J.EndTime BETWEEN dbo.GetUnixTimeBig(DATEADD(d, -7, GETUTCDATE())) AND dbo.GetUnixTimeBig(GETUTCDATE())
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [Last7DayRestoreDetails]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/BkpJobStatus_WMonView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: BkpJobStatus_WMonView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BkpJobStatus_WMonView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[BkpJobStatus_WMonView]
GO

delete from GXDBVersions where name = 'BkpJobStatus_WMonView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'BkpJobStatus_WMonView', '1.4', 'BkpJobStatus_WMonView', '')
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE VIEW BkpJobStatus_WMonView
as
	WITH R1(N,CommServUniqueId,CommCellID,LogDate) AS
	(
	SELECT 0,CommServUniqueId,CommCellID,DATEADD(MONTH,-0,DATEADD(DAY, -(DAY(CAST(LogDate AS DATE))-1),CAST(LogDate AS DATE))) from	dbo.cf_SurveyResultFuncV1(51, 0, 1, null, null,-1,-1) AS resultView
	UNION ALL
	SELECT N+1,CommServUniqueId,CommCellID,DATEADD(MONTH,-1,LogDate) FROM R1
	WHERE N < 11
	)
	select R1.CommServUniqueId,R1.CommCellID,
		S_Rate = ISNULL(CAST(CASE SUM(csInfo.SuccessfulJobs +csInfo.CompletedWithErrorJobs+csInfo.CompletedWithWarningJobs)
							WHEN 0 THEN 0
							ELSE (SUM(csInfo.SuccessfulJobs+csInfo.CompletedWithErrorJobs+csInfo.CompletedWithWarningJobs) * 100.0)/SUM(csInfo.TotalJobs)
						 END
						AS DECIMAL(7, 1)),-1),
		Total					= ISNULL(SUM(csInfo.TotalJobs),-1) ,
		Successful				= ISNULL(SUM(csInfo.SuccessfulJobs),-1) ,
		CompletedWithErrorJobs	= ISNULL(SUM(csInfo.CompletedWithErrorJobs),-1) ,
		CompletedWithWarningJobs= ISNULL(SUM(csInfo.CompletedWithWarningJobs),-1) ,
		Failed			= ISNULL(SUM(csInfo.FailedJobs),-1),
		Killed			= ISNULL(SUM(csInfo.KilledJobs),-1),
		servEndDate		= R1.LogDate
		FROM R1 LEFT OUTER JOIN
			( SELECT csInfo.* FROM cf_SurveyBkpJobStats_WMon AS csInfo WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(51, 0, 1, null, null,-1,-1) AS resultView
				ON resultView.SurverResultId = csInfo.SurveyResultId
				AND csInfo.outType =1 ) csInfo ON R1.LogDate = csInfo.servEndDate
			AND R1.CommservUniqueId = csInfo.CommServUniqueId
			GROUP BY R1.LogDate,R1.CommServUniqueId,R1.CommCellID
go
SET QUOTED_IDENTIFIER ON
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [BkpJobStatus_WMonView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/ClientStoragePolicyAssociation.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: ClientStoragePolicyAssociation"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ClientStoragePolicyAssociation]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[ClientStoragePolicyAssociation]
GO

delete from GXDBVersions where name = 'ClientStoragePolicyAssociation' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'ClientStoragePolicyAssociation', '1.8', 'ClientStoragePolicyAssociation', '')
GO
CREATE VIEW [dbo].[ClientStoragePolicyAssociation]
AS
SELECT      CAST(CC.CommCellID AS INT) AS CommCellID,
            CC.CommServName,
            SC.ClientId,
            SA.clientName AS ClientName,
			ISNULL(SA.PhysicalClientName,SA.clientName) AS PhysicalClientName,
            SC.AgentId,
            SC.AgentName,
            SC.InstanceId,
            SC.InstanceName,
            SC.BackupSetId,
            SC.BackupsetName,
            SC.SubclientId,
            SC.subclientName,
            SC.Content,
            SchedulePolicy,
            ScheduleName,
            SchedBackupType,
            SchedPattern,
            SchedBackupDay,
            SchedBackupTime,
            SchedNextBackupTime,
            Copy.PolicyName,
            Copy.CopyName,
            CASE Copy.IsDefaultCopy
                  WHEN 1 THEN (CASE Copy.IsSnapCopy WHEN 1 THEN 'Primary Snap' ELSE 'Primary' END)
                  ELSE (CASE Copy.CopyType
                              WHEN 1 THEN (CASE Copy.IsSnapCopy WHEN 1 THEN 'Synchronous Snap' ELSE 'Synchronous' END)
                              ELSE (CASE Copy.IsSnapCopy WHEN 1 THEN 'Selective Snap' ELSE 'Selective' END)
                          END)
            END AS CopyType,
            Copy.RetentionDays,
            Copy.RetentionCycles,
            CASE AC.type WHEN 0 THEN 'All full'
						 WHEN 1 THEN 'Cycle'
						 WHEN 2 THEN 'Weekly Fulls'
						 WHEN 3 THEN 'Daily Fulls'
						 WHEN 4 THEN (CASE AC.NumPeriod
											WHEN 3 THEN 'Quarterly Fulls'
											WHEN 6 THEN 'Half Yearly Fulls'
											WHEN 12 THEN 'Yearly Fulls'
											ELSE 'Monthly' END)
						 WHEN 6 THEN 'Monthy On weekday'
						 WHEN 8 THEN 'Copy last full when auxillary copy starts'
						 WHEN 9 THEN 'Manual'
						 WHEN 10 THEN 'Hourly'
						 ELSE ''
			END AS 'Job Selection',
            CASE WHEN AC.type = 4 AND AC.NumPeriod IN (3,6,12) THEN '1'
											ELSE ISNULL(CAST(AC.NumPeriod AS varchar(5)),'') END AS 'Frequency',
            CASE AC.type WHEN 2 THEN (CASE AC.dayNumber
											WHEN 0 THEN 'Sunday'
											WHEN 1 THEN 'Monday'
											WHEN 2 THEN 'Tuesday'
											WHEN 3 THEN 'Wednesday'
											WHEN 4 THEN 'Thursday'
											WHEN 5 THEN 'Friday'
											WHEN 6 THEN 'Saturday' END)
						WHEN 4 THEN CAST(AC.dayNumber AS varchar(5))
						ELSE '' END AS 'Week/Month Start Day'
FROM  cf_SurveySubclientAssociation AS SA
      INNER JOIN cf_SurveyCopyBasicRetention AS Copy
            ON SA.DataPolicyId = Copy.PolicyId
            AND SA.CommservUniqueId = Copy.CommservUniqueId
      INNER JOIN cf_CommcellIdNameMap as CC
            ON CC.ID = SA.CommservUniqueId
            AND Copy.CommservUniqueId = CC.ID
			AND SA.CommservUniqueId = CC.ID
      INNER JOIN SubclientContent SC
            ON SC.SubclientID = SA.AppId AND SA.Deleted = 0
            AND SC.CommCellID = CC.CommCellID
      LEFT OUTER JOIN BackupSchedules BS
            ON BS.SubclientID = SA.AppId
            AND BS.CommCellID = CC.CommCellID
      LEFT OUTER JOIN cf_SurveyArchSelectiveCopy AS AC
			ON Copy.CopyId = AC.CopyId
			AND Copy.CommservUniqueId = AC.CommServUniqueId
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [ClientStoragePolicyAssociation]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/ClientDetailsView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: ClientDetailsView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ClientDetailsView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[ClientDetailsView]
GO

delete from GXDBVersions where name = 'ClientDetailsView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'ClientDetailsView', '1.7', 'ClientDetailsView', '')
GO
CREATE VIEW [dbo].[ClientDetailsView]
AS
SELECT      CAST(resultView.CommCellID AS INT) AS CommCellID,
			ISNULL(resultView.CommServName,'') AS CommServName,
			CAST(clientId AS INT) AS ClientID,
			clientName AS ClientName,
			ISNULL(PhysicalClientName,clientName) AS PhysicalClientName,
			operatingSystem AS OperatingSystem ,
			servicePack AS ServicePack,
			installdate AS InstallDate,
			reverse(substring(reverse(ISNULL(timezone,'')),0,charindex(':',reverse(ISNULL(timezone,'')))))  AS 'Timezone',
			CASE WHEN lastbkp = 1 THEN 'Deconfigured'
				 WHEN lastbkp = 2 THEN 'Uninstalled'
				 ELSE 'Installed' END 'Status'
	FROM cf_Survey77ClientDetails csInfo
			INNER JOIN dbo.cf_SurveyResultFuncV1(77,0,1,null,null,-1,-1) resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [ClientDetailsView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/DiskLibrarySummary.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: DiskLibrarySummary"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DiskLibrarySummary]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[DiskLibrarySummary]
GO

delete from GXDBVersions where name = 'DiskLibrarySummary' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'DiskLibrarySummary', '1.3', 'DiskLibrarySummary', '')
GO
CREATE VIEW [dbo].[DiskLibrarySummary]
AS
	SELECT 	R.LogDate,
			R.CommCellID AS 'CommCell ID',
			ISNULL(R.CommServName, '') AS 'CommCell Name',
			L.LibraryName AS 'Library',
			CAST(ISNULL(libInfo.FreeSpaceGB, L.FreeSpaceMB/1024.0) AS DECIMAL(32,2)) AS 'Free Space (GB)',
			CAST(libInfo.UsedSpaceGB AS DECIMAL(32,2))	AS 'Used Space (GB)',
			CAST(libInfo.totalSpaceGB AS DECIMAL(32,2))	AS 'Capacity (GB)',
			--CASE WHEN libInfo.totalAppSizeGB		IS NULL THEN -1 ELSE libInfo.totalAppSizeGB*1024  	 END	AS 'App Size (GB)',
			CASE WHEN L.Offline = 1 THEN 'Yes' ELSE 'No' END AS 'Offline',
			CASE WHEN libInfo.totalSpaceGB 			IS NULL THEN 'N/A'
			     WHEN (libInfo.estimatedSpaceRunoutDays -datediff (DAY,libInfo.LogDateUTC,GETUTCDATE())) > 9999 OR libInfo.estimatedSpaceRunoutDays = -1 OR libInfo.estimatedSpaceRunoutDays IS NULL THEN 'Never'
			     ELSE CONVERT(VARCHAR(15),DATEADD(DAY, libInfo.estimatedSpaceRunoutDays, libInfo.LogDate),107)
			END AS 'Date to be Full'
		FROM	cf_SurveyLibrarySummary AS L WITH (NOLOCK)
				INNER JOIN dbo.cf_SurveyResultFuncV1(117, 0, 1, NULL, NULL, -1,-1) R
						ON L.SurveyResultId = R.SurverResultId
				LEFT OUTER JOIN
				(
					SELECT libInfo.CommServUniqueId, libInfo.LibraryId, libInfo.totalSpaceGB, libInfo.estimatedSpaceRunoutDays, libInfo.LogDate,libInfo.totalAppSizeGB,libInfo.LogDateUTC,
							mpInfo.UsedSpaceGB,mpInfo.FreeSpaceGB
					FROM
					 (SELECT libInfo.CommServUniqueId, libInfo.LibraryId, libInfo.totalSpaceGB, libInfo.estimatedSpaceRunoutDays, libInfo.LogDate,libInfo.totalAppSizeGB,libInfo.LogDateUTC
					  FROM cf_Survey96DiskLibDetails AS libInfo WITH (NOLOCK)
					  INNER JOIN dbo.cf_SurveyResultFuncV1(96, 0, 1, NULL, NULL, -1,-1) R
								ON libInfo.SurveyResultId = R.SurverResultId
					  ) libInfo
					 INNER JOIN
					 (SELECT libInfo.CommServUniqueId, libInfo.LibraryId, SUM(libInfo.UsedSpaceGB) AS UsedSpaceGB, SUM(libInfo.FreeSpaceGB)AS FreeSpaceGB
					  FROM cf_Survey95MountPathDetails AS libInfo WITH (NOLOCK)
					  INNER JOIN dbo.cf_SurveyResultFuncV1(95, 0, 1, NULL, NULL, -1,-1) R
								ON libInfo.SurveyResultId = R.SurverResultId
					  GROUP BY libInfo.CommServUniqueId, libInfo.LibraryId
					  ) mpInfo ON
					mpInfo.CommServUniqueId= libInfo.CommServUniqueId AND
					mpInfo.LibraryId= libInfo.LibraryId
				)libInfo ON
				libInfo.CommServUniqueId= R.CommServUniqueId AND
				libInfo.LibraryId= L.LibraryId
				WHERE L.LibraryTypeId = 3
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [DiskLibrarySummary]'
END
GO

