

--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/BkpJobStatus_WMonView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: BkpJobStatus_WMonView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BkpJobStatus_WMonView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[BkpJobStatus_WMonView]
GO

delete from GXDBVersions where name = 'BkpJobStatus_WMonView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'BkpJobStatus_WMonView', '1.4.2.1', 'BkpJobStatus_WMonView', '')
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE VIEW BkpJobStatus_WMonView
as
	WITH R1(N,CommServUniqueId,CommCellID,LogDate) AS
	(
	SELECT 0,CommServUniqueId,CommCellID,DATEADD(MONTH,-0,DATEADD(DAY, -(DAY(CAST(LogDate AS DATE))-1),CAST(LogDate AS DATE))) from	dbo.cf_SurveyResultFuncV1(173, 0, 1, null, null,-1,-1) AS resultView
	UNION ALL
	SELECT N+1,CommServUniqueId,CommCellID,DATEADD(MONTH,-1,LogDate) FROM R1
	WHERE N < 11
	)
	select R1.CommServUniqueId,R1.CommCellID,
		S_Rate = ISNULL(CAST(CASE SUM(csInfo.CompletedJobs +csInfo.CWEJobs+csInfo.CWWJobs)
							WHEN 0 THEN 0
							ELSE (SUM(csInfo.CompletedJobs+csInfo.CWEJobs+csInfo.CWWJobs) * 100.0)/SUM(csInfo.TotalJobs)
						 END
						AS DECIMAL(7, 1)),-1),
		Total					= ISNULL(SUM(csInfo.TotalJobs),-1) ,
		Successful				= ISNULL(SUM(csInfo.CompletedJobs),-1) ,
		CompletedWithErrorJobs	= ISNULL(SUM(csInfo.CWEJobs),-1) ,
		CompletedWithWarningJobs= ISNULL(SUM(csInfo.CWWJobs),-1) ,
		Failed			= ISNULL(SUM(csInfo.FailedJobs),-1),
		Killed			= ISNULL(SUM(csInfo.KilledJobs),-1),
		servEndDate		= R1.LogDate
		FROM R1 LEFT OUTER JOIN
			( SELECT csInfo.* FROM cf_SurveyIDAMonthlyBkpJobStats AS csInfo WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(173, 0, 1, null, null,-1,-1) AS resultView
				ON resultView.CommServUniqueId = csInfo.CommServUniqueId
				 ) csInfo ON R1.LogDate = csInfo.MonthStart
			AND R1.CommservUniqueId = csInfo.CommServUniqueId
			GROUP BY R1.LogDate,R1.CommServUniqueId,R1.CommCellID
go
SET QUOTED_IDENTIFIER ON
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [BkpJobStatus_WMonView]'
END
GO

