

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/createfeedback.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/createfeedback.sp,v $ $Id: createfeedback.sp,v 1.3.60.2 2018/05/03 03:38:24 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: createfeedback <<<'

IF EXISTS (select * from sysobjects where name='createfeedback')
	drop procedure createfeedback
IF EXISTS (select * from GxQscripts where name='createfeedback')
	delete from GxQscripts where name = 'createfeedback'
GO

IF EXISTS (select * from GXDBVersions where aliasname='createfeedback')
	delete from GXDBVersions where aliasname = 'createfeedback'
GO
print '... Creating Procedure: createfeedback'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure createfeedback
  @i_oemId INT,
  @i_feedbacktypeId INT,
  @i_productId INT,
  @i_source NVARCHAR(MAX),
  @i_release VARCHAR(512),
  @i_subject NVARCHAR(MAX),
  @i_comments NVARCHAR(MAX),
  @i_url NVARCHAR(MAX) ='',
  @i_email NVARCHAR(MAX) = '',	
  @i_fbattribute INT= 0
AS
SET NOCOUNT ON
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	DECLARE @o_fbId			INT			= 0,
			@o_errorCode	INT			= 0,
			@o_errorMessage	VARCHAR(MAX) = ''
	--perform some validation
	IF( NOT EXISTS(SELECT * FROM Feedback_CVOEM WHERE oemId = ISNULL(@i_oemId,0)))
	BEGIN
		SELECT @o_fbId='', @o_errorCode = 101, @o_errorMessage = 'Invalid OEM is provided. Id:'+ CONVERT(VARCHAR(10), ISNULL(@i_oemId,0))
		GOTO EXIT_;
	END
	IF( NOT EXISTS(SELECT * FROM FeedbackType WHERE feedbackTypeId = ISNULL(@i_feedbacktypeId,0)))
	BEGIN
		SELECT @o_fbId='', @o_errorCode = 102, @o_errorMessage = 'Invalid feedback type is provided. Id:'+ CONVERT(VARCHAR(10), ISNULL(@i_feedbacktypeId,0))
		GOTO EXIT_;
	END
	IF( NOT EXISTS(SELECT * FROM Feedback_Product WHERE productId = ISNULL(@i_productId,0)))
	BEGIN
		SELECT @o_fbId='', @o_errorCode = 103, @o_errorMessage = 'Invalid Product is provided. Id:'+ CONVERT(VARCHAR(10), ISNULL(@i_productId,0))
		GOTO EXIT_;
	END
	--Now insert into Feedback table.
	DECLARE @l_fbId INT = 0
	INSERT INTO FeedbackData (refFeedbackTypeId, refOEMId, refProductId, release, sourceValue,attribute, createDate)
	SELECT @i_feedbacktypeId, @i_oemId, @i_productId, @i_release, @i_source, @i_fbattribute, GETUTCDATE();
	SELECT @l_fbId = @@IDENTITY, @o_errorCode = @@ERROR
	IF (@o_errorCode <> 0)
	BEGIN
		SELECT @o_fbId='', @o_errorCode = 104, @o_errorMessage = 'Unexpected error while insreting entry to feedback table. Error Code:'+ CONVERT(VARCHAR(10), ISNULL(@o_errorCode,0))
		GOTO EXIT_;
	END
	--now insert into feedback content
	INSERT INTO FeedbackContent(refFbId,email,subject,url,comments,createDate)
	SELECT @l_fbId, @i_email, @i_subject, @i_url, @i_comments , GETUTCDATE();
	SELECT @o_fbId = @l_fbId
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
EXIT_:
	IF (@o_errorCode <> 0 AND @ProcessSurveyResultTran = 1)
    BEGIN
        ROLLBACK TRANSACTION ProcessSurveyResultTran
        SET @ProcessSurveyResultTran = 0
    END
	SELECT @o_fbId AS FeedbackId, @o_errorCode	AS ErrorCode, @o_errorMessage AS ErrorMessage
END TRY
BEGIN CATCH
/*
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
*/
IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @o_errorCode = 1
	SELECT @o_errorMessage = 'feedback data insertion failed with error :: ' + ERROR_MESSAGE()
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'createfeedback')
	delete from GxQscripts where name = 'createfeedback'
GO

IF EXISTS (select * from GXDBVersions where aliasname='createfeedback')
	delete from GXDBVersions where aliasname = 'createfeedback'
GO

insert into GXDBVersions values(2, 'createfeedback',  '00010003006000020000', 'createfeedback', '00010003006000020000')
GO

