

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Wr_ManageMetricsReports.sp] ---------- 

SET ANSI_NULLS ON
-- 	+-----------------------------------------------------------------------+
--	| 					PROCEDURE: "Wr_ManageMetricsReports"				|
--	|																		|
--	|		Updates Retention/Status for reports as per user input			|
--	|				from the Metrics Reports Settings Page 					|
--	|																		|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Wr_ManageMetricsReports <<<'

IF EXISTS (select * from sysobjects where name='Wr_ManageMetricsReports')
	drop procedure Wr_ManageMetricsReports
IF EXISTS (select * from GxQscripts where name='Wr_ManageMetricsReports')
	delete from GxQscripts where name = 'Wr_ManageMetricsReports'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Wr_ManageMetricsReports')
	delete from GXDBVersions where aliasname = 'Wr_ManageMetricsReports'
GO
print '... Creating Procedure: Wr_ManageMetricsReports'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Wr_ManageMetricsReports
  @i_UserId INT = -1,
  @i_XMLString NVARCHAR(MAX)
AS
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @inputXML XML = CAST(@i_XmlString AS XML)
	DECLARE @ProcessSurveyResultTran INT
	SET @ProcessSurveyResultTran = 0
	BEGIN TRY
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
	/************************************************************************************************
	*	Preparing table #ReportSurveyConfigMap which will hold										*
	*	the retention parameter names in cf_SurveyConfig for some reports.							*
	*	Retention period for some reports are controlled by parameters in cf_SurveyConfig table.	*
	*************************************************************************************************/
		IF OBJECT_ID('tempdb..#ReportSurveyConfigMap') IS NOT NULL DROP TABLE #ReportSurveyConfigMap
		CREATE TABLE #ReportSurveyConfigMap (
			ReportId int,
			ConfigName nvarchar(64),
			RetentionUnit	int	-- 0 -> Days; 1 -> Months
		)
		INSERT INTO #ReportSurveyConfigMap VALUES (1001, 'RetentionMonthsForGrowth', 1)
		INSERT INTO #ReportSurveyConfigMap VALUES (137, 'RetentionMonthsForJobDetails', 1)
		INSERT INTO #ReportSurveyConfigMap VALUES (51, 'DailyActivityRetentionDays', 0)
		INSERT INTO #ReportSurveyConfigMap VALUES (173, 'MonthlyActivityRetentionMonths', 1)
	/************************************************************************************************
	*	Preparing table for the input data															*
	*	This data will be overwritten to the following tables: 										*
	*		cf_WebConsoleReports --> userModifiedProps												*
	*		cf_SurveyConfig --> Retention															*
	*************************************************************************************************/
		IF OBJECT_ID('tempdb..#InputData') IS NOT NULL DROP TABLE #InputData
		CREATE TABLE #InputData (
			ReportId			INT,
			Retention			INT,
			StatusStr			NVARCHAR(MAX),
			Status				INT,
			userModifiedProps	XML
		)
		INSERT INTO #InputData (ReportId, Retention, StatusStr)
			SELECT QueryId, CAST([retention] AS INT), [status]
			FROM
			(
				SELECT	queryInfo.value('@queryId','INT') AS QueryId,
						columnsInfo.value('@name','NVARCHAR(MAX)') AS columnName,
						columnsInfo.value('@value','NVARCHAR(MAX)') AS columnValue
				FROM @inputXML.nodes('/WebReport_ReportConfigReq/queryInfo') queryInfo(queryInfo)
				CROSS APPLY queryInfo.nodes('columnsInfo') AS columnsInfo(columnsInfo)
			) AS SourceTable
			PIVOT
			(
				MAX(columnValue)
				FOR columnName IN ([retention],[status])
			) AS PivotTable
		UPDATE	#InputData
		SET		Status = CASE WHEN StatusStr = 'Enabled' THEN 1
							  ELSE 0
						 END
	/************************************************************************************************************
	*	Converting input retention to months/days as saved in cf_WebConsoleReports/cf_SurveyConfig				*
	*************************************************************************************************************/
		UPDATE I
		SET Retention = CASE
WHEN (Map.ReportId IS NULL AND R.OpFlags & 4 <> 0)		THEN	CAST(CAST(I.Retention * 30.42 + 1 AS DECIMAL(10,0)) AS nvarchar(max))
WHEN (R.OpFlags & 4 = 0 AND Map.RetentionUnit = 1)		THEN	CAST(CAST((I.Retention-1) / 30.42 AS DECIMAL(10,0)) AS nvarchar(max))
WHEN (R.OpFlags & 4 <> 0 AND Map.RetentionUnit = 0)	THEN	CAST(CAST(I.Retention * 30.42 + 1 AS DECIMAL(10,0)) AS nvarchar(max))
							ELSE I.Retention
						END,
			userModifiedProps = R.userModifiedProps
		FROM #InputData I LEFT OUTER JOIN cf_WebConsoleReports R ON I.ReportId = R.ReportId
			LEFT OUTER JOIN #ReportSurveyConfigMap Map ON Map.ReportId = R.ReportId
	/************************************************************************************************************
	*	Setting unmodified retention and status to -1															*
	*************************************************************************************************************/
	UPDATE I
	SET Retention = -1
	FROM #InputData I INNER JOIN dbo.RptMetricsReportsFlags(0) R ON R.ReportId = I.ReportId
	WHERE I.Retention = R.Retention
	UPDATE I
	SET Status = -1
	FROM #InputData I INNER JOIN dbo.RptMetricsReportsFlags(0) R ON R.ReportId = I. ReportId
	WHERE I.Status = R.Status
	/************************************************************************************************************
	*	Preparing new userModifiedProps XML																		*
	*************************************************************************************************************/
	UPDATE #InputData
	SET userModifiedProps = (SELECT Retention AS '@retention' FOR XML PATH('userModifiedProps'))
	WHERE Retention > -1
		AND userModifiedProps IS NULL
		AND ReportId NOT IN (SELECT ReportId FROM #ReportSurveyConfigMap)  --Do not enter new retention values to userModifiedProps XML for retentions in cf_SurveyConfig
	UPDATE #InputData
	SET userModifiedProps.modify('replace value of (userModifiedProps/@retention)[1] with sql:column("Retention")')
	WHERE userModifiedProps.exist('userModifiedProps/@retention') = 1
		AND Retention > -1
		AND ReportId NOT IN (SELECT ReportId FROM #ReportSurveyConfigMap)  --Do not enter new retention values to userModifiedProps XML for retentions in cf_SurveyConfig
	UPDATE #InputData
	SET userModifiedProps.modify('insert attribute retention {sql:column("Retention")} into (userModifiedProps)[1]')
	WHERE userModifiedProps.exist('userModifiedProps/@retention') = 0
		AND Retention > -1
		AND ReportId NOT IN (SELECT ReportId FROM #ReportSurveyConfigMap)  --Do not enter new retention values to userModifiedProps XML for retentions in cf_SurveyConfig
	UPDATE #InputData
	SET userModifiedProps = (SELECT Status AS '@status' FOR XML PATH('userModifiedProps'))
	WHERE Status > -1 AND userModifiedProps IS NULL
	UPDATE #InputData
	SET userModifiedProps.modify('replace value of (userModifiedProps/@status)[1] with sql:column("Status")')
	WHERE userModifiedProps.exist('userModifiedProps/@status') = 1
		AND Status > -1
	UPDATE #InputData
	SET userModifiedProps.modify('insert attribute status {sql:column("Status")} into (userModifiedProps)[1]')
	WHERE userModifiedProps.exist('userModifiedProps/@status') = 0
		AND Status > -1
	/************************************************************************************************
	*	Updating Retention in table cf_SurveyConfig													*
	*************************************************************************************************/
		UPDATE SC
		SET value = CAST(I.Retention AS nvarchar(max)),
			LogDateUTC = GETUTCDATE()
		FROM cf_SurveyConfig SC INNER JOIN #ReportSurveyConfigMap Map ON SC.name = Map.ConfigName
			INNER JOIN #InputData I ON Map.ReportId = I.ReportId
		WHERE I.Retention > -1
	/************************************************************************************************
	*	Updating userModifiedProps in cf_WebConsoleReports											*
	*************************************************************************************************/
		UPDATE R
		SET userModifiedProps = I.userModifiedProps
		FROM cf_WebConsoleReports R INNER JOIN #InputData I ON I.ReportId = R.ReportId
		IF (@ProcessSurveyResultTran = 1)
		BEGIN
			COMMIT TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 0
		END
	END TRY
	BEGIN CATCH
/*
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
*/
		IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
		BEGIN
			ROLLBACK TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 0
		END
	END CATCH
	IF OBJECT_ID('tempdb..#InputData') IS NOT NULL		DROP TABLE #InputData
	IF OBJECT_ID('tempdb..#ReportSurveyConfigMap') IS NOT NULL	DROP TABLE #ReportSurveyConfigMap
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Wr_ManageMetricsReports')
	delete from GxQscripts where name = 'Wr_ManageMetricsReports'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Wr_ManageMetricsReports')
	delete from GXDBVersions where aliasname = 'Wr_ManageMetricsReports'
GO

insert into GXDBVersions values(2, 'Wr_ManageMetricsReports',  '00000000000000000000', 'Wr_ManageMetricsReports', '00000000000000000000')
GO

