

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Rpt_95MountPathDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Rpt_95MountPathDetails.sp,v $ $Id: Rpt_95MountPathDetails.sp,v 1.9.12.6 2019/08/22 16:31:46 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='Rpt_95MountPathDetails')
BEGIN
	print '>>> Drop Stored Procedure: Rpt_95MountPathDetails <<<'
	drop procedure Rpt_95MountPathDetails
END
IF EXISTS (select * from GxQscripts where name='Rpt_95MountPathDetails')
	delete from GxQscripts where name = 'Rpt_95MountPathDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Rpt_95MountPathDetails')
	delete from GXDBVersions where aliasname = 'Rpt_95MountPathDetails'
GO
print '... Creating Procedure: Rpt_95MountPathDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Rpt_95MountPathDetails
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 117
DECLARE @showHiddenLibraries INT = 0
IF EXISTS (SELECT TOP 1 1 FROM cf_SurveyConfig WHERE name = 'showHiddenLibraries' AND value = '1')
	SET @showHiddenLibraries = 1
IF(@blaggregate=1)
RETURN
IF(@i_CommServUniqueID = 0)
BEGIN
	SELECT DISTINCT
		resultView.CommServUniqueId  AS 'CommServ UniqueId',
		resultView.CommCellID AS 'CommCell ID'
		, resultView.DisplayName AS 'CommCell Name'
		, LP.LibraryName  AS 'Library'
		, csInfo.MountPathName  AS 'Mount Path'
		, ISNULL(csInfo.BaseFolder, 'N/A') AS 'Base Folder<HIDDEN>'
		, ISNULL(csInfo.DeviceName, 'N/A') AS 'Device Name<HIDDEN>'
		, CASE WHEN csInfo.Offline = 1 THEN 'Offline' ELSE 'Online' END AS 'Mount Path Status'
		, csInfo.FreeSpaceMB  AS 'Free Space<SIZEMB>'
		, csInfo.TotalSpaceMB AS 'Total Capacity<SIZEMB>'
		, CASE WHEN csInfo.TotalSpaceMB > 0 THEN (csInfo.TotalSpaceMB - csInfo.FreeSpaceMB)
		       ELSE csInfo.DataWrittenMB END AS 'Used Space<SIZEMB>'
		, CASE WHEN csInfo.TotalSpaceMB > 0 THEN CAST(100.0*csInfo.FreeSpaceMB/csInfo.TotalSpaceMB AS DECIMAL(20,2))
		       ELSE 0.0 END AS 'Free Space (%)'
	FROM cf_SurveyMountPathSummary AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
		INNER JOIN cf_SurveyLibrary LP WITH(NOLOCK) ON resultView.CommServUniqueId = LP.CommservUniqueId AND csInfo.LibraryId = LP.LibraryId AND (@showHiddenLibraries = 1 OR LP.Hidden = 0)
	ORDER BY [CommCell Name], [Free Space (%)]
END
ELSE
BEGIN
	SELECT DISTINCT
		 LP.LibraryName  AS 'Library'
		, csInfo.MountPathName  AS 'Mount Path'
		, ISNULL(csInfo.BaseFolder, 'N/A') AS 'Base Folder<HIDDEN>'
		, ISNULL(csInfo.DeviceName, 'N/A') AS 'Device Name<HIDDEN>'
		, CASE WHEN csInfo.Offline = 1 THEN 'Offline' ELSE 'Online' END AS 'Mount Path Status'
		, csInfo.FreeSpaceMB  AS 'Free Space<SIZEMB>'
		, csInfo.TotalSpaceMB AS 'Total Capacity<SIZEMB>'
		, CASE WHEN csInfo.TotalSpaceMB > 0 THEN (csInfo.TotalSpaceMB - csInfo.FreeSpaceMB)
		       ELSE csInfo.DataWrittenMB END AS 'Used Space<SIZEMB>'
		, CASE WHEN csInfo.TotalSpaceMB > 0 THEN CAST(100.0*csInfo.FreeSpaceMB/csInfo.TotalSpaceMB AS DECIMAL(20,2))
		       ELSE 0.0 END AS 'Free Space (%)'
	FROM cf_SurveyMountPathSummary AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
		INNER JOIN cf_SurveyLibrary LP WITH(NOLOCK) ON resultView.CommServUniqueId = LP.CommservUniqueId AND csInfo.LibraryId = LP.LibraryId AND (@showHiddenLibraries = 1 OR LP.Hidden = 0)
	ORDER BY [Free Space (%)]
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Rpt_95MountPathDetails')
	delete from GxQscripts where name = 'Rpt_95MountPathDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Rpt_95MountPathDetails')
	delete from GXDBVersions where aliasname = 'Rpt_95MountPathDetails'
GO

insert into GXDBVersions values(2, 'Rpt_95MountPathDetails',  '00010009001200060000', 'Rpt_95MountPathDetails', '00010009001200060000')
GO

