

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Rpt_91ProtectedDataPerAgent6WeekInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Rpt_91ProtectedDataPerAgent6WeekInfo.sp,v $ $Id: Rpt_91ProtectedDataPerAgent6WeekInfo.sp,v 1.7 2015/01/22 02:55:10 ashajikumar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Rpt_91ProtectedDataPerAgent6WeekInfo <<<'

IF EXISTS (select * from sysobjects where name='Rpt_91ProtectedDataPerAgent6WeekInfo')
	drop procedure Rpt_91ProtectedDataPerAgent6WeekInfo
IF EXISTS (select * from GxQscripts where name='Rpt_91ProtectedDataPerAgent6WeekInfo')
	delete from GxQscripts where name = 'Rpt_91ProtectedDataPerAgent6WeekInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Rpt_91ProtectedDataPerAgent6WeekInfo')
	delete from GXDBVersions where aliasname = 'Rpt_91ProtectedDataPerAgent6WeekInfo'
GO
print '... Creating Procedure: Rpt_91ProtectedDataPerAgent6WeekInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Rpt_91ProtectedDataPerAgent6WeekInfo
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 91
DECLARE @TblSize TABLE (
	weekNo INT,
	endDate DATE,
	AgentType VARCHAR(256),
	FullAppSize FLOAT,
	NonFullAppSize FLOAT,
	FullJobCount INT,
	NonFullJobCount INT,
	TotalSizeChangePct FLOAT
	)
INSERT INTO @TblSize
SELECT
csInfo.weekNo,
csInfo.endDate,
csInfo.AgentType,
SUM(csInfo.FullAppSize)/(1024.0*1024.0*1024.0)  ,
SUM(csInfo.NonFullAppSize)/(1024.0*1024.0*1024.0)  ,
SUM(csInfo.FullJobCount)  ,
SUM(csInfo.NonFullJobCount)  ,0.0
FROM cf_Survey91ProtectedDataPerAgent6WeekInfo AS csInfo WITH (NOLOCK)
INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
ON resultView.SurverResultId = csInfo.SurveyResultId
AND resultView.LogDateUTC = csInfo.LogDateUTC
AND resultView.CommServUniqueId = csInfo.CommServUniqueId
AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
GROUP BY csInfo.AgentType,csInfo.weekNo,csInfo.endDate
UPDATE	@TblSize
SET		TotalSizeChangePct = CASE WHEN T.totalSize = 0 THEN 0
	ELSE 100.0*(S.FullAppSize + S.NonFullAppSize - T.totalSize)/T.totalSize END
FROM	@TblSize S
INNER JOIN (SELECT weekNo ,AgentType ,(FullAppSize + NonFullAppSize) AS totalSize FROM @TblSize) T
	ON S.weekNo = (T.weekNo + 1) AND S.AgentType = T.AgentType
IF(@blaggregate=1)
BEGIN
	DECLARE @TotalFull FLOAT
	DECLARE @TotalNonFull FLOAT
	SELECT @TotalFull=SUM(FullAppSize),@TotalNonFull=SUM(NonFullAppSize)
		FROM (SELECT AVG(FullAppSize) AS FullAppSize,
			AVG(NonFullAppSize) As NonFullAppSize
			FROM @TblSize
			GROUP BY AgentType) A
	SELECT AgentType,
			CAST(ROUND(AVG(FullAppSize),3) AS DECIMAL(20,3)) AS FullAppSizeGB,
			CAST(ROUND(AVG(NonFullAppSize),3) AS DECIMAL(20,3)) As NonFullAppSizeGB,
			CAST(ROUND(AVG(TotalSizeChangePct),2) AS DECIMAL(20,2)) AS WeeklyChange,
			CASE @TotalFull WHEN 0 THEN -1
			ELSE CAST(ROUND((AVG(FullAppSize)/@TotalFull)*100.0 ,2) AS DECIMAL(15,3)) END AS 'PerFullBckUp'
			FROM @TblSize GROUP BY AgentType ORDER BY AgentType
END
ELSE
BEGIN
	SELECT weekNo,
		   SUBSTRING(CONVERT(VARCHAR(15),endDate,101),1,5)+'-'+SUBSTRING(CONVERT(VARCHAR(15),DATEADD(DAY,-6,endDate),101),1,5) AS Interval,
		   AgentType,
		   FullAppSize,
		   NonFullAppSize,
		   FullJobCount,
		   NonFullJobCount,
		   TotalSizeChangePct
		   FROM @TblSize WHERE weekNo > 1 ORDER BY AgentType,weekNo DESC
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Rpt_91ProtectedDataPerAgent6WeekInfo')
	delete from GxQscripts where name = 'Rpt_91ProtectedDataPerAgent6WeekInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Rpt_91ProtectedDataPerAgent6WeekInfo')
	delete from GXDBVersions where aliasname = 'Rpt_91ProtectedDataPerAgent6WeekInfo'
GO

insert into GXDBVersions values(2, 'Rpt_91ProtectedDataPerAgent6WeekInfo',  '00010007000000000000', 'Rpt_91ProtectedDataPerAgent6WeekInfo', '00010007000000000000')
GO

