

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Rpt_73Backup_Count.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Rpt_73Backup_Count.sp,v $ $Id: Rpt_73Backup_Count.sp,v 1.5.56.3 2016/11/29 17:58:33 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Rpt_73Backup_Count <<<'

IF EXISTS (select * from sysobjects where name='Rpt_73Backup_Count')
	drop procedure Rpt_73Backup_Count
IF EXISTS (select * from GxQscripts where name='Rpt_73Backup_Count')
	delete from GxQscripts where name = 'Rpt_73Backup_Count'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Rpt_73Backup_Count')
	delete from GXDBVersions where aliasname = 'Rpt_73Backup_Count'
GO
print '... Creating Procedure: Rpt_73Backup_Count'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Rpt_73Backup_Count
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 73
IF(@blaggregate=1)
RETURN
ELSE
BEGIN
	SELECT
		resultView.CommServUniqueId  AS 'CommServ UniqueId',
		resultView.CommCellID AS 'CommCell ID',
		resultView.DisplayName AS 'CommCell Name',
		ISNULL((SELECT COUNT(*)
			FROM [cf_SurveyClient] AS csInfo3
			WHERE csInfo3.Deleted = 0 AND (type&1)=1
			AND csInfo.CommServUniqueId=csInfo3.CommServUniqueId
			),0) AS 'No Laptop Clients'
		,ISNULL(( SELECT COUNT(*)
			FROM [cf_SurveyClient]    AS csInfo3
			WHERE csInfo3.Deleted = 0 AND (type&2)=2
			AND csInfo.CommServUniqueId=csInfo3.CommServUniqueId
			),0) AS 'No Media Agents'
		,ISNULL(( SELECT COUNT(*)
			FROM [cf_SurveyClient]  AS csInfo3
				INNER JOIN dbo.cf_SurveyResultFuncV1(77, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS R
				ON R.CommServUniqueId = csInfo3.CommServUniqueId
			WHERE InstallDate>R.LogDateUTC-1
			AND csInfo3.Deleted = 0 AND type&8 !=8  --Ignore VMs which are virtually discovered and deconfigured.
			AND csInfo.CommServUniqueId=csInfo3.CommServUniqueId
			),0) AS 'Clients Installed (24 hrs)'
		, csInfo.Backup_Count_successJobCountPerDay  AS 'Completed Jobs (24 hrs)'
		, csInfo.Backup_Count_failureJobCountPerDay  AS 'Failed Jobs (24 hrs)'
		, csInfo.Backup_Count_topJobCountPerHour     AS 'Top Jobs Per Hour (24 hrs)'
	FROM
		cf_Survey73Backup_Count AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND resultView.LogDateUTC = csInfo.LogDateUTC
		AND resultView.CommServUniqueId = csInfo.CommServUniqueId
		AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
		AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
	ORDER BY csInfo.LogDate DESC, resultView.CustomerName ASC
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Rpt_73Backup_Count')
	delete from GxQscripts where name = 'Rpt_73Backup_Count'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Rpt_73Backup_Count')
	delete from GXDBVersions where aliasname = 'Rpt_73Backup_Count'
GO

insert into GXDBVersions values(2, 'Rpt_73Backup_Count',  '00010005005600030000', 'Rpt_73Backup_Count', '00010005005600030000')
GO

