

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Rpt_106ClientVersion.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Rpt_106ClientVersion.sp,v $ $Id: Rpt_106ClientVersion.sp,v 1.7.2.7 2020/12/30 14:38:13 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='Rpt_106ClientVersion')
BEGIN
	print '>>> Drop Stored Procedure: Rpt_106ClientVersion <<<'
	drop procedure Rpt_106ClientVersion
END
IF EXISTS (select * from GxQscripts where name='Rpt_106ClientVersion')
	delete from GxQscripts where name = 'Rpt_106ClientVersion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Rpt_106ClientVersion')
	delete from GXDBVersions where aliasname = 'Rpt_106ClientVersion'
GO
print '... Creating Procedure: Rpt_106ClientVersion'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure Rpt_106ClientVersion
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NULL
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 12
IF @blaggregate = 1
BEGIN
	IF(@i_CommServUniqueID<=0)
	BEGIN
		IF object_id('tempdb.dbo.#TAB1') is not null
			DROP TABLE #TAB1
		IF object_id('tempdb.dbo.#MONTHS') is not null
			DROP TABLE #MONTHS
		CREATE TABLE #MONTHS (MM INT,YEARS INT)
		CREATE TABLE #TAB1 (MM INT,YY INT,MONTHS VARCHAR(15),V11 INT,V10 INT,V9 INT)
		DECLARE @CNT INT
		DECLARE @STARTDATE DATE
		SET @STARTDATE=GETUTCDATE()
		SET @CNT = 12
		WHILE @CNT >0
		BEGIN
			INSERT INTO #MONTHS VALUES(MONTH(@STARTDATE),YEAR(@STARTDATE))
			SET @STARTDATE=DATEADD(MONTH,-1,@STARTDATE)
			SET @CNT=@CNT-1
		END
		INSERT INTO #TAB1
		SELECT M.MM,M.YEARS,CONVERT(VARCHAR(15),DATEADD(MONTH,(M.YEARS-1970)*12 + M.MM - 1,'01-01-1970'), 106) AS MONTHS,
				V11 ,
				V10 ,
				V9
		FROM (SELECT MONTHS,YEARS,
			SUM(LatestVersionCount) AS V11,
			SUM(IILatestVersionCount) AS V10,
			SUM(IIILatestVersionCount) AS V9
			FROM cf_Survey106ClientVersion CC INNER JOIN cf_CommservSurveyResults CS
			ON CommcellIdNameMap_ID=CommServUniqueId
			AND CC.LogDateUTC=CS.LogDateUTC
			AND CC.SurveyResultId=CS.CommservSurveyResults_ID
			AND CS.QueryId = @i_QueryId
			AND CS.Flags = 1
			WHERE ((YEARS = YEAR(@STARTDATE) AND MONTHS >= MONTH(@STARTDATE)) OR
				  (YEARS > YEAR(@STARTDATE) AND MONTHS <= MONTH(@STARTDATE))) AND LatestVersionCount<>-1
			GROUP BY MONTHS,YEARS) A
		RIGHT OUTER JOIN #MONTHS M
			ON A.MONTHS=M.MM AND A.YEARS=M.YEARS
		DROP TABLE #MONTHS
		UPDATE #TAB1 SET V11=-1,V10=-1,V9=-1 WHERE V11 IS NULL AND V10 IS NULL AND V9 IS NULL
		SELECT MONTHS AS 'Month<clientVersion>',
			   V11 AS 'Version11 Client Count<NumberNA>',
			   V10 AS 'Version10 Client Count<NumberNA>',
			   V9 AS 'Version9 Client Count<NumberNA>'
		FROM #TAB1 ORDER BY YY,MM
		DROP TABLE #TAB1
	END
	ELSE
	BEGIN
		SELECT
		datediff(second, '01/01/1970', DATEADD(MONTH,((Years-1970)*12)+Months-1,'01/01/1970')) AS 'Month<MMMYYYY>',
		csInfo.LatestVersionCount AS 'Version11 Client Count<NumberNA>',
		csInfo.IILatestVersionCount AS 'Version10 Client Count<NumberNA>',
		csInfo.IIILatestVersionCount AS 'Version9 Client Count<NumberNA>'
		FROM cf_Survey106ClientVersion AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		ORDER BY csInfo.YEARS DESC, csInfo.MONTHS DESC
	END
END
ELSE
BEGIN
	IF @i_CommServUniqueID >0
	BEGIN
		SET @i_QueryId = 1
		SET @blLatestSurvey=1
		SELECT ISNULL (csInfo.ClientDisplayName, csInfo.clientName) AS 'Client',
			csInfo.clientName  AS 'Client(classic)<HIDDEN>',
			csInfo.servicePack AS 'Client Version',
			CASE WHEN ISNULL(A.LastUpdateTime, '1970-01-01') > '1970-01-01' THEN datediff(second, '01/01/1970', A.LastUpdateTime)
				ELSE datediff(second, '01/01/1970', csInfo.InstallDate) END AS 'Update Date<MMMDDYYYY>'
		FROM cf_SurveyClient csInfo
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.CommServUniqueId = csInfo.CommServUniqueId
		AND csInfo.Deleted = 0 AND csInfo.InstallStatus = 0 -- InstallStatus: 0 for installed, 1 for deconfigured, 2 for deleted
		LEFT OUTER JOIN cf_SurveyVersionAndServicePack A WITH (NOLOCK) ON A.CommServUniqueId = csInfo.CommServUniqueId AND csInfo.ClientId = A.ClientId
	END
	ELSE
		RETURN
END
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE DEBUGGING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= NULL
  DECLARE @blaggregate INT				= 0
  DECLARE @blLatestSurvey INT			= 1
  DECLARE @i_CommServUniqueID INT		= 11065
  DECLARE @i_LogDateStart DATETIME		= NULL
  DECLARE @i_LogDateEND DATETIME		= NULL
exec Rpt_106ClientVersion @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND
*/

IF EXISTS (select * from GxQscripts where name = 'Rpt_106ClientVersion')
	delete from GxQscripts where name = 'Rpt_106ClientVersion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Rpt_106ClientVersion')
	delete from GXDBVersions where aliasname = 'Rpt_106ClientVersion'
GO

insert into GXDBVersions values(2, 'Rpt_106ClientVersion',  '00010007000200070000', 'Rpt_106ClientVersion', '00010007000200070000')
GO

