

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Rpt_104ExceptionalClients.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Rpt_104ExceptionalClients.sp,v $ $Id: Rpt_104ExceptionalClients.sp,v 1.12.54.9 2020/05/23 14:09:42 nbirru Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='Rpt_104ExceptionalClients')
BEGIN
	print '>>> Drop Stored Procedure: Rpt_104ExceptionalClients <<<'
	drop procedure Rpt_104ExceptionalClients
END
IF EXISTS (select * from GxQscripts where name='Rpt_104ExceptionalClients')
	delete from GxQscripts where name = 'Rpt_104ExceptionalClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Rpt_104ExceptionalClients')
	delete from GXDBVersions where aliasname = 'Rpt_104ExceptionalClients'
GO
print '... Creating Procedure: Rpt_104ExceptionalClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Rpt_104ExceptionalClients
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NULL ,
  @i_CategoryName NVARCHAR(255) = NULL,
  @i_TenantName NVARCHAR(255) = NULL
AS
SET NOCOUNT ON
IF object_id('tempdb.dbo.#TenantClients') IS NOT NULL DROP TABLE #TenantClients
CREATE TABLE #TenantClients (CommServUniqueId INT, TenantName NVARCHAR(255), ClientId INT)
exec GetTenantEntities @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND, @i_TenantName
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @strTYPE1 NVARCHAR(MAX) = 'Laptop Clients With No Storage Policy'
DECLARE @strTYPE2 NVARCHAR(MAX) = 'Laptop Clients With No Subclient Policy'
DECLARE @strTYPE3 NVARCHAR(MAX) = 'Laptop Clients With No Client Group Associations'
DECLARE @strTYPE4 NVARCHAR(MAX) = 'Laptop Clients With System State Content Defined'
DECLARE @strTYPE7 NVARCHAR(MAX) = 'MediaAgents With No Storage Policy Associations'
--DECLARE @strTYPE8 NVARCHAR(MAX) = 'Clients With No Storage Policy Associations'
DECLARE @strTYPE9 NVARCHAR(MAX) = 'MediaAgents Associated With Multiple Client Groups'
DECLARE @strTYPE10 NVARCHAR(MAX) = 'Clients Active In Multiple CommCells'
DECLARE @i_QueryId BIGINT = 1
IF(@blaggregate=1)
BEGIN
	DECLARE @clientData TABLE(CommServUniqueId BIGINT, clientType BIGINT, clientId BIGINT)
	INSERT INTO @clientData
		SELECT
				resultView.CommServUniqueId ,
				csInfo.ExceptionType ,
				csInfo.ClientId
		FROM cf_SurveyClient AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.CommServUniqueId = csInfo.CommServUniqueId
		LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
                     ON csInfo.CommServUniqueId = TC.CommServUniqueId AND csInfo.ClientId = TC.ClientId
		WHERE ((@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL) AND ISNULL(csInfo.ExceptionType,0) > 0
		IF object_id('tempdb.dbo.#aggrClientCount') is not null DROP TABLE #aggrClientCount
			CREATE TABLE #aggrClientCount
			(
				clientName			NVARCHAR(MAX),
				clientcount			BIGINT
			)
			INSERT INTO #aggrClientCount
			SELECT
			csInfo.clientName,
			COUNT(*)
			FROM cf_SurveyClient AS csInfo WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
				ON resultView.CommServUniqueId = csInfo.CommServUniqueId
					AND csInfo.Deleted = 0 AND csInfo.InstallStatus = 0 -- InstallStatus: 0 for installed, 1 for deconfigured, 2 for deleted
			LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
                     ON csInfo.CommServUniqueId = TC.CommServUniqueId AND csInfo.ClientId = TC.ClientId
			WHERE ((@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL)
			GROUP BY csInfo.clientName
			HAVING COUNT(*)>1
		IF object_id('tempdb.dbo.#aggrMAClientGrp') is not null DROP TABLE #aggrMAClientGrp
			CREATE TABLE #aggrMAClientGrp
			(
				CommServUniqueId	BIGINT,
				clientId			BIGINT,
				grpName				NVARCHAR(MAX)
			)
			INSERT INTO #aggrMAClientGrp
			SELECT resultView.CommServUniqueId,
			csInfo.clientId,
			CG.ClientGroupName
			FROM cf_SurveyClient AS csInfo WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
				ON resultView.CommServUniqueId = csInfo.CommServUniqueId AND csInfo.Deleted = 0 AND (csInfo.type &2) =2   -- for MA
			INNER JOIN cf_SurveyClientGroupAssociation CGA WITH (NOLOCK)
				ON resultView.CommServUniqueId = CGA.CommServUniqueId AND csInfo.clientId = CGA.ClientId
			INNER JOIN cf_SurveyClientGroup CG WITH (NOLOCK)
				ON CGA.CommServUniqueId = CG.CommServUniqueId AND CGA.ClientGroupId = CG.ClientGroupId
			LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
                     ON csInfo.CommServUniqueId = TC.CommServUniqueId AND csInfo.ClientId = TC.ClientId
			WHERE ((@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL)
	DECLARE @aggrData TABLE(CommServUniqueId BIGINT, type BIGINT, clientType NVARCHAR(MAX), clientCount BIGINT)
	INSERT INTO @aggrData
	    SELECT data.CommServUniqueId,
				0,
				@strTYPE9,
				COUNT(DISTINCT data.clientId)
		FROM #aggrMAClientGrp AS data
		INNER JOIN (
				SELECT CommServUniqueId,clientId
				FROM #aggrMAClientGrp
				GROUP BY CommServUniqueId,clientId
				having  COUNT (grpName) >1
		) B
		ON B.CommServUniqueId = data.CommServUniqueId AND B.clientId = data.clientId
		GROUP BY data.CommServUniqueId
		UNION
		SELECT  0,
				0,
				@strTYPE10,
				COUNT(clientName)
		FROM #aggrClientCount AS data
		UNION
		SELECT
				data.CommServUniqueId ,
				1,
				@strTYPE1,
				COUNT(data.clientID)
		FROM @clientData AS data
		WHERE (data.clientType & 1) = 1
		GROUP BY data.CommServUniqueId
		UNION
		SELECT
				data.CommServUniqueId ,
				2,
				@strTYPE2,
				COUNT(data.clientID)
		FROM @clientData AS data
		WHERE (data.clientType & 2) = 2
		GROUP BY data.CommServUniqueId
		UNION
		SELECT
				data.CommServUniqueId ,
				4,
				@strTYPE3,
				ISNULL(COUNT(data.clientID),0)
		FROM @clientData AS data
		WHERE (data.clientType & 4) = 4
		GROUP BY data.CommServUniqueId
		UNION
		SELECT
				data.CommServUniqueId ,
				8,
				@strTYPE4,
				COUNT(data.clientID)
		FROM @clientData AS data
		WHERE (data.clientType & 8) = 8
		GROUP BY data.CommServUniqueId
		UNION
		SELECT
				data.CommServUniqueId ,
				64,
				@strTYPE7,
				COUNT(data.clientID)
		FROM @clientData AS data
		WHERE (data.clientType & 64) = 64
		GROUP BY data.CommServUniqueId
		/*UNION
		SELECT
				data.CommServUniqueId ,
				128,
				@strTYPE8,
				COUNT(data.clientID)
		FROM @clientData AS data
		WHERE (data.clientType & 128) = 128
		GROUP BY data.CommServUniqueId*/
		DROP TABLE #aggrMAClientGrp
		DROP TABLE #aggrClientCount
		IF NOT EXISTS (SELECT * FROM @aggrData WHERE clientType = @strTYPE1) INSERT INTO @aggrData SELECT 0,	0,@strTYPE1,0
		IF NOT EXISTS (SELECT * FROM @aggrData WHERE clientType = @strTYPE2) INSERT INTO @aggrData SELECT 0,	0,@strTYPE2,0
		IF NOT EXISTS (SELECT * FROM @aggrData WHERE clientType = @strTYPE3) INSERT INTO @aggrData SELECT 0,	0,@strTYPE3,0
		IF NOT EXISTS (SELECT * FROM @aggrData WHERE clientType = @strTYPE4) INSERT INTO @aggrData SELECT 0,	0,@strTYPE4,0
		IF NOT EXISTS (SELECT * FROM @aggrData WHERE clientType = @strTYPE7) INSERT INTO @aggrData SELECT 0,	0,@strTYPE7,0
		--IF NOT EXISTS (SELECT * FROM @aggrData WHERE clientType = @strTYPE8) INSERT INTO @aggrData SELECT 0,	0,@strTYPE8,0
		IF NOT EXISTS (SELECT * FROM @aggrData WHERE clientType = @strTYPE9) INSERT INTO @aggrData SELECT 0,	0,@strTYPE9,0
		IF NOT EXISTS (SELECT * FROM @aggrData WHERE clientType = @strTYPE10) INSERT INTO @aggrData SELECT 0,	0,@strTYPE10,0
		 IF (@i_CommServUniqueID != 0)
		  DELETE  FROM @aggrData WHERE clientType = @strTYPE10
		SELECT
			--data.CommServUniqueId  AS 'CommServ UniqueId',
			--data.type					 	    AS 'Client Type',
			--data.clientType						AS 'Category<LINK>',
			data.clientType						AS 'Category',
			SUM(data.clientCount) 	AS 'Count<CATEGORY_LINK>'
		FROM @aggrData AS data
		GROUP BY data.clientType
END
ELSE IF (@i_CategoryName IS NULL OR @i_CategoryName='')
BEGIN
	SELECT
		resultView.CommServUniqueId  AS 'CommServ UniqueId',
		resultView.CommCellID AS 'CommCell ID',
		resultView.DisplayName AS 'CommCell Name',
		ISNULL(csInfo.ClientDisplayName, csInfo.clientName) AS 'Client',
		csInfo.clientName  AS 'Client(classic)<HIDDEN>'
		, CASE WHEN (csInfo.ExceptionType & 1) =   1    THEN 'YES'	ELSE 'NO' END AS 'Laptop Clients With No Storage Policy'			    --@strTYPE1
		, CASE WHEN (csInfo.ExceptionType & 2) =   2    THEN 'YES'	ELSE 'NO' END AS 'Laptop Clients With No Subclient Policy'				--@strTYPE2
		, CASE WHEN (csInfo.ExceptionType & 4) =   4    THEN 'YES'	ELSE 'NO' END AS 'Laptop Clients With No Client Group Associations'		--@strTYPE3
		, CASE WHEN (csInfo.ExceptionType & 8) =   8    THEN 'YES'	ELSE 'NO' END AS 'Laptop Clients With System State Content Defined'	--@strTYPE4
		, CASE WHEN (csInfo.ExceptionType & 64) =  64   THEN 'YES'	ELSE 'NO' END AS 'MediaAgents With No Storage Policy Associations'		--@strTYPE7
		--, CASE WHEN (csInfo.ExceptionType & 128) = 128  THEN 'YES'	ELSE 'NO' END AS 'Clients With No Storage Policy Associations'						--@strTYPE8
		FROM cf_SurveyClient AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.CommServUniqueId = csInfo.CommServUniqueId
		LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
                     ON csInfo.CommServUniqueId = TC.CommServUniqueId AND csInfo.ClientId = TC.ClientId
		WHERE ((@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL) AND ISNULL(csInfo.ExceptionType,0) > 0
		ORDER BY resultView.CustomerName ASC , ISNULL(csInfo.ClientDisplayName, csInfo.clientName) ASC
END
ELSE
BEGIN
DECLARE @clientType INT =0
	IF (@i_CategoryName = @strTYPE10)
	BEGIN
		IF object_id('tempdb.dbo.#aggrClientCount1') is not null DROP TABLE #aggrClientCount1
			CREATE TABLE #aggrClientCount1
			(
				clientName			NVARCHAR(MAX),
				clientcount			BIGINT
			)
			INSERT INTO #aggrClientCount1
			SELECT
			csInfo.clientName,
			COUNT(*)
			FROM cf_SurveyClient AS csInfo WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
				ON resultView.CommServUniqueId = csInfo.CommServUniqueId
					AND csInfo.Deleted = 0 AND csInfo.InstallStatus = 0 -- InstallStatus: 0 for installed, 1 for deconfigured, 2 for deleted
			LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
                     ON csInfo.CommServUniqueId = TC.CommServUniqueId AND csInfo.ClientId = TC.ClientId
			WHERE ((@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL)
			GROUP BY csInfo.clientName
			HAVING COUNT(*)>1
		IF object_id('tempdb.dbo.#Client') is not null DROP TABLE #Client
			CREATE TABLE #Client
			(
				CommServUniqueId	BIGINT,
				CommCellID          VARCHAR(32),
				CommcellName       VARCHAR(256),
				clientId			BIGINT,
				clientName			NVARCHAR(MAX),
				clientcount			BIGINT
			)
			INSERT INTO #Client
			SELECT resultView.CommServUniqueId,
			resultView.CommCellID,
			resultView.DisplayName AS 'CommCell Name',
			csInfo.clientId,
			csInfo.clientName ,
			CL.clientcount
			FROM cf_SurveyClient AS csInfo WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
				ON resultView.CommServUniqueId = csInfo.CommServUniqueId
					AND csInfo.Deleted = 0 AND csInfo.InstallStatus = 0 -- InstallStatus: 0 for installed, 1 for deconfigured, 2 for deleted
			INNER JOIN  #aggrClientCount1 AS CL
			ON CL.clientName  = csInfo.clientName
			LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
                     ON csInfo.CommServUniqueId = TC.CommServUniqueId AND csInfo.ClientId = TC.ClientId
			WHERE ((@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL)
			DROP TABLE #aggrClientCount1
			SELECT
	--			CommServUniqueId	AS 'CommServ UniqueId',
	--			CommCellID			AS 'CommCell ID',
	--			CommcellName		AS 'CommCell Name',
				@i_CategoryName  AS 'Category<HIDDEN>',
				c.clientName AS 'Client',
				c.clientcount AS 'No of CommCells' ,
				STUFF
				(
					(
						SELECT ', ' + CommcellName
						FROM #Client M
						WHERE M.clientName = c.clientName
						ORDER BY CommcellName
						FOR XML PATH('')
					), 1, 1, ''
				) AS 'CommCells'
			FROM #Client C
				group by c.clientName,c.clientcount
				order by c.clientcount desc
			DROP TABLE #Client
	END
	ELSE IF (@i_CategoryName = @strTYPE9)
	BEGIN
		IF object_id('tempdb.dbo.#MAClientGrp') is not null DROP TABLE #MAClientGrp
			CREATE TABLE #MAClientGrp
			(
				CommServUniqueId	BIGINT,
				CommCellID          VARCHAR(32),
				CommcellName       VARCHAR(256),
				clientId			BIGINT,
				clientName			NVARCHAR(MAX),
				grpName				NVARCHAR(MAX)
			)
			INSERT INTO #MAClientGrp
			SELECT resultView.CommServUniqueId,
			resultView.CommCellID,
			resultView.DisplayName AS 'CommCell Name',
			csInfo.clientId,
			csInfo.clientName ,
			CG.ClientGroupName
			FROM cf_SurveyClient  AS csInfo WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
				ON resultView.CommServUniqueId = csInfo.CommServUniqueId AND csInfo.Deleted = 0 AND (csInfo.type &2) =2   -- for MA
			INNER JOIN cf_SurveyClientGroupAssociation CGA WITH (NOLOCK)
				ON resultView.CommServUniqueId = CGA.CommServUniqueId AND csInfo.clientId = CGA.ClientId
			INNER JOIN cf_SurveyClientGroup CG WITH (NOLOCK)
				ON CGA.CommServUniqueId = CG.CommServUniqueId AND CGA.ClientGroupId = CG.ClientGroupId
			LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
                     ON csInfo.CommServUniqueId = TC.CommServUniqueId AND csInfo.ClientId = TC.ClientId
			WHERE ((@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL)
			SELECT
				CommServUniqueId	AS 'CommServ UniqueId',
				CommCellID			AS 'CommCell ID',
				CommcellName		AS 'CommCell Name',
				@i_CategoryName  AS 'Category<HIDDEN>',
				c.clientName AS 'Client',
				COUNT (c.clientId) AS 'No of Groups' ,
				STUFF
				(
					(
						SELECT ', ' + grpName
						FROM #MAClientGrp M
						WHERE M.CommServUniqueId = C.CommServUniqueId AND M.clientId = c.clientId
						ORDER BY grpName
						FOR XML PATH('')
					), 1, 1, ''
				) AS 'Client Groups'
			FROM #MAClientGrp C
				group by c.clientName,CommCellID,CommcellName,CommServUniqueId,clientId
				having  COUNT (c.clientId) >1
				order by COUNT (c.clientId)  desc
			DROP TABLE #MAClientGrp
	END
	ELSE IF(@i_CategoryName = @strTYPE1)
		SET @clientType = 1
	ELSE IF(@i_CategoryName = @strTYPE2)
		SET @clientType = 2
	ELSE IF(@i_CategoryName = @strTYPE3)
		SET @clientType = 4
	ELSE IF(@i_CategoryName = @strTYPE4)
		SET @clientType = 8
	ELSE IF(@i_CategoryName = @strTYPE7)
		SET @clientType = 64
	/*ELSE IF(@i_CategoryName = @strTYPE8)
		SET @clientType = 128*/
	IF(@clientType>0)
	BEGIN
	SELECT
		resultView.CommServUniqueId  AS 'CommServ UniqueId',
		resultView.CommCellID AS 'CommCell ID',
		resultView.DisplayName AS 'CommCell Name',
		@i_CategoryName  AS 'Category<HIDDEN>',
		ISNULL(csInfo.ClientDisplayName, csInfo.clientName) AS 'Client',
		csInfo.clientName  AS 'Client(classic)<HIDDEN>'
		FROM cf_SurveyClient AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		   ON resultView.CommServUniqueId = csInfo.CommServUniqueId AND ISNULL(csInfo.ExceptionType,0) & @clientType = @clientType
		LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
                     ON csInfo.CommServUniqueId = TC.CommServUniqueId AND csInfo.ClientId = TC.ClientId
			WHERE ((@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL)
		ORDER BY resultView.CustomerName ASC , ISNULL(csInfo.ClientDisplayName, csInfo.clientName) ASC
	END
END
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE DEBUGGING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= NULL
  DECLARE @blaggregate INT				= 0
  DECLARE @blLatestSurvey INT			= 1
  DECLARE @i_CommServUniqueID INT		= 11065
  DECLARE @i_LogDateStart DATETIME		= NULL
  DECLARE @i_LogDateEND DATETIME		= NULL
  DECLARE @i_CategoryName NVARCHAR(255)	= NULL   --'Laptop Clients With No Storage Policy'
exec Rpt_104ExceptionalClients @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND, @i_CategoryName
*/

IF EXISTS (select * from GxQscripts where name = 'Rpt_104ExceptionalClients')
	delete from GxQscripts where name = 'Rpt_104ExceptionalClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Rpt_104ExceptionalClients')
	delete from GXDBVersions where aliasname = 'Rpt_104ExceptionalClients'
GO

insert into GXDBVersions values(2, 'Rpt_104ExceptionalClients',  '00010012005400090000', 'Rpt_104ExceptionalClients', '00010012005400090000')
GO

