

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptSurveyDDBProtection.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptSurveyDDBProtection.sp,v $ $Id: RptSurveyDDBProtection.sp,v 1.10.56.10 2019/05/09 14:31:10 jge Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptSurveyDDBProtection')
BEGIN
	print '>>> Drop Stored Procedure: RptSurveyDDBProtection <<<'
	drop procedure RptSurveyDDBProtection
END
IF EXISTS (select * from GxQscripts where name='RptSurveyDDBProtection')
	delete from GxQscripts where name = 'RptSurveyDDBProtection'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSurveyDDBProtection')
	delete from GXDBVersions where aliasname = 'RptSurveyDDBProtection'
GO
print '... Creating Procedure: RptSurveyDDBProtection'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptSurveyDDBProtection
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
DECLARE @i_QueryId BIGINT = 66
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
IF(@blaggregate=1)
BEGIN
RETURN
end
ELSE
BEGIN
DECLARE @strGood VARCHAR(10) = '1_Good'
DECLARE @strInfo VARCHAR(10) = '2_Info'
DECLARE @strwarning VARCHAR(10) = '3_Warning'
DECLARE @strCritical VARCHAR(10) = '4_Critical'
DECLARE @criticalVal int
DECLARE @warningVal int
SELECT	@warningVal = WarningThreshold*24,
		@criticalVal =CriticalThreshold*24
FROM	cf_SurveyHealthParam where queryId = @i_QueryId
DECLARE @criticalValForTrasDDB int = 360	--15 Days
DECLARE @warningValTrasDDB int = 192		--8 Days
IF object_id('tempdb..#MA_LOOKUP') IS NOT null DROP TABLE #MA_LOOKUP
CREATE TABLE #MA_LOOKUP (
	commcellId		INT,
	SidbStoreId		INT,
	mediaAgentNames	nvarchar(1024)     -- #MA_SIZE
)
CREATE INDEX Ma_Lookup_idx ON #MA_LOOKUP (commcellId, SidbStoreId)
INSERT #MA_LOOKUP
	SELECT  DISTINCT p1.CommServUniqueId, p1.SidbStoreId,"Media Agents"=SUBSTRING(stuff( (SELECT DISTINCT ', '+p2.MediaAgentName
								FROM cf_SurveyDeDupStoreConfig p2 WITH (NOLOCK)
								INNER JOIN dbo.cf_SurveyResultFuncV1(61, @i_CommServUniqueID, 1, NULL, NULL,@i_UserId,NULL) LS ON LS.CommServUniqueId = p2.CommServUniqueId AND LS.SurverResultId = P2.SurveyResultId
								WHERE p2.SidbStoreId = p1.SidbStoreId
								  AND P1.CommServUniqueId = P2.CommServUniqueId
								  AND (@i_CommServUniqueID = 0 OR p2.CommServUniqueId = @i_CommServUniqueID)
								FOR XML PATH('')),1,1,''), 1, 1023)
	FROM cf_SurveyDeDupStoreConfig p1   WITH (NOLOCK)
	WHERE @i_CommServUniqueID = 0 OR p1.CommServUniqueId = @i_CommServUniqueID
GROUP BY P1.CommServUniqueId, p1.SidbStoreId, P1.SurveyResultId
--ORDER BY  P1.CommServUniqueId,  SidBStoreId
SELECT
	resultView.CommServUniqueId  AS 'CommServ UniqueId',
	resultView.DisplayName AS 'CommCell Name',
	csInfo.SidbStoreId   AS 'DDB ID<HIDDEN>',
	csInfo.SidbStoreName AS 'DDB Name',
	ISNULL(MA.mediaAgentNames, '') AS 'Media Agent(s)',
	case when csInfo.LastDDBBackupJobId =0 THEN -2  -- 'Never Protected'
		ELSE case when ISNULL(csInfo.HoursSinceNoBackup,-1)= -1 THEN -1	-- 'N/A'
		         ELSE CONVERT(VARCHAR(20),csInfo.HoursSinceNoBackup)
			 END
		END as 'Hours Since Last Backup<NumberNA>',
	CASE WHEN csInfo.LastBackupTime < 'Jan 1 1979 12:00AM' THEN -100 ELSE dbo.GetUnixTimeBig(csInfo.LastBackupTime) END as 'Last Backup Time<MMMDDYYYYHrMinAM>',
	ISNULL(csInfo.AppSize, 0)/1024/1024 AS 'Application Size<SIZEMB><HIDDEN>',
	ISNULL(csInfo.WriteTime, 0) AS 'Write Time<HIDDEN><HHMMSS>',
	CAST((CASE WHEN ISNULL(csInfo.AppSize, 0) > 0 AND ISNULL(csInfo.WriteTime, 0) > 0 THEN (csInfo.AppSize/1024.0/1024.0/1024.0)/(csInfo.WriteTime/3600.0) ELSE 0.0 END)
		AS DECIMAL(10,2)) AS 'Throughput (GB/HR)',
	ISNULL(csInfo.SPName,'') AS 'Storage Policy',
	case when csInfo.LastDDBBackupJobId =0 THEN @strCritical
		ELSE case
			when ISNULL(csInfo.HoursSinceNoBackup,-1)= -1 THEN @strCritical
			when ISNULL(csInfo.IsTransactionBased, 0) = 0 AND ISNULL(csInfo.HoursSinceNoBackup,-1) > @criticalVal THEN @strCritical
			when ISNULL(csInfo.IsTransactionBased, 0) = 1 AND ISNULL(csInfo.HoursSinceNoBackup,-1) > @criticalValForTrasDDB THEN @strCritical
			when ISNULL(csInfo.IsTransactionBased, 0) = 0 AND ISNULL(csInfo.HoursSinceNoBackup,-1) > @warningVal THEN @strWarning
			when ISNULL(csInfo.IsTransactionBased, 0) = 1 AND ISNULL(csInfo.HoursSinceNoBackup,-1) > @warningValTrasDDB THEN @strWarning
			else @strGood
		END
		END as 'Status<HEALTH_STATUS>',
	CASE WHEN ISNULL(csInfo.IsTransactionBased, 0) = 1 THEN 'Yes' ELSE 'No' END AS 'Transactional DDB'
FROM cf_SurveyDDBProtection AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
	 LEFT OUTER JOIN #MA_LOOKUP  MA  ON MA.commcellId = resultView.CommServUniqueId AND MA.SidbStoreID = csinfo.SidbStoreId
ORDER BY 'Status<HEALTH_STATUS>' DESC,'CommCell Name' ASC, csInfo.LastDDBBackupJobId asc
END
IF object_id('tempdb..#MA_LOOKUP') IS NOT null DROP TABLE #MA_LOOKUP
SET NOCOUNT OFF
/*
--USE TO STANDALONE TEST Query for HEALTH-->DDB Performance and Status Details:
DECLARE @i_userId 			INT = 1
DECLARE @i_groupId			INT = NULL
DECLARE @i_blaggregate		INT = 0
DECLARE @i_bLatestSurvey		INT = 1
DECLARE @i_CommServUniqueID	INT = 10340
DECLARE @logStart				DATETIME = NULL
DECLARE @logEnd				DATETIME = NULL
--select id, CommcellId, CustomerName, CommServName from cf_CommcellIdNameMap --where CommServName = 'mmdedupeesx'
exec RptSurveyDDBProtection @i_userId, 0, @i_blaggregate, @i_bLatestSurvey, @i_CommServUniqueID, @logStart, @logEnd
*/
GO

IF EXISTS (select * from GxQscripts where name = 'RptSurveyDDBProtection')
	delete from GxQscripts where name = 'RptSurveyDDBProtection'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSurveyDDBProtection')
	delete from GXDBVersions where aliasname = 'RptSurveyDDBProtection'
GO

insert into GXDBVersions values(2, 'RptSurveyDDBProtection',  '00010010005600100000', 'RptSurveyDDBProtection', '00010010005600100000')
GO

