

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptSecurityAssociationDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptSecurityAssociationDetails.sp,v $ $Id: RptSecurityAssociationDetails.sp,v 1.1.2.10.4.1 2021/03/03 04:09:12 rshibu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptSecurityAssociationDetails')
BEGIN
	print '>>> Drop Stored Procedure: RptSecurityAssociationDetails <<<'
	drop procedure RptSecurityAssociationDetails
END
IF EXISTS (select * from GxQscripts where name='RptSecurityAssociationDetails')
	delete from GxQscripts where name = 'RptSecurityAssociationDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSecurityAssociationDetails')
	delete from GXDBVersions where aliasname = 'RptSecurityAssociationDetails'
GO
print '... Creating Procedure: RptSecurityAssociationDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptSecurityAssociationDetails
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 0,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll,
  @i_tableId INTEGER = 1
AS
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @i_QueryId BIGINT = 250
DECLARE @strGood VARCHAR(10) = '1_Good'
DECLARE @strInfo VARCHAR(10) = '2_Info'
DECLARE @strwarning VARCHAR(10) = '3_Warning'
DECLARE @strCritical VARCHAR(10) = '4_Critical'
--get the SurveyResultId of the latest survey that ran on the given commmcell
DECLARE @SurveyResultId BIGINT
SELECT @SurveyResultId = SurverResultId from dbo.cf_SurveyResultFuncV1(250,@i_CommServUniqueID,1,null,null,@i_UserId,0)
IF(ISNULL(@SurveyResultId,0) <> 0)
BEGIN
	--get remarks of each attribute into temptable
	IF OBJECT_ID('tempdb..#SecurityDesc') IS NOT NULL DROP TABLE #SecurityDesc
	CREATE TABLE #SecurityDesc (
		[ccid<DONOTSHOW>] INT,
		[attrName<DONOTSHOW>] varchar(256) ,
		[PARAMID<DONOTSHOW>] INT,
		[Parameter] nvarchar(1024),
		[Status<SCALE_STATUS>] INT,
		[Remarks] nvarchar(1024),
		[Action] nvarchar(1024),
		)
END
INSERT INTO #SecurityDesc
	EXEC dbo.GetSecurityAssociationDetails @i_UserId = @i_UserId, @blaggregate = 1, @i_CommServUniqueID = @i_CommServUniqueID
--update the status column
ALTER TABLE #SecurityDesc ALTER COLUMN [Status<SCALE_STATUS>] NVARCHAR(20)
UPDATE #SecurityDesc
	SET [Status<SCALE_STATUS>] = (CASE WHEN [Status<SCALE_STATUS>]='1' THEN @strGood
										WHEN [Status<SCALE_STATUS>]='2' THEN @strwarning
										WHEN [Status<SCALE_STATUS>]='3' THEN @strCritical
										ELSE  @strInfo END)
--select * from #SecurityDesc
IF (@i_tableId & 1 = 1) --Access Security
BEGIN
	SELECT 'Access Security' AS 'GROUP<DONOTSHOW>',*
		FROM #SecurityDesc o
		WHERE [attrName<DONOTSHOW>] in ('2FAEnabled', 'SSOMethod', 'PCWEnabled','PasswordComplexityLevel','FailedLoginAttemptLimit','AccountLockDuration','WebTimeout','GuiTimeout')
END
IF (@i_tableId & 2 = 2) --Auditing
BEGIN
	SELECT 'Auditing' AS 'GROUP<DONOTSHOW>',*
		FROM #SecurityDesc o
		WHERE [attrName<DONOTSHOW>] in ('AuditTrailRetentionDaysCritical', 'AuditTrailRetentionDaysHigh', 'AuditTrailRetentionDaysMedium','AuditTrailRetentionDaysLow','cleanupReport','userPermissionsReport')
END
IF (@i_tableId & 4 = 4) --Platform Security
BEGIN
	SELECT 'Platform Security' AS 'GROUP<DONOTSHOW>',*
		FROM #SecurityDesc o
		WHERE [attrName<DONOTSHOW>] in ('StoragePoolsWithoutEncryption', 'SecureMountPaths-Secure','FileActivityAlert','DRBackupToCloud','KMSForEncryption')
END
IF (@i_tableId & 8 = 8) --Tenant Security
BEGIN
	SELECT 'Company and Owners Security' AS 'GROUP<DONOTSHOW>',*
		FROM #SecurityDesc o
		WHERE [attrName<DONOTSHOW>] in ('PrivacyFeature', 'ClientEncryption','PasskeyForRestore')
END
IF (@i_tableId & 16 = 16) --Capabilities
BEGIN
	SELECT 'Capabilities' AS 'GROUP<DONOTSHOW>',*
		FROM #SecurityDesc o
		WHERE [attrName<DONOTSHOW>] in ('UsersWithMasterCapabilities', 'GetProcessAuthEnabled', 'DeleteClientAuthorization','Delete Jobs Authorization','RestoreRequestAuthorization','DeleteBackupSetAuthorization','DeleteStoragePolicyAuthorization','DeleteLibraryMountPathAuthorization','RequiresAuthenticationForInstalls','KMS','DLP')
END
IF OBJECT_ID('tempdb..#SecurityDesc') IS NOT NULL DROP TABLE #SecurityDesc
--  QUERY SPECIFIC CODE END --
GO

IF EXISTS (select * from GxQscripts where name = 'RptSecurityAssociationDetails')
	delete from GxQscripts where name = 'RptSecurityAssociationDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSecurityAssociationDetails')
	delete from GXDBVersions where aliasname = 'RptSecurityAssociationDetails'
GO

insert into GXDBVersions values(2, 'RptSecurityAssociationDetails',  'v1.1.2.10.4.1', 'RptSecurityAssociationDetails', 'v1.1.2.10.4.1')
GO

