

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptSealedDDBs.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptSealedDDBs.sp,v $ $Id: RptSealedDDBs.sp,v 1.4.56.2 2018/08/16 11:34:14 skatz Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptSealedDDBs <<<'

IF EXISTS (select * from sysobjects where name='RptSealedDDBs')
	drop procedure RptSealedDDBs
IF EXISTS (select * from GxQscripts where name='RptSealedDDBs')
	delete from GxQscripts where name = 'RptSealedDDBs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSealedDDBs')
	delete from GXDBVersions where aliasname = 'RptSealedDDBs'
GO
print '... Creating Procedure: RptSealedDDBs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptSealedDDBs
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
IF(@blaggregate=1)
	RETURN
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 61
DECLARE @strGood VARCHAR(10) = '1_Good'
DECLARE @strInfo VARCHAR(10) = '2_Info'
DECLARE @strwarning VARCHAR(10) = '3_Warning'
DECLARE @strCritical VARCHAR(10) = '4_Critical'
DECLARE @criticalVal int
DECLARE @warningVal int
SELECT	@warningVal = WarningThreshold,
		@criticalVal =CriticalThreshold
FROM	cf_SurveyHealthParam where queryId = @i_QueryId
IF @i_CommServUniqueID = 0
BEGIN
SELECT
	resultView.CommServUniqueId  AS 'CommServe UniqueId<HIDDEN>',
	resultView.CommCellID AS 'CommCell ID<HIDDEN>',
	resultView.DisplayName AS 'CommCell Name',
	DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(csInfo.LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME>',
	ISNULL(resultView.CommServTimeZone, '')  AS 'TimeZone',
	CASE
		WHEN resultView.RunningTime = -1 THEN 'N/A'
		ELSE CAST(resultView.RunningTime AS VARCHAR(MAX))
	END AS 'Running Time in Seconds<HIDDEN>',
	ISNULL(CL.clientDisplayName, csInfo.MediaAgentName) AS 'Media Agent',
	csInfo.SIDBStoreAliasName AS 'DDB Name',
	csInfo.accessPath AS 'Access Path',
	csInfo.TotalDataSizeMB AS 'Data Size<SIZEMB>',
	DATEADD(s, csInfo.SealedTime, '1970-01-01 00:00:00')  AS 'Sealed Time',
	CASE ISNULL(csInfo.SealedReason, 0)
		WHEN 1 THEN 'Sealed by user'
		WHEN 2 THEN 'Corrupted'
		WHEN 3 THEN 'Rule on data size'
		WHEN 4 THEN 'Rule on number of days'
		WHEN 5 THEN 'Rule on calendar'
		WHEN 6 THEN 'Database restore'
		WHEN 7 THEN 'CommCell migration'
		WHEN 8 THEN 'CommCell clone'
		ELSE ''
	END AS 'Sealed Reason'
FROM cf_SurveyDeDupStoreConfig AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND	csInfo.MediaAgentId > 1
		AND csInfo.SealedStatus = 'Sealed'
	LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = csInfo.CommServUniqueId AND CL.ClientId = csInfo.MediaAgentId
ORDER BY  csInfo.SIDBCountForMA DESC
END
ELSE
SELECT
	csInfo.CommServUniqueId AS 'CommServe UniqueId<HIDDEN>',
	ISNULL(CL.clientDisplayName, csInfo.MediaAgentName) AS 'Media Agent',
	csInfo.SIDBStoreAliasName AS 'DDB Name',
	csInfo.accessPath AS 'Access Path',
	csInfo.TotalDataSizeMB AS 'Data Size<SIZEMB>',
	DATEADD(s, csInfo.SealedTime, '1970-01-01 00:00:00')  AS 'Sealed Time',
	CASE ISNULL(csInfo.SealedReason, 0)
		WHEN 1 THEN 'Sealed by user'
		WHEN 2 THEN 'Corrupted'
		WHEN 3 THEN 'Rule on data size'
		WHEN 4 THEN 'Rule on number of days'
		WHEN 5 THEN 'Rule on calendar'
		WHEN 6 THEN 'Database restore'
		WHEN 7 THEN 'CommCell migration'
		WHEN 8 THEN 'CommCell clone'
		ELSE ''
	END AS 'Sealed Reason'
FROM cf_SurveyDeDupStoreConfig AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND	csInfo.MediaAgentId > 1
		AND csInfo.SealedStatus = 'Sealed'
		LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = csInfo.CommServUniqueId AND CL.ClientId = csInfo.MediaAgentId
ORDER BY csInfo.SIDBCountForMA DESC
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE TESTING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= NULL
  DECLARE @blaggregate INT				= 0         -- NEVER 1 !!!!
  DECLARE @blLatestSurvey INT			= 1
  DECLARE @i_CommServUniqueID INT		= 10006
  DECLARE @i_LogDateEND DATETIME		= 	NULL    -- getDate()
  DECLARE @i_LogDateStart DATETIME		= NULL   --DateAdd(Month, -36, @i_LogDateEND)
exec RptSealedDDBs @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND
*/

IF EXISTS (select * from GxQscripts where name = 'RptSealedDDBs')
	delete from GxQscripts where name = 'RptSealedDDBs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSealedDDBs')
	delete from GXDBVersions where aliasname = 'RptSealedDDBs'
GO

insert into GXDBVersions values(2, 'RptSealedDDBs',  '00010004005600020000', 'RptSealedDDBs', '00010004005600020000')
GO

