

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptRoyaltyStats.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptRoyaltyStats.sp,v $ $Id: RptRoyaltyStats.sp,v 1.6.46.6 2019/01/17 19:53:06 skatz Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptRoyaltyStats')
BEGIN
	print '>>> Drop Stored Procedure: RptRoyaltyStats <<<'
	drop procedure RptRoyaltyStats
END
IF EXISTS (select * from GxQscripts where name='RptRoyaltyStats')
	delete from GxQscripts where name = 'RptRoyaltyStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptRoyaltyStats')
	delete from GXDBVersions where aliasname = 'RptRoyaltyStats'
GO
print '... Creating Procedure: RptRoyaltyStats'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptRoyaltyStats
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @bAggregate INT = 1,
  @bLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEnd DATETIME = NUll
AS
SET NOCOUNT ON
SET @bLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId INT = 92
DECLARE @ServerPrice FLOAT = 5.25
DECLARE @1TouchPrice FLOAT = 2.50
DECLARE @ServerCommitment    INT = 75000
DECLARE @TestServerDeduction INT = 100
SELECT	@ServerPrice = CAST(value AS FLOAT) FROM cf_SurveyConfig WHERE name = 'Server Price'
SELECT	@1TouchPrice = CAST(value AS FLOAT) FROM cf_SurveyConfig WHERE name = 'One Touch Price'
SELECT	@ServerCommitment = CAST(value AS INT) FROM cf_SurveyConfig WHERE name = 'Server Commitment'
SELECT	@TestServerDeduction = CAST(value AS INT) FROM cf_SurveyConfig WHERE name = 'Test Server Deduction'
CREATE	TABLE #Client (
		CommServId INT, ClientId INT, ClientName NVARCHAR(256),
		IsVM INT, HasFSAgent INT, IsOneTouch INT,
		Index1 INTEGER, Number1 NVARCHAR(256), Counted INT)
INSERT	INTO #Client
SELECT	result.CommServUniqueId, ClientId, ClientName, IsVM, HasFSAgent, IsOneTouch,
		CHARINDEX('-', csInfo.ClientName),
		CASE WHEN CHARINDEX('-', ClientName) > 0 THEN LEFT(ClientName, CHARINDEX('-', ClientName)-1) ELSE '' END,
		1
FROM	cf_SurveyRoyaltyStats AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @bLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS result
		ON result.SurverResultId = csInfo.SurveyResultId
UPDATE	#Client SET Counted = 0
FROM	#Client A,
		(SELECT	ClientName, RIGHT(ClientName, LEN(ClientName) - Index1) AS Number2
		FROM	#Client
		WHERE	HasFSAgent = 1
			AND Index1 > 1 AND ISNUMERIC(RIGHT(ClientName, LEN(ClientName) - Index1)) = 1) B
WHERE	A.IsVM = 1 AND A.Index1 > 1 AND A.Number1 = B.Number2 AND A.ClientName <> B.ClientName
UPDATE #CLIENT
	SET clientName = ISNULL(CL.clientDisplayName, C.clientName)
	FROM #CLIENT C
	INNER JOIN cf_SurveyClient CL WITH (NOLOCK)
		ON CL.CommServUniqueId = C.CommServId AND CL.ClientId = C.ClientId
IF	@bAggregate = 1
BEGIN
	DECLARE @ServerCounts   INT = 0
	DECLARE @OneTouchCounts INT = 0
	SELECT	@ServerCounts   = ISNULL(SUM(CASE WHEN Counted = 1 AND IsOneTouch = 0 THEN 1 ELSE 0 END), 0),
			@OneTouchCounts = ISNULL(SUM(CASE WHEN Counted = 1 AND IsOneTouch = 1 THEN 1 ELSE 0 END), 0)
	FROM	#Client
	IF (@ServerCommitment + @TestServerDeduction) >= @ServerCounts
			SET @ServerCounts = 0
	ELSE
			SET @ServerCounts -= (@ServerCommitment + @TestServerDeduction)
	SELECT	@ServerCounts AS 'Server Counts',
			cast(@ServerPrice as numeric(32,2)) AS 'Server Price',
			cast(@ServerCounts*@ServerPrice as numeric(32,2)) AS 'Server Total',
			@OneTouchCounts AS '1 Touch Counts',
			cast(@1TouchPrice as numeric(32,2)) AS '1 Touch Price',
			cast(@OneTouchCounts*@1TouchPrice as numeric(32,2)) AS '1 Touch Total',
			cast((@ServerCounts*@ServerPrice + @OneTouchCounts*@1TouchPrice) as numeric(32,2)) AS 'Grand Total',
			@ServerCommitment AS 'Server Commitment',
			@TestServerDeduction AS 'Test Server Deduction'
END
ELSE
IF	@i_CommServUniqueID = 0
	SELECT 	M.ID				AS 'CommServ UniqueId',
			M.CommCellID		AS 'CommCell ID',
			M.CommServName		AS 'CommCell Name',
			C.ClientName		AS 'Client',
			CASE WHEN IsVM = 1 THEN 'Yes' ELSE 'No' END
								AS 'Discovered VM',
			CASE WHEN HasFSAgent = 1 THEN 'Yes' ELSE 'No' END
								AS 'Has FS Agent',
			CASE WHEN IsOneTouch = 1 THEN 'Yes' ELSE 'No' END
								AS '1 Touch',
			CASE WHEN Counted = 1 THEN 'Yes' ELSE 'No. Already counted on FS agent.' END
								AS 'Counted'
	FROM	#Client AS C
			INNER JOIN cf_CommcellIdNameMap M WITH (NOLOCK) ON C.CommServId = M.ID
	ORDER BY M.CommServName, C.IsVM DESC, C.Counted DESC, C.IsOneTouch, C.ClientName
ELSE
	SELECT 	C.ClientName		AS 'Client',
			CASE WHEN IsVM = 1 THEN 'Yes' ELSE 'No' END
								AS 'Discovered VM',
			CASE WHEN HasFSAgent = 1 THEN 'Yes' ELSE 'No' END
								AS 'Has FS Agent',
			CASE WHEN IsOneTouch = 1 THEN 'Yes' ELSE 'No' END
								AS '1 Touch',
			CASE WHEN Counted = 1 THEN 'Yes' ELSE 'No. Already counted on FS agent.' END
								AS 'Counted'
	FROM	#Client AS C
			INNER JOIN cf_CommcellIdNameMap M WITH (NOLOCK) ON C.CommServId = M.ID
	ORDER BY C.IsVM DESC, C.Counted DESC, C.IsOneTouch, C.ClientName
DROP TABLE #Client
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE TESTING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= NULL
  DECLARE @blaggregate INT				= 0
  DECLARE @blLatestSurvey INT			= 1
  DECLARE @i_CommServUniqueID INT		= 11088
  DECLARE @i_LogDateEND DATETIME		= 	NULL    -- getDate()
  DECLARE @i_LogDateStart DATETIME		= NULL   --DateAdd(Month, -36, @i_LogDateEND)
exec RptRoyaltyStats @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND
*/

IF EXISTS (select * from GxQscripts where name = 'RptRoyaltyStats')
	delete from GxQscripts where name = 'RptRoyaltyStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptRoyaltyStats')
	delete from GXDBVersions where aliasname = 'RptRoyaltyStats'
GO

insert into GXDBVersions values(2, 'RptRoyaltyStats',  '00010006004600060000', 'RptRoyaltyStats', '00010006004600060000')
GO

