

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptQuarterlyPptData.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptQuarterlyPptData.sp,v $ $Id: RptQuarterlyPptData.sp,v 1.5.2.18 2020/12/17 02:50:02 dkraplanee Exp $";
SET ANSI_NULLS ON
--Procedure to get the data from cloud for the QBR PPT
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptQuarterlyPptData')
BEGIN
	print '>>> Drop Stored Procedure: RptQuarterlyPptData <<<'
	drop procedure RptQuarterlyPptData
END
IF EXISTS (select * from GxQscripts where name='RptQuarterlyPptData')
	delete from GxQscripts where name = 'RptQuarterlyPptData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptQuarterlyPptData')
	delete from GXDBVersions where aliasname = 'RptQuarterlyPptData'
GO
print '... Creating Procedure: RptQuarterlyPptData'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptQuarterlyPptData
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll,
  @i_param INT = NUll, --See options below
  @i_fromMonth INT = 0, --The input is the difference between the current month and the "from" month selected
  @i_toMonth INT = 0,  --The input is the difference between the current month and the "to" month selected
  @i_includeQuarters VARCHAR(MAX) = '' -- Space separated list of quarters to consider; 1:last quarter; 2: second last quarter..
/* Options for input i_param:
 * -1:	CUSTOMER NAME
 * 0:	ENVIRONMENT_HEALTH 						(Slide 13)
 * 1:	MISC_CLOUD_INFO_IN_TEXT
 * 2:	TOTAL_JOBS_VS_FAILURES 					(Slides 15, 19)
 * 3:	JOB_SUCCESS_RATE 						(Slide 15)
 * 4:	BACKUP_CAPACITY_SAVINGS  				(Slide 17)
 * 5:	JOBS_ABSOLUTE_NUMBERS  					(Slide 20)
 * 6:	BACKUP_USAGE_BY_AGENT  					(Slide 21)
 * 7:	CAPACITY_GROWTH  						(Slide 23)
 * 8:	CRITICAL_DISKLIBS_UTILIZATION   		(Slide 46)
 * 9:	CRITICAL_DISKLIBS_GROWTH_FORECAST   	(Slide 46)
 * 10:	DEDUPE_SAVINGS_LAST_30_DAYS   			(Slide 47)
 * 11:	DEDUPE_SAVINGS_LAST_30_DAYS   			(Slide 47)
 * 12:	SPCOPY_DEDUPE_RATIO chart   			(Slide 48)
 * 13:	SPCOPY_DEDUPE_RATIO table   			(Slide 49)
 * 14:	INDEX_CACHE   							(Slide 50)
 * 15:	LICENSE_USAGE   						(Slide 22)
 */
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--Validate inputs
IF(@blaggregate=1)
	RETURN
IF ISNULL(@i_CommServUniqueID,0) > 0
BEGIN
	SET @i_GroupId = -1
END
ELSE IF ISNULL(@i_GroupId, 0) > 0
BEGIN
	SET @i_CommServUniqueID = 0
END
ELSE
	RETURN;
SET @i_includeQuarters = ISNULL(LTRIM(RTRIM(@i_includeQuarters)), '')
--Create monthly and quarterly temp tables
DECLARE @queryId INT
DECLARE @FromMonth  DATE = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()) - @i_fromMonth, 0)
DECLARE @ToMonth	DATE = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()) - @i_toMonth, 0)
IF OBJECT_ID('tempdb.dbo.#LastNMonths') IS NOT NULL DROP TABLE #LastNMonths
DECLARE @STARTDATE  DATE = @ToMonth
DECLARE @ENDDATE    DATE = DATEADD(MONTH, 1, @STARTDATE)
DECLARE @tblQuarters TABLE (Quarter INT, QuarterName NVARCHAR(MAX))
INSERT INTO @tblQuarters (Quarter)
SELECT _ID FROM dbo.SplitStringByDelimiter(REPLACE(@i_includeQuarters, ' ', ','), ',')
;WITH MONTHS(Month, Quarter, MonthStart , MonthEnd ) AS
(
	SELECT 1, 1, @STARTDATE, @ENDDATE
	UNION ALL
	SELECT Month+1, Month/3 + 1, DATEADD(MONTH, -1, MonthStart),MonthStart
	FROM MONTHS WHERE MonthStart > @FromMonth
)
SELECT *
INTO #LastNMonths
FROM MONTHS
WHERE @i_includeQuarters = '' OR Quarter IN (SELECT Quarter FROM @tblQuarters)
IF NOT EXISTS (SELECT TOP 1 1 FROM @tblQuarters)
INSERT INTO @tblQuarters (Quarter)
SELECT DISTINCT Quarter FROM #LastNMonths
;WITH QuarterNames AS
(
	SELECT
		Quarter,
		CASE
			WHEN DATEPART(Quarter, MIN(MonthStart)) = DATEPART(Quarter, MAX(MonthStart)) AND MONTH(MIN(MonthStart)) + 2 = MONTH(MAX(MonthStart))
			THEN 'Q' + CAST(DATEPART(Quarter, MIN(MonthStart)) AS NVARCHAR(10)) + ' ' + CAST(YEAR(MIN(MonthStart)) AS NVARCHAR(10))
			ELSE NULL
		END AS QuarterAndYear,
		CASE WHEN MIN(MonthStart) = MAX(MonthStart) THEN ''
			ELSE CONVERT(CHAR(3), MIN(MonthStart), 0) END Month1,
		CASE WHEN MIN(MonthStart) = MAX(MonthStart) THEN ''
			WHEN YEAR(MIN(MonthStart)) = YEAR(MAX(MonthStart)) THEN ' - '
			ELSE '''' + RIGHT(YEAR(MIN(MonthStart)), 2) + ' - ' END Year1,
		CONVERT(CHAR(3), MAX(MonthStart), 0) Month2,
		'''' + RIGHT(YEAR(MAX(MonthStart)), 2) Year2
	FROM #LastNMonths
	GROUP BY Quarter
)
UPDATE Q
SET QuarterName = ISNULL(QuarterAndYear, Month1 + Year1 + Month2 + Year2)
FROM QuarterNames N
	INNER JOIN @tblQuarters Q  ON Q.Quarter = N.Quarter
--Create temp table to hold the latest results
IF OBJECT_ID('tempdb.dbo.#LatestResults') IS NOT NULL DROP TABLE #LatestResults
CREATE TABLE #LatestResults
(
	CommservUniqueId	INT,
	QueryId				INT,
	SurveyResultId		BIGINT
)
--Create commcell list
IF OBJECT_ID('tempdb.dbo.#Commcells') IS NOT NULL DROP TABLE #Commcells
CREATE TABLE #Commcells
(
	CommservUniqueId	INT
)
INSERT INTO #Commcells
SELECT DISTINCT CommservUniqueId
FROM dbo.cf_SurveyResultFuncV1(146, @i_CommServUniqueID,  @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId)
IF NOT EXISTS (SELECT TOP 1 1 FROM #Commcells)
RETURN;
IF @i_param IN (1, 8, 9) --Create a temp table with disk library information for params 1,8,9
BEGIN
	IF OBJECT_ID('tempdb.dbo.#RptDiskLibraryUsageWrapper_Output') IS NOT NULL DROP TABLE #RptDiskLibraryUsageWrapper_Output
	CREATE TABLE #RptDiskLibraryUsageWrapper_Output (
		CommServUniqueId      INT,
		CommCellName          NVARCHAR(256),
		Library               NVARCHAR(256),
		MountPathShared       NVARCHAR(32),
		CapacityMB            BIGINT,
		FreeSpaceMB           BIGINT,
		AvailableSpaceMB      BIGINT,
		AvailableSpacePct     DECIMAL(10,2),
		ReserveSpaceMB        BIGINT,
		DateToBeFull          NVARCHAR(256),
		RangeOfDateToBeFull   NVARCHAR(256),
		DataWrittenMB         BIGINT,
		AppSizeMB             BIGINT,
		PrevMonthChangeMB     BIGINT,
		PrevMonthChangePct    DECIMAL(10,2),
		CurrMonthChangeMB     BIGINT,
		CurrMonthChangePct    DECIMAL(10,2),
		LowWatermarkPct       NVARCHAR(256),
		ReachLowWatermark     BIGINT,
		SixMonthGrowthMB      BIGINT,
		TwelveMonthGrowthMB   BIGINT,
		EighteenMonthGrowthMB BIGINT,
		Status                NVARCHAR(32)
	)
	EXEC RptDiskLibraryUsageWrapper @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND
	IF OBJECT_ID('tempdb..#CriticalDiskLibs') IS NOT NULL DROP TABLE #CriticalDiskLibs
	CREATE TABLE #CriticalDiskLibs
	(
		CommservUniqueId	INT,
		LibraryName			NVARCHAR(MAX)
	)
	INSERT INTO #CriticalDiskLibs
	SELECT CommservUniqueId, LibraryName FROM #RptDiskLibraryUsageWrapper_Output WHERE Status = '4_Critical'
END
IF @i_param = -1 -- CUSTOMER NAME
BEGIN
	DECLARE @CustomerName NVARCHAR(MAX)
	IF @i_GroupId > 0
		SELECT name AS 'CustomerName' FROM cf_CommcellGroup WITH(NOLOCK) WHERE id = @i_GroupId
	ELSE
		SELECT TOP 1 displayName AS 'CustomerName' FROM dbo.cf_SurveyResultFuncV1(146, @i_CommServUniqueID,  @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId)
END
ELSE IF @i_param IN (0, 1) --ENVIRONMENT_HEALTH
BEGIN
	INSERT INTO #LatestResults
	SELECT  DISTINCT R.CommcellIdNameMap_ID, R.QueryId, R.CommservSurveyResults_ID
	FROM    cf_CommservSurveyResults R WITH (NOLOCK)
		INNER JOIN #Commcells C ON C.CommservUniqueId = R.CommcellIdNameMap_ID
	WHERE   R.Flags = 1
		AND R.QueryId IN (173, 146, 129)
	IF OBJECT_ID('tempdb..#EnvironmentHealth') IS NOT NULL DROP TABLE #EnvironmentHealth
	CREATE TABLE #EnvironmentHealth
	(
		Quarter INT,
		ClientsProtected INT,
		SuccessRate DECIMAL(5,2),
		JobCount INT,
		DataProtectedMB BIGINT,
	)
	SET @queryId = 173
	DECLARE @tblQuarterlyJobStats TABLE (Quarter int, TotalJobs bigint, CompletedJobs bigint, SuccessRate DECIMAL(5,2))
	INSERT INTO @tblQuarterlyJobStats (Quarter, TotalJobs, CompletedJobs)
	SELECT	M.Quarter,
			ISNULL(SUM(ISNULL(TotalJobs, 0) - ISNULL(SkippedJobs, 0)), 0),
			ISNULL(SUM(ISNULL(CompletedJobs, 0) + ISNULL(CWEJobs, 0) + ISNULL(CWWJobs, 0)), 0)
	FROM cf_SurveyIDAMonthlyBkpJobStats csInfo WITH(NOLOCK)
		INNER JOIN #LatestResults AS resultView ON resultView.CommServUniqueId = csInfo.CommServUniqueId AND resultView.QueryId = @queryId
		RIGHT OUTER JOIN #LastNMonths M ON csinfo.MonthStart = M.MonthStart
	GROUP BY M.Quarter
	INSERT INTO #EnvironmentHealth (Quarter, SuccessRate, JobCount)
	SELECT Quarter,
		CASE WHEN TotalJobs = 0 THEN NULL ELSE CAST((CAST(CompletedJobs AS DECIMAL(20,2)) * 100.0 )/ (CAST(TotalJobs AS DECIMAL(20,2))) AS DECIMAL(5,2)) END,
		TotalJobs
	FROM @tblQuarterlyJobStats
	SET @QueryId = 146
	;WITH MonthlyClientsProtected AS
	(
		SELECT	M.Quarter AS Quarter,
				ISNULL(SUM(nClientsMet), 0) AS nClients
		FROM cf_SurveySLAHistory csInfo WITH(NOLOCK)
			INNER JOIN #LatestResults AS resultView ON resultView.CommServUniqueId = csInfo.CommServUniqueId AND resultView.QueryId = @queryId
			RIGHT OUTER JOIN #LastNMonths M ON csinfo.MonthBegin = M.MonthStart
		GROUP BY M.MonthStart, M.Quarter
	),
	QuarterlyClientsProtected AS
	(
		SELECT Quarter,
			MAX(nClients) nClients
		FROM MonthlyClientsProtected
		GROUP BY Quarter
	)
	UPDATE EH
	SET ClientsProtected = nClients
	FROM #EnvironmentHealth EH
		INNER JOIN QuarterlyClientsProtected C ON C.Quarter = EH.Quarter
	SET @QueryId = 129
	;WITH DataProtected AS
	(
		SELECT	Quarter,
				ISNULL(SUM(ISNULL(csinfo.AppSizeMB, 0)),0) DataProtectedMB
		FROM cf_SurveyAgentPeakSize csInfo WITH(NOLOCK)
			INNER JOIN #LatestResults AS resultView ON resultView.CommServUniqueId = csInfo.CommServUniqueId AND resultView.QueryId = @queryId AND csInfo.AppTypeId = 0
			RIGHT OUTER JOIN #LastNMonths M ON csinfo.MonthStart = M.MonthStart
		GROUP BY M.Quarter
	)
	UPDATE EH
	SET DataProtectedMB = D.DataProtectedMB
	FROM #EnvironmentHealth EH
		INNER JOIN DataProtected D ON D.Quarter = EH.Quarter
	IF @i_param = 0
	BEGIN
		SELECT Q.Quarter, Q.QuarterName,
			ClientsProtected,
			CASE WHEN SuccessRate IS NULL THEN 'N/A' ELSE CAST(SuccessRate AS NVARCHAR(MAX)) + '%' END AS SuccessRate,
			CAST(JobCount AS NVARCHAR(MAX)) AS JobCount,
			dbo.FormatBytes(DataProtectedMB, 'MB') AS DataProtected
		FROM @tblQuarters Q INNER JOIN #EnvironmentHealth EH ON Q.Quarter = EH.Quarter
		IF OBJECT_ID('tempdb..#EnvironmentHealth') IS NOT NULL DROP TABLE #EnvironmentHealth
	END
END
IF @i_param = 1 -- MISC_CLOUD_INFO_IN_TEXT
BEGIN
	INSERT INTO #LatestResults
	SELECT  DISTINCT R.CommcellIdNameMap_ID, R.QueryId, R.CommservSurveyResults_ID
	FROM    cf_CommservSurveyResults R WITH (NOLOCK)
		INNER JOIN #Commcells C ON C.CommservUniqueId = R.CommcellIdNameMap_ID
	WHERE   R.Flags = 1
		AND R.QueryId IN (8, 1, 174, 26, 3)
	DECLARE @NoOfServers int, @NoOfVMs int
	SET @queryId = 8
	SELECT @NoOfServers = ISNULL(SUM(csInfo.TotalActiveClients), 0) - ISNULL(SUM(csInfo.TotalLaptops), 0) - ISNULL(SUM(csInfo.TotalActiveVMs), 0),
			@NoOfVMs = ISNULL(SUM(csInfo.TotalActiveVMs), 0)
	FROM cf_SurveyClientStatisticsInfo csinfo WITH(NOLOCK)
		INNER JOIN #LatestResults AS resultview
			ON csinfo.surveyResultId = resultview.SurveyResultId AND resultView.QueryId = @queryId
	DECLARE @MaxVersionStr NVARCHAR(MAX), @MaxVersion NVARCHAR(MAX), @MaxSP NVARCHAR(MAX)
	SELECT TOP 1 @MaxVersionStr = CommServVersion
	FROM dbo.cf_SurveyResultFuncV1(146, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId)
	ORDER BY dbo.GetServicePackSortRank(CommServVersion) DESC
	SELECT
		@MaxVersion = SUBSTRING(@MaxVersionStr, 0, CHARINDEX(' ', @MaxVersionStr)),
		@MaxSP = CASE
			WHEN CHARINDEX('P', @MaxVersionStr) > 0
				THEN SUBSTRING(@MaxVersionStr, CHARINDEX('P', @MaxVersionStr) + 1, 3)
				ELSE '0' END
	DECLARE @FreeDiskSpace NVARCHAR(MAX), @TotalDiskSpace NVARCHAR(MAX), @noOfCriticalDiskLibs INT = 0
	SELECT 	@FreeDiskSpace = dbo.FormatBytes(ISNULL(SUM(FreeSpaceMB), 0), 'MB'),
			@TotalDiskSpace = dbo.FormatBytes(ISNULL(SUM(CapacityMB), 0), 'MB')
	FROM #RptDiskLibraryUsageWrapper_Output
	SELECT @noOfCriticalDiskLibs = COUNT(*) FROM #CriticalDiskLibs
	SET @queryId = 174
	DECLARE @DedupeSavingsPercentQ1 DECIMAL(5,2), @DedupeSavingsPercentQ2 DECIMAL(5,2)
	SELECT @DedupeSavingsPercentQ1 = CASE WHEN ISNULL(SUM(D.BackupSize), 0) > ISNULL(SUM(D.DataWritten), 0) THEN 1.0*(ISNULL(SUM(D.BackupSize), 0) - ISNULL(SUM(D.DataWritten), 0))/(0.01*ISNULL(SUM(D.BackupSize),0)) ELSE 0 END
	FROM cf_SurveyMonthlyDedupeSaving D WITH(NOLOCK)
		INNER JOIN #LatestResults AS resultview ON D.CommservUniqueId = resultview.CommservUniqueId AND resultView.QueryId = @queryId
		INNER JOIN #LastNMonths M ON D.MonthStart = M.MonthStart AND M.Quarter = 1
	SELECT @DedupeSavingsPercentQ2 = CASE WHEN ISNULL(SUM(D.BackupSize) ,0) > ISNULL(SUM(D.DataWritten),0) THEN 1.0*(SUM(D.BackupSize) - ISNULL(SUM(D.DataWritten),0))/(0.01*SUM(D.BackupSize)) ELSE 0 END
	FROM cf_SurveyMonthlyDedupeSaving D WITH(NOLOCK)
		INNER JOIN #LatestResults AS resultview ON D.CommservUniqueId = resultview.CommservUniqueId AND resultView.QueryId = @queryId
		INNER JOIN #LastNMonths M ON D.MonthStart = M.MonthStart AND M.Quarter = 2
	DECLARE @DedupeSavingPercentLast30D NVARCHAR(MAX), @DedupeRatioLast30D NVARCHAR(MAX)
	SET @QueryId = 26
	SELECT
        @DedupeSavingPercentLast30D = CASE
            WHEN SUM(csInfo.SizeOnMediaGB)<=0 THEN 'N/A'
            ELSE CAST(
                CAST((100.0*(SUM(csInfo.appSizeGB)-SUM(csInfo.SizeOnMediaGB))/SUM(csInfo.appSizeGB))AS Decimal(20,2))
                AS VARCHAR(MAX)) + '%'
        END,
        @DedupeRatioLast30D = CASE
            WHEN SUM(csInfo.SizeOnMediaGB)<=0 THEN 'N/A'
        ELSE CAST (CAST (( SUM(csInfo.appSizeGB)/SUM(csInfo.SizeOnMediaGB) +0.5) AS INT) AS NVARCHAR(MAX))+' : 1'
        END
    FROM cf_SurveyDDBRatioBySPCopy AS csInfo WITH (NOLOCK)
        INNER JOIN #LatestResults AS resultview
            ON csinfo.surveyResultId = resultview.SurveyResultId AND resultView.QueryId = @queryId
            AND csInfo.Jobs>0 and ( csInfo.DedupeRatio <>0 or  csInfo.SizeOnMediaGB <>0)
            AND csInfo.DedupeRatio>-1
	DECLARE @tblMiscInfo TABLE (ParameterName NVARCHAR(MAX), ParameterValue NVARCHAR(MAX))
	INSERT INTO @tblMiscInfo
		SELECT 'Quarter' + CAST(Quarter AS NVARCHAR(3)), QuarterName FROM @tblQuarters
	UNION ALL
		SELECT	'NoOfServers', CAST(@NoOfServers AS NVARCHAR(MAX))
	UNION ALL
		SELECT	'NoOfVMs', CAST(@NoOfVMs AS NVARCHAR(MAX))
	UNION ALL
		SELECT	'VersionNo', @MaxVersion
	UNION ALL
		SELECT	'SPNo', @MaxSP
	UNION ALL
		SELECT	'FreeDiskSpace', @FreeDiskSpace
	UNION ALL
		SELECT	'TotalDiskSpace', @TotalDiskSpace
	UNION ALL
		SELECT	'noOfCriticalDiskLibs', CAST(@noOfCriticalDiskLibs AS NVARCHAR(MAX))
	UNION ALL
		SELECT	'DedupeSavingsPercentQ1', CAST(@DedupeSavingsPercentQ1 AS NVARCHAR(MAX)) + '%'
	UNION ALL
		SELECT	'DedupeSavingsPercentQ2', CAST(@DedupeSavingsPercentQ2 AS NVARCHAR(MAX)) + '%'
	UNION ALL
		SELECT 'DedupeDiffVerb', CASE WHEN @DedupeSavingsPercentQ1 = @DedupeSavingsPercentQ2 THEN 'Consistent with' WHEN @DedupeSavingsPercentQ1 > @DedupeSavingsPercentQ2 THEN 'Increased from' ELSE 'Decreased from' END
	UNION ALL
		SELECT 'DedupeSavingPercentLast30D', ISNULL(@DedupeSavingPercentLast30D, 'N/A')
	UNION ALL
		SELECT 'DedupeRatioLast30D', ISNULL(@DedupeRatioLast30D, 'N/A')
	DECLARE @SuccessRateQ2 DECIMAL(5,2) = (SELECT ISNULL(SuccessRate, -1) FROM #EnvironmentHealth WHERE Quarter = 2)
	DECLARE @SuccessRateQ1  DECIMAL(5,2) = (SELECT ISNULL(SuccessRate, -1) FROM #EnvironmentHealth WHERE Quarter = 1)
	INSERT INTO @tblMiscInfo
		SELECT 'SuccessRateQ1', CASE WHEN @SuccessRateQ1 < 0 THEN 'N/A' ELSE CAST(@SuccessRateQ1 AS NVARCHAR(MAX)) + '%' END
	UNION ALL
		SELECT 'SuccessRateQ2', CASE WHEN @SuccessRateQ2 < 0 THEN 'N/A' ELSE CAST(@SuccessRateQ2 AS NVARCHAR(MAX)) + '%' END
	UNION ALL
		SELECT 'SuccessRateDiffVerb',
			CASE WHEN (@SuccessRateQ2 = @SuccessRateQ1) OR ((@SuccessRateQ1 < 0) AND (@SuccessRateQ2 < 0)) THEN 'been consistent with'
			WHEN @SuccessRateQ2 > @SuccessRateQ1 THEN 'declined from'
			ELSE 'improved from'
			END
	UNION ALL
		SELECT
		'SuccessRateChangeRate',
		CASE	WHEN @SuccessRateQ2 = -1 OR @SuccessRateQ1 = -1  OR @SuccessRateQ2 = 0 THEN 'N/A'
				WHEN @SuccessRateQ2 = @SuccessRateQ1 THEN 'constant'
				WHEN @SuccessRateQ2 > @SuccessRateQ1 THEN CAST(CAST(((@SuccessRateQ2  - @SuccessRateQ1) * 100.0 / @SuccessRateQ2) AS DECIMAL(32,2)) AS NVARCHAR(MAX)) + '% decrease'
				ELSE CAST(CAST(((@SuccessRateQ1  - @SuccessRateQ2) * 100.0 / @SuccessRateQ2) AS DECIMAL(32,2)) AS NVARCHAR(MAX)) + '% increase'
		END
	DECLARE @ClientsProtectedLastQ int, @ClientsProtectedCurQ int, @JobCountLastQ int, @JobCountCurQ int,
		@DataProtectedQ1 BIGINT, @DataProtectedQ2 BIGINT
	SELECT @ClientsProtectedLastQ = ClientsProtected FROM #EnvironmentHealth WHERE Quarter = 2
	SELECT @ClientsProtectedCurQ = ClientsProtected FROM #EnvironmentHealth WHERE Quarter = 1
	INSERT INTO @tblMiscInfo
	SELECT
		'ClientsProtectedChangeRate',
		CASE	WHEN @ClientsProtectedLastQ = 0 THEN 'N/A'
				WHEN @ClientsProtectedLastQ = @ClientsProtectedCurQ THEN 'constant'
				WHEN @ClientsProtectedLastQ > @ClientsProtectedCurQ THEN CAST(CAST(((@ClientsProtectedLastQ  - @ClientsProtectedCurQ) * 100.0 / @ClientsProtectedLastQ) AS DECIMAL(32,2)) AS NVARCHAR(MAX)) + '% decrease'
				ELSE CAST(CAST(((@ClientsProtectedCurQ  - @ClientsProtectedLastQ) * 100.0 / @ClientsProtectedLastQ) AS DECIMAL(32,2)) AS NVARCHAR(MAX)) + '% increase'
		END
	SELECT @JobCountLastQ = JobCount FROM #EnvironmentHealth WHERE Quarter = 2
	SELECT @JobCountCurQ = JobCount FROM #EnvironmentHealth WHERE Quarter = 1
	INSERT INTO @tblMiscInfo
	SELECT
		'JobCountChangeRate',
		CASE	WHEN @JobCountLastQ = 0 THEN 'N/A'
				WHEN @JobCountLastQ = @JobCountCurQ THEN 'constant'
				WHEN @JobCountLastQ > @JobCountCurQ THEN CAST(CAST(((@JobCountLastQ  - @JobCountCurQ) * 100.0 / @JobCountLastQ) AS DECIMAL(32,2)) AS NVARCHAR(MAX)) + '% decrease'
				ELSE CAST(CAST(((@JobCountCurQ  - @JobCountLastQ) * 100.0 / @JobCountLastQ) AS DECIMAL(32,2)) AS NVARCHAR(MAX)) + '% increase'
		END
	SELECT @DataProtectedQ1 = DataProtectedMB FROM #EnvironmentHealth WHERE Quarter = 1
	SELECT @DataProtectedQ2 = DataProtectedMB FROM #EnvironmentHealth WHERE Quarter = 2
	INSERT INTO @tblMiscInfo
	SELECT
		'DataProtectionGrowthRate',
		CASE	WHEN @DataProtectedQ2 = 0 THEN 'N/A'
				WHEN @DataProtectedQ2 = @DataProtectedQ1 THEN 'constant'
				WHEN @DataProtectedQ2 > @DataProtectedQ1 THEN CAST(CAST(((@DataProtectedQ2  - @DataProtectedQ1) * 100.0 / @DataProtectedQ2) AS DECIMAL(32,2)) AS NVARCHAR(MAX)) + '% decrease'
				ELSE CAST(CAST(((@DataProtectedQ1  - @DataProtectedQ2) * 100.0 / @DataProtectedQ2) AS DECIMAL(32,2)) AS NVARCHAR(MAX)) + '% increase'
		END
	UNION ALL
		SELECT 'DataProtectionQ1', dbo.FormatBytes(@DataProtectedQ1, 'MB')
	UNION ALL
		SELECT
			'DataProtectedChangeValue',
			dbo.FormatBytes(ABS(@DataProtectedQ2 - @DataProtectedQ1), 'MB')
	UNION ALL
		SELECT
			'DataProtectedChangeVerb',
			CASE WHEN @DataProtectedQ2 > @DataProtectedQ1 THEN 'decline' ELSE 'growth' END
	SET @queryId = 1
	DECLARE @BackupPurchased NVARCHAR(MAX), @ReplicationPurchased NVARCHAR(MAX), @SnapshotPurchased NVARCHAR(MAX)
	SELECT
		@BackupPurchased = dbo.FormatBytes(ISNULL(SUM(P.TotalBackupSize), 0), 'MB'),
		@ReplicationPurchased = dbo.FormatBytes(ISNULL(SUM(P.TotalReplicationSize), 0), 'MB'),
		@SnapshotPurchased = dbo.FormatBytes(ISNULL(SUM(P.TotalSnapshotSize), 0), 'MB')
	FROM cf_SurveyCapacityLicenseUsage AS P  WITH(NOLOCK)
		INNER JOIN #LatestResults AS resultview
			ON P.surveyResultId = resultview.SurveyResultId AND resultView.QueryId = @queryId
	DECLARE @CurrentBackupUsage NVARCHAR(MAX), @CurrentReplUsage NVARCHAR(MAX), @CurrentSnapshotUsage NVARCHAR(MAX)
	SELECT
		@CurrentBackupUsage = dbo.FormatBytes(ISNULL(SUM(csInfo.BackupSize), 0), 'MB'),
		@CurrentReplUsage = dbo.FormatBytes(ISNULL(SUM(csInfo.ReplicationSize), 0), 'MB'),
		@CurrentSnapshotUsage = dbo.FormatBytes(ISNULL(SUM(csInfo.SnapshotSize), 0), 'MB')
	FROM cf_SurveyCapacityLicenseUsage csInfo WITH(NOLOCK)
		INNER JOIN #LatestResults AS resultview
			ON csinfo.surveyResultId = resultview.SurveyResultId AND resultView.QueryId = @queryId
	SET @queryId = 3
	DECLARE @CurMonthPeakBackupUsage NVARCHAR(MAX), @CurMonthPeakReplUsage NVARCHAR(MAX), @CurMonthPeakSnapshotUsage NVARCHAR(MAX)
	SELECT
		@CurMonthPeakBackupUsage = dbo.FormatBytes(ISNULL(MAX(BackupSize), 0), 'MB'),
		@CurMonthPeakReplUsage = dbo.FormatBytes(ISNULL(MAX(ReplicationSize), 0), 'MB'),
		@CurMonthPeakSnapshotUsage = dbo.FormatBytes(ISNULL(MAX(SnapshotSize), 0), 'MB')
	FROM (
		SELECT
				ISNULL(SUM(csInfo.BackupSize), 0) AS BackupSize,
				ISNULL(SUM(csInfo.ReplicationSize), 0) AS ReplicationSize,
				ISNULL(SUM(csInfo.SnapshotSize), 0) AS SnapshotSize
		FROM cf_SurveyCapacityLicensePeakUsage csInfo WITH(NOLOCK)
			INNER JOIN #LatestResults AS resultview ON csinfo.CommservUniqueId = resultview.CommservUniqueId AND resultView.QueryId = @queryId
			INNER JOIN #LastNMonths AS months ON csInfo.MonthStart = months.MonthStart AND months.Quarter = 1
		GROUP BY csInfo.MonthStart
	) AS T
	INSERT INTO @tblMiscInfo
		SELECT 	'BackupPurchased', 	@BackupPurchased
	UNION
		SELECT 	'ReplPurchased', 	@ReplicationPurchased
	UNION
		SELECT 	'SnapshotPurchased', 	@SnapshotPurchased
	UNION
		SELECT 	'PeakBackupUsage', 	@CurMonthPeakBackupUsage
	UNION
		SELECT 	'PeakReplUsage', 	@CurMonthPeakReplUsage
	UNION
		SELECT 	'PeakSnapshotUsage', 	@CurMonthPeakSnapshotUsage
	UNION
		SELECT 	'CurrentBackupUsage', 	@CurrentBackupUsage
	UNION
		SELECT 	'CurrentReplUsage', 	@CurrentReplUsage
	UNION
		SELECT 	'CurrentSnapshotUsage', 	@CurrentSnapshotUsage
	UPDATE	@tblMiscInfo
	SET ParameterValue = '100%'
	WHERE ParameterValue = '100.00%'
	SELECT ParameterName, ParameterValue FROM @tblMiscInfo ORDER BY ParameterName
END
ELSE IF @i_param = 2 -- TOTAL_JOBS_VS_FAILURES (Slides 15, 19)
BEGIN
	DECLARE @tblJobStats TABLE (Month NVARCHAR(MAX), TotalJobs BIGINT, FailedJobs BIGINT)
	SET @queryId = 173
	INSERT INTO @tblJobStats
	SELECT	CONVERT(CHAR(3), DATENAME(MONTH, M.MonthStart)),
			ISNULL(SUM(ISNULL(TotalJobs, 0) - ISNULL(SkippedJobs, 0)), 0),
			ISNULL(SUM(ISNULL(FailedJobs, 0)), 0)
	FROM cf_SurveyIDAMonthlyBkpJobStats csInfo WITH(NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) resultView ON resultView.CommservUniqueId = csInfo.CommservUniqueId
		RIGHT OUTER JOIN #LastNMonths M ON csinfo.MonthStart = M.MonthStart
	GROUP BY M.MonthStart
	SELECT Month, TotalJobs AS 'Total Jobs', CASE WHEN TotalJobs = 0 THEN 0 ELSE CAST((CAST(FailedJobs AS DECIMAL(20,4)) / TotalJobs) AS DECIMAL(20,4)) END AS 'Failure %<Percentage>'
	FROM @tblJobStats
END
ELSE IF @i_param = 3 -- JOB_SUCCESS_RATE (Slide 15)
BEGIN
	DECLARE @tblSuccessJobStats TABLE (Month NVARCHAR(MAX), TotalJobs BIGINT, CompletedJobs BIGINT)
	SET @queryId = 173
	INSERT INTO @tblSuccessJobStats
	SELECT	CONVERT(CHAR(3), DATENAME(MONTH, M.MonthStart)),
			ISNULL(SUM(ISNULL(TotalJobs, 0) - ISNULL(SkippedJobs, 0)), 0),
			ISNULL(SUM(ISNULL(CompletedJobs, 0) + ISNULL(CWEJobs, 0) + ISNULL(CWWJobs, 0)), 0)
	FROM cf_SurveyIDAMonthlyBkpJobStats csInfo WITH(NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) resultView ON resultView.CommservUniqueId = csInfo.CommservUniqueId
		RIGHT OUTER JOIN #LastNMonths M ON csinfo.MonthStart = M.MonthStart
	GROUP BY M.MonthStart
	SELECT Month,
		CASE WHEN TotalJobs = 0 THEN 0 ELSE CAST((CAST(CompletedJobs AS DECIMAL(20,4)) / TotalJobs) AS DECIMAL(20,4)) END AS 'Success Rate (%)<Percentage>'
	FROM @tblSuccessJobStats
END
ELSE IF @i_param = 4 --BACKUP_CAPACITY_SAVINGS
BEGIN
	SET @queryId = 174
	DECLARE @capacitySavings DECIMAL(32,2), @backupSize DECIMAL(32,2)
	SELECT
		@capacitySavings = CASE WHEN SUM(D.BackupSize) > SUM(D.DataWritten) THEN (SUM(D.BackupSize) - SUM(D.DataWritten))*1.0/(1024.0*1024.0) ELSE 0 END,
		@backupSize = CASE WHEN SUM(D.BackupSize) > SUM(D.DataWritten) THEN SUM(D.DataWritten)*1.0/(1024.0*1024.0) ELSE 0 END
	FROM cf_SurveyMonthlyDedupeSaving D WITH(NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) resultView ON resultView.CommservUniqueId = D.CommservUniqueId
		INNER JOIN #LastNMonths M ON D.MonthStart = M.MonthStart
	SELECT
		'Total Backup Size %' AS 'Category',
		@backupSize AS 'Savings'
	UNION
	SELECT
		'Capacity Saving %' AS 'Category',
		@capacitySavings AS 'Savings'
END
ELSE IF @i_param = 5 --JOBS_ABSOLUTE_NUMBERS
BEGIN
	SET @queryId = 146
	SELECT	CONVERT(CHAR(3), DATENAME(MONTH, M.MonthStart)) AS Month,
			ISNULL(SUM(ISNULL(CompletedJobs, 0)), 0) AS Successful,
			ISNULL(SUM(ISNULL(FailedJobs, 0)), 0) AS Failed,
			ISNULL(SUM(ISNULL(CWEJobs, 0) + ISNULL(CWWJobs, 0)), 0) AS 'Partial Success',
			ISNULL(SUM(ISNULL(KilledJobs, 0)), 0) AS Killed,
			ISNULL(SUM(ISNULL(TotalJobs, 0) - ISNULL(SkippedJobs, 0)), 0) AS 'Total Jobs'
	FROM cf_SurveyIDAMonthlyBkpJobStats csInfo WITH(NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) resultView ON resultView.CommservUniqueId = csInfo.CommservUniqueId
		RIGHT OUTER JOIN #LastNMonths M ON csinfo.MonthStart = M.MonthStart
	GROUP BY M.MonthStart
END
ELSE IF @i_param = 6 --BACKUP_USAGE_BY_AGENT
BEGIN
	SET @queryId = 3
	DECLARE @tblTempBkpByAgent TABLE (shortname NVARCHAR(MAX), BackupSize DECIMAL(32,0))
	INSERT INTO @tblTempBkpByAgent
	SELECT shortName, MAX(BackupSize)
	FROM
		(
			SELECT
				CASE WHEN CU.TypeId = 38 THEN CU.TypeName ELSE AT.shortName END AS shortName,
				SUM(BackupSize) AS BackupSize
			FROM    cf_SurveyAgentCapacityPeakUsage CU WITH(NOLOCK)
				INNER JOIN cf_SurveyAgentType AT WITH(NOLOCK) ON CU.TypeId = AT.id AND CU.TypeId > 0
				INNER JOIN #LastNMonths month ON CU.MonthStart = month.MonthStart
				INNER JOIN dbo.cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) resultView ON resultView.CommservUniqueId = CU.CommservUniqueId
			GROUP BY month.MonthStart, CASE WHEN CU.TypeId = 38 THEN CU.TypeName ELSE AT.shortName END
		) AS T
	GROUP BY shortName
	DECLARE @tblBkpUsageByAgent TABLE (AgentShortName NVARCHAR(MAX), AgentName NVARCHAR(MAX), BackupSizeTB DECIMAL(32,2))
	INSERT INTO @tblBkpUsageByAgent
	SELECT TOP 9
		shortName,
		shortName + ' - ' + dbo.FormatBytes(BackupSize, 'B'),
		CAST(BackupSize/(1024.00*1024.00*1024.00*1024.00) AS DECIMAL(32,2))
	FROM @tblTempBkpByAgent
	ORDER BY BackupSize desc
	IF EXISTS (SELECT 1 from @tblTempBkpByAgent WHERE shortname NOT IN (SELECT AgentShortName from @tblBkpUsageByAgent))
	BEGIN
		INSERT INTO @tblBkpUsageByAgent
		SELECT 'Others',
			'Others - ' + dbo.FormatBytes(SUM(BackupSize), 'B'),
			CAST(SUM(BackupSize)/(1024.00*1024.00*1024.00*1024.00) AS DECIMAL(32,2))
		FROM @tblTempBkpByAgent
		WHERE shortName NOT IN (SELECT AgentShortName from @tblBkpUsageByAgent)
	END
	SELECT AgentName AS 'Agent', BackupSizeTB AS 'Backup Size (TB)' FROM @tblBkpUsageByAgent
END
ELSE IF @i_param = 7 --CAPACITY_GROWTH
BEGIN
	INSERT INTO #LatestResults
	SELECT  DISTINCT R.CommcellIdNameMap_ID, R.QueryId, R.CommservSurveyResults_ID
	FROM    cf_CommservSurveyResults R WITH (NOLOCK)
		INNER JOIN #Commcells C ON C.CommservUniqueId = R.CommcellIdNameMap_ID
	WHERE   R.Flags = 1
		AND R.QueryId IN (1, 3)
	SET @queryId = 1
	DECLARE @BackupPurchasedTB NVARCHAR(MAX), @ReplicationPurchasedTB NVARCHAR(MAX), @SnapshotPurchasedTB NVARCHAR(MAX)
	SELECT
		@BackupPurchasedTB = CAST(SUM(ISNULL(P.TotalBackupSize,0))/(1024.0*1024.0) AS DECIMAL(32,2)),
		@ReplicationPurchasedTB = CAST(SUM(ISNULL(P.TotalReplicationSize,0))/(1024.0*1024.0) AS DECIMAL(32,2)),
		@SnapshotPurchasedTB = CAST(SUM(ISNULL(P.TotalSnapshotSize,0))/(1024.0*1024.0) AS DECIMAL(32,2))
	FROM cf_SurveyCapacityLicenseUsage AS P WITH(NOLOCK)
		INNER JOIN #LatestResults AS resultview
			ON P.surveyResultId = resultview.SurveyResultId AND resultView.QueryId = @queryId
	SET @queryId = 3
	SELECT CONVERT(CHAR(3), DATENAME(MONTH, M.MonthStart)) AS 'Month',
		CAST(SUM(ISNULL(csInfo.BackupSize,0))/(1024.0*1024.0) AS DECIMAL(32,2)) AS 'Backup Size (TB)',
		@BackupPurchasedTB AS 'Backup Purchased (TB)' ,
		CAST(SUM(ISNULL(csInfo.ReplicationSize,0))/(1024.0*1024.0) AS DECIMAL(32,2)) AS 'Replication Size (TB)',
		@ReplicationPurchasedTB AS 'Replication Purchased (TB)' ,
		CAST(SUM(ISNULL(csInfo.SnapshotSize,0))/(1024.0*1024.0) AS DECIMAL(32,2)) AS 'Snapshot Size (TB)',
		@SnapshotPurchasedTB AS 'Snapshot Purchased (TB)'
	FROM cf_SurveyCapacityLicensePeakUsage AS csInfo WITH(NOLOCK)
		INNER JOIN #LatestResults AS resultview ON csinfo.CommservUniqueId = resultview.CommservUniqueId AND resultView.QueryId = @queryId
		RIGHT OUTER JOIN #LastNMonths M ON csinfo.MonthStart = M.MonthStart
	GROUP BY M.MonthStart
	ORDER BY M.MonthStart
END
ELSE IF @i_param = 8 --CRITICAL_DISKLIBS_UTILIZATION
BEGIN
	SELECT
		LibraryName AS 'Library',
		CAST((CapacityMB - FreeSpaceMB)*1.0/(1024*1024*1024) AS DECIMAL(10,2)) AS 'Space Occupied (PB)',
		CAST(FreeSpaceMB*1.0/(1024*1024*1024) AS DECIMAL(10,2)) AS 'Space Left (PB)',
		CAST(CapacityMB*1.0/(1024*1024*1024) AS DECIMAL(10,2)) AS 'Capacity (PB)',
		CAST(FreeSpaceMB*1.0/CapacityMB AS DECIMAL(10,4)) AS 'Percentage Free'
	FROM #RptDiskLibraryUsageWrapper_Output
	WHERE Status = '4_Critical'
	ORDER BY 'Percentage Free' DESC
END
ELSE IF @i_param = 9 --CRITICAL_DISKLIBS_GROWTH_FORECAST
BEGIN
	IF OBJECT_ID('tempdb.dbo.#DiskLibGrowth') IS NOT NULL DROP TABLE #DiskLibGrowth
	CREATE TABLE #DiskLibGrowth
	(
		CommservUniqueId			INT,
		CommcellName				NVARCHAR(MAX),
		LibraryName					NVARCHAR(MAX),
		LatestMonth					DATE,
		TotalSpaceMB				BIGINT,
		ConsumedSpaceMB				BIGINT,
		PrevMonthChangeMB			BIGINT,
		PrevMonthChangePercent		DECIMAL(10,2),
		CurrentMonthChangeMB		BIGINT,
		CurrentMonthChangePercent	DECIMAL(10,2),
		GrowthRate					DECIMAL(10,2),
		SizeAfter6MonthsMB			BIGINT,
		SizeAfter12MonthsMB			BIGINT,
		SizeAfter18MonthsMB			BIGINT,
		PurchaseAfter6MonthsMB		BIGINT,
		PurchaseAfter12MonthsMB		BIGINT,
		PurchaseAfter18MonthsMB		BIGINT
	)
	INSERT INTO #DiskLibGrowth
	EXEC RptDataGrowthTrend @i_UserId, @i_GroupId, 0, -1, @i_CommServUniqueID, 'Disk Library'
	IF @i_CommServUniqueID = 0
		UPDATE D
		SET LibraryName = LibraryName + (' - ' + CASE WHEN CommCellID = -1 THEN 'FFFFFFFF' ELSE dbo.ConvertBigIntToHexStr(CommCellID) END)
		FROM #CriticalDiskLibs D
			INNER JOIN cf_CommcellIdNameMap C ON D.CommservUniqueId = C.id
	SELECT
		G.LibraryName AS 'Library',
		CAST(ConsumedSpaceMB*1.0/(1024*1024*1024) AS DECIMAL(10,2)) AS 'Consumed Space (PB)',
		CAST(SizeAfter6MonthsMB*1.0/(1024*1024*1024) AS DECIMAL(10,2)) AS 'Size After 6 Months (PB)',
		CAST(SizeAfter12MonthsMB*1.0/(1024*1024*1024) AS DECIMAL(10,2)) AS 'Size After 12 Months (PB)',
		CAST(SizeAfter18MonthsMB*1.0/(1024*1024*1024) AS DECIMAL(10,2)) AS 'Size After 18 Months (PB)'
	FROM #DiskLibGrowth G
		INNER JOIN #CriticalDiskLibs C ON C.CommservUniqueId = G.CommservUniqueId AND C.LibraryName = G.LibraryName
	IF OBJECT_ID('tempdb.dbo.#DiskLibGrowth') IS NOT NULL DROP TABLE #DiskLibGrowth
END
ELSE IF @i_param = 10 --DEDUPE_SAVINGS_LAST_30_DAYS
BEGIN
	SET @queryId = 26
	DECLARE @totalAppSize DECIMAL(32,2) = 0, @totalSizeOnMedia DECIMAL(32,2) = 0
	SELECT
		@totalSizeOnMedia = ISNULL(SUM(csInfo.SizeOnMediaGB)*1.0/1024,0),
		@totalAppSize = ISNULL(SUM(csInfo.appSizeGB)*1.0/1024,0)
	FROM cf_SurveyDDBRatioBySPCopy AS csInfo WITH (NOLOCK)
        INNER JOIN dbo.cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId)  AS result
            ON result.SurverResultId = csInfo.SurveyResultId
            AND csInfo.Jobs>0 and ( csInfo.DedupeRatio <>0 or  csInfo.SizeOnMediaGB <>0)
            AND csInfo.DedupeRatio>-1
	SELECT
		'Total Application Size (TB)' AS 'Category',
		@totalAppSize AS 'Size (TB)'
	UNION
	SELECT
		'Total Backup Size (TB)' AS 'Category',
		@totalSizeOnMedia AS 'Size (TB)'
END
ELSE IF @i_param = 11 --DEDUPE_SAVINGS_LAST_30_DAYS
BEGIN
	SET @queryId = 26
	DECLARE @capacitySavings30Days DECIMAL(32,2) = 0, @backupSize30Days DECIMAL(32,2) = 0
	SELECT
		@capacitySavings30Days = CASE WHEN SUM(csInfo.appSizeGB) > SUM(csInfo.SizeOnMediaGB) THEN (SUM(csInfo.appSizeGB) - SUM(csInfo.SizeOnMediaGB))*1.0/(1024.0) ELSE 0 END,
		@backupSize30Days = CASE WHEN SUM(csInfo.appSizeGB) > SUM(csInfo.SizeOnMediaGB) THEN SUM(csInfo.SizeOnMediaGB)*1.0/(1024.0) ELSE 0 END
	FROM cf_SurveyDDBRatioBySPCopy AS csInfo WITH (NOLOCK)
        INNER JOIN dbo.cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId)  AS result
            ON result.SurverResultId = csInfo.SurveyResultId
            AND csInfo.Jobs>0 and ( csInfo.DedupeRatio <>0 or  csInfo.SizeOnMediaGB <>0)
            AND csInfo.DedupeRatio>-1
	SELECT
		'Total Backup Size %' AS 'Category',
		@backupSize30Days AS 'Savings'
	UNION
	SELECT
		'Capacity Saving %' AS 'Category',
		@capacitySavings30Days AS 'Savings'
END
ELSE IF @i_param IN (12, 13) --SPCOPY_DEDUPE_RATIO
BEGIN
	IF OBJECT_ID('tempdb.dbo.#DedupeRatioBySPCopy') IS NOT NULL DROP TABLE #DedupeRatioBySPCopy
	CREATE TABLE #DedupeRatioBySPCopy
	(
		CommservUniqueId	INT,
		CommCellId			NVARCHAR(MAX),
		CommcellName		NVARCHAR(MAX),
		StoragePolicy		NVARCHAR(MAX),
		CopyName			NVARCHAR(MAX),
		AppSizeMB			BIGINT,
		MediaSizeMB			BIGINT,
		DedupePercent		DECIMAL(5,2),
		NoOfJobs			BIGINT,
		NoOfClients			INT,
		DedupeRatio			NVARCHAR(10)
	)
	IF(@i_CommServUniqueID = 0)
		INSERT INTO #DedupeRatioBySPCopy
		EXEC RptDeDupRatioBySPCopy @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND, 1
	ELSE
	BEGIN
		ALTER TABLE #DedupeRatioBySPCopy ADD DeDupRatioSort INT
		INSERT INTO #DedupeRatioBySPCopy(CommServUniqueId, StoragePolicy, CopyName, AppSizeMB, MediaSizeMB, DedupePercent, NoOfJobs, NoOfClients, DedupeRatio, DeDupRatioSort)
		EXEC RptDeDupRatioBySPCopy @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND, 1
	END
	IF @i_param = 12 --SPCOPY_DEDUPE_RATIO chart
	BEGIN
		SELECT TOP 10
			StoragePolicy + '-' + CopyName AS 'Storage Policy Copy',
			DedupePercent / 100  AS 'Dedupe Ratio (%)',
			CAST(SUBSTRING(DedupeRatio,0,CHARINDEX(':', DedupeRatio, 0)) AS INT) AS 'Dedupe Ratio'
		FROM #DedupeRatioBySPCopy
		ORDER BY DedupePercent
	END
	IF @i_param = 13 --SPCOPY_DEDUPE_RATIO table
	BEGIN
		SELECT TOP 10
			StoragePolicy AS 'Storage Policy',
			CopyName AS 'Copy',
			dbo.FormatBytes(AppSizeMB, 'MB') AS 'Application Size',
			dbo.FormatBytes(MediaSizeMB, 'MB') AS 'Size On Media',
			DedupePercent AS 'Dedupe Ratio (%)'
		FROM #DedupeRatioBySPCopy
		ORDER BY DedupePercent
	END
	IF OBJECT_ID('tempdb.dbo.#DedupeRatioBySPCopy') IS NOT NULL DROP TABLE #DedupeRatioBySPCopy
END
ELSE IF @i_param = 14 --INDEX_CACHE
BEGIN
	SET @queryId = 39
	DECLARE @criticalSpaceMB INT = (SELECT CriticalThreshold FROM cf_SurveyHealthParam WITH(NOLOCK) WHERE queryId = 105)
	SELECT
		ISNULL(CL.clientDisplayName, csInfo.MAName) AS 'Media Agent',
		csInfo.IndexCachePath AS 'Index Cache Path',
		dbo.FormatBytes(csInfo.TotalCapacityMB, 'MB') AS 'Total Capacity',
		dbo.FormatBytes(csInfo.DiskUsageMB, 'MB') AS 'Disk Usage',
		dbo.FormatBytes(csInfo.FreeDiskSpaceMB, 'MB') AS 'Free Disk Space',
		CAST((csInfo.FreeDiskSpaceMB * 100.0 / csInfo.TotalCapacityMB) AS DECIMAL(5,2)) AS 'Free Disk Space (%)'
	FROM cf_SurveyIndexCacheUsage AS csInfo WITH (NOLOCK)
		LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = csInfo.CommServUniqueId AND CL.ClientId = csInfo.MAId
		INNER JOIN dbo.cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
			AND csInfo.TotalCapacityMB > 0 AND csInfo.IndexAccessPathEnabled = 1
		LEFT OUTER JOIN (SELECT commservUniqueId, entityId AS clientId, CASE ISNUMERIC(attrVal) WHEN 1 THEN CAST(CAST(attrVal AS FLOAT) AS BIGINT) ELSE 0 END  AS criticalSpaceMB FROM cf_SurveyCommcellThresholdInfo WITH(NOLOCK) WHERE attrName = 'criticalSpaceMB') AS T
			ON T.CommServUniqueId =csInfo.CommServUniqueId AND csInfo.MAId = T.clientId
	WHERE csInfo.TotalCapacityMB > 0 AND csInfo.FreeDiskSpaceMB > 0 AND csInfo.FreeDiskSpaceMB  < ISNULL(T.criticalSpaceMB, @criticalSpaceMB)
END
ELSE IF @i_param = 15 --LICENSE_USAGE
BEGIN
	IF OBJECT_ID('tempdb.dbo.#LicenseUsage') IS NOT NULL DROP TABLE #LicenseUsage
	CREATE TABLE #LicenseUsage
	(
		CommcellCount	INT,
		Name			NVARCHAR(MAX),
		Total			BIGINT,
		Used			BIGINT,
		PercentUsed		DECIMAL(10,4),
		LogDate			DATETIME,
		Loaned			BIGINT
	)
	INSERT INTO #LicenseUsage
	EXEC RptCapacityLicenseSurvey @i_UserId, @i_GroupId, 1, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND
	SELECT
		Name AS 'License Type',
		Used AS 'Used',
		CASE WHEN Total > 0 THEN Total - Used ELSE 0 END AS 'Unused',
		Total AS 'Total',
		PercentUsed / 100 AS 'Percent Used',
		Loaned AS 'Loaned Capacity'
	FROM #LicenseUsage
	IF OBJECT_ID('tempdb.dbo.#LicenseUsage') IS NOT NULL DROP TABLE #LicenseUsage
END
IF OBJECT_ID('tempdb.dbo.#LastNMonths') IS NOT NULL DROP TABLE #LastNMonths
IF OBJECT_ID('tempdb.dbo.#RptDiskLibraryUsageWrapper_Output') IS NOT NULL DROP TABLE #RptDiskLibraryUsageWrapper_Output
IF OBJECT_ID('tempdb.dbo.#LatestResults') IS NOT NULL DROP TABLE #LatestResults
IF OBJECT_ID('tempdb.dbo.#Commcells') IS NOT NULL DROP TABLE #Commcells
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE TESTING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= NULL
  DECLARE @blaggregate INT				= 0
  DECLARE @blLatestSurvey INT			= 1
  DECLARE @i_CommServUniqueID INT		= 10019
  DECLARE @i_LogDateEND DATETIME		= 	NULL    -- getDate()
  DECLARE @i_LogDateStart DATETIME		= NULL 		-- DateAdd(Month, -36, @i_LogDateEND)
  DECLARE @i_param INT					= 14
  DECLARE @i_fromMonth INT				= 0 		-- The input is the difference between the current month and the "from" month selected
  DECLARE @i_toMonth INT				= 0			-- The input is the difference between the current month and the "to" month selected
  DECLARE @i_includeQuarters VARCHAR(MAX) = ''		-- Space separated list of quarters to consider; 1:last quarter; 2: second last quarter..
exec RptQuarterlyPptData @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND
			, @i_param, @i_fromMonth, @i_toMonth, @i_includeQuarters
*/

IF EXISTS (select * from GxQscripts where name = 'RptQuarterlyPptData')
	delete from GxQscripts where name = 'RptQuarterlyPptData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptQuarterlyPptData')
	delete from GXDBVersions where aliasname = 'RptQuarterlyPptData'
GO

insert into GXDBVersions values(2, 'RptQuarterlyPptData',  '00010005000200180000', 'RptQuarterlyPptData', '00010005000200180000')
GO

