

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptProtectedDataPerAgent.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptProtectedDataPerAgent.sp,v $ $Id: RptProtectedDataPerAgent.sp,v 1.7.56.1 2016/06/06 23:36:10 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptProtectedDataPerAgent <<<'

IF EXISTS (select * from sysobjects where name='RptProtectedDataPerAgent')
	drop procedure RptProtectedDataPerAgent
IF EXISTS (select * from GxQscripts where name='RptProtectedDataPerAgent')
	delete from GxQscripts where name = 'RptProtectedDataPerAgent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptProtectedDataPerAgent')
	delete from GXDBVersions where aliasname = 'RptProtectedDataPerAgent'
GO
print '... Creating Procedure: RptProtectedDataPerAgent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptProtectedDataPerAgent
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
IF(@blaggregate=1)
                RETURN
DECLARE @i_QueryId BIGINT = 54
SET @blLatestSurvey = 1 --Always pickup the latest
IF @i_CommServUniqueID = 0
BEGIN
SELECT
                sub.CommServUniqueId  AS 'CommServ UniqueId',
                sub.CommCellID AS 'CommCell ID',
                sub.CommServIP AS 'CommServe IP<HIDDEN>',
                sub.CommServGUID AS 'CommServer GUID',
                sub.CommCellName AS 'CommCell Name',
                DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(sub.LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME>',
                ISNULL(sub.CommServTimeZone, '')  AS 'TimeZone',
                CASE
                                WHEN sub.RunningTime = -1 THEN 'N/A'
                                ELSE CAST(sub.RunningTime AS VARCHAR(MAX))
                END AS 'Running Time in Seconds',
                sub.AgentType AS 'Agent',
                sub.BackupLevel AS 'Backup Level',
                SUM(sub.JobCount) AS 'Job Count',
                CAST(SUM(sub.ApplicationSizeMB) AS DECIMAL(32,2)) AS 'Application Size<SIZEMB>'
FROM
                (SELECT
                                resultView.CommServUniqueId,
                                resultView.CommCellID,
                                resultView.CommServIP,
                                resultView.CommServGUID,
                                resultView.DisplayName AS 'CommCellName',
                                csInfo.LogDate,
                                resultView.CommServTimeZone,
                                resultView.RunningTime,
                                csInfo.AgentType,
                                CASE csInfo.BackupLevel
                                                WHEN -1 THEN 'All'
                                                WHEN 1 THEN 'Full'
                                                WHEN 2 THEN 'Incremental'
                                                WHEN 4 THEN 'Differential'
                                                WHEN 64 THEN 'Synthetic'
                                                WHEN 128 THEN 'Synthetic'
                                                WHEN 256 THEN 'Log NotRunc'
                                                WHEN 1024 THEN 'OFF Full'
                                                WHEN 16384 THEN 'N/A'
                                                WHEN 32768 THEN 'SEL Full'
                                                ELSE 'Others'
                                END AS BackupLevel,
                                csInfo.JobCount,
                                csInfo.ApplicationSizeMB
FROM cf_SurveyProtectedDataPerAgent AS csInfo WITH (NOLOCK)
                INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
                                ON resultView.SurverResultId = csInfo.SurveyResultId
                                AND resultView.LogDateUTC = csInfo.LogDateUTC
                                AND resultView.CommServUniqueId = csInfo.CommServUniqueId
                                AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
                                AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)) AS sub
GROUP BY
                sub.CommServUniqueId,
                sub.CommCellID,
                sub.CommServIP,
                sub.CommServGUID,
                sub.CommCellName,
                sub.LogDate,
                sub.CommServTimeZone,
                sub.RunningTime,
                sub.AgentType,
                sub.BackupLevel
END
ELSE
SELECT
                sub.CommServUniqueId AS 'CommServ UniqueId',
                sub.AgentType AS 'Agent',
                sub.BackupLevel AS 'Backup Level',
                SUM(sub.JobCount) AS 'Job Count',
                CAST(SUM(sub.ApplicationSizeMB) AS DECIMAL(32,2)) AS 'Application Size<SIZEMB>'
FROM
                (SELECT
                                csInfo.CommServUniqueId,
                                csInfo.AgentType,
                                CASE csInfo.BackupLevel
                                                WHEN -1 THEN 'All'
                                                WHEN 1 THEN 'Full'
                                                WHEN 2 THEN 'Incremental'
                                                WHEN 4 THEN 'Differential'
                                                WHEN 64 THEN 'Synthetic'
                                                WHEN 128 THEN 'Synthetic'
                                                WHEN 256 THEN 'Log NotRunc'
                                                WHEN 1024 THEN 'OFF Full'
                                                WHEN 16384 THEN 'N/A'
                                                WHEN 32768 THEN 'SEL Full'
                                                ELSE 'Others'
                                END AS BackupLevel,
                                csInfo.JobCount,
                                csInfo.ApplicationSizeMB
FROM cf_SurveyProtectedDataPerAgent AS csInfo WITH (NOLOCK)
                INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
                                ON resultView.SurverResultId = csInfo.SurveyResultId
                                AND resultView.LogDateUTC = csInfo.LogDateUTC
                                AND resultView.CommServUniqueId = csInfo.CommServUniqueId
                                AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
                                AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)) AS sub
GROUP BY sub.CommServUniqueId, sub.AgentType, sub.BackupLevel
ORDER BY SUM(sub.ApplicationSizeMB) DESC
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptProtectedDataPerAgent')
	delete from GxQscripts where name = 'RptProtectedDataPerAgent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptProtectedDataPerAgent')
	delete from GXDBVersions where aliasname = 'RptProtectedDataPerAgent'
GO

insert into GXDBVersions values(2, 'RptProtectedDataPerAgent',  '00010007005600010000', 'RptProtectedDataPerAgent', '00010007005600010000')
GO

