

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptMediaManagementSummary.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptMediaManagementSummary.sp,v $ $Id: RptMediaManagementSummary.sp,v 1.15.2.27 2020/12/17 02:47:11 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptMediaManagementSummary')
BEGIN
	print '>>> Drop Stored Procedure: RptMediaManagementSummary <<<'
	drop procedure RptMediaManagementSummary
END
IF EXISTS (select * from GxQscripts where name='RptMediaManagementSummary')
	delete from GxQscripts where name = 'RptMediaManagementSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptMediaManagementSummary')
	delete from GXDBVersions where aliasname = 'RptMediaManagementSummary'
GO
print '... Creating Procedure: RptMediaManagementSummary'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptMediaManagementSummary
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @i_Aggregate INT = 0,
  @i_CommServUniqueID INT = 0,
  @i_OnController INT = 0,
  @i_Entity VARCHAR(16) = 'MediaAgent', -- or 'Library' or 'MountPath' or 'Drive' or 'StoragePool'
  @i_TopN BIGINT = 15
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 117
DECLARE @i_QueryId96 BIGINT = 96
DECLARE @top INT =15
DECLARE @showHiddenLibraries INT = 0
IF EXISTS (SELECT TOP 1 1 FROM cf_SurveyConfig WHERE name = 'showHiddenLibraries' AND value = '1')
	SET @showHiddenLibraries = 1
IF object_id('tempdb.dbo.#LatestResult') is not null DROP TABLE #LatestResult
CREATE	TABLE #LatestResult (
		CommServUniqueId INT,
		CommCellId INT,
		DisplayName NVARCHAR(256),
		CommServName NVARCHAR(256),
		CommServHostName NVARCHAR(510),
		SurveyResultId BIGINT,
		LogDate	DATETIME)
INSERT	INTO #LatestResult
SELECT	CommServUniqueId, CommCellId, DisplayName, CommServName, CommServHostName, SurverResultId, LogDate
FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId,@i_GroupId)
IF object_id('tempdb.dbo.#LatestResult96') is not null DROP TABLE #LatestResult96
CREATE	TABLE #LatestResult96 (
		CommServUniqueId INT,
		CommCellId INT,
		DisplayName NVARCHAR(256),
		CommServName NVARCHAR(256),
		SurveyResultId BIGINT,
		LogDate	DATETIME)
IF @i_Entity = 'Library'
BEGIN
	INSERT	INTO #LatestResult96
	SELECT	CommServUniqueId, CommCellId, DisplayName, CommServName, SurverResultId, LogDate
	FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId96, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId,@i_GroupId)
END
IF @i_Aggregate = 1
BEGIN
	SELECT TOP (@i_TopN) LP.LibraryName AS 'Library',
		   CASE WHEN ISNULL(L.TotalSpaceMB, -1) > 0 THEN (L.TotalSpaceMB - L.FreeSpaceMB)
		        ELSE ISNULL(L.DataWrittenMB, -1) END AS 'Used Space<SIZEMB>',
		   ISNULL(L.FreeSpaceMB, -1) AS 'Free Space<SIZEMB>'
	FROM	cf_SurveyLibrarySummary AS L WITH (NOLOCK)
			INNER JOIN #LatestResult R ON L.SurveyResultId = R.SurveyResultId
			INNER JOIN cf_SurveyLibrary LP WITH(NOLOCK) ON R.CommServUniqueId = LP.CommservUniqueId AND L.LibraryId = LP.LibraryId
	WHERE	(@showHiddenLibraries = 1 OR LP.Hidden = 0)
 	ORDER BY 'Used Space<SIZEMB>' DESC, 'Free Space<SIZEMB>' ASC
END
ELSE
IF @i_Entity = 'MediaAgent'
BEGIN
	SELECT 	R.CommServUniqueId  AS 'CommServ UniqueId',
			R.CommCellID AS 'CommCell ID',
			R.DisplayName AS 'CommCell Name',
			R.CommServHostName AS 'CommServ Host Name<HIDDEN>',
			ISNULL(CL.clientDisplayName, MA.MediaAgentName) AS 'MediaAgent',
			CASE WHEN MA.Offline = 1 THEN 'Yes' ELSE 'No' END AS 'Offline',
			CASE (MA.OfflineReason * MA.Offline)
				WHEN 0 THEN (CASE WHEN MA.Offline = 0 THEN '' ELSE 'N/A' END)
				WHEN 1 THEN 'Communication Error'
				WHEN 2 THEN 'Version Mismatch'
				WHEN 3 THEN 'Disabled '
				WHEN 4 THEN 'Disabled on GracePeriod expiry'
				WHEN 5 THEN 'Initializing'
				ELSE 'N/A'
			END AS 'Failure Reason<HIDDEN>',
			CASE WHEN MA.Offline = 1 AND MA.OfflineTimeStamp > 0 THEN MA.OfflineTimeStamp
				ELSE -100 END AS 'Not Operational Since<MMMDDYYYYHrMinAM><HIDDEN>',										-- -100 value is for empty string at frontend
			MA.OSName AS 'OS',
			MA.ReleaseVersion AS 'Product Version',
			CASE ISNULL(MA.ApplianceType, 0) WHEN 1 THEN 'HyperScale Appliance' WHEN 2 THEN 'HyperScale Reference Architecture' ELSE 'N/A' END AS 'Appliance Type<HIDDEN>'
	FROM	cf_SurveyMediaAgentSummary AS MA WITH (NOLOCK)
			INNER JOIN #LatestResult R ON MA.SurveyResultId = R.SurveyResultId
			LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = R.CommServUniqueId AND CL.ClientId = MA.MAClientId
	ORDER BY 'CommCell Name', MA.MediaAgentName
END
ELSE
IF @i_Entity = 'Library'
BEGIN
	DECLARE @CurrMonth DATE = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()), 0)
	DECLARE	@MaxNumOfMonthsforGrowthRate INT = 6
	DECLARE @FirstMonth DATE = DATEADD(MONTH, -@MaxNumOfMonthsforGrowthRate, @CurrMonth)
	CREATE TABLE #Summary (CommservUniqueId INT, LibraryId INT, LogDateUTC DATETIME,
			TotalSpaceMB BIGINT, TotalFreeSpaceMB BIGINT, TotalReserveSpaceMB BIGINT, UsedSpaceMB BIGINT, TotalAppSizeMB BIGINT,
			MonthlyGrowthMB FLOAT, StDevGrowthMB FLOAT, DaysToBeFull INT)
	INSERT	INTO #Summary
	SELECT	L.CommservUniqueId, L.LibraryId, L.LogDateUTC,
			ISNULL(totalSpaceGB*1024, -1), ISNULL(totalFreeSpaceGB*1024, -1), ISNULL(totalReserveSpaceMB, -1), ISNULL(totalDataWrittenGB*1024, -1), ISNULL(totalAppSizeGB*1024, -1), NULL, NULL, NULL
	FROM	cf_Survey96DiskLibDetails L WITH (NOLOCK)
			INNER JOIN #LatestResult96 R ON L.SurveyResultId = R.SurveyResultId
			INNER JOIN cf_SurveyLibrary LP WITH(NOLOCK) ON R.CommServUniqueId = LP.CommservUniqueId AND L.LibraryId = LP.LibraryId
	WHERE	(@showHiddenLibraries = 1 OR LP.Hidden = 0) AND LP.Enabled = 1
	UPDATE	#Summary SET UsedSpaceMB = (TotalSpaceMB - TotalFreeSpaceMB)
	WHERE	TotalFreeSpaceMB >= 0 AND TotalSpaceMB > TotalFreeSpaceMB
	CREATE TABLE #GrowthData (CommservUniqueId INT, EntityId INT, EntityName NVARCHAR(MAX), X INT, Y FLOAT, SeqId INT) -- for input
	CREATE TABLE #GrowthRate (CommservUniqueId INT, EntityId INT, EntityName NVARCHAR(MAX), GrowthRate FLOAT, GrowthStDev FLOAT) -- for output
	INSERT INTO #GrowthData
	SELECT	S.CommservUniqueId, S.LibraryId, '', DATEDIFF(MONTH, @CurrMonth, S.MonthStart), ISNULL(S.UsedSpaceMB, -1),
			ROW_NUMBER() OVER (PARTITION BY S.CommservUniqueId, S.LibraryId ORDER BY S.MonthStart)
	FROM	cf_SurveyDiskLibraryPeakSize S WITH (NOLOCK)
			INNER JOIN #Summary T ON S.CommservUniqueId = T.CommservUniqueId AND S.LibraryId = T.LibraryId
	WHERE	S.MonthStart >= @FirstMonth AND ISNULL(S.UsedSpaceMB, -1) > 0 AND T.TotalSpaceMB > 0
	EXEC GetLinearGrowthRate 0
	UPDATE	S SET MonthlyGrowthMB = T.GrowthRate, StDevGrowthMB = T.GrowthStDev
	FROM	#Summary S
			INNER JOIN #GrowthRate T ON S.CommservUniqueId = T.CommservUniqueId AND S.LibraryId = T.EntityId
	DROP TABLE #GrowthData
	DROP TABLE #GrowthRate
	UPDATE	#Summary
	SET		DaysToBeFull = CASE
				WHEN 30.0*(TotalFreeSpaceMB - TotalReserveSpaceMB) > MonthlyGrowthMB*(DATEDIFF(DAY, LogDateUTC, GETUTCDATE()) + 9999) THEN 10000
				ELSE 30.0*(TotalFreeSpaceMB - TotalReserveSpaceMB)/MonthlyGrowthMB - DATEDIFF(DAY, LogDateUTC, GETUTCDATE()) END
	WHERE	ISNULL(MonthlyGrowthMB, -1) > 0.001 AND TotalFreeSpaceMB > 0
		--Never value should be lower than (N/A), to get sorting like Date->Never->N/A order
			DECLARE @Never  BIGINT= CAST(0x7FFFFFFFFF AS bigint)-1
			DECLARE @NA  BIGINT =CAST(0x7FFFFFFFFF AS bigint)
	;WITH Controller (SurveyResultId, LibraryId, Operational, MAName) AS
	(
		SELECT	L.SurveyResultId, L.LibraryId, ISNULL(LC.Active&LC.Enabled, 0), ISNULL(MA.MediaAgentName, '')
		FROM	cf_SurveyLibrarySummary AS L WITH (NOLOCK)
				INNER JOIN #LatestResult R ON L.SurveyResultId = R.SurveyResultId
				INNER JOIN cf_SurveyLibrary LP WITH(NOLOCK) ON R.CommServUniqueId = LP.CommservUniqueId AND L.LibraryId = LP.LibraryId AND (@showHiddenLibraries = 1 OR LP.Hidden = 0)
				LEFT OUTER JOIN cf_SurveyLibraryControllerSummary AS LC WITH (NOLOCK)
					ON L.SurveyResultId = LC.SurveyResultId AND L.LibraryId = LC.LibraryId
				LEFT OUTER JOIN cf_SurveyMediaAgentSummary MA WITH (NOLOCK)
					ON MA.SurveyResultId = LC.SurveyResultId AND MA.MAClientId = LC.MAClientId
		GROUP BY L.SurveyResultId, L.LibraryId, ISNULL(LC.Active&LC.Enabled, 0), ISNULL(MA.MediaAgentName, '')
	)
	, ControllerStr (SurveyResultId, LibraryId, Operational, NotOperational) AS
	(
		SELECT	SurveyResultId, LibraryId,
				STUFF((SELECT ' : ' + MAName FROM Controller
						WHERE SurveyResultId = A.SurveyResultId AND LibraryId = A.LibraryId AND Operational = 1
						ORDER BY MAName FOR XML PATH('')), 1, 3, ''),
				STUFF((SELECT ' : ' + MAName FROM Controller
						WHERE SurveyResultId = A.SurveyResultId AND LibraryId = A.LibraryId AND Operational = 0
						ORDER BY MAName FOR XML PATH('')), 1, 3, '')
		FROM	Controller A
		GROUP BY SurveyResultId, LibraryId
	)
	SELECT 	R.CommServUniqueId  AS 'CommServ UniqueId',
			R.CommCellID AS 'CommCell ID',
			R.DisplayName AS 'CommCell Name',
			R.CommServHostName AS 'CommServ Host Name<HIDDEN>',
			LP.LibraryName AS 'Library',
			CASE WHEN ISNULL(S.TotalFreeSpaceMB, -1)< 0 THEN -1 ELSE S.TotalFreeSpaceMB END AS 'Free Space<SIZEMB>',
			CASE WHEN ISNULL(S.TotalReserveSpaceMB, -1) < 0 THEN -1 ELSE S.TotalReserveSpaceMB END AS 'Reserve Space<SIZEMB><HIDDEN>',
			CASE WHEN ISNULL(S.UsedSpaceMB, -1)     < 0 THEN -1 ELSE S.UsedSpaceMB      END AS 'Used Space<SIZEMB>',
			CASE WHEN ISNULL(S.TotalSpaceMB, -1)    < 0 THEN -1 ELSE S.TotalSpaceMB     END AS 'Capacity<SIZEMB>',
			CASE WHEN ISNULL(S.TotalAppSizeMB, -1)  < 0 THEN -1 ELSE S.TotalAppSizeMB   END AS 'App Size<SIZEMB><HIDDEN>',
			CASE WHEN LP.Enabled = 1 THEN 'Yes' ELSE 'No' END AS 'Enabled',
			CASE WHEN L.Offline = 1 THEN 'Yes' ELSE 'No' END AS 'Offline',
			CASE WHEN L.LibraryTypeId IN (1, 2) THEN L.SpareInLibrary ELSE -1 END AS 'Spare Available in Library<NumberNA><HIDDEN>',
			CASE WHEN L.LibraryTypeId IN (1, 2) THEN L.SpareTotal ELSE -1 END AS 'Spare Available Total<NumberNA><HIDDEN>',
			CASE WHEN L.LibraryTypeId in (1, 2) THEN 'Tape'
				 WHEN L.LibraryTypeId = 3 THEN 'Disk'
					WHEN L.LibraryTypeId = -3 THEN 'Cloud'
				 WHEN L.LibraryTypeId IN (4, 5) THEN 'StandAlone'
			END AS 'Library Type<HIDDEN>',
			CASE WHEN ISNULL(L.LibraryInstallTime,0) > 0 THEN L.LibraryInstallTime ELSE -100 END AS 'Creation Time<HIDDEN><MMMDDYYYYHrMinAM>',
			ISNULL(NumMediaAgents, -1) AS 'Number of MediaAgents<NumberNA>',
			ISNULL(MediaAgents, '') AS 'MediaAgent',
			CASE (L.OfflineReason * L.Offline)
				WHEN     0 THEN (CASE WHEN L.Offline = 0 THEN '' ELSE 'N/A' END)
				WHEN 46000 THEN 'Library Management service reset by user'
				WHEN 46001 THEN 'Library has been marked as Disabled'
				WHEN 46002 THEN 'The library has been marked as broken'
				WHEN 46003 THEN 'Ready'
				WHEN 46004 THEN 'Library Management service is ready'
				WHEN 46005 THEN 'Library Management service is offline'
				WHEN 46006 THEN 'Library is marked offline as it is being used for an administrative activity'
				WHEN 46007 THEN 'The cleaning media has retired'
				WHEN 46008 THEN 'Cleaning operation detected that a data Cartridge is loaded in the drive instead of Cleaning Media'
				WHEN 46009 THEN 'SCSI-2 Reservation Command to the Drive failed'
				WHEN 46010 THEN 'SCSI-2 Release Command to the Drive failed'
				WHEN 46011 THEN 'This library is migrated for monitoring purpose, data is not accessible'
				ELSE 'N/A'
			END AS 'Failure Reason<HIDDEN>',
			CASE WHEN L.Offline = 1 AND L.OfflineTimeStamp > 0 THEN L.OfflineTimeStamp
				ELSE -100 END AS 'Not Operational Since<HIDDEN><MMMDDYYYYHrMinAM>',
			CASE WHEN ISNULL(C.Operational, '') = '' AND ISNULL(C.NotOperational, '') = '' THEN 'N/A'
				 WHEN ISNULL(C.Operational, '')<> '' THEN 'Operational' ELSE 'Not Operational' END AS 'Controller Status<HIDDEN>',
			ISNULL(C.Operational, '') AS 'Operational Controller<HIDDEN>',
			ISNULL(C.NotOperational, '') AS 'Not Operational Controller<HIDDEN>',
			L.DataWrittenLastWeek AS 'Data Written (Last Week)<SIZEMB>',
			CASE WHEN ISNULL(DaysToBeFull, -1) < 0 THEN @NA -- For N/A
				 WHEN DaysToBeFull > 9999 THEN @Never -- For Never
				 ELSE dbo.getUnixtimebig(DATEADD(DAY, DaysToBeFull, GETUTCDATE()))
			END AS 'Date to be Full<MMMDDYYYYNEVER>',
			CASE WHEN L.LibraryTypeId = 3 THEN L.LowWaterMark ELSE -1 END AS 'Low WaterMark (%)<HIDDEN><NumberNA>',
			CASE WHEN L.LibraryTypeId IN (1, 2) THEN L.ScratchPoolsBelowLWM
				ELSE -1 END AS 'Scratch Pools (Below Water Mark)<HIDDEN><NumberNA>',
			CASE WHEN L.LibraryTypeId IN (1, 2) THEN L.Slots ELSE -1 END -1 AS 'Slots<HIDDEN><NumberNA>',
			CASE WHEN L.LibraryTypeId IN (1, 2) THEN L.EmptySlots ELSE -1 END AS 'Empty Slots<HIDDEN><NumberNA>',
			CASE WHEN L.LibraryTypeId IN (1, 2) THEN L.Manufacturer
			     WHEN L.LibraryTypeId = -3 THEN CASE
			          WHEN L.Manufacturer = '2' THEN 'Amazon S3'
			          WHEN L.Manufacturer = '3' THEN 'Microsoft Azure Storage'
			          WHEN L.Manufacturer = '4' THEN 'Nirvanix MFS'
			          WHEN L.Manufacturer = '5' THEN 'Rackspace Cloud Files'
			          WHEN L.Manufacturer = '6' THEN 'Iron Mountain ASP'
			          WHEN L.Manufacturer = '7' THEN 'Sun Cloud Storage'
			          WHEN L.Manufacturer = '8' THEN 'i365 Cloud Storage'
			          WHEN L.Manufacturer = '9' THEN 'EMC Atmos'
			          WHEN L.Manufacturer ='10' THEN 'AT&T Synaptic Storage'
			          WHEN L.Manufacturer ='11' THEN 'CV Object Server'
			          WHEN L.Manufacturer ='12' THEN 'Hitachi Content Platform'
			          WHEN L.Manufacturer ='13' THEN 'Mezeo Cloud Storag'
			          WHEN L.Manufacturer ='14' THEN 'OpenStack Object Storage'
			          WHEN L.Manufacturer ='15' THEN 'Quantum ActiveScale'
			          WHEN L.Manufacturer ='16' THEN 'China Mobile oNest'
			          WHEN L.Manufacturer ='17' THEN 'Hadoop Distributed File System'
			          WHEN L.Manufacturer ='18' THEN 'Verizon Cloud Storage'
			          WHEN L.Manufacturer ='19' THEN 'Google Cloud Storage'
			          WHEN L.Manufacturer ='20' THEN 'VMware vCloud Air Object Storage'
			          WHEN L.Manufacturer ='21' THEN 'Oracle Cloud Infrastructure Object Storage Classic'
			          WHEN L.Manufacturer ='22' THEN 'Oracle Cloud Infrastructure Archive Storage Classic'
			          WHEN L.Manufacturer ='23' THEN 'Alibaba Cloud Object Storage Service'
			          WHEN L.Manufacturer ='24' THEN 'Huawei Object Storage'
			          WHEN L.Manufacturer ='25' THEN 'Oracle Cloud Infrastructure Object Storage (S3 Compatibility)'
			          WHEN L.Manufacturer ='26' THEN 'Oracle Cloud Infrastructure Object Storage'
			          WHEN L.Manufacturer ='27' THEN 'Telefonica Open Cloud Object Storage'
			          WHEN L.Manufacturer ='28' THEN 'Oracle Cloud Infrastructure Archive Storage'
			          WHEN L.Manufacturer ='29' THEN 'Inspur Cloud Object Storage'
			          WHEN L.Manufacturer ='30' THEN 'IBM Cloud Object Storage'
			          WHEN L.Manufacturer ='31' THEN 'Microsoft Data Lake Store'
			          WHEN L.Manufacturer ='32' THEN 'Kingsoft Standard Storage Service'
			          WHEN L.Manufacturer ='33' THEN 'Microsoft OneDrive'
			          WHEN L.Manufacturer ='34' THEN 'Iron Mountain Iron Cloud'
			          WHEN L.Manufacturer ='35' THEN 'Microsoft File Share'
			          WHEN L.Manufacturer ='39' THEN 'Microsoft Azure Storage Compatible'
			          WHEN L.Manufacturer ='40' THEN 'S3 Compatible Storage'
			          WHEN L.Manufacturer ='51' THEN 'Caringo CAStor'
			          WHEN L.Manufacturer ='52' THEN 'Dell DX Object Storage Platform'
			          WHEN L.Manufacturer ='53' THEN 'Amazon Glacier'
			          WHEN L.Manufacturer ='54' THEN 'DDN WOS'
			          WHEN L.Manufacturer ='59' THEN 'HPE Catalyst Storage'
					  WHEN L.Manufacturer ='200' THEN 'Ceph Object Gateway (S3-compatible)'
					  WHEN L.Manufacturer ='201' THEN 'Cloudian HyperStore'
					  WHEN L.Manufacturer ='202' THEN 'Dell EMC ECS (S3-compatible)'
					  WHEN L.Manufacturer ='203' THEN 'Fujitsu Storage ETERNUS CD10000'
					  WHEN L.Manufacturer ='204' THEN 'Hitachi Content Platform for Cloud Scale'
					  WHEN L.Manufacturer ='205' THEN 'IBM Cloud Object Storage (S3-compatible)'
					  WHEN L.Manufacturer ='206' THEN 'NetApp StorageGRID'
					  WHEN L.Manufacturer ='207' THEN 'CCL Vault v2'
					  WHEN L.Manufacturer ='208' THEN 'Scality RING'
					  WHEN L.Manufacturer ='209' THEN 'Wasabi Hot Cloud Storage'
					  WHEN L.Manufacturer ='210' THEN 'Nutanix Buckets'
				      ELSE 'N/A' END
			     ELSE 'N/A' END  AS 'Manufacturer/Cloud Vendor Type',
			CASE WHEN L.LibraryTypeId IN (1, 2) THEN L.Model  ELSE 'N/A' END AS 'Model<HIDDEN>',
			CASE WHEN L.LibraryTypeId IN (1, 2) THEN L.SerialNumber  ELSE 'N/A' END AS 'Serial Number<HIDDEN>',
			CASE WHEN L.LibraryTypeId IN (1, 2) THEN L.FirmwareRevision ELSE 'N/A' END AS 'Firmware Revision<HIDDEN>'
		FROM	cf_SurveyLibrarySummary AS L WITH (NOLOCK)
				INNER JOIN #LatestResult R ON L.SurveyResultId = R.SurveyResultId
				INNER JOIN cf_SurveyLibrary LP ON LP.CommservUniqueId = R.CommServUniqueId AND LP.LibraryId = L.LibraryId AND (@showHiddenLibraries = 1 OR LP.Hidden = 0)
				LEFT OUTER JOIN ControllerStr C ON L.SurveyResultId = C.SurveyResultId AND L.LibraryId = C.LibraryId
				LEFT OUTER JOIN #Summary S ON S.CommServUniqueId = R.CommServUniqueId AND S.LibraryId= L.LibraryId
		ORDER BY 'CommCell Name', LP.LibraryName
		DROP TABLE #Summary
	END
	ELSE
	IF @i_Entity = 'MountPath'
	BEGIN
		SELECT 	R.CommServUniqueId  AS 'CommServ UniqueId',
				R.CommCellID AS 'CommCell ID',
				R.DisplayName AS 'CommCell Name',
				R.CommServHostName AS 'CommServ Host Name<HIDDEN>',
				LP.LibraryName AS 'Library',
				MP.MountPathName AS 'MountPath',
				ISNULL(MP.HardDrive, 'N/A') AS 'HardDrive<HIDDEN>',
				CASE MP.HardDriveShared WHEN -1 THEN 'N/A' WHEN 0 THEN 'No' ELSE 'Yes' END AS 'MountPath/HardDrive Shared',
				CASE ISNULL(MP.Enabled,-1) WHEN -1 THEN 'N/A' WHEN 1 THEN 'Yes' ELSE 'No' END AS 'Enabled',
				CASE WHEN MP.Offline = 1 THEN 'Yes' ELSE 'No' END AS 'Offline',
				CASE (MP.OfflineReason * MP.Offline)
					WHEN 0 THEN (CASE WHEN MP.Offline = 0 THEN '' ELSE 'N/A' END)
					WHEN 1 THEN 'Not Accessible'
					WHEN 2 THEN 'Disabled'
					WHEN 3 THEN 'Mount path is dirty'
					WHEN 4 THEN 'Device of mount path is not enabled, not accessible or broken'
					ELSE 'N/A'
				END AS 'Failure Reason<HIDDEN>',
				CASE WHEN MP.Offline = 1 AND MP.OfflineTimeStamp > 0 THEN MP.OfflineTimeStamp
					ELSE -100 END AS 'Not Operational Since<MMMDDYYYYHrMinAM><HIDDEN>',
				CASE ISNULL(MP.MaxConcurrentWriters,-1) WHEN -1 THEN 'N/A' WHEN 0 THEN 'Yes' ELSE 'No' END AS 'Disabled for New Data',
				MP.FreeSpaceMB AS 'Free Space<SIZEMB>',
				MP.TotalSpaceMB AS 'Capacity<SIZEMB>',
				CASE WHEN MP.TotalSpaceMB > 0 THEN (MP.TotalSpaceMB - MP.FreeSpaceMB) ELSE MP.DataWrittenMB END AS 'Used Space<SIZEMB>',
				CASE WHEN MP.TotalSpaceMB > 0 THEN CAST(100.0*MP.FreeSpaceMB/MP.TotalSpaceMB AS DECIMAL(20, 2))
				     ELSE 0.0
				END AS 'Free Space (%)<NumberNA>'
		FROM	cf_SurveyMountPathSummary AS MP WITH (NOLOCK)
				INNER JOIN #LatestResult R ON MP.SurveyResultId = R.SurveyResultId
				INNER JOIN cf_SurveyLibrary LP WITH(NOLOCK) ON R.CommServUniqueId = LP.CommservUniqueId AND MP.LibraryId = LP.LibraryId AND (@showHiddenLibraries = 1 OR LP.Hidden = 0)
		ORDER BY 'CommCell Name', MP.MountPathName
	END
	ELSE
	IF @i_Entity = 'Drive'
	BEGIN
		SELECT 	R.CommServUniqueId  AS 'CommServ UniqueId',
				R.CommCellID AS 'CommCell ID',
				R.DisplayName AS 'CommCell Name',
				R.CommServHostName AS 'CommServ Host Name<HIDDEN>',
				LP.LibraryName AS 'Library',
				D.DriveName AS 'Drive',
				CASE WHEN D.Offline = 1 THEN 'Yes' ELSE 'No' END AS 'Offline',
				CASE (D.OfflineReason * D.Offline)
					WHEN 0 THEN (CASE WHEN D.Offline = 0 THEN '' ELSE 'N/A' END)
					WHEN 1 THEN 'The drive has been marked as broken'
					WHEN 2 THEN 'There is a media stuck in the drive'
					WHEN 3 THEN 'Drive indicates that cleaning is required'
					WHEN 4 THEN 'Cannot communicate with Media Mount Manager Service'
					WHEN 5 THEN 'The drive is not accessible from the Operating System'
					WHEN 6 THEN 'Initialization in progress'
					WHEN 7 THEN 'The drive has been enabled'
					WHEN 8 THEN 'The drive has been disabled'
					WHEN 9 THEN 'The drive is accessible from the Operating System'
					WHEN 10 THEN 'The drive is not accessible from the Operating System'
					WHEN 11 THEN 'The drive could not be SCSI reserved on the SCSI bus'
					WHEN 12 THEN 'SCSI reservation on drive could not be released'
					WHEN 13 THEN 'SCSI command to drive is stuck on the active drive controlling MediaAgent'
					WHEN 14 THEN 'No online drive controllers can be used to release the SCSI-2 reservation'
					WHEN 15 THEN 'Encountered a SCSI error for which the user has specified to mark the drive as disabled'
					ELSE 'N/A'
				END AS 'Failure Reason<HIDDEN>',
				CASE WHEN D.Offline = 1 AND D.OfflineTimeStamp > 0 THEN D.OfflineTimeStamp
					ELSE -100 END AS 'Not Operational Since<HIDDEN><MMMDDYYYYHrMinAM>',
				CASE ISNULL(DC.Active, -1) WHEN 1 THEN 'Operational' WHEN 0 THEN 'NOT Operational' ELSE 'N/A' END AS 'Controller Status',
				CASE WHEN D.RatedThroughputMbps > 0 THEN CAST(CAST(3600.0*D.RatedThroughputMbps/1024.0 AS DECIMAL(20, 2)) AS VARCHAR(32))
					ELSE '' END AS 'Manufacturer Rated Throughput (GB/h)<HIDDEN>',
				D.Manufacturer AS 'Manufacturer<HIDDEN>',
				D.Model AS 'Model<HIDDEN>',
				D.Type AS 'Type<HIDDEN>',
				D.SerialNumber AS 'Serial Number<HIDDEN>',
				D.FirmwareRevision AS 'Firmware Revision<HIDDEN>'
		FROM	cf_SurveyDriveSummary AS D WITH (NOLOCK)
				INNER JOIN #LatestResult R ON D.SurveyResultId = R.SurveyResultId
				INNER JOIN cf_SurveyLibrary LP WITH(NOLOCK) ON R.CommServUniqueId = LP.CommservUniqueId AND D.LibraryId = LP.LibraryId AND (@showHiddenLibraries = 1 OR LP.Hidden = 0)
				LEFT OUTER JOIN cf_SurveyDriveControllerSummary DC WITH (NOLOCK) ON D.SurveyResultId = DC.SurveyResultId AND D.DriveId = DC.DriveId
		ORDER BY 'CommCell Name', D.DriveName
	DROP TABLE #LatestResult
	DROP TABLE #LatestResult96
END
ELSE
IF @i_Entity = 'StoragePool'
BEGIN
	SELECT 	R.CommServUniqueId  AS 'CommServ UniqueId',
			R.CommCellID AS 'CommCell ID',
			R.DisplayName AS 'CommCell Name',
			R.CommServHostName AS 'CommServ Host Name<HIDDEN>',
			PL.StoragePoolName AS 'Storage Pool',
			CASE PL.StoragePoolType WHEN 4 THEN 'Scale Out' WHEN 1 THEN 'Deduplication' WHEN 2 THEN 'Secondary Copy' WHEN 3 THEN 'No Deduplication' ELSE ''
				END AS 'Storage Pool Type',
			CASE WHEN PL.ActiveControllers < PL.TotalControllers THEN 'Yes' ELSE 'No' END AS 'Offline',
			CASE WHEN PL.ActiveControllers = PL.TotalControllers THEN 'N/A'
				 WHEN PL.LibOfflineReason > 0 THEN (
					CASE PL.LibOfflineReason
						WHEN 46000 THEN 'Library Management service reset by user'
						WHEN 46001 THEN 'Library has been marked as Disabled'
						WHEN 46002 THEN 'The library has been marked as broken'
						WHEN 46003 THEN 'Ready'
						WHEN 46004 THEN 'Library Management service is ready'
						WHEN 46005 THEN 'Library Management service is offline'
						WHEN 46006 THEN 'Library is marked offline as it is being used for an administrative activity'
						WHEN 46007 THEN 'The cleaning media has retired'
						WHEN 46008 THEN 'Cleaning operation detected that a data Cartridge is loaded in the drive instead of Cleaning Media'
						WHEN 46009 THEN 'SCSI-2 Reservation Command to the Drive failed'
						WHEN 46010 THEN 'SCSI-2 Release Command to the Drive failed'
						WHEN 46011 THEN 'This library is migrated for monitoring purpose, data is not accessible'
						ELSE 'N/A' END
					)
				 WHEN PL.MPOfflineReason > 0 THEN (
					CASE PL.MPOfflineReason
						WHEN 1 THEN 'Not Accessible'
						WHEN 2 THEN 'Disabled'
						WHEN 3 THEN 'Mount path is dirty'
						WHEN 4 THEN 'Device of mount path is not enabled, not accessible or broken'
						ELSE 'N/A' END
					)
				 WHEN PL.MAOfflineReason > 0 THEN (
					CASE PL.MAOfflineReason
						WHEN 1 THEN 'Communication Error'
						WHEN 2 THEN 'Version Mismatch'
						WHEN 3 THEN 'Disabled '
						WHEN 4 THEN 'Disabled on GracePeriod expiry'
						WHEN 5 THEN 'Initializing'
						ELSE 'N/A' END
					)
				ELSE 'N/A'
				END AS 'Failure Reason<HIDDEN>',
			PL.NumMediaAgents AS 'Number of MediaAgents',
			PL.MediaAgents AS 'MediaAgent',
			CASE ISNULL(PL.ApplianceType, 0) WHEN 1 THEN 'HyperScale Appliance' WHEN 2 THEN 'HyperScale Reference Architecture'
				 WHEN 3 THEN 'HyperScale Appliance, HyperScale Reference Architecture' ELSE 'N/A' END AS 'Appliance Type'
	FROM	cf_SurveyStoragePoolSummary AS PL WITH (NOLOCK)
			INNER JOIN #LatestResult R ON PL.SurveyResultId = R.SurveyResultId
	ORDER BY 'CommCell Name', PL.StoragePoolName
END
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE TESTING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= NULL
  DECLARE @blaggregate INT				= 0
  DECLARE @i_CommServUniqueID INT		= 11065
  DECLARE @i_OnController		INT 	= 0
  DECLARE @i_Entity		VARCHAR(16)		= 'MediaAgent' -- or 'Library' or 'MountPath' or 'Drive' or 'StoragePool'
exec RptMediaManagementSummary @i_UserId, @i_GroupId, @blaggregate, @i_CommServUniqueID, @i_OnController, @i_Entity
*/

IF EXISTS (select * from GxQscripts where name = 'RptMediaManagementSummary')
	delete from GxQscripts where name = 'RptMediaManagementSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptMediaManagementSummary')
	delete from GXDBVersions where aliasname = 'RptMediaManagementSummary'
GO

insert into GXDBVersions values(2, 'RptMediaManagementSummary',  '00010015000200270000', 'RptMediaManagementSummary', '00010015000200270000')
GO

