

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptLongRunningJobs.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptLongRunningJobs.sp,v $ $Id: RptLongRunningJobs.sp,v 1.11.56.2 2018/08/16 11:33:44 skatz Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptLongRunningJobs <<<'

IF EXISTS (select * from sysobjects where name='RptLongRunningJobs')
	drop procedure RptLongRunningJobs
IF EXISTS (select * from GxQscripts where name='RptLongRunningJobs')
	delete from GxQscripts where name = 'RptLongRunningJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLongRunningJobs')
	delete from GXDBVersions where aliasname = 'RptLongRunningJobs'
GO
print '... Creating Procedure: RptLongRunningJobs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptLongRunningJobs
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 24
IF(@blaggregate=1)
BEGIN
	IF @i_CommServUniqueID = 0
	BEGIN
	SELECT TOP(10)
		resultView.CommServUniqueId  AS 'CommServ UniqueId',
		resultView.DisplayName AS 'CommCell Name',
		csInfo.JobId AS 'Job Id',
		CAST(csInfo.DurationHr*60 AS INT) AS 'Duration (hh:mm)<HHMM>'
	FROM cf_SurveyLongRunningJobs AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
	ORDER BY csInfo.DurationHr DESC
	END
	ELSE
	BEGIN
	SELECT TOP(10)
		csInfo.clientName AS 'Client',
		csInfo.JobId AS 'Job Id',
		CAST(csInfo.DurationHr*60 AS INT) AS 'Duration (hh:mm)<HHMM>'
	FROM cf_SurveyLongRunningJobs AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
	ORDER BY csInfo.DurationHr DESC
	END
END
ELSE IF @i_CommServUniqueID = 0
BEGIN
SELECT
	resultView.CommServUniqueId  AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	resultView.CommServIP AS 'CommServe IP<HIDDEN>',
	resultView.DisplayName AS 'CommCell Name',
	ISNULL(CL.clientDisplayName, csInfo.clientName) AS 'Client',
	csInfo.AgentName AS 'Agent',
	csInfo.BackupType AS 'Backup Type',
	csInfo.JobId AS 'Job Id',
	CAST(csInfo.DurationHr*60 AS INT) AS 'Duration (hh:mm)<HHMM>',
	CAST((csInfo.ApplicationSize/1024.00/1024.00) AS DECIMAL(32,2)) AS 'Application Size<SIZEMB>'
FROM cf_SurveyLongRunningJobs AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
			LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = csInfo.CommServUniqueId AND CL.ClientId = csInfo.ClientId
		ORDER BY csInfo.DurationHr DESC, 'CommCell Name' ASC
END
ELSE
SELECT
	csInfo.CommServUniqueId AS 'CommServ UniqueId',
	ISNULL(CL.clientDisplayName, csInfo.clientName) AS 'Client',
	csInfo.AgentName AS 'Agent',
	csInfo.BackupType AS 'Backup Type',
	csInfo.JobId AS 'Job Id',
	CAST(csInfo.DurationHr*60 AS INT) AS 'Duration (hh:mm)<HHMM>',
	CAST((csInfo.ApplicationSize/1024.00/1024.00) AS DECIMAL(32,2)) AS 'Application Size<SIZEMB>'
FROM cf_SurveyLongRunningJobs AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
			LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = csInfo.CommServUniqueId AND CL.ClientId = csInfo.ClientId
		ORDER BY csInfo.DurationHr DESC
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE TESTING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= NULL
  DECLARE @blaggregate INT				= 0
  DECLARE @blLatestSurvey INT			= 1
  DECLARE @i_CommServUniqueID INT		= 11065
  DECLARE @i_LogDateEND DATETIME		= 	NULL    -- getDate()
  DECLARE @i_LogDateStart DATETIME		= NULL   --DateAdd(Month, -36, @i_LogDateEND)
exec RptLongRunningJobs @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND
*/

IF EXISTS (select * from GxQscripts where name = 'RptLongRunningJobs')
	delete from GxQscripts where name = 'RptLongRunningJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLongRunningJobs')
	delete from GXDBVersions where aliasname = 'RptLongRunningJobs'
GO

insert into GXDBVersions values(2, 'RptLongRunningJobs',  '00010011005600020000', 'RptLongRunningJobs', '00010011005600020000')
GO

