

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptLeastDedupedSubclients.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptLeastDedupedSubclients.sp,v $ $Id: RptLeastDedupedSubclients.sp,v 1.5.56.2 2018/08/16 11:34:20 skatz Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptLeastDedupedSubclients <<<'

IF EXISTS (select * from sysobjects where name='RptLeastDedupedSubclients')
	drop procedure RptLeastDedupedSubclients
IF EXISTS (select * from GxQscripts where name='RptLeastDedupedSubclients')
	delete from GxQscripts where name = 'RptLeastDedupedSubclients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLeastDedupedSubclients')
	delete from GXDBVersions where aliasname = 'RptLeastDedupedSubclients'
GO
print '... Creating Procedure: RptLeastDedupedSubclients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptLeastDedupedSubclients
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @i_Aggregate INT = 0,
  @i_CommServUniqueID INT = 0,
  @i_OnFullJobs INT = 1
AS
-- i_OnFullJobs: 0 for all incremental jobs for last 7 days, 1 for the last full job with 30 days
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 119
IF(@i_Aggregate=1)
BEGIN
	IF @i_CommServUniqueID = 0
	BEGIN
		SELECT 	TOP(10)
			R.CommServUniqueId  AS 'CommServ UniqueId',
			R.CommCellID AS 'CommCell ID',
			R.DisplayName AS 'CommCell Name',
			ISNULL(CL.clientDisplayName, S.Client) + '\'+ S.Subclient AS [Client\Subclient],
			CAST(S.DedupSavingPct AS DECIMAL(30, 2)) AS 'Dedup Saving (%)'
	FROM	cf_SurveyLeastDedupedSubclients AS S WITH (NOLOCK)
			INNER JOIN 	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId,@i_GroupId) R 	ON S.SurveyResultId = R.SurverResultId
			LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = R.CommServUniqueId AND CL.ClientName = S.Client
	--WHERE	OnFullJobs = @i_OnFullJobs
			ORDER BY S.DedupSavingPct ASC
	END
	ELSE
	BEGIN
		SELECT 	TOP(10)
			ISNULL(CL.clientDisplayName, S.Client) AS 'Client',
			S.Backupset +'\'+ S.Subclient AS 'Backupset\Subclient',
			CAST(S.DedupSavingPct AS DECIMAL(30, 2)) AS 'Dedup Saving (%)'
	FROM	cf_SurveyLeastDedupedSubclients AS S WITH (NOLOCK)
			INNER JOIN 	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId,@i_GroupId) R 	ON S.SurveyResultId = R.SurverResultId
			LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = R.CommServUniqueId AND CL.ClientName = S.Client
	--WHERE	OnFullJobs = @i_OnFullJobs
			ORDER BY S.DedupSavingPct ASC
	END
END
ELSE
BEGIN
SELECT 	R.CommServUniqueId  AS 'CommServ UniqueId',
		R.CommCellID AS 'CommCell ID',
		R.DisplayName AS 'CommCell Name',
		ISNULL(CL.clientDisplayName, S.Client) AS 'Client',
		S.Agent AS 'Agent',
		S.Instance AS 'Instance',
		S.Backupset AS 'Backupset<HIDDEN>',
		S.Subclient AS 'Subclient',
		S.StoragePolicy AS 'Storage Policy',
		CAST(1.0*S.appSize/1024.0/1024.0 AS DECIMAL(30, 2)) AS 'Application Size<SIZEMB>',
		CAST(1.0*S.DataWritten/1024.0/1024.0 AS DECIMAL(30, 2)) AS 'Data Written<SIZEMB>',
		CAST(S.DedupSavingPct AS DECIMAL(30, 2)) AS 'Dedup Saving (%)'
FROM	cf_SurveyLeastDedupedSubclients AS S WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId,@i_GroupId) R ON S.SurveyResultId = R.SurverResultId
		LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = R.CommServUniqueId AND CL.ClientName = S.Client
WHERE	OnFullJobs = @i_OnFullJobs
ORDER BY 'CommCell Name', S.DedupSavingPct
END
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE TESTING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= NULL
  DECLARE @blaggregate INT				= 0
  DECLARE @i_CommServUniqueID INT		= 11065
  DECLARE @i_OnFullJobs INT				= 0
exec RptLeastDedupedSubclients @i_UserId, @i_GroupId, @blaggregate,  @i_CommServUniqueID, @i_OnFullJobs
*/

IF EXISTS (select * from GxQscripts where name = 'RptLeastDedupedSubclients')
	delete from GxQscripts where name = 'RptLeastDedupedSubclients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLeastDedupedSubclients')
	delete from GXDBVersions where aliasname = 'RptLeastDedupedSubclients'
GO

insert into GXDBVersions values(2, 'RptLeastDedupedSubclients',  '00010005005600020000', 'RptLeastDedupedSubclients', '00010005005600020000')
GO

