

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptLargestClientsByBKPSize.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptLargestClientsByBKPSize.sp,v $ $Id: RptLargestClientsByBKPSize.sp,v 1.10.2.7 2020/07/06 18:29:05 nbirru Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptLargestClientsByBKPSize')
BEGIN
	print '>>> Drop Stored Procedure: RptLargestClientsByBKPSize <<<'
	drop procedure RptLargestClientsByBKPSize
END
IF EXISTS (select * from GxQscripts where name='RptLargestClientsByBKPSize')
	delete from GxQscripts where name = 'RptLargestClientsByBKPSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLargestClientsByBKPSize')
	delete from GXDBVersions where aliasname = 'RptLargestClientsByBKPSize'
GO
print '... Creating Procedure: RptLargestClientsByBKPSize'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptLargestClientsByBKPSize
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll,
  @blNeedTop10 INT = 0,
  @i_trend INT = 0,
  @i_client NVARCHAR(MAX) = NULL,
  @i_TenantName NVARCHAR(255) = NULL
AS
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 251
IF object_id('tempdb.dbo.#TenantClients') IS NOT NULL DROP TABLE #TenantClients
CREATE TABLE #TenantClients (CommServUniqueId INT, TenantName NVARCHAR(255), ClientId INT)
exec GetTenantEntities @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND, @i_TenantName
SET @i_QueryId = 23
IF(@blaggregate=1)
BEGIN
	IF @i_TenantName is NULL
	BEGIN
		SELECT
			T.Range AS 'Capacity Range<ALTSORT>',
			T.LowerLimitGB AS 'Capacity Range_SORTCOLUMN',
			ClientCount AS [Client Count],
			TotalSizeGB AS [Total Size (GB)],
			CASE WHEN ClientCount > 0 THEN CAST(CAST(TotalSizeGB AS FLOAT)/ClientCount AS DECIMAL(15,2)) ELSE 0 END AS [Average Size (GB)]
		FROM
			(SELECT C.Range, C.LowerLimitGB, SUM(C.ClientCount) AS ClientCount, SUM(C.TotalSizeGB) AS TotalSizeGB
			FROM	cf_SurveyClientCountBySize C
				INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId,@i_GroupId) R
				ON C.SurveyResultId = R.SurverResultId
			GROUP BY C.Range, C.LowerLimitGB) T
		ORDER BY T.LowerLimitGB
	END
	ELSE
	BEGIN
		SELECT
			T.Range AS 'Capacity Range<ALTSORT>',
			T.LowerLimitGB AS 'Capacity Range_SORTCOLUMN',
			ClientCount AS [Client Count],
			TotalSizeGB AS [Total Size (GB)],
			CASE WHEN ClientCount > 0 THEN CAST(CAST(TotalSizeGB AS FLOAT)/ClientCount AS DECIMAL(15,2)) ELSE 0 END AS [Average Size (GB)]
		FROM
			(SELECT Range,
					LowerLimitGB,
					COUNT(ClientId) AS ClientCount,
					SUM(ISNULL(FrontEndSizeGB, 0)) AS TotalSizeGB
		FROM    (SELECT 0 AS LowerLimitGB, 1 AS UpperLimitGB, '<1GB' AS Range
			UNION ALL SELECT 1, 10, '1GB-10GB'  UNION ALL SELECT 10, 100, '10GB-100GB'
			UNION ALL SELECT 100, 500, '100GB-500GB' UNION ALL SELECT 500, 1000, '500GB-1TB'
			UNION ALL SELECT 1000, 10000, '1TB-10TB' UNION ALL SELECT 10000, 9223372036854775807, '>10TB') Buckets
				LEFT OUTER JOIN (SELECT C.ClientId, ROUND(applicationSizeGB, 0) AS FrontEndSizeGB FROM cf_SurveyLargestClientsByBKPSize C WITH (NOLOCK)
						INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId,@i_GroupId) R
								ON C.SurveyResultId = R.SurverResultId
						INNER JOIN #TenantClients TC ON TC.CommServUniqueId = C.CommServUniqueId AND TC.ClientId = C.ClientId
				) F ON FrontEndSizeGB >= LowerLimitGB AND FrontEndSizeGB < UpperLimitGB
		GROUP BY LowerLimitGB, UpperLimitGB, Range) T
		ORDER BY T.LowerLimitGB
	END
END
ELSE
IF @i_CommServUniqueID = 0
BEGIN
  IF @blNeedTop10=0 -- health check
  BEGIN
	  SELECT
			resultView.CommServUniqueId  AS 'CommServ UniqueId',
			resultView.CommCellID AS 'CommCell ID',
			resultView.CommServIP AS 'CommServe IP<HIDDEN>',
			resultView.DisplayName AS 'CommCell Name',
			ISNULL(CL.clientDisplayName, csInfo.ClientName) AS 'Client',
			CAST(ISNULL(csInfo.applicationSizeGB, 0)*1024.00 AS DECIMAL(32,2)) AS 'Application Size<SIZEMB>'--,
		 FROM cf_SurveyLargestClientsByBKPSize AS csInfo WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
				ON resultView.SurverResultId = csInfo.SurveyResultId
			LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
                     ON csInfo.CommServUniqueId = TC.CommServUniqueId AND csInfo.ClientId = TC.ClientId
			LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = csInfo.CommServUniqueId AND CL.ClientId = csInfo.ClientId
		WHERE ((@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL)
		 ORDER BY csInfo.applicationSizeGB DESC
 END
 ELSE --operation
 BEGIN
 SELECT TOP(25)
	resultView.CommServUniqueId  AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	resultView.CommServIP AS 'CommServe IP<HIDDEN>',
	resultView.DisplayName AS 'CommCell Name',
	ISNULL(CL.clientDisplayName, csInfo.ClientName) AS 'Client',
	CAST(ISNULL(csInfo.applicationSizeGB, 0)*1024.00 AS DECIMAL(32,2)) AS 'Application Size<SIZEMB>'
 FROM cf_SurveyLargestClientsByBKPSize AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
	LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = csInfo.CommServUniqueId AND CL.ClientId = csInfo.ClientId
	LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
                     ON CL.CommServUniqueId = TC.CommServUniqueId AND CL.ClientId = TC.ClientId
 WHERE ((@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL)
 ORDER BY csInfo.applicationSizeGB DESC
 END
END
ELSE
	IF @i_trend=0
	BEGIN
	SELECT
		csInfo.CommServUniqueId AS 'CommServ UniqueId',
		csInfo.ClientId AS 'ClientId<DONOTSHOW>',
		(CASE WHEN SUM(csInfo.AppTypeId) <> 0 THEN 1 ELSE 0 END) AS 'AgentCheck<DONOTSHOW>',
		ISNULL(CL.clientDisplayName, csinfo.ClientName) as 'Client<largest25ClientsAgentsLink>',
		CAST(ISNULL(SUM(csInfo.applicationSizeGB), 0)*1024.00 AS DECIMAL(32,2)) AS 'Application Size<SIZEMB>',
		CAST(SUM(csInfo.ShareOfTotal) AS DECIMAL(20,2)) AS 'Share of Total (%)'
	FROM cf_SurveyLargestClientsByBKPSize AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
		LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
                     ON csInfo.CommServUniqueId = TC.CommServUniqueId AND csInfo.ClientId = TC.ClientId
		LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = csInfo.CommServUniqueId AND CL.ClientId = csInfo.ClientId
	WHERE ((@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL)
	GROUP BY csInfo.CommServUniqueId, csInfo.ClientId, ISNULL(CL.clientDisplayName, csinfo.ClientName)
	ORDER BY SUM(csInfo.ShareOfTotal) DESC
	END
	ELSE IF @i_trend>0
	BEGIN
	set @blLatestSurvey  = 0
	DECLARE @minStartDate DATETIME
			DECLARE @maxEndDate DATETIME
			SELECT	@minStartDate = MIN(IT.STARTDATE),
					@maxEndDate = MAX(IT.ENDDATE)
			FROM	dbo.RptMetricsTrend(@i_trend) IT
	DECLARE @tempResults TABLE
              (
                    CommServUniqueId INT,
                     CommCellID       VARCHAR(32),
                     CommServIP       VARCHAR(256),
                     CommServGUID     VARCHAR(256),
                     CustomerName     NVARCHAR(256),
                     CommServName     NVARCHAR(256),
                     CommServTimeZone VARCHAR(256),
                     CommServVersion  VARCHAR(256),
                     CommServEdition      VARCHAR(256),
                     SurverResultId   INT,
                     SurveyID         INT,
                     LogDate          DATETIME,
                     LogDateUTC       DATETIME,
                     RunningTime      INT,
                     SureyResultFlags INT
              )
         INSERT INTO @tempResults(CommServUniqueId,CommCellID,CommServIP,CommServGUID, CustomerName,CommServName,CommServTimeZone,CommServVersion,CommServEdition ,SurverResultId,SurveyID,LogDate,LogDateUTC,RunningTime,SureyResultFlags)
        SELECT CommServUniqueId,CommCellID,CommServIP,CommServGUID, CustomerName,CommServName,CommServTimeZone,CommServVersion,CommServEdition ,SurverResultId,SurveyID,LogDate,LogDateUTC,RunningTime,SureyResultFlags FROM dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId)
	SELECT DATEDIFF(s,'1970-01-01',DATEADD(DAY,-1,IT.STARTDATE)) AS 'Date',
		csInfo.CommServUniqueId AS 'CommServ UniqueId',
		ISNULL(CL.clientDisplayName, csInfo.ClientName) AS 'Client',
		CAST(ISNULL(MAX(csInfo.applicationSizeGB), -1) AS DECIMAL(32,6)) AS 'Application Size',
		CAST(ISNULL(MAX(csInfo.ShareOfTotal),-1) AS DECIMAL(20,2)) AS 'Share of Total (%)'
		FROM cf_SurveyLargestClientsByBKPSize AS csInfo WITH (NOLOCK)
		INNER JOIN @tempResults AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
			AND (@i_client= csInfo.ClientName)
		LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = csInfo.CommServUniqueId AND CL.ClientId = csInfo.ClientId
		RIGHT OUTER JOIN dbo.RptMetricsTrend(@i_trend) IT ON IT.STARTDATE < resultView.LogDateUTC AND IT.ENDDATE >= resultView.LogDateUTC
		WHERE csInfo.CommServUniqueId IS NOT NULL
			OR (EXISTS (Select * from @tempResults RV1, cf_SurveyLargestClientsByBKPSize D1 WHERE RV1.SurverResultId = D1.SurveyResultId AND D1.ClientName = @i_client AND RV1.LogDateUTC < IT.STARTDATE AND RV1.LogDateUTC >= @minStartDate)
			AND EXISTS (Select * from @tempResults RV2, cf_SurveyLargestClientsByBKPSize D2 WHERE RV2.SurverResultId = D2.SurveyResultId AND D2.ClientName = @i_client AND RV2.LogDateUTC > IT.ENDDATE AND RV2.LogDateUTC <= @maxEndDate))
			GROUP BY csInfo.CommServUniqueId, ISNULL(CL.clientDisplayName, csInfo.ClientName), IT.STARTDATE
			ORDER BY IT.STARTDATE
	END
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE TESTING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= NULL
  DECLARE @blaggregate INT				= 0
  DECLARE @blLatestSurvey INT			= 1
  DECLARE @i_CommServUniqueID INT		= 11065
  DECLARE @i_LogDateEND DATETIME		= 	NULL    -- getDate()
  DECLARE @i_LogDateStart DATETIME		= NULL   --DateAdd(Month, -36, @i_LogDateEND)
  DECLARE @blNeedTop10 INT = 0
  DECLARE @i_trend INT = 0
  DECLARE @i_client NVARCHAR(MAX) = NULL
exec RptLargestClientsByBKPSize @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND
						,@blNeedTop10, @i_trend, @i_client
*/

IF EXISTS (select * from GxQscripts where name = 'RptLargestClientsByBKPSize')
	delete from GxQscripts where name = 'RptLargestClientsByBKPSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLargestClientsByBKPSize')
	delete from GXDBVersions where aliasname = 'RptLargestClientsByBKPSize'
GO

insert into GXDBVersions values(2, 'RptLargestClientsByBKPSize',  '00010010000200070000', 'RptLargestClientsByBKPSize', '00010010000200070000')
GO

