

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptIndexCacheSpaceUsage.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptIndexCacheSpaceUsage.sp,v $ $Id: RptIndexCacheSpaceUsage.sp,v 1.7.14.20 2020/12/17 02:55:50 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptIndexCacheSpaceUsage')
BEGIN
	print '>>> Drop Stored Procedure: RptIndexCacheSpaceUsage <<<'
	drop procedure RptIndexCacheSpaceUsage
END
IF EXISTS (select * from GxQscripts where name='RptIndexCacheSpaceUsage')
	delete from GxQscripts where name = 'RptIndexCacheSpaceUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptIndexCacheSpaceUsage')
	delete from GXDBVersions where aliasname = 'RptIndexCacheSpaceUsage'
GO
print '... Creating Procedure: RptIndexCacheSpaceUsage'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptIndexCacheSpaceUsage
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
IF(@blaggregate=1)
	RETURN
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 39
DECLARE @Never  BIGINT= CAST(0x7FFFFFFFFF AS bigint)-1
DECLARE @NA  BIGINT =CAST(0x7FFFFFFFFF AS bigint)
DECLARE @criticalThresholdDays int = 30
DECLARE @warningThresholdDays int = 90
DECLARE @useStoredPrediction BIT = ISNULL((SELECT Value from cf_SurveyConfig WHERE Name = 'useStoredPrediction'), 0)
DECLARE @CurrWeek DATE = DATEADD(WEEK, DATEDIFF(WEEK, 0, GETDATE()), 0)
DECLARE @MaxNumOfWeeksforGrowthRate INT = 12
DECLARE @FirstWeek DATE = DATEADD(WEEK, -@MaxNumOfWeeksforGrowthRate, @CurrWeek)
IF object_id('tempdb.dbo.#LatestResult') is not null DROP TABLE #LatestResult
CREATE	TABLE #LatestResult (
		CommServUniqueId INT,
		CommCellId VARCHAR(32),
		CommServIP VARCHAR(256),
		DisplayName      NVARCHAR(256),
		SurveyResultId BIGINT)
INSERT	INTO #LatestResult
SELECT	CommServUniqueId,CommCellID, CommServIP,DisplayName,SurverResultId
FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId,  @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId,@i_GroupId)
IF object_id('tempdb.dbo.#LatestThreshold') is not null DROP TABLE #LatestThreshold
CREATE	TABLE #LatestThreshold (
		CommServUniqueId INT,
		clientId INT,
		warningSpaceMB BIGINT,  criticalSpaceMB BIGINT)
INSERT INTO #LatestThreshold
    SELECT  CommServUniqueId ,entityId  AS clientId,
            CASE ISNUMERIC([warningSpaceMB]) WHEN 1 THEN CAST(CAST([warningSpaceMB] AS FLOAT) AS BIGINT) ELSE 0 END AS warningSpaceMB,
            CASE ISNUMERIC([criticalSpaceMB]) WHEN 1 THEN CAST(CAST([criticalSpaceMB] AS FLOAT) AS BIGINT) ELSE 0 END  AS criticalSpaceMB
    FROM    (SELECT csInfo.CommServUniqueId,entityId, attrName ,attrVal
             FROM cf_SurveyCommcellThresholdInfo csInfo (NOLOCK)
			 INNER JOIN #LatestResult AS resultView
			ON resultView.CommServUniqueId = csInfo.CommServUniqueId
			and attrName IN ( 'warningSpaceMB', 'criticalSpaceMB')
			 ) AS clients
    PIVOT
    (
        MAX(attrVal) FOR attrName IN ( warningSpaceMB, [criticalSpaceMB])
    ) AS P
DECLARE @strGood VARCHAR(10) = '1_Good'
DECLARE @strInfo VARCHAR(10) = '2_Info'
DECLARE @strwarning VARCHAR(10) = '3_Warning'
DECLARE @strCritical VARCHAR(10) = '4_Critical'
DECLARE @strUnknown VARCHAR(10) = '5_Unknown'
DECLARE @criticalVal int
DECLARE @warningVal int
SELECT	@warningVal = WarningThreshold,
		@criticalVal = CriticalThreshold
FROM cf_SurveyHealthParam where queryId = 105
-- Create tmp predict table to store calculated predicted data
IF object_id('tempdb.dbo.#PredictionData') is not null DROP TABLE #PredictionData
CREATE TABLE #PredictionData (
	CommServUniqueId INT,
	MAId INT,
	IndexCachePath NVARCHAR(max),
	DaysToBeFull BIGINT,
	DateToBeFull BIGINT
)
-- Get prediction data
IF @useStoredPrediction = 0 -- Use default linear regression model
BEGIN
	-- Create tmp tables for Growth data calculation
	IF object_id('tempdb.dbo.#GrowthData') IS NOT null DROP TABLE #GrowthData
	CREATE TABLE #GrowthData (CommservUniqueId INT, EntityId INT, EntityName NVARCHAR(MAX), X INT, Y FLOAT, SeqId INT) -- for input
	IF object_id('tempdb.dbo.#GrowthRate') IS NOT null DROP TABLE #GrowthRate
	CREATE TABLE #GrowthRate (CommservUniqueId INT, EntityId INT, EntityName NVARCHAR(MAX), GrowthRate FLOAT, GrowthStDev FLOAT) -- for output
	-- Fill input data
	INSERT INTO #GrowthData
		select B.CommServUniqueId, B.MAId, B.IndexCachePath, B.Weeks, max(B.SpaceMB),
		ROW_NUMBER() OVER (PARTITION BY B.CommServUniqueId, B.MAId, B.IndexCachePath ORDER BY B.Weeks desc)
		from
		(SELECT S.CommServUniqueId, S.MAId, S.IndexCachePath, DATEDIFF(WEEK, S.WeekStart, @CurrWeek) as Weeks, ISNULL(S.DiskUsageMB, -1) as SpaceMB
		FROM cf_SurveyIndexCacheUsagePeakSize S
					INNER JOIN (
							select A.CommServUniqueId, A.MAId, A.IndexCachePath, isnull(max(A.TotalCapacityMB),0) as TotalCapacityMBMax
							from cf_SurveyIndexCacheUsage as A
							INNER JOIN #LatestResult AS result
							ON result.SurveyResultId = A.SurveyResultId and  A.IndexAccessPathEnabled = 1 AND A.TotalCapacityMB > 0
							group by A.CommServUniqueId, A.MAId, A.IndexCachePath
					) T ON S.CommservUniqueId = T.CommServUniqueId AND S.MAId = T.MAId AND S.IndexCachePath = T.IndexCachePath
		WHERE   S.WeekStart >= @FirstWeek AND ISNULL(S.DiskUsageMB, -1) > 0 and T.TotalCapacityMBMax > 0) as B
		group by B.CommServUniqueId, B.MAId, B.IndexCachePath, B.Weeks
	-- Run Growh rate calculation
	EXEC GetLinearGrowthRate 0
	-- Insert tmp prediction data
	INSERT INTO #PredictionData
		SELECT F.*,
			CASE
				WHEN F.DaysToBeFull IS NULL THEN @NA
				WHEN F.DaysToBeFull = @NA THEN @NA
				WHEN F.DaysToBeFull = @Never THEN @Never
				ELSE
					dbo.getUnixtimebig(DATEADD(DAY, F.DaysToBeFull, GETUTCDATE()))
			END -- DateToBeFull
		FROM (
			SELECT 	S.CommServUniqueId, S.MAId, S.IndexCachePath,
				CAST(dbo.CalculateDaysToBeFull (S.FreeDiskSpaceMB, R.GrowthRate/7.0, S.LogDateUTC) AS BIGINT)  AS DaysToBeFull-- DaysToBeFull
			FROM cf_SurveyIndexCacheUsage AS S
			INNER JOIN #LatestResult AS U
			on U.SurveyResultId = S.SurveyResultId
			left join #GrowthRate R
			on S.CommServUniqueId = R.CommServUniqueId
			and S.MAId = R.EntityId
			and S.IndexCachePath = R.EntityName
			where (S.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
		) AS F
	-- Drop tmp tables
	IF object_id('tempdb.dbo.#GrowthData') IS NOT null DROP TABLE #GrowthData
	IF object_id('tempdb.dbo.#GrowthRate') IS NOT null DROP TABLE #GrowthRate
END
ELSE -- Use prediction data from CvStatAnalysis
BEGIN
	INSERT INTO #PredictionData
		SELECT DISTINCT
			I.CommServUniqueId, I.MediaAgentId, I.IndexCachePath,
			I.DaysToBeFull,
			CASE
			WHEN I.DateToBeFull IS NULL THEN I.DaysToBeFull
			ELSE
				dbo.getUnixtimebig(I.DateToBeFull)
			END AS DateToBeFull
		FROM cf_SurveyIndexCacheUsage AS S
		INNER JOIN #LatestResult AS U
		ON U.SurveyResultId = S.SurveyResultId
		LEFT JOIN (
			SELECT CommServUniqueId, MediaAgentId, IndexCachePath, MAX(LogDateUTC) AS LogDate
			FROM IndexCacheUsagePrediction
			GROUP BY CommServUniqueId, MediaAgentId, IndexCachePath
		) R
		ON S.CommServUniqueId = R.CommServUniqueId AND S.MAId = R.MediaAgentId AND S.IndexCachePath = R.IndexCachePath
		LEFT JOIN IndexCacheUsagePrediction I
		ON R.CommServUniqueId = I.CommServUniqueId AND R.MediaAgentId = I.MediaAgentId AND R.IndexCachePath = I.IndexCachePath AND R.LogDate = I.LogDateUTC
		WHERE (S.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
END
-- If no CommServ unique id is given
IF @i_CommServUniqueID = 0
BEGIN
	SELECT
		resultView.CommServUniqueId AS 'CommServ UniqueId',
		resultView.CommCellID AS 'CommCell ID',
		resultView.CommServIP AS 'CommServe IP<HIDDEN>',
		resultView.DisplayName AS 'CommCell Name',
		ISNULL(CL.clientDisplayName, csInfo.MAName) AS 'Media Agent',
		csInfo.IndexCachePath AS 'Index Cache Path',
		CASE
			WHEN csInfo.TotalCapacityMB <= 0 THEN -1
			ELSE csInfo.TotalCapacityMB
		END AS 'Total Capacity<SIZEMB>',
		csInfo.DiskUsageMB AS 'Disk Usage<SIZEMB>',
		csInfo.FreeDiskSpaceMB AS 'Free Disk Space<SIZEMB>',
		CASE
			WHEN csInfo.TotalCapacityMB <= 0 THEN -1
			ELSE CAST((csInfo.FreeDiskSpaceMB * 100.0 / csInfo.TotalCapacityMB) AS DECIMAL(10,2))
		END AS 'Free Disk Space(%)<NumberNA>',
	--  -F.GrowthRate as Rate,
	--  csInfo.FreeDiskSpaceMB/(-F.GrowthRate) as days1,
	--  DATEDIFF(DAY, csInfo.LogDateUTC, GETUTCDATE()) as days2,
		F.DateToBeFull as 'Date to be Full<MMMDDYYYYNEVER>',
		CASE WHEN T.clientId IS NULL
		THEN
			CASE
				WHEN csInfo.TotalCapacityMB <= 0 THEN @strUnknown
				WHEN ( F.DaysToBeFull != @NA and F.DaysToBeFull != @Never and F.DaysToBeFull<@criticalThresholdDays ) THEN @strCritical
				WHEN (csInfo.FreeDiskSpaceMB * 100.0 / csInfo.TotalCapacityMB) < @criticalVal then @strCritical
				WHEN ( F.DaysToBeFull != @NA and F.DaysToBeFull != @Never and F.DaysToBeFull>=@criticalThresholdDays and F.DaysToBeFull <= @warningThresholdDays ) THEN @strwarning
				when (csInfo.FreeDiskSpaceMB * 100.0 / csInfo.TotalCapacityMB) <= @warningVal and (csInfo.FreeDiskSpaceMB * 100.0 / csInfo.TotalCapacityMB) >= @criticalVal  then @strWarning
				ELSE @strGood
			END
		ELSE
			CASE
				WHEN csInfo.TotalCapacityMB <= 0 THEN @strUnknown
				WHEN ( F.DaysToBeFull != @NA and F.DaysToBeFull != @Never and F.DaysToBeFull<@criticalThresholdDays ) THEN @strCritical
				WHEN  csInfo.FreeDiskSpaceMB>0 AND csInfo.FreeDiskSpaceMB  < T.criticalSpaceMB then @strCritical
				WHEN ( F.DaysToBeFull != @NA and F.DaysToBeFull != @Never and F.DaysToBeFull>=@criticalThresholdDays and F.DaysToBeFull <= @warningThresholdDays ) THEN @strwarning
				when csInfo.FreeDiskSpaceMB >= T.criticalSpaceMB  AND csInfo.FreeDiskSpaceMB<= T.warningSpaceMB then @strWarning
				ELSE @strGood
			END
		end
		as 'Status<HEALTH_STATUS>',
		CASE WHEN T.clientId IS NULL
		THEN (csInfo.TotalCapacityMB*@criticalVal)/100
		ELSE  T.criticalSpaceMB
		END AS 'Critical Free Space Threshold<SIZEMB>',
		CASE WHEN T.clientId IS NULL
		THEN (csInfo.TotalCapacityMB*@warningVal)/100
		ELSE  T.warningSpaceMB
		END AS 'Warning Free Space Threshold<SIZEMB>',
		CASE
			WHEN csInfo.CacheType = 0 THEN 'Index'
			ELSE 'Logs'
		END AS 'Cache Type'
	FROM cf_SurveyIndexCacheUsage AS csInfo WITH (NOLOCK)
		left join #PredictionData F
			on csInfo.CommServUniqueId = F.CommServUniqueId
			and csInfo.MAId = F.MAId
			and csInfo.IndexCachePath = F.IndexCachePath
			INNER JOIN #LatestResult AS resultView
			ON resultView.SurveyResultId = csInfo.SurveyResultId
			AND csInfo.TotalCapacityMB > 0 AND csInfo.IndexAccessPathEnabled = 1
	LEFT OUTER JOIN #LatestThreshold T
	ON T.CommServUniqueId =csInfo.CommServUniqueId AND csInfo.MAId =T.clientId
	LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = T.CommServUniqueId AND CL.ClientId = T.ClientId
	ORDER BY  [Status<HEALTH_STATUS>] DESC, 'CommCell Name' ASC
END
ELSE -- If a commcell id is given in input parameters
SELECT
	csInfo.CommServUniqueId AS 'CommServ UniqueId',
	ISNULL(CL.clientDisplayName, csInfo.MAName) AS 'Media Agent',
	csInfo.IndexCachePath AS 'Index Cache Path',
	CASE
		WHEN csInfo.TotalCapacityMB <= 0 THEN -1
		ELSE csInfo.TotalCapacityMB
	END AS 'Total Capacity<SIZEMB>',
	csInfo.DiskUsageMB AS 'Disk Usage<SIZEMB>',
	csInfo.FreeDiskSpaceMB AS 'Free Disk Space<SIZEMB>',
	CASE
		WHEN csInfo.TotalCapacityMB <= 0 THEN -1
		ELSE CAST((csInfo.FreeDiskSpaceMB * 100.0 / csInfo.TotalCapacityMB) AS DECIMAL(10,2))
	END AS 'Free Disk Space(%)<NumberNA>',
	F.DateToBeFull as 'Date to be Full<MMMDDYYYYNEVER>',
	CASE WHEN T.clientId IS NULL
	THEN
		CASE
			WHEN csInfo.TotalCapacityMB <= 0 THEN @strUnknown
			WHEN ( F.DaysToBeFull != @NA and F.DaysToBeFull != @Never and F.DaysToBeFull<@criticalThresholdDays ) THEN @strCritical
			WHEN (csInfo.FreeDiskSpaceMB * 100.0 / csInfo.TotalCapacityMB) < @criticalVal then @strCritical
			WHEN ( F.DaysToBeFull != @NA and F.DaysToBeFull != @Never and F.DaysToBeFull>=@criticalThresholdDays and F.DaysToBeFull <= @warningThresholdDays ) THEN @strwarning
			when (csInfo.FreeDiskSpaceMB * 100.0 / csInfo.TotalCapacityMB) <= @warningVal and (csInfo.FreeDiskSpaceMB * 100.0 / csInfo.TotalCapacityMB) >= @criticalVal  then @strWarning
			ELSE @strGood
		END
	ELSE
		CASE
			WHEN csInfo.TotalCapacityMB <= 0 THEN @strUnknown
			WHEN ( F.DaysToBeFull != @NA and F.DaysToBeFull != @Never and F.DaysToBeFull<@criticalThresholdDays ) THEN @strCritical
			WHEN  csInfo.FreeDiskSpaceMB>0 AND csInfo.FreeDiskSpaceMB  < T.criticalSpaceMB then @strCritical
			WHEN ( F.DaysToBeFull != @NA and F.DaysToBeFull != @Never and F.DaysToBeFull>=@criticalThresholdDays and F.DaysToBeFull <= @warningThresholdDays ) THEN @strwarning
			when csInfo.FreeDiskSpaceMB >= T.criticalSpaceMB  AND csInfo.FreeDiskSpaceMB<= T.warningSpaceMB then @strWarning
			ELSE @strGood
		END
	end
	as 'Status<HEALTH_STATUS>',
	CASE WHEN T.clientId IS NULL
	THEN (csInfo.TotalCapacityMB*@criticalVal)/100
	ELSE  T.criticalSpaceMB
	END AS 'Critical Free Space Threshold<SIZEMB>',
	CASE WHEN T.clientId IS NULL
	THEN (csInfo.TotalCapacityMB*@warningVal)/100
	ELSE  T.warningSpaceMB
	END AS 'Warning Free Space Threshold<SIZEMB>',
	CASE
		WHEN csInfo.CacheType = 0 THEN 'Index'
		ELSE 'Logs'
	END AS 'Cache Type'
FROM cf_SurveyIndexCacheUsage AS csInfo WITH (NOLOCK)
	left join #PredictionData F
		on csInfo.CommServUniqueId = F.CommServUniqueId
		and csInfo.MAId = F.MAId
		and csInfo.IndexCachePath = F.IndexCachePath
	INNER JOIN #LatestResult AS resultView
		ON resultView.SurveyResultId = csInfo.SurveyResultId
		AND csInfo.TotalCapacityMB > 0 AND csInfo.IndexAccessPathEnabled = 1
LEFT OUTER JOIN #LatestThreshold T WITH (NOLOCK)
ON T.CommServUniqueId =csInfo.CommServUniqueId AND csInfo.MAId = T.clientId
LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = T.CommServUniqueId AND CL.ClientId = T.ClientId
ORDER BY [Status<HEALTH_STATUS>] DESC
SET NOCOUNT OFF
IF object_id('tempdb.dbo.#LatestThreshold') is not null DROP TABLE #LatestThreshold
IF object_id('tempdb.dbo.#LatestResult') is not null DROP TABLE #LatestResult
IF object_id('tempdb.dbo.#PredictionData') is not null DROP TABLE #PredictionData
GO
/*
-- FOR STANDALONE TESTING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= NULL
  DECLARE @blaggregate INT				= 0
  DECLARE @blLatestSurvey INT			= 1
  DECLARE @i_CommServUniqueID INT		= 11065
  DECLARE @i_LogDateEND DATETIME		= 	NULL    -- getDate()
  DECLARE @i_LogDateStart DATETIME		= NULL   --DateAdd(Month, -36, @i_LogDateEND)
exec RptIndexCacheSpaceUsage @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND
*/

IF EXISTS (select * from GxQscripts where name = 'RptIndexCacheSpaceUsage')
	delete from GxQscripts where name = 'RptIndexCacheSpaceUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptIndexCacheSpaceUsage')
	delete from GXDBVersions where aliasname = 'RptIndexCacheSpaceUsage'
GO

insert into GXDBVersions values(2, 'RptIndexCacheSpaceUsage',  '00010007001400200000', 'RptIndexCacheSpaceUsage', '00010007001400200000')
GO

