

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptHourlyJobStats.sp] ---------- 

--#define DEBUG_TRACKING 1               -- DELETE ALL DEBUG_TRACKING CODE PRIOR TO CHECK-IN!
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptHourlyJobStats.sp,v $ $Id: RptHourlyJobStats.sp,v 1.7.54.7 2020/05/14 08:15:21 nbirru Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptHourlyJobStats')
BEGIN
	print '>>> Drop Stored Procedure: RptHourlyJobStats <<<'
	drop procedure RptHourlyJobStats
END
IF EXISTS (select * from GxQscripts where name='RptHourlyJobStats')
	delete from GxQscripts where name = 'RptHourlyJobStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptHourlyJobStats')
	delete from GXDBVersions where aliasname = 'RptHourlyJobStats'
GO
print '... Creating Procedure: RptHourlyJobStats'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptHourlyJobStats
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @i_TimeRangeBegin DATETIME = NULL,
  @i_TimeRangeEnd DATETIME = NUll,
  @i_LatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_Options INT = 0,
  @i_TenantName NVARCHAR(255) = NULL
AS
SET NOCOUNT ON
	DECLARE @ExcludeTransactionLogs	INT = CASE WHEN (@i_Options & 1) > 0 THEN 1 ELSE 0 END
	DECLARE @isPrivate 			INT = 0
	SELECT	@isPrivate = ISNULL(CAST(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
	IF @i_TimeRangeBegin IS NULL
		RETURN
DECLARE @FTSASFailedJobs INT = 0
SELECT @FTSASFailedJobs =  ISNULL(value,0) from cf_surveyConfig WITH (NOLOCK) where name like 'considerFailedToStartAsFailedJobsInActivity'
	IF (@isPrivate = 0)--Use query 51 for public
	BEGIN
		DECLARE @i_QueryId BIGINT = 51
		select  CONVERT(VARCHAR(11),DayVal,100) as 'Date <HIDDEN>',
			 HourComp*60  as 'Backup Hour<HOURS>',
			sum(Completed) as 'Completed', sum(Partial) as 'Completed with Errors or Warnings',sum(Failed)+(CASE WHEN  @FTSASFailedJobs = 1 THEN SUM(FailedToStartJobs) ELSE 0 END) as 'Failed', ISNULL(sum(KilledJobs),-1) as 'Killed<NumberNA>', ISNULL(SUM(SkippedJobs)+(CASE WHEN  @FTSASFailedJobs = 0 THEN SUM(FailedToStartJobs) ELSE 0 END),-1) AS 'Skipped<NumberNA>', ISNULL(SUM(CommittedJobs),-1) AS 'Committed<NumberNA>'
		FROM	cf_SurveyHourlyBkpJobs J WITH (NOLOCK)
				INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @i_LatestSurvey, NULL, NULL,@i_UserId,@i_GroupId) AS resultView
				ON resultView.SurverResultId = J.SurveyResultId
			AND J.DayVal BETWEEN @i_TimeRangeBegin AND @i_TimeRangeEnd
			group by DayVal, HourComp
	END
	ELSE --User query 137 for private
	BEGIN
		IF object_id('tempdb.dbo.#TenantClients') IS NOT NULL DROP TABLE #TenantClients
		CREATE TABLE #TenantClients (CommServUniqueId INT, TenantName NVARCHAR(255), ClientId INT)
		exec GetTenantEntities @i_UserId, @i_GroupId, 1, 1, @i_CommServUniqueID, NULL, NULL, @i_TenantName
		IF (@i_TimeRangeEnd < DATEADD(DD, 1, @i_TimeRangeBegin))
			SET @i_TimeRangeEnd = DATEADD(DD, 1, @i_TimeRangeBegin)
		IF object_id('tempdb.dbo.#HourTbl') is not null DROP TABLE #HourTbl
		CREATE TABLE #HourTbl (DateVal DATE, Hour INT)
		DECLARE	@htCtr	DATETIME = DATEADD(HOUR, -1, @i_TimeRangeEnd)
		WHILE DATEDIFF(DAY, @i_TimeRangeBegin, @htCtr) = 0
		BEGIN
			INSERT	INTO #HourTbl
			SELECT @htCtr, DATEDIFF(HOUR, @i_TimeRangeBegin, @htCtr)
			SET @htCtr = DATEADD(HOUR, -1, @htCtr)
		END
		SELECT
			CONVERT(VARCHAR(11), ht.DateVal, 100) AS 'Date <HIDDEN>',
			ht.Hour*60 AS 'Backup Hour<HOURS>',
			ISNULL(sub.Completed, 0) AS 'Completed',
			ISNULL(sub.CWWOrE, 0) AS 'Completed with Errors or Warnings',
			ISNULL(sub.Failed, 0) AS 'Failed',
			ISNULL(sub.Killed, 0) AS 'Killed<NumberNA>',
			ISNULL(sub.Skipped, 0) AS 'Skipped<NumberNA>',
			ISNULL(sub.CommittedJ, 0) AS 'Committed<NumberNA>'
		FROM #HourTbl ht
			LEFT OUTER JOIN
			(SELECT
				CONVERT(DATE, DATEADD(s, EndDate, '1970-01-01 00:00:00')) AS 'DateVal',
				DATEPART(HOUR, DATEADD(s, EndDate, '1970-01-01 00:00:00')) AS 'BackupHour',
				SUM(CASE WHEN Status = 1 THEN 1 ELSE 0 END) AS 'Completed',
				SUM(CASE WHEN Status IN (3, 14) THEN 1 ELSE 0 END) AS 'CWWOrE',
				SUM(CASE WHEN Status = 2 OR (Status = 9 AND @FTSASFailedJobs = 1 AND failureErrorCode = 8) THEN 1 ELSE 0 END) AS 'Failed',
				SUM(CASE WHEN Status = 4 THEN 1 ELSE 0 END) 'Killed',
				SUM(CASE WHEN (Status = 9 AND (@FTSASFailedJobs = 0 OR failureErrorCode <> 8)) THEN 1 ELSE 0 END) 'Skipped',
				SUM(CASE WHEN Status = 16 THEN 1 ELSE 0 END) AS 'CommittedJ'
			FROM cf_SurveyJobStats J WITH(NOLOCK)
				INNER JOIN dbo.cf_SurveyResultFuncV1(2, @i_CommServUniqueID, @i_LatestSurvey, NULL, NULL, @i_UserId, @i_GroupId) AS resultView
					ON resultView.CommServUniqueId = J.CommservUniqueId
					AND EndDate >=  DATEDIFF(s, '1970-01-01 00:00:00', @i_TimeRangeBegin)
					AND EndDate < DATEDIFF(s, '1970-01-01 00:00:00', @i_TimeRangeEnd)
					-- FOLLOWING (3) LINES TO (OPTIONALLY) EXCLUDE DB TRANSACTION LOGS:
				INNER JOIN  cf_SurveySubclients SC ON J.AppId = SC.AppId  AND SC.CommservUniqueId = J.CommservUniqueId
				INNER JOIN  cf_SurveySubclientAssociation SA ON SC.AppId = SA.AppId AND SC.CommservUniqueId = SA.CommservUniqueId
				LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
                    ON SA.CommServUniqueId = TC.CommServUniqueId AND SA.ClientId = TC.ClientId
					WHERE ((@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL) AND (@ExcludeTransactionLogs = 0
					OR (NOT (BkpLevel = 2 AND SC.AppTypeId  IN (4,16,70,81))))     -- 5, 125 ARE OTHER DBs w/Transaction Logs but we are excluding from this option
			GROUP BY CONVERT(DATE, DATEADD(s, EndDate, '1970-01-01 00:00:00')), DATEPART(HOUR, DATEADD(s, EndDate, '1970-01-01 00:00:00'))
			) AS sub
		ON ht.DateVal = sub.DateVal
			AND ht.Hour = sub.BackupHour
		ORDER BY ht.DateVal, ht.Hour
		IF object_id('tempdb.dbo.#TenantClients') IS NOT NULL DROP TABLE #TenantClients
		IF object_id('tempdb.dbo.#HourTbl') is not null DROP TABLE #HourTbl
	END
SET NOCOUNT OFF
/*   FOR STANDALONE DEBUGGING:
DECLARE @userId			INT = 1
DECLARE @GroupId		INT = -1
DECLARE @timeRangeEnd	DATETIME = 'Dec 05 2018 11:59PM'
DECLARE @timeRangeStart	DATETIME = 'Dec 05 2018 12:00AM'
DECLARE @latestSurvey	INT	= 9
DECLARE @commservId		INT = 10000   -- THIS IS CORRECT!
DECLARE @i_Options		INT = 1
exec RptHourlyJobStats @userId, @groupId, @timeRangeStart, @timeRangeEnd, @latestSurvey, @commservId, @i_Options
select top 1 * from SK_LOG order by LogDate desc
--   DELETE stuk_log
*/
GO

IF EXISTS (select * from GxQscripts where name = 'RptHourlyJobStats')
	delete from GxQscripts where name = 'RptHourlyJobStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptHourlyJobStats')
	delete from GXDBVersions where aliasname = 'RptHourlyJobStats'
GO

insert into GXDBVersions values(2, 'RptHourlyJobStats',  '00010007005400070000', 'RptHourlyJobStats', '00010007005400070000')
GO

