

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptGrowingClients.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptGrowingClients.sp,v $ $Id: RptGrowingClients.sp,v 1.1.2.7 2020/12/17 02:53:17 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptGrowingClients')
BEGIN
	print '>>> Drop Stored Procedure: RptGrowingClients <<<'
	drop procedure RptGrowingClients
END
IF EXISTS (select * from GxQscripts where name='RptGrowingClients')
	delete from GxQscripts where name = 'RptGrowingClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGrowingClients')
	delete from GXDBVersions where aliasname = 'RptGrowingClients'
GO
print '... Creating Procedure: RptGrowingClients'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptGrowingClients
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll,
  @blNeedTop10 INT = 0,
  @i_nDaysAgo INT = 7
AS
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 204
IF OBJECT_ID('tempdb.dbo.#LatestResult') IS NOT NULL DROP TABLE #LatestResult
CREATE TABLE #LatestResult (CommServUniqueId INT, CommCellId VARCHAR(32), CommServIP VARCHAR(256), DisplayName NVARCHAR(256), SurveyResultId BIGINT, LogDate DATETIME)
INSERT	INTO #LatestResult
SELECT	CommServUniqueId, CommCellId, CommServIP, DisplayName, SurverResultId, LogDate
FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId)
IF @blaggregate = 1 -- Number of clients in growth buckets
BEGIN
	SELECT
		T.RangeGB AS 'Growth Range<ALTSORT>',
		T.fromMB  AS 'Growth Range_SORTCOLUMN',
		ClientCount AS [Client Count]
	FROM
		(SELECT C.RangeGB, C.fromMB, SUM(C.nClients) AS ClientCount
		FROM	cf_SurveyClientGrowthBucket C
			INNER JOIN #LatestResult R ON C.SurveyResultId = R.SurveyResultId
		WHERE	C.nDaysAgo = @i_nDaysAgo
		GROUP BY C.RangeGB, C.fromMB
		) T
	ORDER BY T.fromMB
END
ELSE
IF @blaggregate = 2 -- Growth by agent types
BEGIN
	SELECT
		T.shortName AS 'Agent Type',
		CAST(1.0*(T.appSizeMB)/1024.0 AS DECIMAL(32,2)) AS [App Size From 7 Days Ago (GB)],
		CAST(1.0*(T.appSizeMB+T.growthMB)/1024.0 AS DECIMAL(32,2)) AS [Current App Size (GB)],
		CAST(1.0*T.growthMB/1024.0 AS DECIMAL(32,2)) AS [Growth (GB)],
		CASE WHEN T.appSizeMB > 0 THEN CAST(100.0*T.growthMB/T.appSizeMB AS DECIMAL(32,2)) ELSE 0 END AS [Growth (%)]
	FROM
		(SELECT AT.shortName, SUM(appSizeMB) AS appSizeMB, SUM(A.growthMB) AS growthMB
		FROM	cf_SurveyAgentGrowth A
			INNER JOIN cf_SurveyAgentType AT ON A.appTypeId = AT.id
			INNER JOIN #LatestResult R ON A.SurveyResultId = R.SurveyResultId
		WHERE	A.nDaysAgo = @i_nDaysAgo
		GROUP BY AT.shortName
		) T
	WHERE	T.appSizeMB > 0
	ORDER BY T.growthMB DESC
END
ELSE
IF @blaggregate = 3 -- Top 25 growing clients
BEGIN
	SELECT TOP 25
		C.CommServUniqueId  AS 'CommServ UniqueId<DONOTSHOW>',
		C.CommCellID AS 'CommCell ID<HIDDEN>',
		C.CommServIP AS 'CommServe IP<HIDDEN>',
		C.DisplayName AS 'CommCell Name',
		ISNULL(CL.clientDisplayName, C.ClientName) AS 'Client',
		CAST(1.0*(T.appSizeMB)/1024.0 AS DECIMAL(32,2)) AS [App Size From 7 Days Ago (GB)],
		CAST(1.0*(T.appSizeMB+T.growthMB)/1024.0 AS DECIMAL(32,2)) AS [Current App Size (GB)],
		CAST(1.0*T.growthMB/1024.0 AS DECIMAL(32,2)) AS [Growth (GB)],
		CASE WHEN T.appSizeMB > 0 THEN CAST(100.0*T.growthMB/T.appSizeMB AS DECIMAL(32,2)) ELSE 0 END AS [Growth (%)]
	FROM
		(SELECT	R.CommServUniqueId, A.clientId,
				SUM(appSizeMB) AS appSizeMB, SUM(growthMB) AS growthMB
		FROM	cf_SurveyGrowingClients A
				INNER JOIN #LatestResult R ON A.SurveyResultId = R.SurveyResultId
		WHERE	A.nDaysAgo = @i_nDaysAgo
		GROUP BY R.CommServUniqueId, A.clientId
		) T
		INNER JOIN
		(SELECT	DISTINCT S.CommservUniqueId, LR.CommCellID, LR.CommServIP, LR.DisplayName, S.ClientId, S.ClientName
		FROM	cf_SurveySubclientAssociation S
				INNER JOIN #LatestResult LR ON S.CommservUniqueId = LR.CommservUniqueId
		WHERE	Deleted = 0
		) C ON T.CommServUniqueId = C.CommservUniqueId AND T.clientId = C.ClientId
		LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = C.CommServUniqueId AND CL.ClientId = C.ClientId
	WHERE	T.appSizeMB > 0
	ORDER BY T.growthMB DESC
END
ELSE
IF @blaggregate = 4 -- Subclient Details for Top 25 growing clients
BEGIN
	CREATE TABLE #TopGrowingClients (CommServUniqueId INT, SurveyResultId BIGINT, ClientId INT, TotalGrowthMB BIGINT)
	INSERT	INTO #TopGrowingClients
	SELECT	R.CommservUniqueId, A.SurveyResultId, A.clientId, SUM(growthMB)
	FROM	cf_SurveyGrowingClients A
			INNER JOIN #LatestResult R ON A.SurveyResultId = R.SurveyResultId
	WHERE	A.nDaysAgo = @i_nDaysAgo
	GROUP BY R.CommservUniqueId, A.SurveyResultId, A.clientId
	SELECT
		C.CommServUniqueId  AS 'CommServ UniqueId<DONOTSHOW>',
		C.CommCellID AS 'CommCell ID<HIDDEN>',
		C.CommServIP AS 'CommServe IP<HIDDEN>',
		C.DisplayName AS 'CommCell Name',
		CASE WHEN S.appTypeId = 106 THEN ISNULL(CL.clientDisplayName, C.ClientName) ELSE ISNULL(CL.clientDisplayName, S.ClientName) END AS 'Client',
		CASE WHEN S.appTypeId = 106 THEN 'Virtual Server in ' + ISNULL(CL.clientDisplayName, S.ClientName) ELSE AT.shortName END AS 'Agent Type',
		S.InstanceName AS 'Instance',
		S.BackupsetName AS 'Backupset',
		S.SubclientName AS 'Subclient',
		CAST(1.0*(G.appSizeMB)/1024.0 AS DECIMAL(32,2)) AS [App Size From 7 Days Ago (GB)],
		CAST(1.0*(G.appSizeMB+G.growthMB)/1024.0 AS DECIMAL(32,2)) AS [Current App Size (GB)],
		CAST(1.0*G.growthMB/1024.0 AS DECIMAL(32,2)) AS [Growth (GB)],
		CASE WHEN G.appSizeMB > 0 THEN CAST(100.0*G.growthMB/G.appSizeMB AS DECIMAL(32,2)) ELSE 0 END AS [Growth (%)]
	FROM
		(SELECT	CommservUniqueId, SurveyResultId, clientId, TotalGrowthMB, ROW_NUMBER() OVER (ORDER BY TotalGrowthMB DESC) RowNo
		FROM	#TopGrowingClients
		) T
		INNER JOIN cf_SurveyGrowingClients G ON T.SurveyResultId = G.SurveyResultId AND T.clientId = G.clientId
		INNER JOIN cf_SurveySubclientAssociation S ON T.CommservUniqueId = S.CommservUniqueId
			AND (G.appId = S.AppId OR G.clientId = S.ClientId AND S.appTypeId = 106 AND S.AppId = 0) AND S.Deleted = 0
		INNER JOIN
		(SELECT	DISTINCT S1.CommservUniqueId, R1.CommCellID, R1.CommServIP, R1.DisplayName, S1.ClientId, S1.ClientName
		FROM	cf_SurveySubclientAssociation S1
				INNER JOIN #LatestResult R1 ON S1.CommservUniqueId = R1.CommservUniqueId
		WHERE	S1.Deleted = 0
		) C ON T.CommServUniqueId = C.CommservUniqueId AND T.clientId = C.ClientId
		LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = T.CommServUniqueId AND CL.ClientId = T.ClientId
		INNER JOIN cf_SurveyAgentType AT ON S.AppTypeId = AT.id
		WHERE	T.rowNo <= 25
	ORDER BY T.TotalGrowthMB DESC, 'CommCell Name', 'Client', G.growthMB DESC
	DROP TABLE #TopGrowingClients
END
DROP TABLE #LatestResult
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE TESTING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= NULL
  DECLARE @blaggregate INT				=  3          -- TAKES VALUES 1, 2, 3, 4 (3,4 use client name)
  DECLARE @blLatestSurvey INT			= 1				-- (ignored)
  DECLARE @i_CommServUniqueID INT		= 11065
  DECLARE @i_LogDateEND DATETIME		= 	NULL    -- getDate()
  DECLARE @i_LogDateStart DATETIME		= NULL   --DateAdd(Month, -36, @i_LogDateEND)
  DECLARE @blNeedTop10 INT				= 0
  DECLARE @i_nDaysAgo INT				= 7
exec RptGrowingClients @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND, @blNeedTop10, @i_nDaysAgo
*/

IF EXISTS (select * from GxQscripts where name = 'RptGrowingClients')
	delete from GxQscripts where name = 'RptGrowingClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGrowingClients')
	delete from GXDBVersions where aliasname = 'RptGrowingClients'
GO

insert into GXDBVersions values(2, 'RptGrowingClients',  '00010001000200070000', 'RptGrowingClients', '00010001000200070000')
GO

