

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptGetMetricsReportInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET ANSI_NULLS ON
-- 	+-----------------------------------------------------------------------+
--	| 					PROCEDURE: "RptGetMetricsReportInfo"				|
--	|																		|
--	|			Returns information on all/specified metrics reports 		|
--	|																		|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptGetMetricsReportInfo <<<'

IF EXISTS (select * from sysobjects where name='RptGetMetricsReportInfo')
	drop procedure RptGetMetricsReportInfo
IF EXISTS (select * from GxQscripts where name='RptGetMetricsReportInfo')
	delete from GxQscripts where name = 'RptGetMetricsReportInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetMetricsReportInfo')
	delete from GXDBVersions where aliasname = 'RptGetMetricsReportInfo'
GO
print '... Creating Procedure: RptGetMetricsReportInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptGetMetricsReportInfo
  @i_UserId int = -1,
  @i_reportId int =  0,
  @i_commUniId int = -1,
  @i_optParameters nvarchar(250) = NULL,
  @i_bAllReport nvarchar(250) = 0
AS
	SET NOCOUNT ON
	DECLARE @reportName nvarchar(1024) = NULL
	IF @i_commUniId = 0 AND (@i_optParameters IS NULL OR @i_optParameters = '')
		SET @i_optParameters = 'worldwide'
	ELSE IF @i_commUniId <> -1 AND (@i_optParameters IS NULL OR @i_optParameters = '')
		SET @i_optParameters = 'commcell'
	IF @i_optParameters IS NOT NULL
		SELECT @reportName = names.names.value('@name', 'nvarchar(1024)')
		FROM cf_WebConsoleReports R WITH(NOLOCK)
		CROSS APPLY R.AltNamesXml.nodes('/AlternateReportNames/report') names(names)
		WHERE ReportId = @i_reportId AND names.names.value('@reporttype', 'nvarchar(250)') = @i_optParameters
	IF @i_commUniId <= 0
		SELECT TOP 1 @i_commUniId = csinfo.ID
	        FROM cf_CommcellIdNameMap csinfo WITH (NOLOCK)
	                INNER JOIN dbo.cf_SurveyResultFuncV1(146, 0, 1, NULL, NULL, @i_UserId, -1) AS resultView
	                        ON resultView.CommServUniqueId = csinfo.ID
		ORDER BY csinfo.ModifiedTime ASC
	DECLARE @tblUpdatedRetentionAndFlags TABLE (ReportId int, Retention int, Status int, OpFlags int, DispFlag int)
	INSERT INTO @tblUpdatedRetentionAndFlags
	SELECT ReportId, Retention, Status, OpFlags, DispFlag
	FROM dbo.RptMetricsReportsFlags(0)
	--Retention period for some reports are controlled by parameters in cf_SurveyConfig table. #ReportSurveyConfigMap will contain parameter names in cf_SurveyConfig table for these reports.
	DECLARE @ReportSurveyConfigMap TABLE (
		ReportId int,
		ConfigName nvarchar(64),
		RetentionUnit int	-- 0 -> Days; 1 -> Months
	)
	INSERT INTO @ReportSurveyConfigMap VALUES (1001, 'RetentionMonthsForGrowth', 1)
	INSERT INTO @ReportSurveyConfigMap VALUES (137, 'RetentionMonthsForJobDetails', 1)
	INSERT INTO @ReportSurveyConfigMap VALUES (51, 'DailyActivityRetentionDays', 0)
	INSERT INTO @ReportSurveyConfigMap VALUES (173, 'MonthlyActivityRetentionMonths', 1)
	UPDATE RT
	SET Retention = CASE
WHEN	(RT.OpFlags & 4 = 0 AND Map.RetentionUnit IS NULL)  THEN RT.Retention
WHEN	(RT.OpFlags & 4 <> 0 AND Map.RetentionUnit IS NULL) THEN ROUND((RT.Retention-1)/30.42,0)
WHEN 	(RT.OpFlags & 4 <> 0 AND Map.RetentionUnit = 1) OR
(RT.OpFlags & 4 = 0 AND Map.RetentionUnit = 0)		THEN CAST(SC.value AS INT)
WHEN	(RT.OpFlags & 4 <> 0 AND Map.RetentionUnit = 0)		THEN ROUND((CAST(SC.value AS INT)-1)/30.42,0)
WHEN	(RT.OpFlags & 4 = 0 AND Map.RetentionUnit = 1)		THEN ROUND(CAST(SC.value AS INT)  * 30.42 + 1, 0)
			END
	FROM @tblUpdatedRetentionAndFlags RT
		LEFT OUTER JOIN @ReportSurveyConfigMap Map ON RT.ReportId = Map.ReportId
		LEFT OUTER JOIN cf_SurveyConfig SC WITH(NOLOCK) ON Map.ConfigName = SC.Name
	DECLARE @ThisMonthStart NVARCHAR(15) = CAST(DATEADD(mm, DATEDIFF(mm, 0, GETDATE()), 0) AS DATE)
	DECLARE @NextMonthStart NVARCHAR(15) = CAST(DATEADD(mm, DATEDIFF(mm, 0, GETDATE()) + 1, 0) AS DATE)
	SELECT
		R.ReportId AS 'ReportId<DONOTSHOW>',
		ISNULL(@reportName, R.Name) AS 'Report Name<reportConfigurationActions>',
		REPLACE(REPLACE(REPLACE(R.Hyperlink,'<commUniId>', @i_commUniId), '<startDate>', @ThisMonthStart), '<endDate>', @NextMonthStart) AS 'Hyperlink<DONOTSHOW>',
		R.Description,
		RT.Retention AS 'Retention<DATEUNIT>',
		R.RetentionText AS 'RetentionText<DONOTSHOW>',
		CASE
			WHEN ISNULL(RT.Status,0) <> 0 THEN 'Enabled'
			ELSE 'Disabled'
		END AS Status,
		R.NoDisableText AS 'StatusText<DONOTSHOW>',
		RT.OpFlags AS 'Flags<DONOTSHOW>',
CAST(	CASE RT.OpFlags & 4
				WHEN 0 THEN RT.Retention
				ELSE ROUND(RT.Retention * 30.42, 0)
			END AS INT)
		AS 'RetentionInDays<HIDDEN>'
	FROM cf_WebConsoleReports R WITH(NOLOCK)
		INNER JOIN @tblUpdatedRetentionAndFlags RT ON R.reportId = RT.reportId
	WHERE R.reportId = @i_reportId OR (@i_reportId = 0 AND (RT.OpFlags <> 0 OR (@i_bAllReport=1 AND ISNULL(RT.Status,0) !=0)) AND R.reportId NOT IN(51,173,1000,208,  63,93,88,159))
	ORDER BY ISNULL(@reportName, R.Name)
	--CommCell  Audit report (63,93,88,159)  is excluded with  @i_bAllReport=1 as URL need diffferent parameter to give csv output for report content push
	-- Activity Daily , monthly report (51,173,1000) is excluded as this has operation page(dashboard) url, export of this will be giving other report data which is already pushed and causing problem
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetMetricsReportInfo')
	delete from GxQscripts where name = 'RptGetMetricsReportInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetMetricsReportInfo')
	delete from GXDBVersions where aliasname = 'RptGetMetricsReportInfo'
GO

insert into GXDBVersions values(2, 'RptGetMetricsReportInfo',  '00000000000000000000', 'RptGetMetricsReportInfo', '00000000000000000000')
GO

