

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptGetMetricsQueryInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET ANSI_NULLS ON
-- 	+-----------------------------------------------------------------------+
--	| 					PROCEDURE: "RptGetMetricsQueryInfo"					|
--	|																		|
--	|			Returns information on all/specified metrics queries 		|
--	|																		|
-- 	+-----------------------------------------------------------------------+
--		Parameters:
--			i_reportType = 0 returns info for all general reports		(deprecated)
--			i_reportType = 1 returns info for all health reports		(deprecated)
--			i_reportType = 2 returns info for all activity reports		(deprecated)
--			i_reportType = 3 returns info for all chargeback reports	(deprecated)
--			i_reportType = 4 returns info for all audit reports			(deprecated)
--			i_reportType = -1 returns all info for all reports if queryId  = 0
--			i_reportType = -1 and queryId = x gives all info for report with queryId = x
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptGetMetricsQueryInfo <<<'

IF EXISTS (select * from sysobjects where name='RptGetMetricsQueryInfo')
	drop procedure RptGetMetricsQueryInfo
IF EXISTS (select * from GxQscripts where name='RptGetMetricsQueryInfo')
	delete from GxQscripts where name = 'RptGetMetricsQueryInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetMetricsQueryInfo')
	delete from GXDBVersions where aliasname = 'RptGetMetricsQueryInfo'
GO
print '... Creating Procedure: RptGetMetricsQueryInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptGetMetricsQueryInfo
  @i_UserId INT = -1,
  @i_reportType INT,
  @i_queryId INT = 0,
  @i_commServUniqueId INT = 0,
  @i_repType NVARCHAR(250) = NULL
AS
SET NOCOUNT ON
	IF (@i_reportType = -1 AND @i_queryId <> 0)
	BEGIN
		DECLARE @reportName NVARCHAR(255) = NULL
		IF (@i_queryId = 51 AND @i_repType = 'hourly')					--returns different names depending on the page on which the report appears in web console
			SELECT @reportName = 'Hourly Backup Jobs'
		ELSE IF (@i_queryId = 51 AND @i_commServUniqueId = 0)
			SELECT @reportName = 'Worldwide Backup Statistics'
		ELSE IF (@i_queryId = 51 AND @i_commServUniqueId <> 0)
			SELECT @reportName = 'Backup Statistics'
		ELSE IF (@i_queryId = 137 AND @i_repType = 'monthly')
			SELECT @reportName = 'Daily Backup Jobs'
		ELSE IF(@i_queryId = 24)										-- hardcoded names must be moved to cf_CommservSurveyGroupMap table or new table
			SELECT @reportName = 'Top 25 Long Running Backup Jobs'
		ELSE IF(@i_queryId = 31)
			SELECT @reportName = 'DR Backup Configuration'
		ELSE IF(@i_queryId = 44)
			SELECT @reportName = 'Slowest Clients by Throughput in Last 24 Hours'
		ELSE IF(@i_queryId = 98)
			SELECT @reportName = 'File System Backup Efficiency'
		ELSE IF(@i_queryId = 99)
			SELECT @reportName = 'File Data Placement'
		ELSE IF(@i_queryId = 100)
			SELECT @reportName = 'Rapid Recovery Capability'
		ELSE IF(@i_queryId = 101)
			SELECT @reportName = 'VM Backup Efficiency'
		ELSE IF(@i_queryId = 102)
			SELECT @reportName = 'Application Backup Efficiency'
		ELSE IF(@i_queryId = 112)
			SELECT @reportName = 'Email Data Placement'
		SELECT	CASE WHEN @reportName IS NOT NULL
					THEN @reportName
					ELSE Name
				END AS 'Report Name<reportConfigurationActions>',
				Description,
				DataRetentionDays AS [Retention in Days],
				CASE
					WHEN Flags <> 0 THEN 'Enabled'
					ELSE 'Disabled'
				END AS Status,
				CASE WHEN (Flags & 321) <> 0 THEN 'Yes' ELSE 'No' END AS [CommCell<booleanRenderer>],
				CASE WHEN (Flags & 641) <> 0 THEN 'Yes' ELSE 'No' END AS [Worldwide<booleanRenderer>],
				QueryId AS 'ReportId<DONOTSHOW>'
		FROM cf_CommservSurveyQueries WITH (NOLOCK)
		WHERE QueryId = @i_queryId
	END
	ELSE
	BEGIN
		IF OBJECT_ID('tempdb..#MetricsQueries') IS NOT NULL DROP TABLE #MetricsQueries
		CREATE TABLE #MetricsQueries (
			ReportName					NVARCHAR(MAX),
			Description					NVARCHAR(MAX),
			Retention					INT,
			Status						NVARCHAR(MAX),
			CommCell					NVARCHAR(MAX),
			Worldwide					NVARCHAR(MAX),
			General						NVARCHAR(MAX),
			Health						NVARCHAR(MAX),
			Activity					NVARCHAR(MAX),
			Chargeback					NVARCHAR(MAX),
			Audit						NVARCHAR(MAX),
			ReportId					INT,
			ReportType					INT
		)
		IF OBJECT_ID('tempdb..#ReportNameOverride') IS NOT NULL DROP TABLE #ReportNameOverride					--hardcoded names must be moved to cf_CommservSurveyGroupMap table or new table
		CREATE TABLE #ReportNameOverride (
			ReportName	NVARCHAR(MAX),
			QueryId		INT
		)
		INSERT INTO #ReportNameOverride VALUES('Top 25 Long Running Backup Jobs',24)
		INSERT INTO #ReportNameOverride VALUES('DR Backup Configuration',31)
		INSERT INTO #ReportNameOverride VALUES('Slowest Clients by Throughput in Last 24 Hours',44)
		INSERT INTO #ReportNameOverride VALUES('File System Backup Efficiency',98)
		INSERT INTO #ReportNameOverride VALUES('File Data Placement',99)
		INSERT INTO #ReportNameOverride VALUES('Rapid Recovery Capability',100)
		INSERT INTO #ReportNameOverride VALUES('VM Backup Efficiency',101)
		INSERT INTO #ReportNameOverride VALUES('Application Backup Efficiency',102)
		INSERT INTO #ReportNameOverride VALUES('Email Data Placement',112)
		IF OBJECT_ID('tempdb..#OldXMLData') IS NOT NULL DROP TABLE #OldXMLData
		CREATE TABLE #OldXMLData (
			QueryId INT,
			OldFlags INT
		)
		IF (NOT EXISTS (SELECT id FROM cf_SurveyConfig WITH (NOLOCK) WHERE Name = 'MetricsQueriesPreviousFlags'))
			INSERT INTO cf_SurveyConfig VALUES ('MetricsQueriesPreviousFlags','',GETUTCDATE())
		IF (NOT EXISTS (SELECT id FROM cf_SurveyConfig WITH (NOLOCK) WHERE Name = 'DefaultMetricsReportsSettings'))
		BEGIN
			DECLARE @DefaultMetricsReportsSettings XML = (SELECT QueryId AS '@queryid', Status AS '@status', Flags AS '@flags', DataRetentionDays AS '@retention' FROM cf_CommservSurveyQueries FOR XML PATH ('Query'), ROOT ('DefaultMetricsReportsSettings'))
			INSERT INTO cf_SurveyConfig VALUES ('DefaultMetricsReportsSettings',CAST(@DefaultMetricsReportsSettings AS NVARCHAR(MAX)),GETUTCDATE())
		END
		DECLARE @OldXML XML = (SELECT CAST(Value AS XML) FROM cf_SurveyConfig WITH (NOLOCK) WHERE Name = 'MetricsQueriesPreviousFlags')
		INSERT INTO #OldXMLData (QueryId, OldFlags)
			SELECT	queries.value('@queryId','INT'),
					queries.value('@flags','INT')
			FROM @OldXML.nodes('/MetricsQueriesPreviousFlags/Query') Q(queries)
		/****************************** Chargeback Report **********************************
		IF (@i_reportType = 3)
		BEGIN
			DECLARE @status NVARCHAR(MAX)
			DECLARE @indFlag NVARCHAR(MAX)
			DECLARE @wwFlag NVARCHAR(MAX)
			SELECT @status = CASE
								WHEN Flags <> 0 THEN 'Enabled'
								ELSE 'Disabled'
							END,
					@indFlag = CASE
								WHEN Flags <> 0 THEN 'Yes'
								ELSE 'No'
							END,
					@wwFlag = CASE
								WHEN Flags <> 0 THEN 'Yes'
								ELSE 'No'
							END
			FROM cf_CommServSurveyQueries WITH (NOLOCK)
			WHERE QueryId = 72
			INSERT INTO #MetricsQueries VALUES ('Chargeback', 'Storage Usage and Chargeback', NULL, @status, @indFlag, @wwFlag, 72, @i_reportType)
		END
		**************************************************************************************/
		INSERT INTO #MetricsQueries (ReportName, Description, Retention, Status, CommCell, Worldwide, General, Health, Activity, Chargeback, Audit, ReportId, ReportType)
			SELECT	Name,
					Description,
					DataRetentionDays,
					CASE
						WHEN Flags <> 0 THEN 'Enabled'
						ELSE 'Disabled'
					END,
					CASE
						WHEN (Flags & 321) <> 0 --OR (Flags = 0 AND OldFlags IS NOT NULL AND (OldFlags & 321) <> 0 )
							THEN 'Yes'
							ELSE 'No'
					END,
					CASE
						WHEN (Flags & 641) <> 0 --OR (Flags = 0 AND OldFlags IS NOT NULL AND (OldFlags & 641) <> 0 )
							THEN 'Yes'
							ELSE 'No'
					END,
					CASE
						WHEN (Flags & 193) <> 0 --OR (Flags = 0 AND OldFlags IS NOT NULL AND (OldFlags & 4) <> 0 )
							THEN 'Yes'
							ELSE 'No'
					END,
					CASE
						WHEN (Flags & 4) <> 0 --OR (Flags = 0 AND OldFlags IS NOT NULL AND (OldFlags & 4) <> 0 )
							THEN 'Yes'
							ELSE 'No'
					END,
					CASE
						WHEN (Flags & 8) <> 0 --OR (Flags = 0 AND OldFlags IS NOT NULL AND (OldFlags & 8) <> 0 )
							THEN 'Yes'
							ELSE 'No'
					END,
					CASE
						WHEN (12 IN (SELECT GroupId FROM cf_CommservSurveyGroupMap WITH (NOLOCK) WHERE SurveyId = CSQ.QueryId)) AND Flags <> 0
							THEN 'Yes'
							ELSE 'No'
					END,
					CASE
						WHEN (11 IN (SELECT GroupId FROM cf_CommservSurveyGroupMap WITH (NOLOCK) WHERE SurveyId = CSQ.QueryId)) AND Flags <> 0
							THEN 'Yes'
							ELSE 'No'
					END,
					CSQ.QueryId,
					CASE
						WHEN (((Flags & 4) <> 0) AND ((Flags & 193) = 0)) OR (Flags = 0 AND ((OldFlags & 4) <> 0 ) AND ((OldFlags & 193) = 0)) OR		--health reports for which Individual/worldwide flags are not set
						(Flags & 4 = 0 AND ((Flags & 8) <> 0 OR (Flags = 0 AND (OldFlags & 8) = 0))) OR													--activity reports
						12 IN (SELECT GroupId FROM cf_CommservSurveyGroupMap WITH (NOLOCK) WHERE SurveyId = CSQ.QueryId)								--chargeback reports
						--11 IN (SELECT GroupId FROM cf_CommservSurveyGroupMap WITH (NOLOCK) WHERE SurveyId = CSQ.QueryId)								--audit reports
								THEN 0
						ELSE 1																															--general reports
					END
			FROM cf_CommservSurveyQueries CSQ WITH (NOLOCK) LEFT OUTER JOIN #OldXMLData OLD ON CSQ.QueryId = OLD.QueryId
			WHERE NOT (CSQ.Flags = 0 AND OldFlags IS NULL)	-- excluding reports that were disabled by default
			  AND CSQ.QueryId < 10000						-- excluding custom reports
			  AND CSQ.QueryId <> 137						-- Excluding internal report 137
		UPDATE #MetricsQueries
		SET ReportType = ReportType | 2
		FROM cf_CommservSurveyQueries CSQ WITH (NOLOCK) LEFT OUTER JOIN #OldXMLData OLD ON CSQ.QueryId = OLD.QueryId
		WHERE ReportId = CSQ.QueryId
			AND ((Flags & 4) <> 0 OR (OldFlags & 4) <> 0)
		UPDATE #MetricsQueries
		SET ReportType = ReportType | 4
		FROM cf_CommservSurveyQueries CSQ WITH (NOLOCK) LEFT OUTER JOIN #OldXMLData OLD ON CSQ.QueryId = OLD.QueryId
		WHERE ReportId = CSQ.QueryId
			AND ((Flags & 8) <> 0 OR (OldFlags & 8) <> 0)
			AND ReportId <> 23
		UPDATE #MetricsQueries
		SET ReportType = ReportType | 8
		FROM cf_CommservSurveyQueries WITH (NOLOCK)
		WHERE ReportId = QueryId
			AND 12 IN (SELECT GroupId FROM cf_CommservSurveyGroupMap WITH (NOLOCK) WHERE SurveyId = QueryId)
		UPDATE #MetricsQueries
		SET ReportType = ReportType | 16
		FROM cf_CommservSurveyQueries WITH (NOLOCK)
		WHERE ReportId = QueryId
			AND 11 IN (SELECT GroupId FROM cf_CommservSurveyGroupMap WITH (NOLOCK) WHERE SurveyId = QueryId)
		UPDATE #MetricsQueries
		SET ReportType = ReportType | 1
		FROM cf_CommservSurveyQueries CSQ WITH (NOLOCK) LEFT OUTER JOIN #OldXMLData OLD ON CSQ.QueryId = OLD.QueryId
		WHERE ReportId = CSQ.QueryId
			AND ((Flags = 0 AND (OldFlags & 193) <> 0) OR ReportType = 0)
		IF (@i_reportType <> -1 AND @i_repType LIKE 'enabled')				--gives all enabled reports of specified report type
		BEGIN
			SELECT ReportName AS 'Report Name<reportConfigurationActions>', Description, Retention AS [Retention in Days],  Status, CommCell AS [CommCell<booleanRenderer>],
				Worldwide AS [Worldwide<booleanRenderer>], ReportId AS 'ReportId<DONOTSHOW>'
			FROM #MetricsQueries
			WHERE (ReportType & POWER(2,@i_reportType)) <> 0 AND Status like 'Enabled'
			ORDER BY ReportName ASC, Retention DESC
		END
		ELSE IF (@i_reportType <> -1)										--gives all reports of specified report type
		BEGIN
			SELECT ReportName AS 'Report Name<reportConfigurationActions>', Description, Retention AS [Retention in Days],  Status, CommCell AS [CommCell<booleanRenderer>],
				Worldwide AS [Worldwide<booleanRenderer>], ReportId AS 'ReportId<DONOTSHOW>'
			FROM #MetricsQueries
			WHERE (ReportType & POWER(2,@i_reportType)) <> 0
			ORDER BY ReportName ASC, Retention DESC
		END
		ELSE																--gives all reports
		BEGIN
			SELECT CASE WHEN RN.ReportName IS NULL THEN MQ.ReportName ELSE RN.ReportName END AS 'Report Name<reportConfigurationActions>',
				Description, Retention AS [Retention in Days],  Status, CommCell AS [CommCell<booleanRenderer>],
				Worldwide AS [Worldwide<booleanRenderer>], General AS [General<booleanRenderer>], Health AS [Health<booleanRenderer>], Activity AS [Activity<booleanRenderer>], Chargeback AS [Chargeback<booleanRenderer>], Audit AS [Audit<booleanRenderer>], ReportId AS 'ReportId<DONOTSHOW>'
			FROM #MetricsQueries MQ LEFT OUTER JOIN #ReportNameOverride RN ON MQ.ReportId = RN.QueryId
			ORDER BY (CASE WHEN RN.ReportName IS NULL THEN MQ.ReportName ELSE RN.ReportName END) ASC, Retention DESC
		END
		DROP TABLE #MetricsQueries
	END
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetMetricsQueryInfo')
	delete from GxQscripts where name = 'RptGetMetricsQueryInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetMetricsQueryInfo')
	delete from GXDBVersions where aliasname = 'RptGetMetricsQueryInfo'
GO

insert into GXDBVersions values(2, 'RptGetMetricsQueryInfo',  '00000000000000000000', 'RptGetMetricsQueryInfo', '00000000000000000000')
GO

