

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptGetClientBackupJobs.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptGetClientBackupJobs.sp,v $ $Id: RptGetClientBackupJobs.sp,v 1.1.4.9 2018/08/16 11:34:26 skatz Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptGetClientBackupJobs <<<'

IF EXISTS (select * from sysobjects where name='RptGetClientBackupJobs')
	drop procedure RptGetClientBackupJobs
IF EXISTS (select * from GxQscripts where name='RptGetClientBackupJobs')
	delete from GxQscripts where name = 'RptGetClientBackupJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetClientBackupJobs')
	delete from GXDBVersions where aliasname = 'RptGetClientBackupJobs'
GO
print '... Creating Procedure: RptGetClientBackupJobs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptGetClientBackupJobs
  @inputFileName NVARCHAR(MAX) = NULL
AS
SET NOCOUNT ON
IF OBJECT_ID('tempdb..#tempInput') IS NOT NULL
    DROP TABLE #tempInput
CREATE TABLE #tempInput (clientName NVARCHAR(MAX),dbInstanceName NVARCHAR(MAX), StartTime DATETIME, EndTime DATETIME, StartTimeInt INT, EndTimeInt INT )
IF OBJECT_ID('tempdb..#tempOutput') IS NOT NULL
    DROP TABLE #tempOutput
CREATE TABLE #tempOutput (CommservUniqueId BIGINT, CommcellId BIGINT, CommServName NVARCHAR(256), ClientId BIGINT, ClientName NVARCHAR(256), PhysicalClientName NVARCHAR(255), AgentId BIGINT, AgentName NVARCHAR(256), Instance NVARCHAR(512), BackupSet NVARCHAR(128), SubClientId BIGINT,
	SubClientName NVARCHAR(128), PolicyId BIGINT, JobId BIGINT, StartDate BIGINT, EndDate BIGINT, Status INT, OpType INT, BkpLevel INT, ScanType INT, DataProtected BIGINT, DataCompressed BIGINT, DataTransferred BIGINT, DataWritten BIGINT, SizeChangePct INT, TransferTime INT, StoragePolicy NVARCHAR(144), SchedulePolicy NVARCHAR(256), ScheduleName NVARCHAR(256), Attempts INT, ErrorCode NVARCHAR(32), FailureReason NVARCHAR(512),
	failureErrorCode INT)
IF OBJECT_ID('tempdb..#tempClientInput') IS NOT NULL
    DROP TABLE #tempClientInput
CREATE TABLE #tempClientInput
(ClientName NVARCHAR(256),
DbInstanceName NVARCHAR(256),
StartDate NVARCHAR(128),
EndDate NVARCHAR(128))
DECLARE @sql NVARCHAR(MAX)
SET @sql = 'BULK INSERT #tempClientInput FROM ''' + @inputFileName + '''WITH ( FIELDTERMINATOR = '','', CODEPAGE = ''OEM'', DATAFILETYPE = ''char'', ROWTERMINATOR = ''\n'' )'
exec (@sql)
Update #tempClientInput   set clientName = subString(clientName, 5, 99) where ClientName like N'∩╗┐%'   -- SKSKSKS
--select tbl='#tempClientInput', * from #tempClientInput  --SKSKSKSK
IF OBJECT_ID('tempdb..#tempDates') IS NOT NULL
    DROP TABLE #tempDates
CREATE TABLE #tempDates (datelist DATETIME)
DECLARE @dt DATETIME
DECLARE @dtEnd DATETIME
SELECT @dt = min(Cast(StartDate AS DATETIME)), @dtEnd = MAX(Cast(EndDate AS DATETIME)) from #tempClientInput
WHILE (@dt <= @dtEnd) BEGIN
    insert into #tempDates
        values(@dt)
    SET @dt = DATEADD(day, 1, @dt)
END
IF OBJECT_ID('tempdb..#tempClientDates') IS NOT NULL
    DROP TABLE #tempClientDates
CREATE TABLE #tempClientDates (clientName NVARCHAR(MAX),dbInstanceName NVARCHAR(MAX), DT DATETIME, StartTimeInt INT, EndTimeInt INT )
INSERT INTO #tempClientDates
SELECT C.ClientName, C.DbInstanceName, D.datelist, dbo.GetUnixTimeBig(D.datelist), dbo.GetUnixTimeBig( DATEADD(d, 1, D.datelist )) - 1 FROM #tempClientInput C
	INNER JOIN #tempDates D
	ON CONVERT(date, D.datelist) between CONVERT(date, C.StartDate) AND CONVERT(date, C.EndDate)
IF OBJECT_ID('tempdb..#tempDates') IS NOT NULL
    DROP TABLE #tempDates
INSERT INTO #tempInput
SELECT LTRIM(RTRIM(ClientName)),
	LTRIM(RTRIM(DbInstanceName)),
	StartDate,
	EndDate,
	dbo.GetUnixTimeBig(StartDate),
	dbo.GetUnixTimeBig( DATEADD(d, 1, EndDate )) - 1
FROM #tempClientInput
IF OBJECT_ID('tempdb..#tempClientInput') IS NOT NULL
    DROP TABLE #tempClientInput
INSERT INTO #tempOutput
SELECT CC.ID,
	CC.CommCellID,
	CC.CommServName,
	SA.ClientId,
	SA.clientName,  --SKSKSK
	ISNULL(SA.PhysicalClientName,SA.clientName),
	SA.AppTypeId,
	SA.AgentName,
	SA.InstanceName,
	SA.BackupsetName,
	SA.AppId,
	SA.SubclientName,
	SA.DataPolicyId,
	J.JobId,
	J.StartDate,
	J.EndDate,
	J.Status,
	J.OpType,
	J.BkpLevel,
	J.ScanType,
	J.DataProtected,
	J.DataCompressed,
	J.DataTransferred,
	J.DataWritten,
	J.SizeChangePct,
	J.TransferTime,
	J.StoragePolicy,
	J.SchedulePolicy,
	J.ScheduleName,
	J.Attempts,
	J.ErrorCode,
	J.FailureReason,
	J.failureErrorCode
	FROM #tempInput AS I
	INNER JOIN cf_SurveySubclientAssociation SA  WITH(NOLOCK)
	ON SA.ClientName = I.clientName OR SA.InstanceName = I.dbInstanceName
	INNER JOIN cf_SurveyJobStats J  WITH(NOLOCK)
	ON J.CommservUniqueId = SA.CommservUniqueId AND (J.EndDate between I.StartTimeInt and I.EndTimeInt OR  J.StartDate between I.StartTimeInt and I.EndTimeInt)  AND J.AppId = SA.AppId
	INNER JOIN cf_CommcellIdNameMap as CC  WITH(NOLOCK)
	ON CC.ID = SA.CommservUniqueId
INSERT INTO #tempOutput
SELECT DISTINCT
	CC.ID,
	CC.CommCellID,
	CC.CommServName,
	SA.ClientId,
	SA.clientName,
	ISNULL(SA.PhysicalClientName,SA.clientName),
	0, --AppTypeId
	'NA', --AgentName
	'NA', --InstanceName
	'NA', --BackupsetName
	0, --AppId
	'NA', --SubclientName
	0, --DataPolicyId
	0, --JobId
	I.StartTimeInt, --StartDate
	I.StartTimeInt, --EndDate
	17, --Status
	0, --OpType
	0, --BkpLevel
	0, --ScanType
	0, --DataProtected
	0, --DataCompressed
	0, --DataTransferred
	0, --DataWritten
	0, --SizeChangePct
	0, --TransferTime
	0, --StoragePolicy
	0, --SchedulePolicy
	'NA', --ScheduleName
	0, --Attempts
	0, --ErrorCode
	'NA', --FailureReason
	0
FROM #tempClientDates I
LEFT OUTER JOIN #tempOutput O
ON (I.clientName = O.ClientName OR I.dbInstanceName = O.Instance) AND Convert(date, I.DT) between Convert(date, dbo.GetDateTime(O.StartDate)) and Convert(date, dbo.GetDateTime(O.EndDate) )
INNER JOIN cf_SurveySubclientAssociation SA  WITH(NOLOCK)
ON (SA.ClientName = I.clientName OR SA.instanceName = I.dbInstanceName)
INNER JOIN cf_CommcellIdNameMap as CC  WITH(NOLOCK)
ON SA.CommservUniqueId = CC.ID
WHERE O.ClientName is NULL OR
O.Instance is NULL
INSERT INTO #tempOutput
SELECT DISTINCT
	0,
	0,
	'NA',
	0,
	I.clientName,
	I.clientName,
	0, --AppTypeId
	'NA', --AgentName
	'NA', --InstanceName
	'NA', --BackupsetName
	0, --AppId
	'NA', --SubclientName
	0, --DataPolicyId
	0, --JobId
	I.StartTimeInt, --StartDate
	I.StartTimeInt, --EndDate
	17, --Status
	0, --OpType
	0, --BkpLevel
	0, --ScanType
	0, --DataProtected
	0, --DataCompressed
	0, --DataTransferred
	0, --DataWritten
	0, --SizeChangePct
	0, --TransferTime
	0, --StoragePolicy
	0, --SchedulePolicy
	'NA', --ScheduleName
	0, --Attempts
	0, --ErrorCode
	'NA', --FailureReason
	0
FROM #tempClientDates I
LEFT OUTER JOIN #tempOutput O
ON (I.clientName = O.ClientName OR I.dbInstanceName = O.Instance) AND Convert(date, I.DT) between Convert(date, dbo.GetDateTime(O.StartDate)) and Convert(date, dbo.GetDateTime(O.EndDate) )
WHERE O.ClientName is NULL and
O.Instance is NOT NULL
SELECT DISTINCT CommServName AS CommServName,
	ClientName AS Client,
	PhysicalClientName AS PhysicalClientName,
	AgentName AS Agent,
	Instance AS Instance,
	BackupSet AS BackupSet,
	SubClientName AS SubClient,
	JobId AS JobId,
	DATEADD(second, StartDate, CAST('1970-01-01 00:00:00' AS datetime)) AS 'StartDate',
	DATEADD(second, EndDate, CAST('1970-01-01 00:00:00' AS datetime)) AS 'EndDate',
	CASE Status
		  WHEN 0 THEN 'Running'
		  WHEN 1 THEN 'Completed'
		  WHEN 2 THEN 'Failed'
		  WHEN 3 THEN 'Completed with errors'
		  WHEN 4 THEN 'Killed'
		  WHEN 5 THEN 'Suspended'
		  WHEN 6 THEN 'Interrupted'
		  WHEN 7 THEN 'Any Status'
		  WHEN 8 THEN 'Skipped'
		  WHEN 9 THEN   CASE WHEN failureErrorCode NOT IN (8)  THEN 'Skipped' ELSE 'Failed To Start' END
		  WHEN 10 THEN 'Synchronized'
		  WHEN 11 THEN 'Not Synchronized'
		  WHEN 12 THEN 'Not Attempted'
		  WHEN 13 THEN 'Started'
		  WHEN 14 THEN 'Completed with warnings'
		  WHEN 15 THEN 'System Failed'
		  WHEN 16 THEN 'Committed'
		  ELSE 'NA'
	END AS 'Job Status',
	CASE OpType
		  WHEN 4 THEN (CASE WHEN AgentId = 67 THEN N'Compliance Archive' ELSE N'Backup' END)
		  WHEN 14 THEN N'Synthetic Full'
		  WHEN 18 THEN N'Backup 3RD'
		  WHEN 59 THEN N'Snap Backup'
		  WHEN 60 THEN N'Backup Copy'
		  WHEN 65 THEN N'Snap Backup3RD'
		  ELSE N'NA'
	END AS 'Operation',
	CASE BkpLevel
		  WHEN 1 THEN (CASE WHEN AgentId IN (45,56,57,58,67,73) THEN N'New Index' ELSE N'Full' END)
		  WHEN 2 THEN (CASE WHEN AgentId IN (4,5,16,70,81) THEN N'Transaction Log' WHEN AgentId = 125 THEN N'Log Only' ELSE N'Incremental' END)
		  WHEN 4 THEN (CASE WHEN AgentId IN (37,62) THEN N'Delta' ELSE N'Differential' END)
		  WHEN 0x40    THEN N'Synthetic Full' WHEN 0x80 THEN N'Synthetic Full' WHEN 0x4000 THEN N'Synthetic Full'
		  WHEN 0x100   THEN (CASE WHEN AgentId = 104 THEN N'Incremental' ELSE N'Transaction Log' END)
		  WHEN 0x200   THEN N'ASR'
		  WHEN 0x800   THEN N'Snapshot'
		  WHEN 0x1000  THEN N'New Volume Creation'
		  WHEN 0x2000  THEN N'Incremental Volume Update'
		  WHEN 0x400   THEN N'Offline Full'
		  WHEN 0x8000  THEN N'Online Full'
		  WHEN 0x20000 THEN N'Analysis'
		  WHEN 0x40000 THEN N'Discovery'
		  ELSE N'NA'
	END AS 'Job Type',
	CASE ScanType
		  WHEN 1 THEN 'Change Journal'
		  WHEN 2 THEN 'Classic'
		  WHEN 3 THEN 'Mixed'
		  WHEN 4 THEN 'Optimized Scan'
		  ELSE ''
	END AS 'Scan Type',
	CAST(DataProtected/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Application Size (MB)',
	CAST((CASE WHEN DataProtected > 0 AND DataProtected > DataCompressed THEN 100.0*(DataProtected - DataCompressed)/DataProtected ELSE 0 END)
		  AS DECIMAL(20,2)) AS 'Compression Rate (%)',
	CAST(DataTransferred/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Data Transferred (MB)',
	CAST(DataWritten/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Data Written (MB)',
	CAST((CASE WHEN DataProtected > 0 AND DataProtected > DataWritten THEN 100.0*(DataProtected - DataWritten)/DataProtected ELSE 0 END)
		  AS DECIMAL(10,2)) AS 'Space Saving (%)',
	SizeChangePct AS 'Data Size Change (%)',
	CONVERT(VARCHAR(20), DATEADD(SECOND, TransferTime, 0), 108) AS 'Transfer Time',
	CAST((CASE WHEN TransferTime > 0 THEN 3600.0*DataProtected/1024.0/1024.0/1024.0/TransferTime ELSE 0.0 END)
		  AS DECIMAL(10,3)) AS 'Throughput (GB/Hour)',
	StoragePolicy AS 'Storage Policy',
	SchedulePolicy AS 'Schedule Policy',
	ScheduleName AS 'Schedule Name',
	Attempts AS 'Job Attempts',
	ErrorCode AS 'Error Code',
	FailureReason AS 'Failure Reason'
FROM #tempOutput A
ORDER BY CommServName, ClientName, JobId desc
IF OBJECT_ID('tempdb..#tempClientDates') IS NOT NULL
    DROP TABLE #tempClientDates
IF OBJECT_ID('tempdb..#tempInput') IS NOT NULL
    DROP TABLE #tempInput
IF OBJECT_ID('tempdb..#tempOutput') IS NOT NULL
    DROP TABLE #tempOutput
SET NOCOUNT OFF
GO
/*
/*  USE THE FOLLOWING TO CREATE A DATA INPUT FILE THAT'S NEEDED TO RUN THE SP:
select DISTINCT top 6 clientName   +', '
                     +InstanceName +', '
					 +CAST(getDate() as varchar(256)) +', '
					 +CAST(DAteAdd(year, -1, getDate()) as varchar(256))
					  from cf_SurveySubclientAssociation where InstanceName <> ''
*/
--STANDALONE:
  DECLARE @inputFileName NVARCHAR(MAX) = NULL
exec RptGetClientBackupJobs @inputFileName
*/

IF EXISTS (select * from GxQscripts where name = 'RptGetClientBackupJobs')
	delete from GxQscripts where name = 'RptGetClientBackupJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetClientBackupJobs')
	delete from GXDBVersions where aliasname = 'RptGetClientBackupJobs'
GO

insert into GXDBVersions values(2, 'RptGetClientBackupJobs',  '00010001000400090000', 'RptGetClientBackupJobs', '00010001000400090000')
GO

