

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptGetClientBackupDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptGetClientBackupDetails.sp,v $ $Id: RptGetClientBackupDetails.sp,v 1.1.4.5 2018/08/16 11:33:14 skatz Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptGetClientBackupDetails <<<'

IF EXISTS (select * from sysobjects where name='RptGetClientBackupDetails')
	drop procedure RptGetClientBackupDetails
IF EXISTS (select * from GxQscripts where name='RptGetClientBackupDetails')
	delete from GxQscripts where name = 'RptGetClientBackupDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetClientBackupDetails')
	delete from GXDBVersions where aliasname = 'RptGetClientBackupDetails'
GO
print '... Creating Procedure: RptGetClientBackupDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptGetClientBackupDetails
  @CommCellID NVARCHAR(10) = NULL,
  @clientName NVARCHAR(MAX) = NULL,
  @startTime DATETIME = NULL,
  @endTime DATETIME = NULL
AS
SET NOCOUNT ON
DECLARE @ccId INT = 0
IF (@CommCellID IS NOT NULL)
	SELECT @ccId = dbo.ConvertHexToInt(@CommCellID)
DECLARE @startTimeInt INT = 0
DECLARE @endTimeInt INT = 0
SELECT @startTimeInt = (DATEDIFF(s, '1970-01-01 00:00:00', @startTime))
SELECT @endTimeInt = (DATEDIFF(s, '1970-01-01 00:00:00', @endTime))
SELECT
	CAST(CC.CommCellID AS INT) AS CommCellID,
	CC.CommServName AS CommServName,
	SA.ClientId AS 'ClientID',
	ISNULL(CL.clientDisplayName, SA.clientName) AS Client,
	ISNULL(SA.PhysicalClientName,SA.clientName) AS PhysicalClientName,
	SA.AppTypeId AS 'AgentID',
	SA.AgentName AS 'Agent',
	SA.InstanceId AS 'InstanceID',
	SA.InstanceName AS 'Instance',
	SA.BackupsetId AS 'BackupSetID',
	SA.BackupsetName AS 'Backupset',
	SA.AppId AS 'SubclientID',
	SA.SubclientName AS 'Subclient',
	JobId AS 'Job ID',
	StartDate AS 'Start Time',
	DATEADD(second, StartDate, CAST('1970-01-01 00:00:00' AS datetime)) AS 'StartDate',
	EndDate AS 'End Time',
	DATEADD(second, EndDate, CAST('1970-01-01 00:00:00' AS datetime)) AS 'EndDate',
	CASE Status
		  WHEN 0 THEN 'Running'
		  WHEN 1 THEN 'Completed'
		  WHEN 2 THEN 'Failed'
		  WHEN 3 THEN 'Completed with errors'
		  WHEN 4 THEN 'Killed'
		  WHEN 5 THEN 'Suspended'
		  WHEN 6 THEN 'Interrupted'
		  WHEN 7 THEN 'Any Status'
		  WHEN 8 THEN 'Skipped'
		  WHEN 9 THEN   CASE WHEN failureErrorCode NOT IN (8)  THEN 'Skipped' ELSE 'Failed To Start' END
		  WHEN 10 THEN 'Synchronized'
		  WHEN 11 THEN 'Not Synchronized'
		  WHEN 12 THEN 'Not Attempted'
		  WHEN 13 THEN 'Started'
		  WHEN 14 THEN 'Completed with warnings'
		  WHEN 15 THEN 'System Failed'
		  WHEN 16 THEN 'Committed'
		  ELSE 'Unknown'
	END AS 'Job Status',
	CASE OpType
		  WHEN 4 THEN (CASE WHEN SA.AppTypeId = 67 THEN N'Compliance Archive' ELSE N'Backup' END)
		  WHEN 14 THEN N'Synthetic Full'
		  WHEN 18 THEN N'Backup 3RD'
		  WHEN 59 THEN N'Snap Backup'
		  WHEN 60 THEN N'Backup Copy'
		  WHEN 65 THEN N'Snap Backup3RD'
		  ELSE N'Unknown'
	END AS 'Operation',
	CASE BkpLevel
		  WHEN 1 THEN (CASE WHEN SA.AppTypeId IN (45,56,57,58,67,73) THEN N'New Index' ELSE N'Full' END)
		  WHEN 2 THEN (CASE WHEN SA.AppTypeId IN (4,5,16,70,81) THEN N'Transaction Log' WHEN SA.AppTypeId = 125 THEN N'Log Only' ELSE N'Incremental' END)
		  WHEN 4 THEN (CASE WHEN SA.AppTypeId IN (37,62) THEN N'Delta' ELSE N'Differential' END)
		  WHEN 0x40    THEN N'Synthetic Full' WHEN 0x80 THEN N'Synthetic Full' WHEN 0x4000 THEN N'Synthetic Full'
		  WHEN 0x100   THEN (CASE WHEN SA.AppTypeId = 104 THEN N'Incremental' ELSE N'Transaction Log' END)
		  WHEN 0x200   THEN N'ASR'
		  WHEN 0x800   THEN N'Snapshot'
		  WHEN 0x1000  THEN N'New Volume Creation'
		  WHEN 0x2000  THEN N'Incremental Volume Update'
		  WHEN 0x400   THEN N'Offline Full'
		  WHEN 0x8000  THEN N'Online Full'
		  WHEN 0x20000 THEN N'Analysis'
		  WHEN 0x40000 THEN N'Discovery'
		  ELSE N'Unknown'
	END AS 'Job Type',
	CASE ScanType
		  WHEN 1 THEN 'Change Journal'
		  WHEN 2 THEN 'Classic'
		  WHEN 3 THEN 'Mixed'
		  WHEN 4 THEN 'Optimized Scan'
		  ELSE ''
	END AS 'Scan Type',
	CAST(DataProtected/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Application Size (MB)',
	CAST((CASE WHEN DataProtected > 0 AND DataProtected > DataCompressed THEN 100.0*(DataProtected - DataCompressed)/DataProtected ELSE 0 END)
		  AS DECIMAL(20,2)) AS 'Compression Rate (%)',
	CAST(DataTransferred/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Data Transferred (MB)',
	CAST(DataWritten/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Data Written (MB)',
	CAST((CASE WHEN DataProtected > 0 AND DataProtected > DataWritten THEN 100.0*(DataProtected - DataWritten)/DataProtected ELSE 0 END)
		  AS DECIMAL(10,2)) AS 'Space Saving (%)',
	SizeChangePct AS 'Data Size Change (%)',
	CONVERT(VARCHAR(20), DATEADD(SECOND, TransferTime, 0), 108) AS 'Transfer Time',
	CAST((CASE WHEN TransferTime > 0 THEN 3600.0*DataProtected/1024.0/1024.0/1024.0/TransferTime ELSE 0.0 END)
		  AS DECIMAL(20,3)) AS 'Throughput (GB/Hour)',  -- 20180806  -SK  Was causing arithmetic overflow as (10,3) on test data
	J.StoragePolicy AS 'Storage Policy',
	ErrorCode AS 'Error Code',
	FailureReason AS 'Failure Reason',
	SchedulePolicy AS 'Schedule Policy',
	ScheduleName AS 'Schedule Name',
	Attempts AS 'Job Attempts'
FROM
	cf_CommcellIdNameMap as CC WITH (NOLOCK)
	INNER JOIN cf_SurveyJobStats J WITH (NOLOCK)
            ON CC.ID = J.CommservUniqueId AND J.EndDate between @startTimeInt and @endTimeInt
    INNER JOIN cf_SurveySubclientAssociation SA WITH (NOLOCK)
		ON J.CommservUniqueId = SA.CommservUniqueId AND J.AppId = SA.AppId
	LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = SA.CommServUniqueId AND CL.ClientId = SA.ClientId
WHERE	(@ccId = 0 OR CC.CommCellID = @ccId)
	AND ((ISNULL(@clientName, '') = '') OR ISNULL(CL.clientDisplayName, SA.clientName) = @clientName)
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE TESTING:
  DECLARE @i_CommServUniqueID INT		= 0
  DECLARE @clientName NVARCHAR(MAX)		= NULL
  DECLARE @i_LogDateEND DATETIME		= getDate()
  DECLARE @i_LogDateStart DATETIME		= DateAdd(Month, -36, @i_LogDateEND)
exec RptGetClientBackupDetails @i_CommServUniqueID, @clientName, @i_LogDateStart, @i_LogDateEND
*/

IF EXISTS (select * from GxQscripts where name = 'RptGetClientBackupDetails')
	delete from GxQscripts where name = 'RptGetClientBackupDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetClientBackupDetails')
	delete from GXDBVersions where aliasname = 'RptGetClientBackupDetails'
GO

insert into GXDBVersions values(2, 'RptGetClientBackupDetails',  '00010001000400050000', 'RptGetClientBackupDetails', '00010001000400050000')
GO

