

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptGUILoginLanguageSurvey.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptGUILoginLanguageSurvey.sp,v $ $Id: RptGUILoginLanguageSurvey.sp,v 1.6.14.1 2016/06/06 23:37:49 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptGUILoginLanguageSurvey <<<'

IF EXISTS (select * from sysobjects where name='RptGUILoginLanguageSurvey')
	drop procedure RptGUILoginLanguageSurvey
IF EXISTS (select * from GxQscripts where name='RptGUILoginLanguageSurvey')
	delete from GxQscripts where name = 'RptGUILoginLanguageSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGUILoginLanguageSurvey')
	delete from GXDBVersions where aliasname = 'RptGUILoginLanguageSurvey'
GO
print '... Creating Procedure: RptGUILoginLanguageSurvey'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptGUILoginLanguageSurvey
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
DECLARE @i_QueryId BIGINT = 5
IF(@blaggregate=1)
SELECT DISTINCT
	csInfo.LoginLanguage AS 'Language',
	SUM (csInfo.LoginCount) AS 'Login Count',
	COUNT (csInfo.CommServUniqueId) AS 'CommCell Count'
FROM cf_SurveyGUILoginInfo AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND resultView.LogDateUTC = csInfo.LogDateUTC
		AND resultView.CommServUniqueId = csInfo.CommServUniqueId
		AND resultView.SurveyID = @i_QueryId
		AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
		AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
		AND csInfo.LoginLanguage IS NOT NULL
GROUP BY csInfo.LoginLanguage
ORDER BY [Login Count] DESC
ELSE
BEGIN
IF @i_CommServUniqueID = 0
BEGIN
SELECT
	resultView.CommServUniqueId AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	resultView.CommServIP AS 'CommServe IP<HIDDEN>',
	resultView.CommServGUID AS 'CommServer GUID',
	resultView.DisplayName AS 'CommCell Name',
	DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(csInfo.LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME>',
	ISNULL(resultView.CommServTimeZone, '')  AS 'Time Zone',
	CASE
		WHEN resultView.RunningTime = -1 THEN 'N/A'
		ELSE CAST(resultView.RunningTime AS VARCHAR(MAX))
	END AS 'Running Time in Seconds',
	ISNULL(csInfo.LoginLanguage, 'N/A') AS 'Language',
	ISNULL(csInfo.LoginCount, 0) as 'Login Count'
FROM cf_SurveyGUILoginInfo AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND resultView.LogDateUTC = csInfo.LogDateUTC
		AND resultView.CommServUniqueId = csInfo.CommServUniqueId
		AND csInfo.LoginLanguage IS NOT NULL
ORDER BY csInfo.LogDateUTC DESC, resultView.DisplayName ASC
END
ELSE
SELECT
	csInfo.CommServUniqueId AS 'CommServ UniqueId',
	DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(csInfo.LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME>',
	CASE
		WHEN resultView.RunningTime = -1 THEN 'N/A'
		ELSE CAST(resultView.RunningTime AS VARCHAR(MAX))
	END AS 'Running Time in Seconds',
	ISNULL(csInfo.LoginLanguage, 'N/A') AS 'Language',
	ISNULL(csInfo.LoginCount, 0) as 'Login Count'
FROM cf_SurveyGUILoginInfo AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND resultView.LogDateUTC = csInfo.LogDateUTC
		AND resultView.CommServUniqueId = csInfo.CommServUniqueId
		AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
		AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
		AND csInfo.LoginLanguage IS NOT NULL
ORDER BY csInfo.LogDateUTC DESC
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGUILoginLanguageSurvey')
	delete from GxQscripts where name = 'RptGUILoginLanguageSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGUILoginLanguageSurvey')
	delete from GXDBVersions where aliasname = 'RptGUILoginLanguageSurvey'
GO

insert into GXDBVersions values(2, 'RptGUILoginLanguageSurvey',  '00010006001400010000', 'RptGUILoginLanguageSurvey', '00010006001400010000')
GO

