

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptDeDupStoreConfig.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptDeDupStoreConfig.sp,v $ $Id: RptDeDupStoreConfig.sp,v 1.9.56.3 2018/08/16 11:32:26 skatz Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptDeDupStoreConfig <<<'

IF EXISTS (select * from sysobjects where name='RptDeDupStoreConfig')
	drop procedure RptDeDupStoreConfig
IF EXISTS (select * from GxQscripts where name='RptDeDupStoreConfig')
	delete from GxQscripts where name = 'RptDeDupStoreConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDeDupStoreConfig')
	delete from GXDBVersions where aliasname = 'RptDeDupStoreConfig'
GO
print '... Creating Procedure: RptDeDupStoreConfig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptDeDupStoreConfig
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
IF(@blaggregate=1)
	RETURN
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 61
IF @i_CommServUniqueID = 0
BEGIN
SELECT
	sub.CommServUniqueId AS 'CommServ UniqueId',
	sub.CommCellID AS 'CommCell ID',
	sub.CommCellName AS 'CommCell Name',
	sub.MediaAgentName AS 'Media Agent',
	sub.SIDBCountForMA AS 'DDB Count',
	sub.SubstoreCountForMA AS 'DDB Partition Count'
FROM
(
SELECT
	csInfo.CommServUniqueId,
	resultView.CommCellID AS 'CommCellID',
	resultView.DisplayName AS 'CommCellName',
	DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(csInfo.LogDate, '1970-01-01 00:00:00')) AS 'CollectionTime',
	ISNULL(resultView.CommServTimeZone, '')  AS 'TimeZone',
	CASE
		WHEN resultView.RunningTime = -1 THEN 'N/A'
		ELSE CAST(resultView.RunningTime AS VARCHAR(MAX))
	END AS 'RunningTime',
	ISNULL (CL.ClientDisplayName, csInfo.MediaAgentName) AS 'MediaAgentName',
	csInfo.SIDBCountForMA,
	csInfo.SubstoreCountForMA
FROM cf_SurveyDeDupStoreConfig AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId AND	csInfo.MediaAgentId > 1
	LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = csInfo.CommServUniqueId AND CL.ClientId = CSInfo.MediaAgentId
) AS sub
GROUP BY
	sub.CommServUniqueId,
	sub.CommCellID,
	sub.CommCellName,
	sub.CollectionTime,
	sub.TimeZone,
	sub.RunningTime,
	sub.MediaAgentName,
	sub.SIDBCountForMA,
	sub.SubstoreCountForMA
ORDER BY sub.CommCellName ASC
END
ELSE
SELECT
	sub.CommServUniqueId AS 'CommServ UniqueId',
	sub.MediaAgentName AS 'Media Agent',
	sub.SIDBCountForMA AS 'DDB Count',
	sub.SubstoreCountForMA AS 'DDB Partition Count',
	SUM(IsActive) AS 'Active DDB Partitions',
	SUM(IsSpecialSealed) AS 'Sealed SIDBs with 100M Rows'
FROM
(
SELECT
	csInfo.CommServUniqueId,
	ISNULL (CL.ClientDisplayName, csInfo.MediaAgentName) AS 'MediaAgentName',
	csInfo.SIDBCountForMA,
	csInfo.SubstoreCountForMA,
	CASE
		WHEN csInfo.SealedStatus = 'Active' THEN 1
		ELSE 0
	END AS 'IsActive',
	CASE
		WHEN (csInfo.SIDBStoreStatus <> 0 AND csInfo.TotalRecords >= 100000000) THEN 1
		ELSE 0
	END AS 'IsSpecialSealed'
FROM cf_SurveyDeDupStoreConfig AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId AND	csInfo.MediaAgentId > 1
	LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = csInfo.CommServUniqueId AND CL.ClientId = CSInfo.MediaAgentId
) AS sub
GROUP BY sub.CommServUniqueId, sub.MediaAgentName, sub.SIDBCountForMA, sub.SubstoreCountForMA
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE TESTING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= NULL
  DECLARE @blaggregate INT				= 0
  DECLARE @blLatestSurvey INT			= 1
  DECLARE @i_CommServUniqueID INT		= 0 -- 11065
  DECLARE @i_LogDateEND DATETIME		= 	NULL    -- getDate()
  DECLARE @i_LogDateStart DATETIME		= NULL   --DateAdd(Months, -36, @i_LogDateEND)
exec RptDeDupStoreConfig @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND
*/

IF EXISTS (select * from GxQscripts where name = 'RptDeDupStoreConfig')
	delete from GxQscripts where name = 'RptDeDupStoreConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDeDupStoreConfig')
	delete from GXDBVersions where aliasname = 'RptDeDupStoreConfig'
GO

insert into GXDBVersions values(2, 'RptDeDupStoreConfig',  '00010009005600030000', 'RptDeDupStoreConfig', '00010009005600030000')
GO

