

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptDeDupDeletedAFCount.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptDeDupDeletedAFCount.sp,v $ $Id: RptDeDupDeletedAFCount.sp,v 1.7.56.1 2016/06/06 23:36:19 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptDeDupDeletedAFCount <<<'

IF EXISTS (select * from sysobjects where name='RptDeDupDeletedAFCount')
	drop procedure RptDeDupDeletedAFCount
IF EXISTS (select * from GxQscripts where name='RptDeDupDeletedAFCount')
	delete from GxQscripts where name = 'RptDeDupDeletedAFCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDeDupDeletedAFCount')
	delete from GXDBVersions where aliasname = 'RptDeDupDeletedAFCount'
GO
print '... Creating Procedure: RptDeDupDeletedAFCount'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptDeDupDeletedAFCount
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 35
IF(@blaggregate=1 AND @i_CommServUniqueID <> 0)
	RETURN
IF(@blaggregate=1)
BEGIN
	IF @i_CommServUniqueID = 0
	BEGIN
		DECLARE @tmpCount TABLE(CSUID INT, DeletedAFCount BIGINT)
		INSERT INTO @tmpCount
		SELECT
			resultView.CommServUniqueId  AS 'CommServ UniqueId',
			csInfo.DeletedAFCount AS 'DeletedAFCount'
		FROM cf_SurveyDeDupDeletedAFCount AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
				ON resultView.SurverResultId = csInfo.SurveyResultId
				AND csInfo.DeletedAFCount > 20000
		DECLARE @range0 INT = 0
		DECLARE @range1 INT = 0
		DECLARE @range2 INT = 0
		DECLARE @range3 INT = 0
		SELECT @range0 = COUNT(DISTINCT CSUID) FROM @tmpCount WHERE DeletedAFCount < 25000
		SELECT @range1 = COUNT(DISTINCT CSUID) FROM @tmpCount WHERE DeletedAFCount >= 25000 AND DeletedAFCount < 50000
		SELECT @range2 = COUNT(DISTINCT CSUID) FROM @tmpCount WHERE DeletedAFCount >= 50000 AND DeletedAFCount < 150000
		SELECT @range1 = COUNT(DISTINCT CSUID) FROM @tmpCount WHERE DeletedAFCount >= 150000
		SELECT '< 25K' AS 'DeletedAFCount', @range0 AS 'CommCell Count'
		UNION
		SELECT '25K To 50K' AS 'DeletedAFCount', @range1 AS 'CommCell Count'
		UNION
		SELECT '50K To 150K' AS 'DeletedAFCount', @range2 AS 'CommCell Count'
		UNION
		SELECT '> 150K' AS 'DeletedAFCount', @range3 AS 'CommCell Count'
	END
END
ELSE
BEGIN
DECLARE @strGood VARCHAR(10) = '1_Good'
DECLARE @strInfo VARCHAR(10) = '2_Info'
DECLARE @strwarning VARCHAR(10) = '3_Warning'
DECLARE @strCritical VARCHAR(10) = '4_Critical'
DECLARE @criticalVal int
DECLARE @warningVal int
SELECT	@warningVal = WarningThreshold,
		@criticalVal =CriticalThreshold
FROM	cf_SurveyHealthParam where queryId = @i_QueryId
IF @i_CommServUniqueID = 0
BEGIN
SELECT
	resultView.CommServUniqueId  AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	resultView.CommServIP AS 'CommServe IP<HIDDEN>',
	resultView.CommServGUID AS 'CommServer GUID',
	resultView.DisplayName AS 'CommCell Name',
	DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(csInfo.LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME>',
	ISNULL(resultView.CommServTimeZone, '')  AS 'TimeZone',
	CASE
		WHEN resultView.RunningTime = -1 THEN 'N/A'
		ELSE CAST(resultView.RunningTime AS VARCHAR(MAX))
	END AS 'Running Time in Seconds',
	csInfo.SIDBStoreName AS 'SIDBStoreName',
	csInfo.DeletedAFCount AS 'DeletedAFCount',
	csInfo.SealedOrNot AS 'SealedOrNot',
	csInfo.DDBHost AS 'DDBHost'
FROM cf_SurveyDeDupDeletedAFCount AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND csInfo.DeletedAFCount > 20000
ORDER BY csInfo.DeletedAFCount DESC
END
ELSE
SELECT
	csInfo.CommServUniqueId AS 'CommServ UniqueId',
	csInfo.SIDBStoreName AS 'SIDBStoreName',
	csInfo.DeletedAFCount AS 'DeletedAFCount',
	csInfo.SealedOrNot AS 'SealedOrNot',
	csInfo.DDBHost AS 'DDBHost',
	CASE
		WHEN csInfo.DeletedAFCount > @criticalVal then @strCritical
		WHEN csInfo.DeletedAFCount >= @warningVal AND csInfo.DeletedAFCount <= @criticalVal  then @strWarning
		ELSE @strGood
	END AS 'Status<HEALTH_STATUS>'
FROM cf_SurveyDeDupDeletedAFCount AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND csInfo.DeletedAFCount > 20000
ORDER BY csInfo.DeletedAFCount DESC
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptDeDupDeletedAFCount')
	delete from GxQscripts where name = 'RptDeDupDeletedAFCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDeDupDeletedAFCount')
	delete from GXDBVersions where aliasname = 'RptDeDupDeletedAFCount'
GO

insert into GXDBVersions values(2, 'RptDeDupDeletedAFCount',  '00010007005600010000', 'RptDeDupDeletedAFCount', '00010007005600010000')
GO

