

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptCostParam.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptCostParam.sp,v $ $Id: RptCostParam.sp,v 1.5.56.2 2020/12/17 02:54:29 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptCostParam')
BEGIN
	print '>>> Drop Stored Procedure: RptCostParam <<<'
	drop procedure RptCostParam
END
IF EXISTS (select * from GxQscripts where name='RptCostParam')
	delete from GxQscripts where name = 'RptCostParam'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCostParam')
	delete from GXDBVersions where aliasname = 'RptCostParam'
GO
print '... Creating Procedure: RptCostParam'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptCostParam
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @i_CommServUniqueID INT = 0,
  @i_LogDateEnd DATETIME = NULL
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 72
DECLARE @TblSurveyResult TABLE (CommServUniqueId INT, SurveyResultId BIGINT)
IF	ISNULL(@i_LogDateEnd, 0) > 0
	INSERT	INTO @TblSurveyResult
	SELECT	R.CommcellIdNameMap_ID, R.CommservSurveyResults_ID
	FROM	(SELECT	ROW_NUMBER() OVER(PARTITION BY CommcellIdNameMap_ID ORDER BY LogDate DESC) AS RowId, CommcellIdNameMap_ID, CommservSurveyResults_ID
			FROM	cf_CommservSurveyResults WITH (NOLOCK)
			WHERE	QueryId = @i_QueryId AND ShredStatus = 1 AND LogDate < @i_LogDateEnd) R
	WHERE	R.RowId = 1
ELSE
	INSERT	INTO @TblSurveyResult
	SELECT	CommcellIdNameMap_ID, CommservSurveyResults_ID
	FROM	cf_CommservSurveyResults R WITH (NOLOCK)
	WHERE	QueryId = @i_QueryId AND (@i_CommServUniqueId = 0 OR CommcellIdNameMap_ID = @i_CommServUniqueId)
		AND Flags = 1
DECLARE	@l_FrontEndTBCost        FLOAT = 0
DECLARE	@l_DataWrittenCostPerTB  FLOAT = 0
DECLARE	@l_AdminCostPerClient    FLOAT = 0
DECLARE	@l_AdminCostPerSubclient FLOAT = 0
SELECT	@l_FrontEndTBCost        = FrontEndTBCost,
		@l_DataWrittenCostPerTB  = DataWrittenCostPerTB,
		@l_AdminCostPerClient    = AdminCostPerClient,
		@l_AdminCostPerSubclient = AdminCostPerSubclient
FROM	cf_GlobalCostParamView
SELECT 	ccMap.CommServUniqueId AS 'CommServ UniqueId',
		ccMap.CommCellID AS 'CommCell ID',
		ccMap.CommServName AS 'CommServer',
		Result.SurveyResultId AS 'ResultId',
		ISNULL(CostOnFrontEndTB, @l_FrontEndTBCost) AS 'FET (Front End TB)',
		ISNULL(CostOnDataWrittenPerTB, @l_DataWrittenCostPerTB) AS 'Data Written (Media) per TB',
		ISNULL(AdminCostPerClient, @l_AdminCostPerClient) AS 'Per Client',
		ISNULL(AdminCostPerSubclient, @l_AdminCostPerSubclient)  AS 'Per Subclient'
FROM	@TblSurveyResult Result
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, 1, NULL, @i_LogDateEnd,@i_UserId,@i_GroupId)  AS ccMap
			ON Result.CommServUniqueId = ccMap.CommServUniqueId
		LEFT OUTER JOIN cf_SurveyCommCellCostParam AS csInfo WITH (NOLOCK)
			ON Result.CommServUniqueId = csInfo.CommServUniqueId AND Result.SurveyResultId = csInfo.SurveyResultId
			AND (CostOnFrontEndTB > 0 OR CostOnDataWrittenPerTB > 0 OR AdminCostPerClient > 0 OR AdminCostPerSubclient > 0)
ORDER BY ccMap.CommServName, ccMap.CommCellID
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptCostParam')
	delete from GxQscripts where name = 'RptCostParam'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCostParam')
	delete from GXDBVersions where aliasname = 'RptCostParam'
GO

insert into GXDBVersions values(2, 'RptCostParam',  '00010005005600020000', 'RptCostParam', '00010005005600020000')
GO

