

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptClientsWithoutSP.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptClientsWithoutSP.sp,v $ $Id: RptClientsWithoutSP.sp,v 1.7.56.3 2018/08/16 11:34:11 skatz Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptClientsWithoutSP <<<'

IF EXISTS (select * from sysobjects where name='RptClientsWithoutSP')
	drop procedure RptClientsWithoutSP
IF EXISTS (select * from GxQscripts where name='RptClientsWithoutSP')
	delete from GxQscripts where name = 'RptClientsWithoutSP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptClientsWithoutSP')
	delete from GXDBVersions where aliasname = 'RptClientsWithoutSP'
GO
print '... Creating Procedure: RptClientsWithoutSP'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptClientsWithoutSP
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
IF(@blaggregate=1)
	RETURN
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 20
IF @i_CommServUniqueID = 0
BEGIN
SELECT
	resultView.CommServUniqueId  AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	resultView.CommServIP AS 'CommServe IP<HIDDEN>',
	resultView.DisplayName AS 'CommCell Name',
	csInfo.TotalClients AS 'Total Client',
	csInfo.ClientsWithoutSP AS 'Clients Without Storage Policy',
	--CAST(csInfo.ClientsWithoutSPPercent AS DECIMAL(5, 2)) AS '% Clients Without Storage Policy',
	ISNULL (CL.ClientDisplayName, csInfo.clientName) AS [Client],
	csInfo.clientName  AS [Client(classic)<HIDDEN>],
	csInfo.AgentName AS 'Agent',
	csInfo.InstanceName AS 'Instance',
	csInfo.Backupset AS 'Backupset',
	csInfo.Subclient AS 'Subclient'
FROM cf_SurveyClientsWithoutSPInfo AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
	LEFT JOIN cf_SurveyClient CL ON CL.CommServUniqueId = csInfo.CommServUniqueId AND CL.ClientId = csInfo.ClientId
ORDER BY 'CommCell Name' ASC, [Client]
END
ELSE
SELECT
	csInfo.CommServUniqueId AS 'CommServ UniqueId',
	ISNULL (CL.ClientDisplayName, csInfo.clientName) AS [Client],
	csInfo.clientName  AS [Client(classic)<HIDDEN>],
	csInfo.AgentName AS 'Agent',
	csInfo.InstanceName AS 'Instance',
	csInfo.Backupset AS 'Backupset',
	csInfo.Subclient AS 'Subclient'
FROM cf_SurveyClientsWithoutSPInfo AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
	LEFT JOIN cf_SurveyClient CL ON CL.CommServUniqueId = csInfo.CommServUniqueId AND CL.ClientId = csInfo.ClientId
ORDER BY [Client]
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE TESTING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= 0
  DECLARE @blaggregate INT				= 0
  DECLARE @blLatestSurvey INT			= 1
  DECLARE @i_CommServUniqueID INT		= 0 --11065
  DECLARE @i_LogDateStart DATETIME		= NULL
  DECLARE @i_LogDateEND DATETIME		= NULL
exec RptClientsWithoutSP @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey,
                               @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND
*/

IF EXISTS (select * from GxQscripts where name = 'RptClientsWithoutSP')
	delete from GxQscripts where name = 'RptClientsWithoutSP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptClientsWithoutSP')
	delete from GXDBVersions where aliasname = 'RptClientsWithoutSP'
GO

insert into GXDBVersions values(2, 'RptClientsWithoutSP',  '00010007005600030000', 'RptClientsWithoutSP', '00010007005600030000')
GO

