

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptClientGroupQuotaUsage.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptClientGroupQuotaUsage.sp,v $ $Id: RptClientGroupQuotaUsage.sp,v 1.1.2.9 2017/06/09 16:07:14 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptClientGroupQuotaUsage <<<'

IF EXISTS (select * from sysobjects where name='RptClientGroupQuotaUsage')
	drop procedure RptClientGroupQuotaUsage
IF EXISTS (select * from GxQscripts where name='RptClientGroupQuotaUsage')
	delete from GxQscripts where name = 'RptClientGroupQuotaUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptClientGroupQuotaUsage')
	delete from GXDBVersions where aliasname = 'RptClientGroupQuotaUsage'
GO
print '... Creating Procedure: RptClientGroupQuotaUsage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptClientGroupQuotaUsage
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @i_CommCellID INT = 0,
  @i_Aggregate INT = 0,
  @i_LatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 185
SET @i_LatestSurvey = 1 --Pick up only the latest data for now
CREATE	TABLE #QuotaUsage (
		CommServUniqueId	INT,
		CommCellId			INT,
		CommServName		NVARCHAR(256),
		ClientGroupName		NVARCHAR(512),
		QuotaType			INT,
		QuotaEnabled		INT,
		QuotaLimitGB		BIGINT,
		QuotaUsedGB			BIGINT,
		UpdateTime			INT,
		ExpiryTime			INT
		)
IF @i_CommCellID > 0 -- Web Server API
	SELECT	@i_GroupId = A.CommCellGroupId
	FROM	cf_CommcellGroupAssoc A WITH (NOLOCK)
			INNER JOIN cf_CommcellGroup G WITH (NOLOCK) ON A.CommCellGroupId = G.id
			INNER JOIN cf_CommcellIdNameMap C WITH (NOLOCK) ON A.CommcellIdNameMap_ID = C.ID
WHERE	G.flag& 0x1000000 > 0 AND C.CommCellId = @i_CommCellID
INSERT	INTO #QuotaUsage
SELECT	CommServUniqueId, CommCellId, CommServName, ClientGroupName, QuotaType, QuotaEnabled, QuotaLimitGB, QuotaUsedGB, UpdateTime, ExpiryTime
FROM	cf_SurveyClientGroupQuotaUsage AS U WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @i_LatestSurvey, NULL, NULL, @i_UserId, @i_GroupId) R ON U.SurveyResultId = R.SurverResultId
IF @i_CommCellID > 0 -- Web Server API
BEGIN
	IF ISNULL(@i_GroupId, 0) > 0
		SELECT	DISTINCT 'CommCell Inherited Capacity', ISNULL(U.QuotaUsedGB, 0), Q.QuotaLimitGB, Q.UpdateTime, Q.QuotaType, Q.ExpiryTime
		FROM	cf_SurveyPublicLicenseQuota Q
				LEFT OUTER JOIN
				(SELECT	A.CommCellGroupId, T.QuotaType, SUM(T.QuotaUsedGB) AS QuotaUsedGB
				FROM	#QuotaUsage T
						INNER JOIN cf_CommcellGroupAssoc A WITH (NOLOCK) ON T.CommServUniqueId = A.CommcellIdNameMap_ID
				WHERE	T.QuotaEnabled&1 = 1 AND A.CommCellGroupId = @i_GroupId
				GROUP BY A.CommCellGroupId, QuotaType
				) U ON Q.CommCellGroupId = U.CommCellGroupId AND Q.QuotaType = U.QuotaType
		WHERE  Q.CommCellGroupId = @i_GroupId
	ELSE
		SELECT	DISTINCT T.ClientGroupName, U.QuotaUsedGB, Q.QuotaLimitGB, Q.UpdateTime, T.QuotaType, Q.ExpiryTime
		FROM	(SELECT DISTINCT ClientGroupName, QuotaType FROM #QuotaUsage WHERE (CommCellId = @i_CommCellID OR ClientGroupName = 'CommCell Inherited Capacity')) T
				INNER JOIN (
				SELECT	ClientGroupName, QuotaType, SUM(QuotaUsedGB) AS QuotaUsedGB
				FROM	#QuotaUsage
				WHERE	QuotaEnabled&1 = 1
				GROUP BY ClientGroupName, QuotaType
				) U ON T.ClientGroupName = U.ClientGroupName AND T.QuotaType = U.QuotaType
				INNER JOIN (
				SELECT	ClientGroupName, QuotaType, QuotaLimitGB, UpdateTime, ExpiryTime, ROW_NUMBER() OVER (PARTITION BY ClientGroupName, QuotaType ORDER BY UpdateTime DESC) AS RowId
				FROM	#QuotaUsage
				WHERE	QuotaEnabled&(1|4) > 0
				) Q ON T.ClientGroupName = Q.ClientGroupName AND T.QuotaType = Q.QuotaType
		WHERE	Q.RowId = 1
END
ELSE
BEGIN
	SELECT	T.CommServUniqueId AS 'CommServ UniqueId',
			T.CommServName AS 'CommCell Name',
			T.ClientGroupName AS 'Client Group',
			CASE T.QuotaType WHEN 100002 THEN 'Backup' WHEN 100004 THEN 'Archive' WHEN 100005 THEN 'Snapshot' WHEN 100006 THEN 'Replication' ELSE L.name END AS 'Quota Type',
			T.QuotaEnabled&1 AS 'Quota Enabled',
			CASE WHEN T.QuotaType IN (100002, 100004, 100005, 100006, 100015, 100016) THEN 'GB' WHEN T.QuotaType = 100017 THEN 'M' ELSE '' END AS 'Quota Unit',
			CASE WHEN T.QuotaType = 100017 THEN T.QuotaUsedGB/1000000 ELSE T.QuotaUsedGB END AS 'Quota Used',
			CASE WHEN T.QuotaType = 100017 THEN T.QuotaLimitGB/1000000 ELSE T.QuotaLimitGB END AS 'Quota Limit',
			T.UpdateTime AS 'Update Time<DATETIME>',
			CASE WHEN T.QuotaType = 100017 THEN Q.QuotaLimitGB/1000000 ELSE Q.QuotaLimitGB END AS 'Global Quota Limit',
			T.ExpiryTime AS 'Expiry Date<DATETIME>'
	FROM	#QuotaUsage T
			INNER JOIN cf_SurveyLicType L ON T.QuotaType = L.id
			INNER JOIN (
			SELECT	ClientGroupName, QuotaType, QuotaLimitGB, UpdateTime, ROW_NUMBER() OVER (PARTITION BY ClientGroupName, QuotaType ORDER BY UpdateTime DESC) AS RowId
			FROM	#QuotaUsage
			WHERE	QuotaEnabled&(1|4) > 0
			) Q ON T.ClientGroupName = Q.ClientGroupName AND T.QuotaType = Q.QuotaType
	WHERE	Q.RowId = 1
END
DROP TABLE #QuotaUsage
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptClientGroupQuotaUsage')
	delete from GxQscripts where name = 'RptClientGroupQuotaUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptClientGroupQuotaUsage')
	delete from GXDBVersions where aliasname = 'RptClientGroupQuotaUsage'
GO

insert into GXDBVersions values(2, 'RptClientGroupQuotaUsage',  '00010001000200090000', 'RptClientGroupQuotaUsage', '00010001000200090000')
GO

