

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptCapacityPeakUsageDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptCapacityPeakUsageDetails.sp,v $ $Id: RptCapacityPeakUsageDetails.sp,v 1.1.2.6 2018/08/16 11:34:29 skatz Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptCapacityPeakUsageDetails <<<'

IF EXISTS (select * from sysobjects where name='RptCapacityPeakUsageDetails')
	drop procedure RptCapacityPeakUsageDetails
IF EXISTS (select * from GxQscripts where name='RptCapacityPeakUsageDetails')
	delete from GxQscripts where name = 'RptCapacityPeakUsageDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCapacityPeakUsageDetails')
	delete from GXDBVersions where aliasname = 'RptCapacityPeakUsageDetails'
GO
print '... Creating Procedure: RptCapacityPeakUsageDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptCapacityPeakUsageDetails
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_MonthStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 129
DECLARE @i_JobType INT = -1
SET @i_JobType = CASE @blaggregate WHEN 1 THEN 0 WHEN 2 THEN 1 WHEN 3 THEN 2 WHEN 4 THEN 3 END
IF OBJECT_ID('tempdb.dbo.#CommCell') IS NOT NULL DROP TABLE #CommCell
CREATE TABLE #CommCell (CommServUniqueId INT, DisplayName NVARCHAR(512))
INSERT INTO #CommCell
SELECT	CommServUniqueId, DisplayName
FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId)
IF @i_CommServUniqueID = 0
	SELECT	CC.CommservUniqueId AS 'CommServ UniqueId<HIDDEN>',
			CC.DisplayName AS 'CommCell Name',
--			S.ClientName AS 'Client',
			ISNULL (CL.ClientDisplayName, S.clientName) AS 'Client',
			S.clientName  AS 'Client(classic)<HIDDEN>',
			S.AgentName AS 'Agent Type',
			S.InstanceName AS 'Instance',
			S.BackupsetName AS 'Backup Set',
			S.SubclientName AS 'Subclient',
			U.PeakDate AS 'Peak Date',
			U.jobId AS 'Job ID',
			CASE U.nJobType WHEN 0 THEN 'Backup' WHEN 1 THEN 'Archive' WHEN 2 THEN 'Snapshot' ELSE 'Replication' END AS 'Job Type',
			U.AppSizeMB AS 'Frontend Size<capacityMB>',
			(SELECT TOP 1 PolicyName FROM cf_SurveyCopyBasicRetention WITH (NOLOCK)
				WHERE CommServUniqueId = U.CommservUniqueId AND PolicyId = U.SPId AND IsDefaultCopy = 1) AS 'Storage Policy'
	FROM	cf_SurveyLicPeakUsageDetails U WITH (NOLOCK)
			INNER JOIN #CommCell CC
				ON U.CommServUniqueId = CC.CommservUniqueId AND U.MonthStart = @i_MonthStart AND (U.nJobType = @i_JobType OR @i_JobType < 0)
			INNER JOIN cf_SurveySubclientAssociation S WITH (NOLOCK)
				ON U.CommServUniqueId = S.CommservUniqueId AND U.ClientId = S.ClientId AND (U.AppId = S.AppId OR S.AppId = 0)
			LEFT JOIN cf_SurveyClient CL WITH (NOLOCK)
				ON CL.CommServUniqueId = S.CommServUniqueId  AND CL.ClientId = S.ClientId
	ORDER BY 'CommCell Name', 'Client', 'Agent Type', 'Instance', 'Backup Set', 'Subclient'
ELSE
	SELECT	CC.CommservUniqueId AS 'CommServ UniqueId<HIDDEN>',
--			S.ClientName AS 'Client',
			ISNULL (CL.ClientDisplayName, S.clientName) AS 'Client',
			S.clientName  AS 'Client(classic)<HIDDEN>',
			S.AgentName AS 'Agent Type',
			S.InstanceName AS 'Instance',
			S.BackupsetName AS 'Backup Set',
			S.SubclientName AS 'Subclient',
			U.PeakDate AS 'Peak Date',
			U.jobId AS 'Job ID',
			CASE U.nJobType WHEN 0 THEN 'Backup' WHEN 1 THEN 'Archive' WHEN 2 THEN 'Snapshot' ELSE 'Replication' END AS 'Job Type',
			U.AppSizeMB AS 'Frontend Size<capacityMB>',
			(SELECT TOP 1 PolicyName FROM cf_SurveyCopyBasicRetention WITH (NOLOCK)
				WHERE CommServUniqueId = U.CommservUniqueId AND PolicyId = U.SPId AND IsDefaultCopy = 1) AS 'Storage Policy'
	FROM	cf_SurveyLicPeakUsageDetails U WITH (NOLOCK)
			INNER JOIN #CommCell CC
				ON U.CommServUniqueId = CC.CommservUniqueId AND U.MonthStart = @i_MonthStart AND (U.nJobType = @i_JobType OR @i_JobType < 0)
			INNER JOIN cf_SurveySubclientAssociation S WITH (NOLOCK)
				ON U.CommServUniqueId = S.CommservUniqueId AND U.ClientId = S.ClientId AND (U.AppId = S.AppId OR S.AppId = 0)
			LEFT JOIN cf_SurveyClient CL WITH (NOLOCK)
				ON CL.CommServUniqueId = S.CommServUniqueId  AND CL.ClientId = S.ClientId
	ORDER BY 'Client', 'Agent Type', 'Instance', 'Backup Set', 'Subclient'
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE TESTING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= 0
  DECLARE @blaggregate INT				= 1
  DECLARE @blLatestSurvey INT			= 1
  DECLARE @i_CommServUniqueID INT		= 11065
  DECLARE @i_MonthStart DATETIME		= '2017-11-01 00:00:00.000'
  DECLARE @i_LogDateEND DATETIME		= NULL
exec RptCapacityPeakUsageDetails @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_MonthStart, @i_LogDateEND
*/

IF EXISTS (select * from GxQscripts where name = 'RptCapacityPeakUsageDetails')
	delete from GxQscripts where name = 'RptCapacityPeakUsageDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCapacityPeakUsageDetails')
	delete from GXDBVersions where aliasname = 'RptCapacityPeakUsageDetails'
GO

insert into GXDBVersions values(2, 'RptCapacityPeakUsageDetails',  '00010001000200060000', 'RptCapacityPeakUsageDetails', '00010001000200060000')
GO

