

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptAgentCapacityLicenseSurvey.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptAgentCapacityLicenseSurvey.sp,v $ $Id: RptAgentCapacityLicenseSurvey.sp,v 1.16.2.20 2020/12/17 02:49:14 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptAgentCapacityLicenseSurvey')
BEGIN
	print '>>> Drop Stored Procedure: RptAgentCapacityLicenseSurvey <<<'
	drop procedure RptAgentCapacityLicenseSurvey
END
IF EXISTS (select * from GxQscripts where name='RptAgentCapacityLicenseSurvey')
	delete from GxQscripts where name = 'RptAgentCapacityLicenseSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptAgentCapacityLicenseSurvey')
	delete from GXDBVersions where aliasname = 'RptAgentCapacityLicenseSurvey'
GO
print '... Creating Procedure: RptAgentCapacityLicenseSurvey'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptAgentCapacityLicenseSurvey
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
DECLARE @i_QueryId BIGINT = 3
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Pick up only the latest data for now
IF object_id('tempdb.dbo.#CommServResults') is not null DROP TABLE #CommServResults
CREATE TABLE #CommServResults (
	CommServUniqueId INT, CommCellID VARCHAR(32), CommServIP VARCHAR(256), CommServGUID VARCHAR(256), DisplayName NVARCHAR(256),
	CommServName NVARCHAR(256), CommServTimeZone VARCHAR(256), SurveyResultId BIGINT, LogDate DATETIME, LogDateUTC DATETIME, RunningTime INT
)
INSERT INTO #CommServResults
SELECT	CommServUniqueId, CommCellID, CommServIP, CommServGUID, DisplayName, CommServName, CommServTimeZone, SurverResultId, LogDate, LogDateUTC, RunningTime
FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId)
DECLARE @LicenseUsageTbl TABLE (CommServUniqueId INT, CommCellName NVARCHAR(256), License VARCHAR(128), Purchased BIGINT, Loaned BIGINT, Used BIGINT, Available BIGINT, ExpiresOn INT)
DECLARE @now DATETIME = GETDATE()
IF (SELECT COUNT(DISTINCT CommServTimeZone) FROM #CommServResults WHERE ISNULL(CommServTimeZone, '') <> '') = 1
BEGIN
	DECLARE @csTimeZone VARCHAR(256)
	SELECT	@csTimeZone = CommServTimeZone
	FROM	#CommServResults
	WHERE	ISNULL(CommServTimeZone, '') <> ''
	IF @csTimeZone IS NOT NULL
		SET @now = dbo.UTCToLocalDateTimeConversion(GETUTCDATE(), @csTimeZone)
END
IF @blaggregate = 1 -- Aggregated Capacity Usage by Agent Types (pie chart)
	SELECT
		CASE WHEN S.TypeId = 38 THEN S.TypeName ELSE AT.shortName END + CASE WHEN Flag = 0 THEN '' ELSE ' (*)' END AS 'Agent Type',
		SUM(UsedAgents) AS 'Used Agents<FORMATNUMBERNA>',
		CAST(SUM(BackupSize)/(1024.00*1024.00) AS DECIMAL(32,2)) AS 'Backup Size<LicenseSizeMB>',
		CAST(SUM(ArchiveSize)/(1024.00*1024.00) AS DECIMAL(32,2)) AS 'Archive Size<LicenseSizeMB>',
		CAST(SUM(SnapshotSize)/(1024.00*1024.00) AS DECIMAL(32,2)) AS 'Snapshot Size<LicenseSizeMB>',
		CAST(SUM(ReplicationSize)/(1024.00*1024.00) AS DECIMAL(32,2)) AS 'Replication Size<LicenseSizeMB>'
	FROM
		(SELECT	CU.SurveyResultId, CU.TypeId, CU.TypeName,
				MAX(UsedAgents) AS UsedAgents, SUM(BackupSize) AS BackupSize, SUM(ArchiveSize) AS ArchiveSize,
				SUM(SnapshotSize) AS SnapshotSize, SUM(ReplicationSize) AS ReplicationSize, MAX(CU.Flag) AS Flag
		FROM	cf_SurveyAgentCapacityUsage CU WITH (NOLOCK)
		INNER JOIN #CommServResults AS R ON CU.SurveyResultId = R.SurveyResultId AND CU.TypeId > 0
		GROUP BY CU.SurveyResultId, CU.TypeId, CU.TypeName) S
		INNER JOIN cf_SurveyAgentType AT WITH (NOLOCK) ON S.TypeId = AT.id
	GROUP BY CASE WHEN S.TypeId = 38 THEN S.TypeName ELSE AT.shortName END + CASE WHEN Flag = 0 THEN '' ELSE ' (*)' END
	ORDER BY 'Agent Type'
ELSE
IF @blaggregate = 2 -- Aggregated License Usage (pie chart)
	SELECT
		licType.name AS 'License',
		SUM(PermLicensesUsed + EvalLicensesUsed) AS 'Used Licenses'
	FROM	cf_SurveyAgentLicenseUsage LU WITH (NOLOCK)
		INNER JOIN cf_SurveyLicType licType ON LU.TypeId = licType.id
		INNER JOIN #CommServResults AS R ON LU.SurveyResultId = R.SurveyResultId
	WHERE	licType.id NOT IN (100029, 100030, 200001, 200002, 200003)
	GROUP BY licType.name
	ORDER BY licType.name
ELSE
IF @blaggregate = 3 -- Aggregated Capacity Usage by Licenses
BEGIN
	DECLARE @CapacityUsageTbl TABLE (License VARCHAR(128), Purchased BIGINT, Loaned BIGINT, Used BIGINT, Available BIGINT,
		BackupSizeMB DECIMAL(32,2), ArchiveSizeMB DECIMAL(32,2), SnapshotSizeMB DECIMAL(32,2), ReplicationSizeMB DECIMAL(32,2))
	INSERT INTO @CapacityUsageTbl
	SELECT
		licType.name AS 'License',
		SUM(T.PermLicensesIssued) AS 'Purchased<NumberUnlimitedNA>',
		SUM(T.EvalLicensesIssued) AS 'Loaned<NumberUnlimitedNA>',
		SUM(T.PermLicensesUsed + T.EvalLicensesUsed) AS 'Used<FORMATNUMBERNA>',
		SUM(T.PermLicensesAvailable + T.EvalLicensesAvailable) AS 'Available<NumberUnlimitedNA><HIDDEN>',
		CAST(SUM(ISNULL(S.BackupSize, 0))/(1024.00*1024.00) AS DECIMAL(32,2)) AS 'Backup Size<LicenseSizeMB>',
		CAST(SUM(ISNULL(S.ArchiveSize, 0))/(1024.00*1024.00) AS DECIMAL(32,2)) AS 'Archive Size<LicenseSizeMB>',
		CAST(SUM(ISNULL(S.SnapshotSize, 0))/(1024.00*1024.00) AS DECIMAL(32,2)) AS 'Snapshot Size<LicenseSizeMB>',
		CAST(SUM(ISNULL(S.ReplicationSize, 0))/(1024.00*1024.00) AS DECIMAL(32,2)) AS 'Replication Size<LicenseSizeMB>'
	FROM cf_SurveyLicType licType
		INNER JOIN (
			SELECT
				LU.TypeId,
				SUM(CASE WHEN LU.PermLicensesIssued > 0 OR @i_CommServUniqueID > 0 THEN LU.PermLicensesIssued ELSE 0 END) AS PermLicensesIssued,
				SUM(LU.PermLicensesUsed) AS PermLicensesUsed,
				SUM(CASE WHEN LU.PermLicensesAvailable > 0 OR @i_CommServUniqueID > 0 THEN LU.PermLicensesAvailable ELSE 0 END) AS PermLicensesAvailable,
				SUM(CASE WHEN (ISNULL(LU.EvalLicenseExpiryDate, '1970-01-01') <= '1970-01-01' OR ISNULL(LU.EvalLicenseExpiryDate, '1970-01-01') > @now)
					 AND (LU.EvalLicensesIssued > 0 OR @i_CommServUniqueID > 0) THEN LU.EvalLicensesIssued ELSE 0 END) AS EvalLicensesIssued,
				SUM(LU.EvalLicensesUsed) AS EvalLicensesUsed,
				SUM(CASE WHEN (ISNULL(LU.EvalLicenseExpiryDate, '1970-01-01') <= '1970-01-01' OR ISNULL(LU.EvalLicenseExpiryDate, '1970-01-01') > @now)
					 AND (LU.EvalLicensesAvailable > 0 OR @i_CommServUniqueID > 0) THEN LU.EvalLicensesAvailable ELSE 0 END) AS EvalLicensesAvailable
			FROM	cf_SurveyAgentLicenseUsage AS LU WITH (NOLOCK)
				INNER JOIN #CommServResults AS R1 ON LU.SurveyResultId = R1.SurveyResultId
			GROUP BY LU.TypeId) T ON T.TypeId = licType.id
		LEFT OUTER JOIN (
			SELECT	CU.LicType, SUM(BackupSize) AS BackupSize, SUM(ArchiveSize) AS ArchiveSize, SUM(SnapshotSize) AS SnapshotSize, SUM(ReplicationSize) AS ReplicationSize
			FROM	cf_SurveyAgentCapacityUsage CU
				INNER JOIN #CommServResults AS R2 ON CU.SurveyResultId = R2.SurveyResultId
			GROUP BY CU.LicType) S ON T.TypeId = S.LicType
	WHERE licType.groupId = 3 OR licType.id IN (100029, 100030, 200001, 200002, 200003)
	GROUP BY licType.name
	IF NOT EXISTS (SELECT * FROM #CommServResults WHERE CommCellID <> '-1')
		SELECT
			License AS 'License',
			(Purchased + Loaned) AS 'Evaluation<NumberUnlimitedNA>',
			Used AS 'Used<FORMATNUMBERNA>',
			Available AS 'Available<NumberUnlimitedNA><HIDDEN>',
			BackupSizeMB AS 'Backup Size<LicenseSizeMB>',
			ArchiveSizeMB AS 'Archive Size<LicenseSizeMB>',
			SnapshotSizeMB AS 'Snapshot Size<LicenseSizeMB>',
			ReplicationSizeMB AS 'Replication Size<LicenseSizeMB>'
		FROM @CapacityUsageTbl
		ORDER BY License
	ELSE
		SELECT
			License AS 'License',
			Purchased AS 'Purchased<NumberUnlimitedNA>',
			Loaned AS 'Loaned<NumberUnlimitedNA>',
			Used AS 'Used<FORMATNUMBERNA>',
			Available AS 'Available<NumberUnlimitedNA><HIDDEN>',
			BackupSizeMB AS 'Backup Size<LicenseSizeMB>',
			ArchiveSizeMB AS 'Archive Size<LicenseSizeMB>',
			SnapshotSizeMB AS 'Snapshot Size<LicenseSizeMB>',
			ReplicationSizeMB AS 'Replication Size<LicenseSizeMB>'
		FROM @CapacityUsageTbl
		ORDER BY License
END
ELSE
IF @blaggregate = 4 -- Feature licenses table (cell level & those not tracked at capacity.  Also put Disk library)
BEGIN
	INSERT INTO @LicenseUsageTbl
	SELECT
		resultView.CommServUniqueId AS 'CommServ UniqueId',
		resultView.DisplayName AS 'CommCell Name',
		licType.name AS 'License',
		CASE
			WHEN csInfo.PermLicensesIssued > -1 THEN csInfo.PermLicensesIssued
			WHEN csInfo.PermLicensesIssued = -1 THEN -1
			ELSE -2
		END AS 'Purchased<NumberUnlimitedNA>',
		0 AS 'Loaned<NumberUnlimitedNA>',
		csInfo.PermLicensesUsed AS 'Used<FORMATNUMBERNA>',
		CASE
			WHEN csInfo.PermLicensesAvailable > -1 THEN csInfo.PermLicensesAvailable
			WHEN csInfo.PermLicensesAvailable = -1 THEN -1
			ELSE -2
		END AS 'Available<NumberUnlimitedNA><HIDDEN>',
		0 AS 'Expires on<DATETIME>'
	FROM cf_SurveyAgentLicenseUsage AS csInfo WITH (NOLOCK)
		INNER JOIN cf_SurveyLicType licType ON csInfo.TypeId = licType.id
		INNER JOIN #CommServResults AS resultView ON resultView.SurveyResultId = csInfo.SurveyResultId
	WHERE (licType.groupId NOT IN (3, 14, 15) OR licType.id IN (100015, 100016))
		AND (csInfo.PermLicensesIssued <> 0 OR csInfo.EvalLicensesIssued = 0)
	UNION
	SELECT
		resultView.CommServUniqueId AS 'CommServ UniqueId',
		resultView.DisplayName AS 'CommCell Name',
		licType.name AS 'License',
		0 AS 'Purchased<NumberUnlimitedNA>',
		CASE
			WHEN csInfo.EvalLicensesIssued > -1 THEN csInfo.EvalLicensesIssued
			WHEN csInfo.EvalLicensesIssued = -1 THEN -1
			ELSE -2
		END AS 'Loaned<NumberUnlimitedNA>',
		csInfo.EvalLicensesUsed AS 'Used<FORMATNUMBERNA>',
		CASE
			WHEN csInfo.EvalLicensesAvailable > -1 THEN csInfo.EvalLicensesAvailable
			WHEN csInfo.EvalLicensesAvailable = -1 THEN -1
			ELSE -2
		END AS 'Available<NumberUnlimitedNA><HIDDEN>',
		ISNULL(dbo.GetUnixTimeBig(csInfo.EvalLicenseExpiryDate), 0) AS 'Expires on<DATETIME>'
	FROM cf_SurveyAgentLicenseUsage AS csInfo WITH (NOLOCK)
		INNER JOIN cf_SurveyLicType licType ON csInfo.TypeId = licType.id
		INNER JOIN #CommServResults AS resultView ON resultView.SurveyResultId = csInfo.SurveyResultId
	WHERE (licType.groupId NOT IN (3, 14, 15) OR licType.id IN (100015, 100016))
		AND csInfo.EvalLicensesIssued <> 0
		AND (ISNULL(EvalLicenseExpiryDate, '1970-01-01') <= '1970-01-01' OR ISNULL(EvalLicenseExpiryDate, '1970-01-01') > @now OR EvalLicensesUsed > 0)
	IF NOT EXISTS (SELECT * FROM #CommServResults WHERE CommCellID <> '-1')
		SELECT
			CommServUniqueId AS 'CommServ UniqueId',
			CommCellName AS 'CommCell Name',
			License AS 'License',
			(Purchased + Loaned) AS 'Evaluation<NumberUnlimitedNA>',
			Used AS 'Used<FORMATNUMBERNA>',
			Available AS 'Available<NumberUnlimitedNA><HIDDEN>',
			ExpiresOn AS 'Expires on<DATETIME>'
		FROM @LicenseUsageTbl
		ORDER BY CommCellName, License
	ELSE
		SELECT
			CommServUniqueId AS 'CommServ UniqueId',
			CommCellName AS 'CommCell Name',
			License AS 'License',
			Purchased AS 'Purchased<NumberUnlimitedNA>',
			Loaned AS 'Loaned<NumberUnlimitedNA>',
			Used AS 'Used<FORMATNUMBERNA>',
			Available AS 'Available<NumberUnlimitedNA><HIDDEN>',
			ExpiresOn AS 'Expires on<DATETIME>'
		FROM @LicenseUsageTbl
		ORDER BY CommCellName, License
END
ELSE
IF @blaggregate = 5 -- Retired and consolidated licenses table
BEGIN
	INSERT INTO @LicenseUsageTbl
	SELECT
		resultView.CommServUniqueId AS 'CommServ UniqueId',
		resultView.DisplayName AS 'CommCell Name',
		csInfo.TypeName AS 'License',
		CASE
			WHEN csInfo.PermLicensesIssued > -1 THEN csInfo.PermLicensesIssued
			WHEN csInfo.PermLicensesIssued = -1 THEN -1
			ELSE -2
		END AS 'Purchased<NumberUnlimitedNA>',
		0 AS 'Loaned<NumberUnlimitedNA>',
		csInfo.PermLicensesUsed AS 'Used<FORMATNUMBERNA>',
		CASE
			WHEN csInfo.PermLicensesAvailable > -1 THEN csInfo.PermLicensesAvailable
			WHEN csInfo.PermLicensesAvailable = -1 THEN -1
			ELSE -2
		END AS 'Available<NumberUnlimitedNA><HIDDEN>',
		0 AS 'Expires on<DATETIME>'
	FROM cf_SurveyAgentLicenseUsage AS csInfo WITH (NOLOCK)
		LEFT OUTER JOIN cf_SurveyLicType licType ON csInfo.TypeId = licType.id
		INNER JOIN #CommServResults AS resultView ON resultView.SurveyResultId = csInfo.SurveyResultId
	WHERE licType.id IS NULL
		AND (csInfo.PermLicensesIssued <> 0 OR csInfo.EvalLicensesIssued = 0)
	UNION
	SELECT
		resultView.CommServUniqueId AS 'CommServ UniqueId',
		resultView.DisplayName AS 'CommCell Name',
		csInfo.TypeName AS 'License',
		0 AS 'Purchased<NumberUnlimitedNA>',
		CASE
			WHEN csInfo.EvalLicensesIssued > -1 THEN csInfo.EvalLicensesIssued
			WHEN csInfo.EvalLicensesIssued = -1 THEN -1
			ELSE -2
		END AS 'Loaned<NumberUnlimitedNA>',
		csInfo.EvalLicensesUsed AS 'Used<FORMATNUMBERNA>',
		CASE
			WHEN csInfo.EvalLicensesAvailable > -1 THEN csInfo.EvalLicensesAvailable
			WHEN csInfo.EvalLicensesAvailable = -1 THEN -1
			ELSE -2
		END AS 'Available<NumberUnlimitedNA><HIDDEN>',
		ISNULL(dbo.GetUnixTimeBig(csInfo.EvalLicenseExpiryDate), 0) AS 'Expires on<DATETIME>'
	FROM cf_SurveyAgentLicenseUsage AS csInfo WITH (NOLOCK)
		LEFT OUTER JOIN cf_SurveyLicType licType ON csInfo.TypeId = licType.id
		INNER JOIN #CommServResults AS resultView ON resultView.SurveyResultId = csInfo.SurveyResultId
	WHERE licType.id IS NULL
		AND csInfo.EvalLicensesIssued <> 0
		AND (ISNULL(EvalLicenseExpiryDate, '1970-01-01') <= '1970-01-01' OR ISNULL(EvalLicenseExpiryDate, '1970-01-01') > @now OR EvalLicensesUsed > 0)
	ORDER BY 'CommCell Name', 'License'
	IF NOT EXISTS (SELECT * FROM #CommServResults WHERE CommCellID <> '-1')
		SELECT
			CommServUniqueId AS 'CommServ UniqueId',
			CommCellName AS 'CommCell Name',
			License AS 'License',
			(Purchased + Loaned) AS 'Evaluation<NumberUnlimitedNA>',
			Used AS 'Used<FORMATNUMBERNA>',
			Available AS 'Available<NumberUnlimitedNA><HIDDEN>',
			ExpiresOn AS 'Expires on<DATETIME>'
		FROM @LicenseUsageTbl
		ORDER BY CommCellName, License
	ELSE
		SELECT
			CommServUniqueId AS 'CommServ UniqueId',
			CommCellName AS 'CommCell Name',
			License AS 'License',
			Purchased AS 'Purchased<NumberUnlimitedNA>',
			Loaned AS 'Loaned<NumberUnlimitedNA>',
			Used AS 'Used<FORMATNUMBERNA>',
			Available AS 'Available<NumberUnlimitedNA><HIDDEN>',
			ExpiresOn AS 'Expires on<DATETIME>'
		FROM @LicenseUsageTbl
		ORDER BY CommCellName, License
END
DROP TABLE #CommServResults
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptAgentCapacityLicenseSurvey')
	delete from GxQscripts where name = 'RptAgentCapacityLicenseSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptAgentCapacityLicenseSurvey')
	delete from GXDBVersions where aliasname = 'RptAgentCapacityLicenseSurvey'
GO

insert into GXDBVersions values(2, 'RptAgentCapacityLicenseSurvey',  '00010016000200200000', 'RptAgentCapacityLicenseSurvey', '00010016000200200000')
GO

