

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ProcessCollectedResults.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ProcessCollectedResults.sp,v $ $Id: ProcessCollectedResults.sp,v 1.1.90.12 2020/08/18 05:48:12 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ProcessCollectedResults')
BEGIN
	print '>>> Drop Stored Procedure: ProcessCollectedResults <<<'
	drop procedure ProcessCollectedResults
END
IF EXISTS (select * from GxQscripts where name='ProcessCollectedResults')
	delete from GxQscripts where name = 'ProcessCollectedResults'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ProcessCollectedResults')
	delete from GXDBVersions where aliasname = 'ProcessCollectedResults'
GO
print '... Creating Procedure: ProcessCollectedResults'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ProcessCollectedResults
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @XmlFileId	INT = 0
DECLARE @LastFileId	INT = 0
DECLARE @LogLevel	INT = 1
DECLARE	@StartDate	DATETIME = GETUTCDATE()
DECLARE	@TempDate	DATETIME
DECLARE	@Duration	INT = 0
DECLARE	@ShredStatus INT= 0
DECLARE @nXmlFile	INT = 0
DECLARE @nSuccess	INT = 0
DECLARE @nFailed	INT = 0
DECLARE @nSkipped	INT = 0
DECLARE @LogString	NVARCHAR(MAX)
DECLARE @ErrMessage	NVARCHAR(MAX)
DECLARE	@TranName	NVARCHAR(256)
DECLARE	@TranCount	INT
DECLARE	@ErrCode	INT
BEGIN TRY
SELECT	@LogLevel = CAST(Value AS INT)
FROM	cf_SurveyConfig WITH(NOLOCK)
WHERE	Name = 'Survey Log Level'
SET @TranCount = @@TRANCOUNT
IF  @TranCount > 0
BEGIN
	SELECT	@TranName = A.name
	FROM	sys.dm_tran_active_transactions A
			INNER JOIN sys.dm_tran_session_transactions S ON A.transaction_id = S.transaction_id
	WHERE	S.session_id = @@SPID
	SET @LogString = 'Session ' + CAST(@@SPID AS VARCHAR(20)) + ' - Rollback uncommitted transaction ' + ISNULL(@TranName, '') + ' (Previous TRANCOUNT = ' + CAST(@TranCount AS VARCHAR(20))
			+ ') when ProcessCollectedResults starts'
	SET @TempDate = GETUTCDATE()
	ROLLBACK TRANSACTION
	SET @Duration = DATEDIFF(SS, @TempDate,  GETUTCDATE())
	SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(20)) + ' (sec)'
	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString)
END
DECLARE @EnabledQuery TABLE (QueryId INT)
INSERT	INTO @EnabledQuery
SELECT	QueryId
FROM	dbo.RptGetMetricsQueryFlags(0)
WHERE	QueryEnabled = 1
-- Reset cf_CustomerFeedbackXmlFile.ShredStatus from 1 to 0 in case the last processing was not stopped gracefully
-- This statement should be moved to the main thread when multi-thread processing is enabled.
UPDATE  cf_CustomerFeedbackXmlFile SET ShredStatus = 0 WHERE ShredStatus = 1
WHILE (1=1)
BEGIN
	SET @XmlFileId = (
		SELECT	TOP 1 F.ID
		FROM	cf_CustomerFeedbackXmlFile F
				INNER JOIN cf_CommcellIdNameMap C ON F.CommcellIdNameMap_ID = C.ID AND (C.Flags&1) = 0
		WHERE	F.ShredStatus = 0 AND F.ID > @LastFileId
		ORDER BY F.ID)
	IF	@XmlFileId IS NULL
		BREAK
	UPDATE	cf_CustomerFeedbackXmlFile SET ShredStatus = 1, ParseTime = GETUTCDATE()
	WHERE	ID = @XmlFileId AND ShredStatus = 0
	IF	@@ROWCOUNT = 0
		CONTINUE
	UPDATE	R SET ShredStatus = 1
	FROM	cf_CommservSurveyResults R
			INNER JOIN @EnabledQuery Q ON R.QueryId = Q.QueryId
	WHERE	CustomerFeedbackXmlFile_ID = @XmlFileId AND ShredStatus = 0
	SET @LogString = ''
	BEGIN TRY
		EXEC ParseCollectedResultsForSurvey @XmlFileId, @ShredStatus OUTPUT, @LogLevel
	END TRY
	BEGIN CATCH
		SELECT	@ErrCode = ERROR_NUMBER(), @ErrMessage = ERROR_MESSAGE()
		SET @LogString += ' - Exception from ParseCollectedResultsForSurvey procedure. ERROR CODE: '
				+ CAST(@ErrCode AS VARCHAR(20)) + ' ERROR MESSAGE: ' + ISNULL(@ErrMessage, '')
	END CATCH
	SET @TranCount = @@TRANCOUNT
	IF  @TranCount > 0
	BEGIN
		SELECT	@TranName = A.name
		FROM	sys.dm_tran_active_transactions A
				INNER JOIN sys.dm_tran_session_transactions S ON A.transaction_id = S.transaction_id
		WHERE	S.session_id = @@SPID
		SET @LogString += ' - Rollback uncommitted transaction ' + ISNULL(@TranName, '')
				+ ' (Previous TRANCOUNT = ' + CAST(@TranCount AS VARCHAR(20)) + ')'
		SET @TempDate = GETUTCDATE()
		ROLLBACK TRANSACTION
		SET @Duration = DATEDIFF(SS, @TempDate,  GETUTCDATE())
		SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(20)) + ' (sec).'
	END
	IF	@LogString <> ''
	BEGIN
		SET @LogString = ('Session ' + CAST(@@SPID AS VARCHAR(20)) + @LogString)
		INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString)
	END
	SET	@LastFileId = @XmlFileId
	IF @ShredStatus = 3
		SET @nFailed += 1
	ELSE
	IF @ShredStatus = 2
		SET @nSuccess += 1
	ELSE
		SET @nSkipped += 1
END
SET @nXmlFile = (@nSuccess + @nFailed + @nSkipped)
SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE())
SET @LogString = 'Session ' + CAST(@@SPID AS VARCHAR(20))
		+ ' - Processed ' + CAST(@nXmlFile AS VARCHAR(20)) + ' xml files - Suceeded: ' + CAST(@nSuccess AS VARCHAR(20))
		+ ', Failed: ' + CAST(@nFailed AS VARCHAR(20)) + ', Skipped: ' + CAST(@nSkipped AS VARCHAR(20))
		+ '). Duration: ' + CAST(@Duration AS VARCHAR(20)) + ' (sec)'
INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString)
END TRY
BEGIN CATCH
	SELECT	@ErrCode = ERROR_NUMBER(), @ErrMessage = ERROR_MESSAGE()
	SET @LogString = 'Session ' + CAST(@@SPID AS VARCHAR(20)) + ' - Exception in ParseCollectedResultsForSurvey procedure. ERROR CODE: '
			+ CAST(@ErrCode AS VARCHAR(20)) + ' ERROR MESSAGE: ' + ISNULL(@ErrMessage, '')
	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString)
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ProcessCollectedResults')
	delete from GxQscripts where name = 'ProcessCollectedResults'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ProcessCollectedResults')
	delete from GXDBVersions where aliasname = 'ProcessCollectedResults'
GO

insert into GXDBVersions values(2, 'ProcessCollectedResults',  '00010001009000120000', 'ProcessCollectedResults', '00010001009000120000')
GO

