

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ProcessCSVFile.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ProcessCSVFile.sp,v $ $Id: ProcessCSVFile.sp,v 1.1.2.5 2018/05/03 03:35:45 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ProcessCSVFile <<<'

IF EXISTS (select * from sysobjects where name='ProcessCSVFile')
	drop procedure ProcessCSVFile
IF EXISTS (select * from GxQscripts where name='ProcessCSVFile')
	delete from GxQscripts where name = 'ProcessCSVFile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ProcessCSVFile')
	delete from GXDBVersions where aliasname = 'ProcessCSVFile'
GO
print '... Creating Procedure: ProcessCSVFile'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ProcessCSVFile
  @FullFileName VARCHAR(1024),
  @FileTime INT, 
  @FileType VARCHAR(32),
  @CCID INT, 
  @CSGUID VARCHAR(256),
  @isPrintOn INTEGER = 0
AS
	SET NOCOUNT ON
	DECLARE @curTime DATETIME = GETUTCDATE()
	DECLARE @csuid INT = 0
	DECLARE @cstz VARCHAR(256)
	DECLARE @UpdateTime DATETIME
	DECLARE @csversion VARCHAR(256)
	DECLARE @ErrorCode INTEGER
	DECLARE @ErrorString NVARCHAR(MAX)
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'ProcessCSVFile - Started'
	IF @isPrintOn = 1 PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	DECLARE @ParseSP SYSNAME = ''
	DECLARE @QueryEnabled INT
	SELECT  @ParseSP = ISNULL(ParserScript, ''), @QueryEnabled = F.QueryEnabled FROM cf_CommservSurveyQueries Q WITH(NOLOCK) INNER JOIN dbo.RptGetMetricsQueryFlags(0) F ON Q.QueryId = F.QueryId WHERE Q.CollectScriptName = @FileType AND Q.Type = 2
	IF (@QueryEnabled = 0)
	BEGIN
		SELECT @ErrorCode = 1
		SELECT @ErrorString = 'Parsing disabled for [' + @FullFileName + ']'
		GOTO PROC_EXIT
	END
	IF LEN(@ParseSP) <= 0
	BEGIN
		SELECT @ErrorCode = 2
		SELECT @ErrorString = 'Parsing script is not available for [' + @FileType + ']'
		GOTO PROC_EXIT
	END
	SELECT @csuid = ID, @cstz = CommServTZ, @csversion = CommServVersion FROM cf_CommcellIdNameMap WITH(NOLOCK) WHERE CommServGUID = @CSGUID AND (Flags & 1) = 0
	IF (ISNULL(@csuid, 0) = 0)
	BEGIN
		SELECT @ErrorCode = 3
		SELECT @ErrorString = 'Cannot find CommServ entry for file [' + @FullFileName + '] in cf_CommcellIdNameMap'
		GOTO PROC_EXIT
	END
	--Execute corresponding Parser script by building Dynamic Query
	DECLARE @SQLString NVARCHAR(500)
	DECLARE @ParmDefinition NVARCHAR(500)
	DECLARE @RetErrorCode INTEGER = 0
	DECLARE @RetErrorString NVARCHAR(MAX) = ''
	SELECT @UpdateTime = dbo.UTCToLocalDateTimeConversion(dateadd(S, @FileTime, '1970-01-01'), @cstz)
	SET @SQLString=N'EXEC ' + @ParseSP + ' @cid, @upTime, @file, @ec OUTPUT, @es OUTPUT, @printOn'
	SET @ParmDefinition=N'@cid INTEGER, @upTime DATETIME, @file VARCHAR(1024), @ec INTEGER OUTPUT, @es NVARCHAR(MAX) OUTPUT, @printOn INTEGER'
	BEGIN TRY
		EXECUTE sp_executesql @SQLString, @ParmDefinition, @cid = @csuid, @upTime = @UpdateTime, @file = @FullFileName, @ec = @RetErrorCode OUTPUT, @es = @RetErrorString OUTPUT, @printOn = @isPrintOn
		IF (@@TRANCOUNT > 0)
			ROLLBACK TRANSACTION
	END TRY
	BEGIN CATCH
/*
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
*/
		IF (@@TRANCOUNT > 0)
			ROLLBACK TRANSACTION
		SET @ErrorCode = 4
		SET @ErrorString = 'Exception from the parser for ' + @FileType + ' !!! Failed with error :: ' + ERROR_MESSAGE()
	END CATCH
	PROC_EXIT:
		IF (@ErrorCode = 0)
			SELECT @ErrorString	= 'ProcessCSVFile - Successfully Completed'
		ELSE IF (@ErrorCode in (1, 4))
			SELECT @ErrorCode = 0 --Consider these cases as success
		ELSE
			SELECT @ErrorString	= 'ProcessCSVFile - Failed with error :: ' + @ErrorString
		IF @isPrintOn = 1 PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
		SELECT @ErrorCode AS ErrorCode, @ErrorString AS ErrorString
		RETURN
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ProcessCSVFile')
	delete from GxQscripts where name = 'ProcessCSVFile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ProcessCSVFile')
	delete from GXDBVersions where aliasname = 'ProcessCSVFile'
GO

insert into GXDBVersions values(2, 'ProcessCSVFile',  '00010001000200050000', 'ProcessCSVFile', '00010001000200050000')
GO

