

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseTapeMediaUsage.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseTapeMediaUsage.sp,v $ $Id: ParseTapeMediaUsage.sp,v 1.1.2.13 2020/12/17 02:50:41 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseTapeMediaUsage')
BEGIN
	print '>>> Drop Stored Procedure: ParseTapeMediaUsage <<<'
	drop procedure ParseTapeMediaUsage
END
IF EXISTS (select * from GxQscripts where name='ParseTapeMediaUsage')
	delete from GxQscripts where name = 'ParseTapeMediaUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseTapeMediaUsage')
	delete from GXDBVersions where aliasname = 'ParseTapeMediaUsage'
GO
print '... Creating Procedure: ParseTapeMediaUsage'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseTapeMediaUsage
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseTapeMediaUsageTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
IF object_id('tempdb.dbo.#SurveyTapeMediaUsage') is not null DROP TABLE #SurveyTapeMediaUsage
IF object_id('tempdb.dbo.#SurveyTapeUsageByType') is not null DROP TABLE #SurveyTapeUsageByType
IF object_id('tempdb.dbo.#SurveyTapeUsageByLibrary') is not null DROP TABLE #SurveyTapeUsageByLibrary
IF object_id('tempdb.dbo.#SurveyMonthlyTapeUsageByLibrary') is not null DROP TABLE #SurveyMonthlyTapeUsageByLibrary
CREATE TABLE #SurveyTapeMediaUsage (
	CommServUniqueId INT NOT NULL,
	MonthVal DATE NOT NULL,
	MediaTypeId INT NOT NULL,
	MediaTypeName VARCHAR(256) NOT NULL,
	TapesUsed INT NULL,
	TapesRecycled INT NULL
)
CREATE TABLE #SurveyTapeUsageByType
(
	SurveyResultId BIGINT NOT NULL,
	MediaTypeId INT NOT NULL,
	MediaTypeName VARCHAR(32) NOT NULL,
	UsedTapeCount INT NULL,
	UsedSpaceMB BIGINT NULL,
)
CREATE TABLE #SurveyTapeUsageByLibrary
(
	SurveyResultId BIGINT NOT NULL,
	LibraryId INT NOT NULL,
	UsedTapeCount INT NULL,
	SpareTapeCount INT NULL,
	TotalSpaceMB BIGINT NULL,
	UsedSpaceMB BIGINT NULL,
	AppSizeMB BIGINT NULL,
	DataWrittenMB BIGINT NULL
)
CREATE TABLE #SurveyMonthlyTapeUsageByLibrary
(
	CommServUniqueId INT NOT NULL,
	LibraryId INT NOT NULL,
	MonthStart DATE NOT NULL,
	UsedTapeCount INT NULL,
	SpareTapeCount INT NULL
)
DECLARE @currentMonth DATE = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()), 0)
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #SurveyTapeUsageByType (SurveyResultId, MediaTypeId, MediaTypeName, UsedTapeCount, UsedSpaceMB)
	SELECT
		@ResultId,
		csInfo.n.value('@MediaTypeId', 'INT'),
		csInfo.n.value('@MediaTypeName', 'VARCHAR(32)'),
		csInfo.n.value('@UsedTapeCount', 'INT'),
		csInfo.n.value('@UsedSpaceMB', 'BIGINT')
	FROM
		@ResultXml.nodes('/TapeUsageByType') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #SurveyTapeMediaUsage (CommServUniqueId, MonthVal, MediaTypeId, MediaTypeName, TapesUsed, TapesRecycled)
	SELECT
		@CSUniqueId,
		csInfo.n.value('@MonthVal', 'DATE'),
		csInfo.n.value('@MediaTypeId', 'INT'),
		csInfo.n.value('@MediaTypeName', 'VARCHAR(256)'),
		csInfo.n.value('@TapesUsed', 'INT'),
		csInfo.n.value('@TapesRecycled', 'INT')
	FROM
		@ResultXml.nodes('/TapeMediaUsageXML') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #SurveyTapeUsageByLibrary (SurveyResultId, LibraryId, UsedTapeCount, SpareTapeCount, TotalSpaceMB, UsedSpaceMB, AppSizeMB, DataWrittenMB)
	SELECT
		@ResultId,
		csInfo.n.value('@LibraryId', 'INT'),
		csInfo.n.value('@UsedTapeCount', 'INT'),
		csInfo.n.value('@SpareTapeCount', 'INT'),
		csInfo.n.value('@TotalSpaceMB', 'BIGINT'),
		csInfo.n.value('@UsedSpaceMB', 'BIGINT'),
		csInfo.n.value('@AppSizeMB', 'BIGINT'),
		csInfo.n.value('@DataWrittenMB', 'BIGINT')
	FROM
		@ResultXml.nodes('/LibraryTapeUsage') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #SurveyMonthlyTapeUsageByLibrary (CommServUniqueId, LibraryId, MonthStart, UsedTapeCount, SpareTapeCount)
	SELECT
		@CSUniqueId,
		csInfo.n.value('@LibraryId', 'INT'),
		csInfo.n.value('@MonthStart', 'DATE'),
		csInfo.n.value('@UsedTapeCount', 'INT'),
		csInfo.n.value('@SpareTapeCount', 'INT')
	FROM
		@ResultXml.nodes('/MonthlyTapeUsage') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyTapeUsageByType (SurveyResultId, MediaTypeId, MediaTypeName, UsedTapeCount, UsedSpaceMB)
	SELECT	SurveyResultId, MediaTypeId, MediaTypeName, UsedTapeCount, UsedSpaceMB
	FROM	#SurveyTapeUsageByType
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	MERGE cf_SurveyTapeMediaUsage TU
	USING
		(SELECT CommServUniqueId, MonthVal, MediaTypeId, MediaTypeName, TapesUsed, TapesRecycled FROM #SurveyTapeMediaUsage) T
	ON T.CommServUniqueId = TU.CommServUniqueId AND T.MonthVal = TU.MonthVal AND T.MediaTypeId = TU.MediaTypeId
	WHEN MATCHED THEN
			UPDATE SET TapesUsed = T.TapesUsed, TapesRecycled = T.TapesRecycled
	WHEN NOT MATCHED THEN
			INSERT (CommServUniqueId, MonthVal, MediaTypeId, MediaTypeName, TapesUsed, TapesRecycled)
			VALUES (T.CommServUniqueId, T.MonthVal, T.MediaTypeId, T.MediaTypeName, T.TapesUsed, T.TapesRecycled);
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyTapeUsageByLibrary (SurveyResultId, LibraryId, UsedTapeCount, SpareTapeCount, TotalSpaceMB, UsedSpaceMB, AppSizeMB, DataWrittenMB)
	SELECT	SurveyResultId, LibraryId, UsedTapeCount, SpareTapeCount, TotalSpaceMB, UsedSpaceMB, AppSizeMB, DataWrittenMB
	FROM	#SurveyTapeUsageByLibrary
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	MERGE cf_SurveyMonthlyTapeUsageByLibrary TU
	USING
		(SELECT CommServUniqueId, LibraryId, MonthStart, UsedTapeCount, SpareTapeCount FROM #SurveyMonthlyTapeUsageByLibrary) T
	ON T.CommServUniqueId = TU.CommServUniqueId AND T.LibraryId = TU.LibraryId AND T.MonthStart = TU.MonthStart
	WHEN MATCHED AND (T.MonthStart = @currentMonth) THEN
			UPDATE SET UsedTapeCount = T.UsedTapeCount, SpareTapeCount = T.SpareTapeCount
	WHEN NOT MATCHED THEN
			INSERT (CommServUniqueId, LibraryId, MonthStart, UsedTapeCount, SpareTapeCount)
			VALUES (T.CommServUniqueId, T.LibraryId, T.MonthStart, T.UsedTapeCount, T.SpareTapeCount);
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseTapeMediaUsageTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseTapeMediaUsage')
	delete from GxQscripts where name = 'ParseTapeMediaUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseTapeMediaUsage')
	delete from GXDBVersions where aliasname = 'ParseTapeMediaUsage'
GO

insert into GXDBVersions values(2, 'ParseTapeMediaUsage',  '00010001000200130000', 'ParseTapeMediaUsage', '00010001000200130000')
GO

