

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseTapeMediaInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseTapeMediaInfo.sp,v $ $Id: ParseTapeMediaInfo.sp,v 1.1.2.8 2020/12/17 02:51:23 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseTapeMediaInfo')
BEGIN
	print '>>> Drop Stored Procedure: ParseTapeMediaInfo <<<'
	drop procedure ParseTapeMediaInfo
END
IF EXISTS (select * from GxQscripts where name='ParseTapeMediaInfo')
	delete from GxQscripts where name = 'ParseTapeMediaInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseTapeMediaInfo')
	delete from GXDBVersions where aliasname = 'ParseTapeMediaInfo'
GO
print '... Creating Procedure: ParseTapeMediaInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseTapeMediaInfo
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseTapeMediaInfoTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
IF object_id('tempdb.dbo.#SurveyTapeMediaInfo') is not null DROP TABLE #SurveyTapeMediaInfo
CREATE TABLE #SurveyTapeMediaInfo (
	MediaId				INT,
	BarCode				NVARCHAR(256),
	ArchGroupCopyId		INT,
	LibraryId			INT,
	LocationId			INT,
	LocationName		NVARCHAR(256),
	SpareGroupName		NVARCHAR(256),
	VolumeFlag			INT,
	LastWriteTime		BIGINT,
	LastReadTime		BIGINT,
	TotalDataMB			BIGINT,
	RetentionExpireTime	BIGINT,
	Creationtime		BIGINT,
	MediaLocation		NVARCHAR(256),
	Encryption			INT
	)
DECLARE @FileName NVARCHAR(1024)
SELECT	@FileName = CAST(CollectedResults as NVARCHAR(1024))
FROM	cf_CommservSurveyResults
WHERE	CommservSurveyResults_ID = @ResultId
IF 	@ErrorCode = 0
BEGIN
    DECLARE @sql NVARCHAR(2000) = 'BULK INSERT #SurveyTapeMediaInfo FROM ''' + @FileName + ''' WITH ( FIELDTERMINATOR ='','', ROWTERMINATOR =''\n'' )';
    EXEC(@sql);
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	MERGE INTO cf_SurveyTapeMediaInfo AS csInfo
	USING #SurveyTapeMediaInfo AS temp
	ON @CSUniqueId = csInfo.CommservUniqueId AND temp.mediaId = csInfo.MediaId
	WHEN MATCHED THEN
		UPDATE SET barCode = temp.barCode, archGroupCopyId = temp.archGroupCopyId, libraryId = temp.libraryId, locationId = temp.locationId, locationName = temp.locationName, spareGroupName = temp.spareGroupName,
				volumeFlag = temp.volumeFlag, lastWriteTime = temp.lastWriteTime, lastReadTime = temp.lastReadTime, totalDataMB = temp.totalDataMB, retentionExpireTime = temp.retentionExpireTime,
				creationTime = temp.creationTime, MediaLocation = temp.mediaLocation, encryption = temp.encryption
	WHEN NOT MATCHED BY TARGET THEN
		INSERT (CommservUniqueId, MediaId, BarCode, ArchGroupCopyId, LibraryId, LocationId, LocationName, SpareGroupName, VolumeFlag,
		 		LastWriteTime, LastReadTime, TotalDataMB, RetentionExpireTime, CreationTime, MediaLocation, Encryption)
		VALUES (@CSUniqueId, temp.MediaId, temp.BarCode, temp.ArchGroupCopyId, temp.LibraryId, temp.LocationId, temp.LocationName, temp.SpareGroupName, temp.VolumeFlag,
				temp.LastWriteTime, temp.LastReadTime, temp.TotalDataMB, temp.RetentionExpireTime, temp.CreationTime, temp.MediaLocation, temp.Encryption)
	WHEN NOT MATCHED BY SOURCE AND csInfo.CommservUniqueId = @CSUniqueId THEN
		DELETE;
	SELECT @ErrorCode = @@ERROR
END
IF object_id('tempdb.dbo.#SurveyTapeMediaInfo') is not null DROP TABLE #SurveyTapeMediaInfo
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseTapeMediaInfoTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseTapeMediaInfo')
	delete from GxQscripts where name = 'ParseTapeMediaInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseTapeMediaInfo')
	delete from GXDBVersions where aliasname = 'ParseTapeMediaInfo'
GO

insert into GXDBVersions values(2, 'ParseTapeMediaInfo',  '00010001000200080000', 'ParseTapeMediaInfo', '00010001000200080000')
GO

